/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import kafka.api.Request$;
import kafka.tools.ReplicaBuffer;
import kafka.tools.ReplicaFetcherBlockingSend;
import kafka.utils.ShutdownableThread;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001\u0002\u000b\u0016\tiA\u0011\"\t\u0001\u0003\u0002\u0003\u0006IAI\u0018\t\u0011A\u0002!\u0011!Q\u0001\nEB\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0001B\u0001B\u0003%\u0011\u000b\u0003\u0005V\u0001\t\u0005\t\u0015!\u0003W\u0011!Q\u0006A!A!\u0002\u00131\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002,\t\u0011q\u0003!\u0011!Q\u0001\nYC\u0001\"\u0018\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"A!\r\u0001B\u0001B\u0003%1\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003W\u0011\u0015a\u0007\u0001\"\u0001n\u0011\u001da\bA1A\u0005\nuDq!a\u0001\u0001A\u0003%a\u0010C\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u0011q\u0003\u0001!\u0002\u0013\tI\u0001C\u0004\u0002\u001a\u0001!\t%a\u0007\u0003\u001dI+\u0007\u000f\\5dC\u001a+Go\u00195fe*\u0011acF\u0001\u0006i>|Gn\u001d\u0006\u00021\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\tqr#A\u0003vi&d7/\u0003\u0002!;\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0003\u0011q\u0017-\\3\u0011\u0005\rbcB\u0001\u0013+!\t)\u0003&D\u0001'\u0015\t9\u0013$\u0001\u0004=e>|GO\u0010\u0006\u0002S\u0005)1oY1mC&\u00111\u0006K\u0001\u0007!J,G-\u001a4\n\u00055r#AB*ue&twM\u0003\u0002,Q%\u0011\u0011eH\u0001\rg>,(oY3Ce>\\WM\u001d\t\u0003eij\u0011a\r\u0006\u0003iU\naaY8n[>t'B\u0001\r7\u0015\t9\u0004(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002s\u0005\u0019qN]4\n\u0005m\u001a$\u0001\u0002(pI\u0016\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0004}\r3eBA B\u001d\t)\u0003)C\u0001*\u0013\t\u0011\u0005&A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0011+%\u0001C%uKJ\f'\r\\3\u000b\u0005\tC\u0003C\u0001\u001aH\u0013\tA5G\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u0011Q|\u0007/[2JIN\u0004BaI&#\u001b&\u0011AJ\f\u0002\u0004\u001b\u0006\u0004\bC\u0001\u001aO\u0013\ty5G\u0001\u0003Vk&$\u0017!\u0004:fa2L7-\u0019\"vM\u001a,'\u000f\u0005\u0002S'6\tQ#\u0003\u0002U+\ti!+\u001a9mS\u000e\f')\u001e4gKJ\fQb]8dW\u0016$H+[7f_V$\bCA,Y\u001b\u0005A\u0013BA-)\u0005\rIe\u000e^\u0001\u0011g>\u001c7.\u001a;Ck\u001a4WM]*ju\u0016\f\u0011BZ3uG\"\u001c\u0016N_3\u0002\u000f5\f\u0007pV1ji\u0006AQ.\u001b8CsR,7/\u0001\be_Z+'/\u001b4jG\u0006$\u0018n\u001c8\u0011\u0005]\u0003\u0017BA1)\u0005\u001d\u0011un\u001c7fC:\fabY8ogVlWM]\"p]\u001aLw\r\u0005\u0002eS6\tQM\u0003\u0002gO\u0006!Q\u000f^5m\u0015\u0005A\u0017\u0001\u00026bm\u0006L!A[3\u0003\u0015A\u0013x\u000e]3si&,7/A\u0005gKR\u001c\u0007.\u001a:JI\u00061A(\u001b8jiz\"bB\\8qcJ\u001cH/\u001e<xqfT8\u0010\u0005\u0002S\u0001!)\u0011E\u0004a\u0001E!)\u0001G\u0004a\u0001c!)AH\u0004a\u0001{!)\u0011J\u0004a\u0001\u0015\")\u0001K\u0004a\u0001#\")QK\u0004a\u0001-\")!L\u0004a\u0001-\")1L\u0004a\u0001-\")AL\u0004a\u0001-\")QL\u0004a\u0001-\")aL\u0004a\u0001?\")!M\u0004a\u0001G\")1N\u0004a\u0001-\u0006ia-\u001a;dQ\u0016sG\r]8j]R,\u0012A \t\u0003%~L1!!\u0001\u0016\u0005i\u0011V\r\u001d7jG\u00064U\r^2iKJ\u0014En\\2lS:<7+\u001a8e\u000391W\r^2i\u000b:$\u0007o\\5oi\u0002\n!\u0002^8qS\u000et\u0015-\\3t+\t\tI\u0001\u0005\u0004\u0002\f\u0005UQJI\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003'A\u0013AC2pY2,7\r^5p]&\u0019A*!\u0004\u0002\u0017Q|\u0007/[2OC6,7\u000fI\u0001\u0007I><vN]6\u0015\u0005\u0005u\u0001cA,\u0002 %\u0019\u0011\u0011\u0005\u0015\u0003\tUs\u0017\u000e\u001e")
public class ReplicaFetcher
extends ShutdownableThread {
    private final Node sourceBroker;
    private final Iterable<TopicPartition> topicPartitions;
    private final Map<String, Uuid> topicIds;
    private final ReplicaBuffer replicaBuffer;
    private final int fetchSize;
    private final int maxWait;
    private final int minBytes;
    private final boolean doVerification;
    private final ReplicaFetcherBlockingSend fetchEndpoint;
    private final Map<Uuid, String> topicNames;

    private ReplicaFetcherBlockingSend fetchEndpoint() {
        return this.fetchEndpoint;
    }

    private Map<Uuid, String> topicNames() {
        return this.topicNames;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doWork() {
        CountDownLatch verificationBarrier;
        CountDownLatch fetcherBarrier;
        block7: {
            block6: {
                void forReplica_minBytes;
                void forReplica_maxWait;
                void forReplica_replicaId;
                FetchRequest.Builder builder;
                fetcherBarrier = this.replicaBuffer.getFetcherBarrier();
                verificationBarrier = this.replicaBuffer.getVerificationBarrier();
                LinkedHashMap requestMap = new LinkedHashMap();
                this.topicPartitions.foreach((Function1 & Serializable)topicPartition -> requestMap.put(topicPartition, new FetchRequest.PartitionData((Uuid)$this.topicIds.getOrElse((Object)topicPartition.topic(), (Function0 & Serializable)() -> Uuid.ZERO_UUID), $this.replicaBuffer.getOffset((TopicPartition)topicPartition), 0L, $this.fetchSize, Optional.empty())));
                int n = this.minBytes;
                int n2 = this.maxWait;
                int n3 = Request$.MODULE$.DebuggingConsumerId();
                short forReplica_allowedVersion = ApiKeys.FETCH.latestVersion();
                FetchRequest.Builder builder2 = builder = new FetchRequest.Builder(forReplica_allowedVersion, forReplica_allowedVersion, (int)forReplica_replicaId, (int)forReplica_maxWait, (int)forReplica_minBytes, requestMap);
                builder = null;
                FetchRequest.Builder fetchRequestBuilder = builder2;
                this.debug((Function0<String>)(Function0 & Serializable)() -> "Issuing fetch request ");
                FetchResponse fetchResponse = null;
                try {
                    fetchResponse = (FetchResponse)this.fetchEndpoint().sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)fetchRequestBuilder).responseBody();
                }
                finally {
                    if (fetchResponse != null) {
                    }
                    break block6;
                }
                fetchResponse.responseData(CollectionConverters$.MODULE$.MapHasAsJava(this.topicNames()).asJava(), ApiKeys.FETCH.latestVersion()).forEach((tp, partitionData) -> $this.replicaBuffer.addFetchedData((TopicPartition)tp, $this.sourceBroker.id(), (FetchResponseData.PartitionData)partitionData));
                break block7;
            }
            this.topicPartitions.foreach((Function1 & Serializable)topicAndPartition -> {
                this.replicaBuffer.addFetchedData(topicAndPartition, this.sourceBroker.id(), FetchResponse.partitionResponse((int)topicAndPartition.partition(), (Errors)Errors.NONE));
                return BoxedUnit.UNIT;
            });
        }
        fetcherBarrier.countDown();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Done fetching");
        fetcherBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Ready for verification");
        if (this.doVerification) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Do verification");
            this.replicaBuffer.verifyCheckSum((Function1<String, BoxedUnit>)(Function1 & Serializable)x -> {
                Predef$.MODULE$.println(x);
                return BoxedUnit.UNIT;
            });
            this.replicaBuffer.createNewFetcherBarrier();
            this.replicaBuffer.createNewVerificationBarrier();
            this.debug((Function0<String>)(Function0 & Serializable)() -> "Created new barrier");
            verificationBarrier.countDown();
        }
        verificationBarrier.await();
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Done verification");
    }

    public ReplicaFetcher(String name, Node sourceBroker, Iterable<TopicPartition> topicPartitions, Map<String, Uuid> topicIds, ReplicaBuffer replicaBuffer, int socketTimeout, int socketBufferSize, int fetchSize, int maxWait, int minBytes, boolean doVerification, Properties consumerConfig, int fetcherId) {
        this.sourceBroker = sourceBroker;
        this.topicPartitions = topicPartitions;
        this.topicIds = topicIds;
        this.replicaBuffer = replicaBuffer;
        this.fetchSize = fetchSize;
        this.maxWait = maxWait;
        this.minBytes = minBytes;
        this.doVerification = doVerification;
        super(name, true);
        this.fetchEndpoint = new ReplicaFetcherBlockingSend(sourceBroker, new ConsumerConfig(consumerConfig), new Metrics(), Time.SYSTEM, fetcherId, new StringBuilder(16).append("broker-").append(Request$.MODULE$.DebuggingConsumerId()).append("-fetcher-").append(fetcherId).toString());
        this.topicNames = (Map)topicIds.map((Function1 & Serializable)x$9 -> x$9.swap());
    }
}

