/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.spans;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spans.AssertingSpanWeight;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanWeight;

public class AssertingSpanQuery
extends SpanQuery {
    private final SpanQuery in;

    public AssertingSpanQuery(SpanQuery in) {
        this.in = in;
    }

    public String getField() {
        return this.in.getField();
    }

    public String toString(String field) {
        return "AssertingSpanQuery(" + this.in.toString(field) + ")";
    }

    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        SpanWeight weight = this.in.createWeight(searcher, needsScores);
        return new AssertingSpanWeight(searcher, weight);
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query q = this.in.rewrite(reader);
        if (q == this.in) {
            return super.rewrite(reader);
        }
        if (q instanceof SpanQuery) {
            return new AssertingSpanQuery((SpanQuery)q);
        }
        return q;
    }

    public Query clone() {
        return new AssertingSpanQuery(this.in);
    }

    public boolean equals(Object o) {
        return this.sameClassAs(o) && this.equalsTo((AssertingSpanQuery)((Object)((Object)((Object)this)).getClass().cast(o)));
    }

    private boolean equalsTo(AssertingSpanQuery other) {
        return Objects.equals(this.in, other.in);
    }

    public int hashCode() {
        return this.in == null ? 0 : this.in.hashCode();
    }
}

