/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.javadoc.AbstractJavadocMojo;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;

public class JavadocJar
extends AbstractJavadocMojo {
    private File destDir;
    private String jarOutputDirectory;
    private String finalName;
    private MavenProjectHelper projectHelper;
    private boolean attach;

    public void execute() throws MojoExecutionException {
        File destDir = this.destDir;
        if (destDir == null) {
            destDir = this.outputDirectory;
        }
        this.aggregate = false;
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        if (!"java".equals(artifactHandler.getLanguage())) {
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info((CharSequence)"Not executing Javadoc as the project is not a Java classpath-capable package");
            }
        } else {
            try {
                this.executeReport(Locale.getDefault());
                if (destDir.exists()) {
                    File outputFile = this.generateArchive(destDir, this.finalName + "-javadoc.jar");
                    if (!this.attach) {
                        if (this.getLog().isInfoEnabled()) {
                            this.getLog().info((CharSequence)"NOT adding javadoc to attached artifacts list.");
                        }
                    } else {
                        this.projectHelper.attachArtifact(this.project, "javadoc", "javadoc", outputFile);
                    }
                }
            }
            catch (ArchiverException e) {
                throw new MojoExecutionException("Error while creating archive:" + e.getMessage(), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error while creating archive:" + e.getMessage(), (Exception)e);
            }
            catch (MavenReportException e) {
                throw new MojoExecutionException("Error while creating archive:" + e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    private File generateArchive(File javadocFiles, String target) throws ArchiverException, IOException {
        File javadocJar = new File(this.jarOutputDirectory, target);
        if (javadocJar.exists()) {
            javadocJar.delete();
        }
        JarArchiver archiver = new JarArchiver();
        List resources = this.project.getBuild().getResources();
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            if (!r.getDirectory().endsWith("maven-shared-archive-resources")) continue;
            archiver.addDirectory(new File(r.getDirectory()));
        }
        archiver.addDirectory(javadocFiles);
        archiver.setDestFile(javadocJar);
        archiver.createArchive();
        return javadocJar;
    }
}

