/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.cvslib.command.checkout;

import java.io.File;
import java.io.IOException;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.checkout.AbstractCheckOutCommand;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.cvslib.command.CvsCommand;
import org.apache.maven.scm.provider.cvslib.command.CvsCommandUtils;
import org.apache.maven.scm.provider.cvslib.repository.CvsScmProviderRepository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.Commandline;

public abstract class AbstractCvsCheckOutCommand
extends AbstractCheckOutCommand
implements CvsCommand {
    protected CheckOutScmResult executeCheckOutCommand(ScmProviderRepository repo, ScmFileSet fileSet, String tag) throws ScmException {
        if (fileSet.getBasedir().exists()) {
            try {
                FileUtils.deleteDirectory((File)fileSet.getBasedir());
            }
            catch (IOException e) {
                this.getLogger().warn("Can't delete " + fileSet.getBasedir().getAbsolutePath(), (Throwable)e);
            }
        }
        CvsScmProviderRepository repository = (CvsScmProviderRepository)repo;
        Commandline cl = CvsCommandUtils.getBaseCommand("checkout", repository, fileSet);
        cl.setWorkingDirectory(fileSet.getBasedir().getParentFile().getAbsolutePath());
        if (!StringUtils.isEmpty((String)tag)) {
            cl.createArgument().setValue("-r");
            cl.createArgument().setValue(tag);
        }
        cl.createArgument().setValue("-d");
        cl.createArgument().setValue(fileSet.getBasedir().getName());
        cl.createArgument().setValue(repository.getModule());
        this.getLogger().info("Executing: " + cl);
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        return this.executeCvsCommand(cl);
    }

    protected abstract CheckOutScmResult executeCvsCommand(Commandline var1) throws ScmException;
}

