/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.git.jgit.command.remoteinfo;

import java.util.Collection;
import java.util.HashMap;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.remoteinfo.AbstractRemoteInfoCommand;
import org.apache.maven.scm.command.remoteinfo.RemoteInfoScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.git.command.GitCommand;
import org.apache.maven.scm.provider.git.jgit.command.JGitUtils;
import org.apache.maven.scm.provider.git.repository.GitScmProviderRepository;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;

public class JGitRemoteInfoCommand
extends AbstractRemoteInfoCommand
implements GitCommand {
    public RemoteInfoScmResult executeRemoteInfoCommand(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        GitScmProviderRepository repo = (GitScmProviderRepository)repository;
        Git git = null;
        try {
            git = JGitUtils.openRepo(fileSet.getBasedir());
            CredentialsProvider credentials = JGitUtils.getCredentials(repo);
            LsRemoteCommand lsCommand = (LsRemoteCommand)git.lsRemote().setRemote(repo.getPushUrl()).setCredentialsProvider(credentials);
            HashMap<String, String> tag = new HashMap<String, String>();
            Collection allTags = lsCommand.setHeads(false).setTags(true).call();
            for (Ref ref : allTags) {
                tag.put(Repository.shortenRefName((String)ref.getName()), ref.getObjectId().name());
            }
            HashMap<String, String> heads = new HashMap<String, String>();
            Collection allHeads = lsCommand.setHeads(true).setTags(false).call();
            for (Ref ref : allHeads) {
                heads.put(Repository.shortenRefName((String)ref.getName()), ref.getObjectId().name());
            }
            RemoteInfoScmResult remoteInfoScmResult = new RemoteInfoScmResult("JGit remoteinfo", heads, tag);
            return remoteInfoScmResult;
        }
        catch (Exception e) {
            throw new ScmException("JGit remoteinfo failure!", (Throwable)e);
        }
        finally {
            JGitUtils.closeRepo(git);
        }
    }
}

