/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.remove;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.remove.AbstractRemoveCommand;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.remove.SvnRemoveConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnRemoveCommand
extends AbstractRemoveCommand
implements SvnCommand {
    protected ScmResult executeRemoveCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message) throws ScmException {
        int exitCode;
        if (fileSet.getFiles().length == 0) {
            throw new ScmException("You must provide at least one file/directory to remove");
        }
        Commandline cl = SvnRemoveCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFileList());
        SvnRemoveConsumer consumer = new SvnRemoveConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
        this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        try {
            exitCode = SvnCommandLineUtils.execute(cl, consumer, stderr, this.getLogger());
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", (Throwable)ex);
        }
        if (exitCode != 0) {
            return new RemoveScmResult(cl.toString(), "The svn command failed.", stderr.getOutput(), false);
        }
        return new RemoveScmResult(cl.toString(), consumer.getRemovedFiles());
    }

    private static Commandline createCommandLine(File workingDirectory, List files) throws ScmException {
        Commandline cl = new Commandline();
        cl.setExecutable("svn");
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cl.createArgument().setValue("remove");
        try {
            SvnCommandLineUtils.addTarget(cl, files);
        }
        catch (IOException e) {
            throw new ScmException("Can't create the targets file", (Throwable)e);
        }
        return cl;
    }
}

