/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.tck.command.branch;

import java.io.File;
import java.io.FileWriter;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTckTestCase;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.branch.BranchScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.codehaus.plexus.util.FileUtils;

public abstract class BranchCommandTckTest
extends ScmTckTestCase {
    public void testBranchCommandTest() throws Exception {
        String branch = "test-branch";
        BranchScmResult branchResult = this.getScmManager().getProviderByUrl(this.getScmUrl()).branch(this.getScmRepository(), new ScmFileSet(this.getWorkingCopy()), branch);
        this.assertResultIsSuccess((ScmResult)branchResult);
        BranchCommandTckTest.assertEquals((String)"check all 4 files branched", (int)4, (int)branchResult.getBranchedFiles().size());
        File readmeTxt = new File(this.getWorkingCopy(), "readme.txt");
        BranchCommandTckTest.assertEquals((String)"check readme.txt contents", (String)"/readme.txt", (String)FileUtils.fileRead((File)readmeTxt));
        this.changeReadmeTxt(readmeTxt);
        CheckInScmResult checkinResult = this.getScmManager().checkIn(this.getScmRepository(), new ScmFileSet(this.getWorkingCopy()), "commit message");
        this.assertResultIsSuccess((ScmResult)checkinResult);
        CheckOutScmResult checkoutResult = this.getScmManager().checkOut(this.getScmRepository(), new ScmFileSet(this.getAssertionCopy()));
        this.assertResultIsSuccess((ScmResult)checkoutResult);
        readmeTxt = new File(this.getAssertionCopy(), "readme.txt");
        BranchCommandTckTest.assertEquals((String)"check readme.txt contents", (String)"changed file", (String)FileUtils.fileRead((File)readmeTxt));
        FileUtils.deleteDirectory((File)this.getAssertionCopy());
        BranchCommandTckTest.assertFalse((String)"check previous assertion copy deleted", (boolean)this.getAssertionCopy().exists());
        checkoutResult = this.getScmManager().getProviderByUrl(this.getScmUrl()).checkOut(this.getScmRepository(), new ScmFileSet(this.getAssertionCopy()), (ScmVersion)new ScmBranch(branch));
        this.assertResultIsSuccess((ScmResult)checkoutResult);
        BranchCommandTckTest.assertEquals((String)"check readme.txt contents is from branched version", (String)"/readme.txt", (String)FileUtils.fileRead((File)readmeTxt));
    }

    private void changeReadmeTxt(File readmeTxt) throws Exception {
        FileWriter output = new FileWriter(readmeTxt);
        output.write("changed file");
        output.close();
    }
}

