/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.tck.command.list;

import java.io.File;
import java.util.List;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTckTestCase;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.list.ListScmResult;
import org.apache.maven.scm.provider.ScmProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListCommandTckTest
extends ScmTckTestCase {
    public void testListCommandTest() throws Exception {
        ScmFileSet fileSet = new ScmFileSet(new File("."), new File("."));
        List<ScmFile> files = this.runList(fileSet, false);
        ListCommandTckTest.assertEquals((String)("The result of the list command doesn't have all the files in SCM: " + files), (int)3, (int)files.size());
    }

    public void testListCommandRecursiveTest() throws Exception {
        ScmFileSet fileSet = new ScmFileSet(new File("."), new File("."));
        List<ScmFile> files = this.runList(fileSet, true);
        ListCommandTckTest.assertEquals((String)("The result of the list command doesn't have all the files in SCM: " + files), (int)10, (int)files.size());
    }

    public void testListCommandUnexistantFileTest() throws Exception {
        ScmFileSet fileSet = new ScmFileSet(new File("."), new File("/void"));
        ScmProvider provider = this.getScmManager().getProviderByUrl(this.getScmUrl());
        ListScmResult result = provider.list(this.getScmRepository(), fileSet, false, (ScmVersion)null);
        ListCommandTckTest.assertFalse((String)"Found file when shouldn't", (boolean)result.isSuccess());
    }

    private List<ScmFile> runList(ScmFileSet fileSet, boolean recursive) throws Exception {
        ScmProvider provider = this.getScmManager().getProviderByUrl(this.getScmUrl());
        ListScmResult result = provider.list(this.getScmRepository(), fileSet, recursive, (ScmVersion)null);
        ListCommandTckTest.assertTrue((String)("SCM command failed: " + result.getCommandLine() + " : " + result.getProviderMessage() + (result.getCommandOutput() == null ? "" : ": " + result.getCommandOutput())), (boolean)result.isSuccess());
        return result.getFiles();
    }
}

