/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.tck.command.status;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTckTestCase;
import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;

public abstract class StatusCommandTckTest
extends ScmTckTestCase {
    private void commit(File workingDirectory, ScmRepository repository) throws Exception {
        CheckInScmResult result = this.getScmManager().checkIn(repository, new ScmFileSet(workingDirectory), "No msg");
        StatusCommandTckTest.assertTrue((String)("Check result was successful, output: " + result.getCommandOutput()), (boolean)result.isSuccess());
        List committedFiles = result.getCheckedInFiles();
        StatusCommandTckTest.assertEquals((String)("Expected 2 files in the committed files list " + committedFiles), (int)2, (int)committedFiles.size());
    }

    public void testStatusCommand() throws Exception {
        ScmRepository repository = this.makeScmRepository(this.getScmUrl());
        this.checkOut(this.getUpdatingCopy(), repository);
        ScmTestCase.makeFile(this.getWorkingCopy(), "/readme.txt", "changed readme.txt");
        ScmTestCase.makeFile(this.getWorkingCopy(), "/project.xml", "changed project.xml");
        this.addToWorkingTree(this.getWorkingCopy(), new File("project.xml"), repository);
        this.commit(this.getWorkingCopy(), repository);
        ScmTestCase.makeFile(this.getUpdatingCopy(), "/pom.xml", "changed pom.xml");
        ScmTestCase.makeDirectory(this.getUpdatingCopy(), "/src/test/java/org");
        this.addToWorkingTree(this.getUpdatingCopy(), new File("src/test/java/org"), repository);
        ScmTestCase.makeFile(this.getUpdatingCopy(), "/src/main/java/org/Foo.java");
        this.addToWorkingTree(this.getUpdatingCopy(), new File("src/main/java/org"), repository);
        this.addToWorkingTree(this.getUpdatingCopy(), new File("src/main/java/org/Foo.java"), repository);
        ScmManager scmManager = this.getScmManager();
        StatusScmResult result = scmManager.getProviderByUrl(this.getScmUrl()).status(repository, new ScmFileSet(this.getUpdatingCopy()));
        StatusCommandTckTest.assertNotNull((String)"The command returned a null result.", (Object)result);
        this.assertResultIsSuccess((ScmResult)result);
        List changedFiles = result.getChangedFiles();
        StatusCommandTckTest.assertEquals((String)("Expected 2 files in the updated files list " + changedFiles), (int)2, (int)changedFiles.size());
        Iterator files = new TreeSet(changedFiles).iterator();
        ScmFile file = (ScmFile)files.next();
        this.assertPath("/src/main/java/org/Foo.java", file.getPath());
        StatusCommandTckTest.assertEquals((Object)ScmFileStatus.ADDED, (Object)file.getStatus());
        file = (ScmFile)files.next();
        this.assertPath("/pom.xml", file.getPath());
        StatusCommandTckTest.assertEquals((Object)ScmFileStatus.MODIFIED, (Object)file.getStatus());
        this.assertFile(this.getUpdatingCopy(), "/readme.txt");
        StatusCommandTckTest.assertFalse((String)"project.xml created incorrectly", (boolean)new File(this.getUpdatingCopy(), "/project.xml").exists());
    }
}

