/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.booterclient;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.maven.plugin.surefire.SurefireHelper;
import org.apache.maven.plugin.surefire.booterclient.AbstractClasspathForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.Platform;
import org.apache.maven.plugin.surefire.booterclient.lazytestprovider.OutputStreamFlushableCommandline;
import org.apache.maven.plugin.surefire.booterclient.output.InPluginProcessDumpSingleton;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.util.internal.StringUtils;

public final class JarManifestForkConfiguration
extends AbstractClasspathForkConfiguration {
    public JarManifestForkConfiguration(@Nonnull Classpath bootClasspath, @Nonnull File tempDirectory, @Nullable String debugLine, @Nonnull File workingDirectory, @Nonnull Properties modelProperties, @Nullable String argLine, @Nonnull Map<String, String> environmentVariables, boolean debug, int forkCount, boolean reuseForks, @Nonnull Platform pluginPlatform, @Nonnull ConsoleLogger log) {
        super(bootClasspath, tempDirectory, debugLine, workingDirectory, modelProperties, argLine, environmentVariables, debug, forkCount, reuseForks, pluginPlatform, log);
    }

    @Override
    protected void resolveClasspath(@Nonnull OutputStreamFlushableCommandline cli, @Nonnull String booterThatHasMainMethod, @Nonnull StartupConfiguration config, @Nonnull File dumpLogDirectory) throws SurefireBooterForkException {
        try {
            File jar = this.createJar(this.toCompleteClasspath(config), booterThatHasMainMethod, dumpLogDirectory);
            cli.createArg().setValue("-jar");
            cli.createArg().setValue(SurefireHelper.escapeToPlatformPath(jar.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new SurefireBooterForkException("Error creating archive file", (Throwable)e);
        }
    }

    @Nonnull
    private File createJar(@Nonnull List<String> classPath, @Nonnull String startClassName, @Nonnull File dumpLogDirectory) throws IOException {
        File file = File.createTempFile("surefirebooter", ".jar", this.getTempDirectory());
        if (!this.isDebug()) {
            file.deleteOnExit();
        }
        Path parent = file.getParentFile().toPath();
        FileOutputStream fos = new FileOutputStream(file);
        try (JarOutputStream jos = new JarOutputStream(fos);){
            jos.setLevel(0);
            JarEntry je = new JarEntry("META-INF/MANIFEST.MF");
            jos.putNextEntry(je);
            Manifest man = new Manifest();
            boolean dumpError = true;
            StringBuilder cp = new StringBuilder();
            Iterator<String> it = classPath.iterator();
            while (it.hasNext()) {
                Path classPathElement = Paths.get(it.next(), new String[0]);
                ClasspathElementUri classpathElementUri = JarManifestForkConfiguration.toClasspathElementUri(parent, classPathElement, dumpLogDirectory, dumpError);
                dumpError &= !classpathElementUri.absolute;
                cp.append(classpathElementUri.uri);
                if (Files.isDirectory(classPathElement, new LinkOption[0]) && !classpathElementUri.uri.endsWith("/")) {
                    cp.append('/');
                }
                if (!it.hasNext()) continue;
                cp.append(' ');
            }
            man.getMainAttributes().putValue("Manifest-Version", "1.0");
            man.getMainAttributes().putValue("Class-Path", cp.toString().trim());
            man.getMainAttributes().putValue("Main-Class", startClassName);
            man.write(jos);
            jos.closeEntry();
            jos.flush();
            File file2 = file;
            return file2;
        }
    }

    static String relativize(@Nonnull Path parent, @Nonnull Path child) throws IllegalArgumentException {
        return parent.relativize(child).toString();
    }

    static String toAbsoluteUri(@Nonnull Path absolutePath) {
        return absolutePath.toUri().toASCIIString();
    }

    static ClasspathElementUri toClasspathElementUri(@Nonnull Path parent, @Nonnull Path classPathElement, @Nonnull File dumpLogDirectory, boolean dumpError) throws IOException {
        try {
            String relativeUriPath = JarManifestForkConfiguration.relativize(parent, classPathElement).replace('\\', '/');
            return new ClasspathElementUri(new URI(null, relativeUriPath, null));
        }
        catch (IllegalArgumentException e) {
            if (dumpError) {
                String error = "Boot Manifest-JAR contains absolute paths in classpath '" + classPathElement + "'" + StringUtils.NL + "Hint: <argLine>-Djdk.net.URLClassPath.disableClassPathURLCheck=true</argLine>";
                InPluginProcessDumpSingleton.getSingleton().dumpStreamText(error, dumpLogDirectory);
            }
            return new ClasspathElementUri(JarManifestForkConfiguration.toAbsoluteUri(classPathElement));
        }
        catch (URISyntaxException e) {
            throw new IOException("Could not create a relative path " + classPathElement + " against " + parent, e);
        }
    }

    static final class ClasspathElementUri {
        final String uri;
        final boolean absolute;

        ClasspathElementUri(String uri) {
            this.uri = uri;
            this.absolute = true;
        }

        ClasspathElementUri(URI uri) {
            this.uri = uri.toASCIIString();
            this.absolute = false;
        }
    }
}

