/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.spi;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.apache.maven.plugin.surefire.log.api.ConsoleLoggerUtils;
import org.apache.maven.surefire.api.booter.DumpErrorSingleton;
import org.apache.maven.surefire.api.booter.ForkedProcessEventType;
import org.apache.maven.surefire.api.booter.MasterProcessChannelEncoder;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.RunMode;
import org.apache.maven.surefire.api.report.SafeThrowable;
import org.apache.maven.surefire.api.report.StackTraceWriter;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.api.util.internal.WritableBufferedByteChannel;
import org.apache.maven.surefire.booter.stream.EventEncoder;

public class EventChannelEncoder
extends EventEncoder
implements MasterProcessChannelEncoder {
    private final AtomicBoolean trouble = new AtomicBoolean();
    private volatile boolean onExit;

    public EventChannelEncoder(@Nonnull WritableBufferedByteChannel out) {
        super(out);
    }

    public boolean checkError() {
        return this.trouble.get();
    }

    public void onJvmExit() {
        this.onExit = true;
        this.write(ByteBuffer.wrap(new byte[]{10}), true);
    }

    void encodeSystemProperties(Map<String, String> sysProps, RunMode runMode, Long testRunId) {
        CharsetEncoder encoder = this.newCharsetEncoder();
        Buffer result = null;
        Iterator<Map.Entry<String, String>> it = sysProps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            String value = entry.getValue();
            int bufferLength = this.estimateBufferLength(ForkedProcessEventType.BOOTERCODE_SYSPROPS.getOpcode().length(), runMode, encoder, 0, 1, new String[]{key, value});
            result = result != null && result.capacity() >= bufferLength ? result : ByteBuffer.allocate(bufferLength);
            result.clear();
            this.encode(encoder, (ByteBuffer)result, (Enum)ForkedProcessEventType.BOOTERCODE_SYSPROPS, runMode, testRunId, new String[]{key, value});
            boolean sync = !it.hasNext();
            this.write((ByteBuffer)result, sync);
        }
    }

    public void testSetStarting(TestSetReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TESTSET_STARTING, (ReportEntry)reportEntry, trimStackTraces, true);
    }

    public void testSetCompleted(TestSetReportEntry reportEntry, boolean trimStackTraces) {
        this.encodeSystemProperties(reportEntry.getSystemProperties(), reportEntry.getRunMode(), reportEntry.getTestRunId());
        this.encode(ForkedProcessEventType.BOOTERCODE_TESTSET_COMPLETED, (ReportEntry)reportEntry, trimStackTraces, true);
    }

    public void testStarting(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_STARTING, reportEntry, trimStackTraces, true);
    }

    public void testSucceeded(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_SUCCEEDED, reportEntry, trimStackTraces, true);
    }

    public void testFailed(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_FAILED, reportEntry, trimStackTraces, true);
    }

    public void testSkipped(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_SKIPPED, reportEntry, trimStackTraces, true);
    }

    public void testError(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_ERROR, reportEntry, trimStackTraces, true);
    }

    public void testAssumptionFailure(ReportEntry reportEntry, boolean trimStackTraces) {
        this.encode(ForkedProcessEventType.BOOTERCODE_TEST_ASSUMPTIONFAILURE, reportEntry, trimStackTraces, true);
    }

    public void testOutput(TestOutputReportEntry reportEntry) {
        boolean stdout = reportEntry.isStdOut();
        boolean newLine = reportEntry.isNewLine();
        String msg = reportEntry.getLog();
        ForkedProcessEventType event = stdout ? (newLine ? ForkedProcessEventType.BOOTERCODE_STDOUT_NEW_LINE : ForkedProcessEventType.BOOTERCODE_STDOUT) : (newLine ? ForkedProcessEventType.BOOTERCODE_STDERR_NEW_LINE : ForkedProcessEventType.BOOTERCODE_STDERR);
        this.setOutErr(event, reportEntry.getRunMode(), reportEntry.getTestRunId(), msg);
    }

    private void setOutErr(ForkedProcessEventType eventType, RunMode runMode, Long testRunId, String message) {
        ByteBuffer result = this.encodeMessage(eventType, runMode, testRunId, message);
        this.write(result, false);
    }

    public void consoleInfoLog(String message) {
        ByteBuffer result = this.encodeMessage(ForkedProcessEventType.BOOTERCODE_CONSOLE_INFO, message);
        this.write(result, true);
    }

    public void consoleErrorLog(String message) {
        this.consoleErrorLog(message, null);
    }

    public void consoleErrorLog(Throwable t) {
        this.consoleErrorLog(t.getLocalizedMessage(), t);
    }

    public void consoleErrorLog(String message, Throwable t) {
        CharsetEncoder encoder = this.newCharsetEncoder();
        String stackTrace = t == null ? null : ConsoleLoggerUtils.toString((Throwable)t);
        int bufferMaxLength = this.estimateBufferLength(ForkedProcessEventType.BOOTERCODE_CONSOLE_ERROR.getOpcode().length(), null, encoder, 0, 0, new String[]{message, null, stackTrace});
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encodeHeader(result, (Enum)ForkedProcessEventType.BOOTERCODE_CONSOLE_ERROR);
        this.encodeCharset(result);
        this.encode(encoder, result, message, null, stackTrace);
        this.write(result, true);
    }

    public void consoleErrorLog(StackTraceWriter stackTraceWriter, boolean trimStackTraces) {
        this.error(stackTraceWriter, trimStackTraces, ForkedProcessEventType.BOOTERCODE_CONSOLE_ERROR, true);
    }

    public void consoleDebugLog(String message) {
        ByteBuffer result = this.encodeMessage(ForkedProcessEventType.BOOTERCODE_CONSOLE_DEBUG, message);
        this.write(result, true);
    }

    public void consoleWarningLog(String message) {
        ByteBuffer result = this.encodeMessage(ForkedProcessEventType.BOOTERCODE_CONSOLE_WARNING, message);
        this.write(result, true);
    }

    public void bye() {
        this.encodeOpcode(ForkedProcessEventType.BOOTERCODE_BYE, true);
    }

    public void stopOnNextTest() {
        this.encodeOpcode(ForkedProcessEventType.BOOTERCODE_STOP_ON_NEXT_TEST, true);
    }

    public void acquireNextTest() {
        this.encodeOpcode(ForkedProcessEventType.BOOTERCODE_NEXT_TEST, true);
    }

    public void sendExitError(StackTraceWriter stackTraceWriter, boolean trimStackTraces) {
        this.error(stackTraceWriter, trimStackTraces, ForkedProcessEventType.BOOTERCODE_JVM_EXIT_ERROR, true);
    }

    private void error(StackTraceWriter stackTraceWriter, boolean trimStackTraces, ForkedProcessEventType eventType, boolean sync) {
        CharsetEncoder encoder = this.newCharsetEncoder();
        StackTrace stackTraceWrapper = new StackTrace(stackTraceWriter, trimStackTraces);
        int bufferMaxLength = this.estimateBufferLength(eventType.getOpcode().length(), null, encoder, 0, 0, new String[]{stackTraceWrapper.message, stackTraceWrapper.smartTrimmedStackTrace, stackTraceWrapper.stackTrace});
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encodeHeader(result, (Enum)eventType);
        this.encodeCharset(result);
        this.encode(encoder, result, stackTraceWrapper);
        this.write(result, sync);
    }

    private void encode(ForkedProcessEventType operation, ReportEntry reportEntry, boolean trimStackTraces, boolean sync) {
        ByteBuffer result = this.encode(operation, reportEntry, trimStackTraces);
        this.write(result, sync);
    }

    private void encodeOpcode(ForkedProcessEventType eventType, boolean sync) {
        int bufferMaxLength = this.estimateBufferLength(eventType.getOpcode().length(), null, null, 0, 0, new String[0]);
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encodeHeader(result, (Enum)eventType);
        this.write(result, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(ByteBuffer frame, boolean sync) {
        boolean wasInterrupted = Thread.interrupted();
        try {
            super.write(frame, sync);
        }
        catch (ClosedChannelException e) {
            if (!this.onExit) {
                String event = new String(frame.array(), frame.arrayOffset() + frame.position(), frame.remaining(), this.getCharset());
                DumpErrorSingleton.getSingleton().dumpException((Throwable)e, "Channel closed while writing the event '" + event + "'.");
            }
        }
        catch (IOException e) {
            if (this.trouble.compareAndSet(false, true)) {
                DumpErrorSingleton.getSingleton().dumpException((Throwable)e);
            }
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void encode(CharsetEncoder encoder, ByteBuffer result, StackTrace stw) {
        this.encode(encoder, result, stw.message, stw.smartTrimmedStackTrace, stw.stackTrace);
    }

    private void encode(CharsetEncoder encoder, ByteBuffer result, String message, String smartStackTrace, String stackTrace) {
        this.encodeString(encoder, result, message);
        this.encodeString(encoder, result, smartStackTrace);
        this.encodeString(encoder, result, stackTrace);
    }

    ByteBuffer encode(ForkedProcessEventType operation, ReportEntry reportEntry, boolean trimStackTraces) {
        StackTrace stackTraceWrapper = new StackTrace(reportEntry.getStackTraceWriter(), trimStackTraces);
        CharsetEncoder encoder = this.newCharsetEncoder();
        int bufferMaxLength = this.estimateBufferLength(operation.getOpcode().length(), reportEntry.getRunMode(), encoder, 1, 1, new String[]{reportEntry.getSourceName(), reportEntry.getSourceText(), reportEntry.getName(), reportEntry.getNameText(), reportEntry.getGroup(), reportEntry.getMessage(), stackTraceWrapper.message, stackTraceWrapper.smartTrimmedStackTrace, stackTraceWrapper.stackTrace});
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encodeHeader(result, (Enum)operation, reportEntry.getRunMode(), reportEntry.getTestRunId());
        this.encodeCharset(result);
        this.encodeString(encoder, result, reportEntry.getSourceName());
        this.encodeString(encoder, result, reportEntry.getSourceText());
        this.encodeString(encoder, result, reportEntry.getName());
        this.encodeString(encoder, result, reportEntry.getNameText());
        this.encodeString(encoder, result, reportEntry.getGroup());
        this.encodeString(encoder, result, reportEntry.getMessage());
        this.encodeInteger(result, reportEntry.getElapsed());
        this.encode(encoder, result, stackTraceWrapper);
        return result;
    }

    ByteBuffer encodeMessage(ForkedProcessEventType eventType, RunMode runMode, Long testRunId, String message) {
        CharsetEncoder encoder = this.newCharsetEncoder();
        int bufferMaxLength = this.estimateBufferLength(eventType.getOpcode().length(), runMode, encoder, 0, 1, new String[]{message});
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encode(encoder, result, (Enum)eventType, runMode, testRunId, new String[]{message});
        return result;
    }

    ByteBuffer encodeMessage(ForkedProcessEventType eventType, String message) {
        CharsetEncoder encoder = this.newCharsetEncoder();
        int bufferMaxLength = this.estimateBufferLength(eventType.getOpcode().length(), null, encoder, 0, 0, new String[]{message});
        ByteBuffer result = ByteBuffer.allocate(bufferMaxLength);
        this.encode(encoder, result, (Enum)eventType, new String[]{message});
        return result;
    }

    private static String toStackTrace(StackTraceWriter stw, boolean trimStackTraces) {
        if (stw == null) {
            return null;
        }
        return trimStackTraces ? stw.writeTrimmedTraceToString() : stw.writeTraceToString();
    }

    private static final class StackTrace {
        final String message;
        final String smartTrimmedStackTrace;
        final String stackTrace;

        StackTrace(StackTraceWriter stackTraceWriter, boolean trimStackTraces) {
            SafeThrowable throwable = stackTraceWriter == null ? null : stackTraceWriter.getThrowable();
            this.message = throwable == null ? null : throwable.getLocalizedMessage();
            this.smartTrimmedStackTrace = stackTraceWriter == null ? null : stackTraceWriter.smartTrimmedStackTrace();
            this.stackTrace = stackTraceWriter == null ? null : EventChannelEncoder.toStackTrace(stackTraceWriter, trimStackTraces);
        }
    }
}

