/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.amqp_1_0.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.amqp_1_0.codec.ProtocolHandler;
import org.apache.qpid.amqp_1_0.framing.SASLFrameHandler;
import org.apache.qpid.amqp_1_0.transport.ConnectionEndpoint;

public class SASLProtocolHeaderHandler
implements ProtocolHandler {
    private ConnectionEndpoint _connection;
    private static final byte MAJOR_VERSION = 1;
    private static final byte MINOR_VERSION = 0;
    private boolean _done;
    private State _state = State.AWAITING_MAJOR;

    public SASLProtocolHeaderHandler(ConnectionEndpoint connection) {
        this._connection = connection;
    }

    @Override
    public ProtocolHandler parse(ByteBuffer in) {
        while (in.hasRemaining() && this._state != State.ERROR) {
            switch (this._state) {
                case AWAITING_MAJOR: {
                    State state = this._state = in.get() == 1 ? State.AWAITING_MINOR : State.ERROR;
                    if (this._state == State.ERROR || !in.hasRemaining()) {
                        this._done = true;
                        break;
                    }
                }
                case AWAITING_MINOR: {
                    State state = this._state = in.get() == 0 ? State.AWAITING_MINOR : State.ERROR;
                    if (this._state == State.ERROR || !in.hasRemaining()) {
                        this._done = true;
                        break;
                    }
                }
                case AWAITING_REVISION: {
                    byte revision = in.get();
                    this._connection.protocolHeaderReceived((byte)1, (byte)0, revision);
                    SASLFrameHandler handler = new SASLFrameHandler(this._connection);
                    this._done = true;
                    return handler.parse(in);
                }
            }
        }
        if (this._state == State.ERROR) {
            this._connection.invalidHeaderReceived();
        }
        return this;
    }

    @Override
    public boolean isDone() {
        return this._done || this._connection.closedForInput();
    }

    static enum State {
        AWAITING_MAJOR,
        AWAITING_MINOR,
        AWAITING_REVISION,
        ERROR;

    }
}

