/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.spring.support;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.TransactionListener;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.spring.core.RocketMQLocalTransactionListener;
import org.apache.rocketmq.spring.core.RocketMQLocalTransactionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.util.StringUtils;

public class RocketMQUtil {
    private static final Logger log = LoggerFactory.getLogger(RocketMQUtil.class);

    public static TransactionListener convert(final RocketMQLocalTransactionListener listener) {
        return new TransactionListener(){

            public LocalTransactionState executeLocalTransaction(Message message, Object obj) {
                RocketMQLocalTransactionState state = listener.executeLocalTransaction(RocketMQUtil.convertToSpringMessage(message), obj);
                return RocketMQUtil.convertLocalTransactionState(state);
            }

            public LocalTransactionState checkLocalTransaction(MessageExt messageExt) {
                RocketMQLocalTransactionState state = listener.checkLocalTransaction(RocketMQUtil.convertToSpringMessage(messageExt));
                return RocketMQUtil.convertLocalTransactionState(state);
            }
        };
    }

    private static LocalTransactionState convertLocalTransactionState(RocketMQLocalTransactionState state) {
        switch (state) {
            case UNKNOWN: {
                return LocalTransactionState.UNKNOW;
            }
            case COMMIT: {
                return LocalTransactionState.COMMIT_MESSAGE;
            }
            case ROLLBACK: {
                return LocalTransactionState.ROLLBACK_MESSAGE;
            }
        }
        log.warn("Failed to covert enum type RocketMQLocalTransactionState.%s", (Object)state);
        return LocalTransactionState.UNKNOW;
    }

    public static MessagingException convert(MQClientException e) {
        return new MessagingException(e.getErrorMessage(), (Throwable)e);
    }

    public static org.springframework.messaging.Message convertToSpringMessage(MessageExt message) {
        org.springframework.messaging.Message retMessage = MessageBuilder.withPayload((Object)message.getBody()).setHeader("KEYS", (Object)message.getKeys()).setHeader("TAGS", (Object)message.getTags()).setHeader("TOPIC", (Object)message.getTopic()).setHeader("MESSAGE_ID", (Object)message.getMsgId()).setHeader("BORN_TIMESTAMP", (Object)message.getBornTimestamp()).setHeader("BORN_HOST", (Object)message.getBornHostString()).setHeader("FLAG", (Object)message.getFlag()).setHeader("QUEUE_ID", (Object)message.getQueueId()).setHeader("SYS_FLAG", (Object)message.getSysFlag()).setHeader("TRANSACTION_ID", (Object)message.getTransactionId()).setHeader("PROPERTIES", (Object)message.getProperties()).build();
        return retMessage;
    }

    public static org.springframework.messaging.Message convertToSpringMessage(Message message) {
        org.springframework.messaging.Message retMessage = MessageBuilder.withPayload((Object)message.getBody()).setHeader("KEYS", (Object)message.getKeys()).setHeader("TAGS", (Object)message.getTags()).setHeader("TOPIC", (Object)message.getTopic()).setHeader("FLAG", (Object)message.getFlag()).setHeader("TRANSACTION_ID", (Object)message.getTransactionId()).setHeader("PROPERTIES", (Object)message.getProperties()).build();
        return retMessage;
    }

    public static Message convertToRocketMessage(ObjectMapper objectMapper, String charset, String destination, org.springframework.messaging.Message<?> message) {
        byte[] payloads;
        Object payloadObj = message.getPayload();
        if (payloadObj instanceof String) {
            payloads = ((String)payloadObj).getBytes(Charset.forName(charset));
        } else {
            try {
                String jsonObj = objectMapper.writeValueAsString(payloadObj);
                payloads = jsonObj.getBytes(Charset.forName(charset));
            }
            catch (Exception e) {
                throw new RuntimeException("convert to RocketMQ message failed.", e);
            }
        }
        String[] tempArr = destination.split(":", 2);
        String topic = tempArr[0];
        String tags = "";
        if (tempArr.length > 1) {
            tags = tempArr[1];
        }
        Message rocketMsg = new Message(topic, tags, payloads);
        MessageHeaders headers = message.getHeaders();
        if (Objects.nonNull(headers) && !headers.isEmpty()) {
            Object keys = headers.get((Object)"KEYS");
            if (!StringUtils.isEmpty((Object)keys)) {
                rocketMsg.setKeys(keys.toString());
            }
            Object flagObj = headers.getOrDefault((Object)"FLAG", (Object)"0");
            int flag = 0;
            try {
                flag = Integer.parseInt(flagObj.toString());
            }
            catch (NumberFormatException e) {
                log.info("flag must be integer, flagObj:{}", flagObj);
            }
            rocketMsg.setFlag(flag);
            Object waitStoreMsgOkObj = headers.getOrDefault((Object)"WAIT_STORE_MSG_OK", (Object)"true");
            boolean waitStoreMsgOK = Boolean.TRUE.equals(waitStoreMsgOkObj);
            rocketMsg.setWaitStoreMsgOK(waitStoreMsgOK);
            headers.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), "KEYS") && !Objects.equals(entry.getKey(), "FLAG") && !Objects.equals(entry.getKey(), "WAIT_STORE_MSG_OK")).forEach(entry -> rocketMsg.putUserProperty("USERS_" + (String)entry.getKey(), String.valueOf(entry.getValue())));
        }
        return rocketMsg;
    }
}

