/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import com.google.common.eventbus.EventBus;
import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.event.AlarmEvent;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.loadbalance.Configuration;
import org.apache.servicecomb.loadbalance.ServiceCombLoadBalancerStats;
import org.apache.servicecomb.loadbalance.ServiceCombServer;
import org.apache.servicecomb.loadbalance.ServiceCombServerStats;
import org.apache.servicecomb.loadbalance.event.IsolationServerEvent;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolationDiscoveryFilter
implements DiscoveryFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsolationDiscoveryFilter.class);
    public EventBus eventBus = EventManager.getEventBus();

    public int getOrder() {
        return 500;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.isolation.enabled", true).get();
    }

    public boolean isGroupingFilter() {
        return false;
    }

    public DiscoveryTreeNode discovery(DiscoveryContext context, DiscoveryTreeNode parent) {
        Map instances = (Map)parent.data();
        Invocation invocation = (Invocation)context.getInputParameters();
        if (!Configuration.INSTANCE.isIsolationFilterOpen(invocation.getMicroserviceName())) {
            return parent;
        }
        HashMap<String, MicroserviceInstance> filteredServers = new HashMap<String, MicroserviceInstance>();
        for (String key : instances.keySet()) {
            MicroserviceInstance instance = (MicroserviceInstance)instances.get(key);
            if (!this.allowVisit(invocation, instance)) continue;
            filteredServers.put(key, instance);
        }
        DiscoveryTreeNode child = new DiscoveryTreeNode();
        if (filteredServers.isEmpty() && DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.isolation.emptyInstanceProtectionEnabled", false).get()) {
            LOGGER.warn("All servers have been isolated, allow one of them based on load balance rule.");
            child.data((Object)instances);
        } else {
            child.data(filteredServers);
        }
        parent.child("filterred", child);
        return child;
    }

    private Settings createSettings(Invocation invocation) {
        Settings settings = new Settings();
        settings.errorThresholdPercentage = Configuration.INSTANCE.getErrorThresholdPercentage(invocation.getMicroserviceName());
        settings.singleTestTime = Configuration.INSTANCE.getSingleTestTime(invocation.getMicroserviceName());
        settings.enableRequestThreshold = Configuration.INSTANCE.getEnableRequestThreshold(invocation.getMicroserviceName());
        settings.continuousFailureThreshold = Configuration.INSTANCE.getContinuousFailureThreshold(invocation.getMicroserviceName());
        settings.minIsolationTime = Configuration.INSTANCE.getMinIsolationTime(invocation.getMicroserviceName());
        return settings;
    }

    private boolean allowVisit(Invocation invocation, MicroserviceInstance instance) {
        ServiceCombServer server = ServiceCombLoadBalancerStats.INSTANCE.getServiceCombServer(instance);
        if (server == null) {
            return true;
        }
        ServiceCombServerStats serverStats = ServiceCombLoadBalancerStats.INSTANCE.getServiceCombServerStats(server);
        Settings settings = this.createSettings(invocation);
        if (!this.checkThresholdAllowed(settings, serverStats)) {
            if (serverStats.isIsolated() && System.currentTimeMillis() - serverStats.getLastVisitTime() > settings.singleTestTime) {
                LOGGER.info("The Service {}'s instance {} has been isolated for a while, give a single test opportunity.", (Object)invocation.getMicroserviceName(), (Object)instance.getInstanceId());
                return true;
            }
            if (!serverStats.isIsolated()) {
                ServiceCombLoadBalancerStats.INSTANCE.markIsolated(server, true);
                this.eventBus.post((Object)new IsolationServerEvent(invocation, instance, serverStats, settings, AlarmEvent.Type.OPEN));
                LOGGER.warn("Isolate service {}'s instance {}.", (Object)invocation.getMicroserviceName(), (Object)instance.getInstanceId());
            }
            return false;
        }
        if (serverStats.isIsolated()) {
            if (System.currentTimeMillis() - serverStats.getLastVisitTime() <= (long)settings.minIsolationTime) {
                return false;
            }
            ServiceCombLoadBalancerStats.INSTANCE.markIsolated(server, false);
            this.eventBus.post((Object)new IsolationServerEvent(invocation, instance, serverStats, settings, AlarmEvent.Type.CLOSE));
            LOGGER.warn("Recover service {}'s instance {} from isolation.", (Object)invocation.getMicroserviceName(), (Object)instance.getInstanceId());
        }
        return true;
    }

    private boolean checkThresholdAllowed(Settings settings, ServiceCombServerStats serverStats) {
        if (serverStats.getTotalRequests() < settings.enableRequestThreshold) {
            return true;
        }
        if (settings.continuousFailureThreshold > 0 && serverStats.getCountinuousFailureCount() >= (long)settings.continuousFailureThreshold) {
            return false;
        }
        if (settings.errorThresholdPercentage == 0) {
            return true;
        }
        return serverStats.getFailedRate() < settings.errorThresholdPercentage;
    }

    public class Settings {
        public int errorThresholdPercentage;
        public long singleTestTime;
        public long enableRequestThreshold;
        public int continuousFailureThreshold;
        public int minIsolationTime;
    }
}

