/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.loadbalance.filter;

import com.netflix.config.DynamicPropertyFactory;
import java.util.HashMap;
import java.util.Map;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.serviceregistry.discovery.AbstractDiscoveryFilter;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryContext;
import org.apache.servicecomb.serviceregistry.discovery.DiscoveryTreeNode;

public class ZoneAwareDiscoveryFilter
extends AbstractDiscoveryFilter {
    private static final String KEY_ZONE_AWARE_STEP = "_KEY_ZONE_AWARE_STEP";
    private static final String GROUP_RegionAndAZMatch = "instancesRegionAndAZMatch";
    private static final String GROUP_instancesAZMatch = "instancesAZMatch";
    private static final String GROUP_instancesNoMatch = "instancesNoMatch";

    public int getOrder() {
        return 300;
    }

    public boolean enabled() {
        return DynamicPropertyFactory.getInstance().getBooleanProperty("servicecomb.loadbalance.filter.zoneaware.enabled", true).get();
    }

    public boolean isGroupingFilter() {
        return true;
    }

    protected void init(DiscoveryContext context, DiscoveryTreeNode parent) {
        MicroserviceInstance myself = RegistryUtils.getMicroserviceInstance();
        HashMap<String, MicroserviceInstance> instancesRegionAndAZMatch = new HashMap<String, MicroserviceInstance>();
        HashMap<String, MicroserviceInstance> instancesAZMatch = new HashMap<String, MicroserviceInstance>();
        HashMap<String, MicroserviceInstance> instancesNoMatch = new HashMap<String, MicroserviceInstance>();
        Map instances = (Map)parent.data();
        for (String id : instances.keySet()) {
            MicroserviceInstance target = (MicroserviceInstance)instances.get(id);
            if (this.regionAndAZMatch(myself, target)) {
                instancesRegionAndAZMatch.put(id, target);
                continue;
            }
            if (this.regionMatch(myself, target)) {
                instancesAZMatch.put(id, target);
                continue;
            }
            instancesNoMatch.put(id, target);
        }
        HashMap<String, VersionedCache> children = new HashMap<String, VersionedCache>();
        children.put(GROUP_RegionAndAZMatch, new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_RegionAndAZMatch).data(instancesRegionAndAZMatch));
        children.put(GROUP_instancesAZMatch, new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_instancesAZMatch).data(instancesAZMatch));
        children.put(GROUP_instancesNoMatch, new DiscoveryTreeNode().subName((VersionedCache)parent, GROUP_instancesNoMatch).data(instancesNoMatch));
        parent.children(children);
    }

    protected String findChildName(DiscoveryContext context, DiscoveryTreeNode parent) {
        String key = (String)context.getContextParameter(KEY_ZONE_AWARE_STEP);
        if (key == null) {
            key = GROUP_RegionAndAZMatch;
            context.pushRerunFilter();
        } else if (GROUP_RegionAndAZMatch.equals(key)) {
            key = GROUP_instancesAZMatch;
            context.pushRerunFilter();
        } else if (GROUP_instancesAZMatch.equals(key)) {
            key = GROUP_instancesNoMatch;
        } else {
            throw new ServiceCombException("not possible happen, maybe a bug.");
        }
        context.putContextParameter(KEY_ZONE_AWARE_STEP, (Object)key);
        return key;
    }

    private boolean regionAndAZMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (myself.getDataCenterInfo() == null) {
            return true;
        }
        if (target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion()) && myself.getDataCenterInfo().getAvailableZone().equals(target.getDataCenterInfo().getAvailableZone());
        }
        return false;
    }

    private boolean regionMatch(MicroserviceInstance myself, MicroserviceInstance target) {
        if (target.getDataCenterInfo() != null) {
            return myself.getDataCenterInfo().getRegion().equals(target.getDataCenterInfo().getRegion());
        }
        return false;
    }
}

