/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.mysql.visitor.format.impl;

import java.util.Properties;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeVisitor;
import org.antlr.v4.runtime.tree.RuleNode;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementBaseVisitor;
import org.apache.shardingsphere.sql.parser.autogen.MySQLStatementParser;

public abstract class MySQLFormatSQLVisitor
extends MySQLStatementBaseVisitor<String> {
    private StringBuilder result = new StringBuilder();
    private boolean upperCase = true;
    private boolean parameterized = true;
    private int indentCount;
    private int lines;
    private int projectionsCountOfLine = 3;

    public MySQLFormatSQLVisitor(Properties props) {
        if (null != props) {
            if (props.containsKey("upperCase")) {
                this.setUpperCase(Boolean.parseBoolean(props.getProperty("upperCase")));
            }
            if (props.containsKey("parameterized")) {
                this.setParameterized(Boolean.parseBoolean(props.getProperty("parameterized")));
            }
            if (props.containsKey("projectionsCountOfLine")) {
                this.setProjectionsCountOfLine(Integer.parseInt(props.getProperty("projectionsCountOfLine")));
            }
        }
    }

    @Override
    public String visitSelect(MySQLStatementParser.SelectContext ctx) {
        if (null != ctx.queryExpression()) {
            this.visit((ParseTree)ctx.queryExpression());
            if (null != ctx.lockClauseList()) {
                this.result.append(" ");
                this.visit((ParseTree)ctx.lockClauseList());
            }
        } else if (null != ctx.queryExpressionParens()) {
            this.visit((ParseTree)ctx.queryExpressionParens());
        } else {
            this.visit((ParseTree)ctx.selectWithInto());
        }
        this.formatPrint(";");
        return this.result.toString();
    }

    @Override
    public String visitQueryExpression(MySQLStatementParser.QueryExpressionContext ctx) {
        if (null != ctx.withClause()) {
            this.visit((ParseTree)ctx.withClause());
            this.formatPrint(" ");
        }
        if (null != ctx.queryExpressionBody()) {
            this.visit((ParseTree)ctx.queryExpressionBody());
        } else {
            this.visit((ParseTree)ctx.queryExpressionParens());
        }
        if (null != ctx.orderByClause()) {
            this.formatPrint(" ");
            this.visit((ParseTree)ctx.orderByClause());
        }
        if (null != ctx.limitClause()) {
            this.formatPrint(" ");
            this.visit((ParseTree)ctx.limitClause());
        }
        return this.result.toString();
    }

    @Override
    public String visitQueryExpressionParens(MySQLStatementParser.QueryExpressionParensContext ctx) {
        this.formatPrintln();
        ++this.indentCount;
        this.formatPrint("(");
        this.formatPrintln();
        if (null != ctx.queryExpressionParens()) {
            this.visit((ParseTree)ctx.queryExpressionParens());
        } else {
            this.visit((ParseTree)ctx.queryExpression());
            if (null != ctx.lockClauseList()) {
                this.result.append(" ");
                this.visit((ParseTree)ctx.lockClauseList());
            }
        }
        --this.indentCount;
        this.formatPrintln();
        this.formatPrint(")");
        return this.result.toString();
    }

    @Override
    public String visitQueryExpressionBody(MySQLStatementParser.QueryExpressionBodyContext ctx) {
        if (1 == ctx.getChildCount()) {
            this.visit((ParseTree)ctx.queryPrimary());
        } else {
            this.visit((ParseTree)ctx.queryExpressionParens(0));
            this.result.append("\nUNION\n");
            if (null != ctx.unionOption()) {
                this.visit((ParseTree)ctx.unionOption());
                this.result.append(" ");
            }
            if (null != ctx.queryPrimary()) {
                this.visit((ParseTree)ctx.queryPrimary());
            } else {
                this.visit((ParseTree)ctx.queryExpressionParens(1));
            }
        }
        return this.result.toString();
    }

    @Override
    public String visitQuerySpecification(MySQLStatementParser.QuerySpecificationContext ctx) {
        this.formatPrint("SELECT ");
        int selectSpecCount = ctx.selectSpecification().size();
        for (int i = 0; i < selectSpecCount; ++i) {
            this.visit((ParseTree)ctx.selectSpecification(i));
            this.formatPrint(" ");
        }
        this.visit((ParseTree)ctx.projections());
        if (null != ctx.fromClause()) {
            this.formatPrintln();
            this.visit((ParseTree)ctx.fromClause());
        }
        if (null != ctx.whereClause()) {
            this.formatPrintln();
            this.visit((ParseTree)ctx.whereClause());
        }
        if (null != ctx.groupByClause()) {
            this.formatPrintln();
            this.visit((ParseTree)ctx.groupByClause());
        }
        if (null != ctx.havingClause()) {
            this.formatPrintln();
            this.visit((ParseTree)ctx.havingClause());
        }
        if (null != ctx.windowClause()) {
            this.formatPrintln();
            this.visit((ParseTree)ctx.windowClause());
        }
        return this.result.toString();
    }

    @Override
    public String visitExplicitTable(MySQLStatementParser.ExplicitTableContext ctx) {
        this.formatPrint("TABLE ");
        this.visit((ParseTree)ctx.tableName());
        return this.result.toString();
    }

    @Override
    public String visitInsert(MySQLStatementParser.InsertContext ctx) {
        this.visit((ParseTree)ctx.INSERT());
        this.formatPrint(" ");
        this.visit((ParseTree)ctx.insertSpecification());
        this.formatPrint(" ");
        if (null != ctx.INTO()) {
            this.visit((ParseTree)ctx.INTO());
            this.formatPrint(" ");
        }
        this.visit((ParseTree)ctx.tableName());
        this.formatPrint(" ");
        if (null != ctx.partitionNames()) {
            this.formatPrintln();
            this.visit((ParseTree)ctx.partitionNames());
        }
        if (null != ctx.insertValuesClause()) {
            this.visit((ParseTree)ctx.insertValuesClause());
        } else if (null != ctx.insertSelectClause()) {
            this.visit((ParseTree)ctx.insertSelectClause());
        } else {
            this.visit((ParseTree)ctx.setAssignmentsClause());
        }
        if (null != ctx.onDuplicateKeyClause()) {
            this.formatPrintln();
            this.visit((ParseTree)ctx.onDuplicateKeyClause());
        }
        return this.result.toString();
    }

    @Override
    public String visitPartitionNames(MySQLStatementParser.PartitionNamesContext ctx) {
        this.visit((ParseTree)ctx.PARTITION());
        this.formatPrintln(" (");
        int identifierCount = ctx.identifier().size();
        for (int i = 0; i < identifierCount; ++i) {
            if (i == 0) {
                this.visit((ParseTree)ctx.identifier(i));
                continue;
            }
            this.formatPrint(" ,");
            this.visit((ParseTree)ctx.identifier(i));
        }
        this.formatPrint(")");
        return this.result.toString();
    }

    @Override
    public String visitInsertValuesClause(MySQLStatementParser.InsertValuesClauseContext ctx) {
        if (null != ctx.LP_()) {
            this.formatPrint("(");
            if (null != ctx.fields()) {
                this.visit((ParseTree)ctx.fields());
            }
            this.formatPrint(")");
        }
        this.formatPrintln();
        if (null != ctx.VALUE()) {
            this.visit((ParseTree)ctx.VALUE());
        } else {
            this.visit((ParseTree)ctx.VALUES());
        }
        ++this.indentCount;
        this.formatPrintln();
        if (!ctx.assignmentValues().isEmpty()) {
            int valueCount = ctx.assignmentValues().size();
            for (int i = 0; i < valueCount; ++i) {
                if (i == 0) {
                    this.visit((ParseTree)ctx.assignmentValues(i));
                    continue;
                }
                this.formatPrint(",");
                this.formatPrintln();
                this.visit((ParseTree)ctx.assignmentValues(i));
            }
        }
        if (null != ctx.rowConstructorList()) {
            ++this.indentCount;
            this.visit((ParseTree)ctx.rowConstructorList());
            --this.indentCount;
        }
        --this.indentCount;
        if (null != ctx.valueReference()) {
            this.formatPrintln();
            this.visit((ParseTree)ctx.valueReference());
        }
        return this.result.toString();
    }

    @Override
    public String visitInsertSelectClause(MySQLStatementParser.InsertSelectClauseContext ctx) {
        if (null != ctx.valueReference()) {
            this.visit((ParseTree)ctx.valueReference());
            this.formatPrint(" ");
        }
        if (null != ctx.LP_()) {
            this.formatPrint("(");
            if (null != ctx.fields()) {
                this.visit((ParseTree)ctx.fields());
            }
            this.formatPrint(") ");
        }
        this.formatPrintln();
        this.visit((ParseTree)ctx.select());
        return this.result.toString();
    }

    @Override
    public String visitSetAssignmentsClause(MySQLStatementParser.SetAssignmentsClauseContext ctx) {
        if (null != ctx.valueReference()) {
            this.visit((ParseTree)ctx.valueReference());
            this.formatPrint(" ");
        }
        ++this.indentCount;
        this.visit((ParseTree)ctx.SET());
        this.formatPrint(" ");
        int assignmentCount = ctx.assignment().size();
        for (int i = 0; i < assignmentCount; ++i) {
            if (i == 0) {
                this.visit((ParseTree)ctx.assignment(i));
                continue;
            }
            this.formatPrintln(",");
            this.visit((ParseTree)ctx.assignment(i));
        }
        --this.indentCount;
        return this.result.toString();
    }

    @Override
    public String visitDerivedColumns(MySQLStatementParser.DerivedColumnsContext ctx) {
        this.formatPrint("(");
        int aliasCount = ctx.alias().size();
        for (int i = 0; i < aliasCount; ++i) {
            if (i == 0) {
                this.visit((ParseTree)ctx.alias(i));
                continue;
            }
            this.formatPrint(", ");
            this.visit((ParseTree)ctx.alias(i));
        }
        this.formatPrint(")");
        return this.result.toString();
    }

    @Override
    public String visitOnDuplicateKeyClause(MySQLStatementParser.OnDuplicateKeyClauseContext ctx) {
        this.visit((ParseTree)ctx.ON());
        this.formatPrint(" ");
        this.visit((ParseTree)ctx.DUPLICATE());
        this.formatPrint(" ");
        this.visit((ParseTree)ctx.KEY());
        this.formatPrint(" ");
        this.visit((ParseTree)ctx.UPDATE());
        this.formatPrint(" ");
        ++this.indentCount;
        int assignmentCount = ctx.assignment().size();
        for (int i = 0; i < assignmentCount; ++i) {
            if (i == 0) {
                this.visit((ParseTree)ctx.assignment(i));
                continue;
            }
            this.formatPrintln();
            this.visit((ParseTree)ctx.assignment(i));
        }
        --this.indentCount;
        return this.result.toString();
    }

    @Override
    public String visitTableName(MySQLStatementParser.TableNameContext ctx) {
        if (null != ctx.owner()) {
            this.formatPrint(ctx.owner().getText());
            this.formatPrint(".");
        }
        this.formatPrint(ctx.name().getText());
        return this.result.toString();
    }

    @Override
    public String visitTableValueConstructor(MySQLStatementParser.TableValueConstructorContext ctx) {
        this.formatPrint("VALUES ");
        this.visit((ParseTree)ctx.rowConstructorList());
        return this.result.toString();
    }

    @Override
    public String visitAlterTable(MySQLStatementParser.AlterTableContext ctx) {
        this.visit((ParseTree)ctx.ALTER());
        this.formatPrint(" ");
        this.visit((ParseTree)ctx.TABLE());
        this.formatPrint(" ");
        this.visit((ParseTree)ctx.tableName());
        if (null != ctx.alterTableActions()) {
            ++this.indentCount;
            this.formatPrintln();
            this.visit((ParseTree)ctx.alterTableActions());
            --this.indentCount;
        } else if (null != ctx.standaloneAlterTableAction()) {
            ++this.indentCount;
            this.formatPrintln();
            this.visit((ParseTree)ctx.standaloneAlterTableAction());
            --this.indentCount;
        }
        return this.result.toString();
    }

    @Override
    public String visitAlterTableActions(MySQLStatementParser.AlterTableActionsContext ctx) {
        if (null != ctx.alterCommandList()) {
            this.visit((ParseTree)ctx.alterCommandList());
            if (null != ctx.alterTablePartitionOptions()) {
                this.formatPrintln();
                this.visit((ParseTree)ctx.alterTablePartitionOptions());
            }
        } else {
            this.visit((ParseTree)ctx.alterTablePartitionOptions());
        }
        return this.result.toString();
    }

    @Override
    public String visitAlterCommandList(MySQLStatementParser.AlterCommandListContext ctx) {
        if (null != ctx.alterCommandsModifierList()) {
            this.visit((ParseTree)ctx.alterCommandsModifierList());
            if (null != ctx.alterList()) {
                this.formatPrintln(",");
                this.visit((ParseTree)ctx.alterList());
            }
        } else if (null != ctx.alterList()) {
            this.visit((ParseTree)ctx.alterList());
        }
        return this.result.toString();
    }

    @Override
    public String visitAlterList(MySQLStatementParser.AlterListContext ctx) {
        int childCount = ctx.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ParseTree child = ctx.getChild(i);
            if (i != 0) {
                if (child instanceof TerminalNode) {
                    this.formatPrintln(",");
                    continue;
                }
                child.accept((ParseTreeVisitor)this);
                continue;
            }
            child.accept((ParseTreeVisitor)this);
        }
        return this.result.toString();
    }

    @Override
    public String visitCreateTableOptionsSpaceSeparated(MySQLStatementParser.CreateTableOptionsSpaceSeparatedContext ctx) {
        int childCount = ctx.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (0 != i) {
                this.formatPrintln();
            }
            this.visit(ctx.getChild(i));
        }
        return this.result.toString();
    }

    @Override
    public String visitStandaloneAlterTableAction(MySQLStatementParser.StandaloneAlterTableActionContext ctx) {
        if (null != ctx.alterCommandsModifierList()) {
            this.visit((ParseTree)ctx.alterCommandsModifierList());
            this.formatPrintln(",");
        }
        this.visit((ParseTree)ctx.standaloneAlterCommands());
        return this.result.toString();
    }

    @Override
    public String visitRowConstructorList(MySQLStatementParser.RowConstructorListContext ctx) {
        int rowCount = ctx.assignmentValues().size();
        for (int i = 0; i < rowCount; ++i) {
            if (i == 0) {
                this.visit((ParseTree)ctx.ROW(i));
                this.formatPrint(" ");
                this.visit((ParseTree)ctx.assignmentValues(i));
                continue;
            }
            this.formatPrintln(",");
            this.visit((ParseTree)ctx.ROW(i));
            this.formatPrint(" ");
            this.visit((ParseTree)ctx.assignmentValues(i));
        }
        return this.result.toString();
    }

    @Override
    public String visitAssignmentValues(MySQLStatementParser.AssignmentValuesContext ctx) {
        this.formatPrint("(");
        int assignCount = ctx.assignmentValue().size();
        for (int i = 0; i < assignCount; ++i) {
            if (i != 0) {
                this.formatPrint(", ");
                this.visit((ParseTree)ctx.assignmentValue(i));
                continue;
            }
            this.visit((ParseTree)ctx.assignmentValue(i));
        }
        this.formatPrint(")");
        return this.result.toString();
    }

    @Override
    public String visitWhereClause(MySQLStatementParser.WhereClauseContext ctx) {
        this.visit((ParseTree)ctx.WHERE());
        this.formatPrint(" ");
        ++this.indentCount;
        this.formatPrintln();
        this.visit((ParseTree)ctx.expr());
        --this.indentCount;
        return this.result.toString();
    }

    @Override
    public String visitExpr(MySQLStatementParser.ExprContext ctx) {
        if (null != ctx.logicalOperator()) {
            MySQLStatementParser.ExprContext left = ctx.expr(0);
            this.visit((ParseTree)left);
            this.formatPrintln();
            MySQLStatementParser.ExprContext right = ctx.expr(1);
            this.formatPrint(ctx.logicalOperator().getText());
            this.formatPrint(" ");
            this.visit((ParseTree)right);
        } else if (null != ctx.notOperator()) {
            this.formatPrint(ctx.notOperator().getText());
            this.visit((ParseTree)ctx.expr(0));
        } else {
            this.visitChildren((RuleNode)ctx);
        }
        return this.result.toString();
    }

    @Override
    public String visitAlias(MySQLStatementParser.AliasContext ctx) {
        this.formatPrint(ctx.getText());
        return this.result.toString();
    }

    @Override
    public String visitProjections(MySQLStatementParser.ProjectionsContext ctx) {
        ++this.indentCount;
        if (null != ctx.unqualifiedShorthand()) {
            this.visit((ParseTree)ctx.unqualifiedShorthand());
            this.result.append(" ");
        }
        int projectionCount = ctx.projection().size();
        int lineItemCount = 0;
        for (int i = 0; i < projectionCount; ++i) {
            if (0 != i) {
                this.result.append(", ");
                if (lineItemCount >= this.projectionsCountOfLine) {
                    lineItemCount = 0;
                    this.formatPrintln();
                }
            }
            this.visit((ParseTree)ctx.projection(i));
            ++lineItemCount;
        }
        --this.indentCount;
        return this.result.toString();
    }

    @Override
    public String visitProjection(MySQLStatementParser.ProjectionContext ctx) {
        if (null != ctx.expr()) {
            this.visit((ParseTree)ctx.expr());
            this.formatPrint(" ");
        }
        if (null != ctx.AS()) {
            this.formatPrint("AS ");
        }
        if (null != ctx.alias()) {
            this.visit((ParseTree)ctx.alias());
        }
        if (null != ctx.qualifiedShorthand()) {
            this.visit((ParseTree)ctx.qualifiedShorthand());
        }
        return this.result.toString();
    }

    @Override
    public String visitCreateDefinitionClause(MySQLStatementParser.CreateDefinitionClauseContext ctx) {
        ++this.indentCount;
        this.formatPrint("(");
        this.formatPrintln();
        this.visit((ParseTree)ctx.tableElementList());
        this.formatPrint("\n");
        this.formatPrint(")");
        --this.indentCount;
        return this.result.toString();
    }

    @Override
    public String visitTableElementList(MySQLStatementParser.TableElementListContext ctx) {
        int tableElementCount = ctx.tableElement().size();
        for (int i = 0; i < tableElementCount; ++i) {
            if (0 == i) {
                this.visit((ParseTree)ctx.tableElement(i));
                continue;
            }
            this.formatPrintln(",");
            this.visit((ParseTree)ctx.tableElement(i));
        }
        return this.result.toString();
    }

    @Override
    public String visitFieldLength(MySQLStatementParser.FieldLengthContext ctx) {
        this.formatPrint("(");
        this.formatPrint(ctx.NUMBER_().getText());
        this.formatPrint(")");
        return this.result.toString();
    }

    @Override
    public String visitPrecision(MySQLStatementParser.PrecisionContext ctx) {
        this.formatPrint("(");
        this.formatPrint(ctx.NUMBER_(0).getText());
        this.formatPrint(", ");
        this.formatPrint(ctx.NUMBER_(1).getText());
        this.formatPrint(")");
        return (String)super.visitPrecision(ctx);
    }

    @Override
    public String visitTypeDatetimePrecision(MySQLStatementParser.TypeDatetimePrecisionContext ctx) {
        this.formatPrint("(");
        this.formatPrint(ctx.NUMBER_().getText());
        this.formatPrint(")");
        return this.result.toString();
    }

    @Override
    public String visitDataType(MySQLStatementParser.DataTypeContext ctx) {
        int childCount = ctx.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ParseTree child = ctx.getChild(i);
            if (!(i == 0 || child instanceof MySQLStatementParser.FieldLengthContext || child instanceof MySQLStatementParser.PrecisionContext || child instanceof MySQLStatementParser.StringListContext || child instanceof MySQLStatementParser.TypeDatetimePrecisionContext)) {
                this.formatPrint(" ");
            }
            child.accept((ParseTreeVisitor)this);
        }
        return this.result.toString();
    }

    @Override
    public String visitStringList(MySQLStatementParser.StringListContext ctx) {
        int stringCount = ctx.textString().size();
        this.formatPrint("(");
        for (int i = 0; i < stringCount; ++i) {
            if (0 == i) {
                this.formatPrint(ctx.textString(i).getText());
                continue;
            }
            this.formatPrintln(",");
            this.visit((ParseTree)ctx.textString(i));
        }
        this.formatPrint(")");
        return this.result.toString();
    }

    @Override
    public String visitUserVariable(MySQLStatementParser.UserVariableContext ctx) {
        this.formatPrint("@");
        this.visit((ParseTree)ctx.textOrIdentifier());
        return this.result.toString();
    }

    @Override
    public String visitSystemVariable(MySQLStatementParser.SystemVariableContext ctx) {
        this.formatPrint("@@");
        if (null != ctx.systemVariableScope) {
            if (this.upperCase) {
                this.formatPrint(ctx.systemVariableScope.getText().toUpperCase());
            } else {
                this.formatPrint(ctx.systemVariableScope.getText().toLowerCase());
            }
        }
        this.visit((ParseTree)ctx.textOrIdentifier());
        if (null != ctx.DOT_()) {
            this.formatPrint(".");
            this.visit((ParseTree)ctx.identifier());
        }
        return this.result.toString();
    }

    public String visitTerminal(TerminalNode node) {
        if ("<EOF>".equals(node.getText())) {
            return this.result.toString();
        }
        if (this.upperCase) {
            this.formatPrint(node.getText().toUpperCase());
        } else {
            this.formatPrint(node.getText().toLowerCase());
        }
        return this.result.toString();
    }

    @Override
    public String visitIdentifier(MySQLStatementParser.IdentifierContext ctx) {
        this.formatPrint(ctx.getText());
        return this.result.toString();
    }

    @Override
    public String visitLiterals(MySQLStatementParser.LiteralsContext ctx) {
        if (this.parameterized) {
            this.formatPrint("?");
        } else {
            super.visitLiterals(ctx);
        }
        return this.result.toString();
    }

    @Override
    public String visitTemporalLiterals(MySQLStatementParser.TemporalLiteralsContext ctx) {
        this.visit(ctx.getChild(0));
        this.formatPrint(ctx.SINGLE_QUOTED_TEXT().getText());
        return this.result.toString();
    }

    @Override
    public String visitStringLiterals(MySQLStatementParser.StringLiteralsContext ctx) {
        if (this.parameterized) {
            this.formatPrint("?");
            return this.result.toString();
        }
        if (null != ctx.string_()) {
            if (null != ctx.UNDERSCORE_CHARSET()) {
                this.formatPrint(ctx.UNDERSCORE_CHARSET().getText());
            }
            this.visit((ParseTree)ctx.string_());
        } else {
            this.visit((ParseTree)ctx.NCHAR_TEXT());
        }
        return this.result.toString();
    }

    @Override
    public String visitString_(MySQLStatementParser.String_Context ctx) {
        this.formatPrint(ctx.getText());
        return this.result.toString();
    }

    @Override
    public String visitNumberLiterals(MySQLStatementParser.NumberLiteralsContext ctx) {
        if (this.parameterized) {
            this.formatPrint("?");
        } else {
            this.formatPrint(ctx.getText());
        }
        return this.result.toString();
    }

    @Override
    public String visitWithClause(MySQLStatementParser.WithClauseContext ctx) {
        this.formatPrint("WITH ");
        if (null != ctx.RECURSIVE()) {
            this.visit((ParseTree)ctx.RECURSIVE());
            this.result.append(" ");
        }
        for (int i = 0; i < ctx.cteClause().size(); ++i) {
            if (i != 0 && i < ctx.cteClause().size() - 1) {
                this.result.append(", ");
            }
            this.visit((ParseTree)ctx.cteClause(i));
        }
        if (null != ctx.parent) {
            this.result.append("\n");
        }
        return this.result.toString();
    }

    @Override
    public String visitCteClause(MySQLStatementParser.CteClauseContext ctx) {
        this.visit((ParseTree)ctx.identifier());
        this.result.append(" ");
        if (null != ctx.columnNames()) {
            this.visit((ParseTree)ctx.columnNames());
            this.result.append(" ");
        }
        this.result.append("AS ");
        this.visit((ParseTree)ctx.subquery());
        return this.result.toString();
    }

    @Override
    public String visitColumnNames(MySQLStatementParser.ColumnNamesContext ctx) {
        int columnCount = ctx.columnName().size();
        for (int i = 0; i < columnCount; ++i) {
            if (i != 0 && i < columnCount - 1) {
                this.result.append(", ");
                continue;
            }
            this.visit((ParseTree)ctx.columnName(i));
        }
        return this.result.toString();
    }

    public String visitChildren(RuleNode node) {
        String result = (String)this.defaultResult();
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (!(i == 0 || "(".equals(node.getChild(i - 1).getText()) || ")".equals(node.getChild(i).getText()) || "(".equals(node.getChild(i).getText()))) {
                this.formatPrint(" ");
            }
            if (!this.shouldVisitNextChild(node, result)) break;
            ParseTree child = node.getChild(i);
            String childResult = (String)child.accept((ParseTreeVisitor)this);
            result = (String)this.aggregateResult(result, childResult);
        }
        return result;
    }

    private void formatPrint(char value) {
        if (null == this.result) {
            return;
        }
        this.result.append(value);
    }

    private void formatPrint(String text) {
        if (null == this.result) {
            return;
        }
        this.result.append(text);
    }

    protected void formatPrintIndent() {
        if (null == this.result) {
            return;
        }
        for (int i = 0; i < this.indentCount; ++i) {
            this.result.append('\t');
        }
    }

    private void formatPrintln() {
        this.formatPrint('\n');
        ++this.lines;
        this.formatPrintIndent();
    }

    private void formatPrintln(String text) {
        this.formatPrint(text);
        this.formatPrint('\n');
        ++this.lines;
        this.formatPrintIndent();
    }

    @Generated
    public MySQLFormatSQLVisitor() {
    }

    @Generated
    public StringBuilder getResult() {
        return this.result;
    }

    @Generated
    public boolean isUpperCase() {
        return this.upperCase;
    }

    @Generated
    public boolean isParameterized() {
        return this.parameterized;
    }

    @Generated
    public int getIndentCount() {
        return this.indentCount;
    }

    @Generated
    public int getLines() {
        return this.lines;
    }

    @Generated
    public int getProjectionsCountOfLine() {
        return this.projectionsCountOfLine;
    }

    @Generated
    public void setResult(StringBuilder result) {
        this.result = result;
    }

    @Generated
    public void setUpperCase(boolean upperCase) {
        this.upperCase = upperCase;
    }

    @Generated
    public void setParameterized(boolean parameterized) {
        this.parameterized = parameterized;
    }

    @Generated
    public void setIndentCount(int indentCount) {
        this.indentCount = indentCount;
    }

    @Generated
    public void setLines(int lines) {
        this.lines = lines;
    }

    @Generated
    public void setProjectionsCountOfLine(int projectionsCountOfLine) {
        this.projectionsCountOfLine = projectionsCountOfLine;
    }
}

