/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sql.dialect.handler.dml;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.pagination.limit.LimitSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.LockSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WindowSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.WithSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.handler.SQLStatementHandler;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.MySQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dml.MySQLSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.OracleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.oracle.dml.OracleSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.PostgreSQLStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.postgresql.dml.PostgreSQLSelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.SQL92Statement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sql92.dml.SQL92SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.SQLServerStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dml.SQLServerSelectStatement;

public final class SelectStatementHandler
implements SQLStatementHandler {
    public static Optional<LimitSegment> getLimitSegment(SelectStatement selectStatement) {
        if (selectStatement instanceof MySQLStatement) {
            return ((MySQLSelectStatement)selectStatement).getLimit();
        }
        if (selectStatement instanceof PostgreSQLStatement) {
            return ((PostgreSQLSelectStatement)selectStatement).getLimit();
        }
        if (selectStatement instanceof SQL92Statement) {
            return ((SQL92SelectStatement)selectStatement).getLimit();
        }
        if (selectStatement instanceof SQLServerStatement) {
            return ((SQLServerSelectStatement)selectStatement).getLimit();
        }
        return Optional.empty();
    }

    public static Optional<LockSegment> getLockSegment(SelectStatement selectStatement) {
        if (selectStatement instanceof MySQLStatement) {
            return ((MySQLSelectStatement)selectStatement).getLock();
        }
        if (selectStatement instanceof OracleStatement) {
            return ((OracleSelectStatement)selectStatement).getLock();
        }
        if (selectStatement instanceof PostgreSQLStatement) {
            return ((PostgreSQLSelectStatement)selectStatement).getLock();
        }
        return Optional.empty();
    }

    public static Optional<WindowSegment> getWindowSegment(SelectStatement selectStatement) {
        if (selectStatement instanceof MySQLStatement) {
            return ((MySQLSelectStatement)selectStatement).getWindow();
        }
        if (selectStatement instanceof PostgreSQLStatement) {
            return ((PostgreSQLSelectStatement)selectStatement).getWindow();
        }
        return Optional.empty();
    }

    public static Optional<WithSegment> getWithSegment(SelectStatement selectStatement) {
        if (selectStatement instanceof OracleStatement) {
            return ((OracleSelectStatement)selectStatement).getWithSegment();
        }
        return Optional.empty();
    }

    @Generated
    private SelectStatementHandler() {
    }
}

