/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;
import scala.Tuple3;

public final class JavaLogQuery {
    public static final List<String> exampleApacheLogs = Lists.newArrayList((Object[])new String[]{"10.10.10.10 - \"FRED\" [18/Jan/2013:17:56:07 +1100] \"GET http://images.com/2013/Generic.jpg HTTP/1.1\" 304 315 \"http://referall.com/\" \"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; GTB7.4; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022; .NET CLR 3.0.4506.2152; .NET CLR 1.0.3705; .NET CLR 1.1.4322; .NET CLR 3.5.30729; Release=ARP)\" \"UD-1\" - \"image/jpeg\" \"whatever\" 0.350 \"-\" - \"\" 265 923 934 \"\" 62.24.11.25 images.com 1358492167 - Whatup", "10.10.10.10 - \"FRED\" [18/Jan/2013:18:02:37 +1100] \"GET http://images.com/2013/Generic.jpg HTTP/1.1\" 304 306 \"http:/referall.com\" \"Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; GTB7.4; .NET CLR 2.0.50727; .NET CLR 3.0.04506.30; .NET CLR 3.0.04506.648; .NET CLR 3.5.21022; .NET CLR 3.0.4506.2152; .NET CLR 1.0.3705; .NET CLR 1.1.4322; .NET CLR  3.5.30729; Release=ARP)\" \"UD-1\" - \"image/jpeg\" \"whatever\" 0.352 \"-\" - \"\" 256 977 988 \"\" 0 73.23.2.15 images.com 1358492557 - Whatup"});
    public static final Pattern apacheLogRegex = Pattern.compile("^([\\d.]+) (\\S+) (\\S+) \\[([\\w\\d:/]+\\s[+\\-]\\d{4})\\] \"(.+?)\" (\\d{3}) ([\\d\\-]+) \"([^\"]+)\" \"([^\"]+)\".*");

    public static Tuple3<String, String, String> extractKey(String line) {
        Matcher m = apacheLogRegex.matcher(line);
        List key = Collections.emptyList();
        if (m.find()) {
            String ip = m.group(1);
            String user = m.group(3);
            String query = m.group(5);
            if (!user.equalsIgnoreCase("-")) {
                return new Tuple3((Object)ip, (Object)user, (Object)query);
            }
        }
        return new Tuple3(null, null, null);
    }

    public static Stats extractStats(String line) {
        Matcher m = apacheLogRegex.matcher(line);
        if (m.find()) {
            int bytes = Integer.parseInt(m.group(7));
            return new Stats(1, bytes);
        }
        return new Stats(1, 0);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: JavaLogQuery <master> [logFile]");
            System.exit(1);
        }
        JavaSparkContext jsc = new JavaSparkContext(args[0], "JavaLogQuery", System.getenv("SPARK_HOME"), JavaSparkContext.jarOfClass(JavaLogQuery.class));
        JavaRDD dataSet = args.length == 2 ? jsc.textFile(args[1]) : jsc.parallelize(exampleApacheLogs);
        JavaPairRDD extracted = dataSet.map((PairFunction)new PairFunction<String, Tuple3<String, String, String>, Stats>(){

            public Tuple2<Tuple3<String, String, String>, Stats> call(String s) {
                return new Tuple2(JavaLogQuery.extractKey(s), (Object)JavaLogQuery.extractStats(s));
            }
        });
        JavaPairRDD counts = extracted.reduceByKey((Function2)new Function2<Stats, Stats, Stats>(){

            public Stats call(Stats stats, Stats stats2) {
                return stats.merge(stats2);
            }
        });
        List output = counts.collect();
        for (Tuple2 t : output) {
            System.out.println(t._1 + "\t" + t._2);
        }
        System.exit(0);
    }

    public static class Stats
    implements Serializable {
        private final int count;
        private final int numBytes;

        public Stats(int count, int numBytes) {
            this.count = count;
            this.numBytes = numBytes;
        }

        public Stats merge(Stats other) {
            return new Stats(this.count + other.count, this.numBytes + other.numBytes);
        }

        public String toString() {
            return String.format("bytes=%s\tn=%s", this.numBytes, this.count);
        }
    }
}

