/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public final class JavaPageRank {
    private static final Pattern SPACES = Pattern.compile("\\s+");

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            System.err.println("Usage: JavaPageRank <master> <file> <number_of_iterations>");
            System.exit(1);
        }
        JavaSparkContext ctx = new JavaSparkContext(args[0], "JavaPageRank", System.getenv("SPARK_HOME"), JavaSparkContext.jarOfClass(JavaPageRank.class));
        JavaRDD lines = ctx.textFile(args[1], 1);
        JavaPairRDD links = lines.map((PairFunction)new PairFunction<String, String, String>(){

            public Tuple2<String, String> call(String s) {
                String[] parts = SPACES.split(s);
                return new Tuple2((Object)parts[0], (Object)parts[1]);
            }
        }).distinct().groupByKey().cache();
        JavaPairRDD ranks = links.mapValues((Function)new Function<List<String>, Double>(){

            public Double call(List<String> rs) {
                return 1.0;
            }
        });
        for (int current = 0; current < Integer.parseInt(args[2]); ++current) {
            JavaPairRDD contribs = links.join(ranks).values().flatMap((PairFlatMapFunction)new PairFlatMapFunction<Tuple2<List<String>, Double>, String, Double>(){

                public Iterable<Tuple2<String, Double>> call(Tuple2<List<String>, Double> s) {
                    ArrayList<Tuple2<String, Double>> results = new ArrayList<Tuple2<String, Double>>();
                    for (String n : (List)s._1) {
                        results.add((Tuple2<String, Double>)new Tuple2((Object)n, (Object)((Double)s._2 / (double)((List)s._1).size())));
                    }
                    return results;
                }
            });
            ranks = contribs.reduceByKey((Function2)new Sum()).mapValues((Function)new Function<Double, Double>(){

                public Double call(Double sum) {
                    return 0.15 + sum * 0.85;
                }
            });
        }
        List output = ranks.collect();
        for (Tuple2 tuple : output) {
            System.out.println(tuple._1 + " has rank: " + tuple._2 + ".");
        }
        System.exit(0);
    }

    private static class Sum
    extends Function2<Double, Double, Double> {
        private Sum() {
        }

        public Double call(Double a, Double b) {
            return a + b;
        }
    }
}

