/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Blas;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.SeqBlas;
import cern.jet.math.Functions;
import org.apache.spark.examples.LocalALS$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class LocalALS$ {
    public static final LocalALS$ MODULE$;
    private int M;
    private int U;
    private int F;
    private int ITERATIONS;
    private final double LAMBDA;
    private final DoubleFactory2D factory2D;
    private final DoubleFactory1D factory1D;
    private final Algebra algebra;
    private final Blas blas;

    static {
        new LocalALS$();
    }

    public int M() {
        return this.M;
    }

    public void M_$eq(int x$1) {
        this.M = x$1;
    }

    public int U() {
        return this.U;
    }

    public void U_$eq(int x$1) {
        this.U = x$1;
    }

    public int F() {
        return this.F;
    }

    public void F_$eq(int x$1) {
        this.F = x$1;
    }

    public int ITERATIONS() {
        return this.ITERATIONS;
    }

    public void ITERATIONS_$eq(int x$1) {
        this.ITERATIONS = x$1;
    }

    public double LAMBDA() {
        return this.LAMBDA;
    }

    public DoubleFactory2D factory2D() {
        return this.factory2D;
    }

    public DoubleFactory1D factory1D() {
        return this.factory1D;
    }

    public Algebra algebra() {
        return this.algebra;
    }

    public Blas blas() {
        return this.blas;
    }

    public DoubleMatrix2D generateR() {
        DoubleMatrix2D mh = this.factory2D().random(this.M(), this.F());
        DoubleMatrix2D uh = this.factory2D().random(this.U(), this.F());
        return this.algebra().mult(mh, this.algebra().transpose(uh));
    }

    public double rmse(DoubleMatrix2D targetR, DoubleMatrix1D[] ms, DoubleMatrix1D[] us) {
        DoubleMatrix2D r = this.factory2D().make(this.M(), this.U());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)new Serializable(ms, us, r){
            public static final long serialVersionUID = 0L;
            public final DoubleMatrix1D[] ms$1;
            public final DoubleMatrix1D[] us$1;
            public final DoubleMatrix2D r$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), LocalALS$.MODULE$.U()).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.rmse.1 $outer;
                    private final int i$2;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        this.$outer.r$1.set(this.i$2, j, LocalALS$.MODULE$.blas().ddot(this.$outer.ms$1[this.i$2], this.$outer.us$1[j]));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$2 = i$2;
                    }
                });
            }
            {
                this.ms$1 = ms$1;
                this.us$1 = us$1;
                this.r$1 = r$1;
            }
        });
        this.blas().daxpy(-1.0, targetR, r);
        double sumSqs = r.aggregate(Functions.plus, Functions.square);
        return package$.MODULE$.sqrt(sumSqs / (double)(this.M() * this.U()));
    }

    public DoubleMatrix1D updateMovie(int i, DoubleMatrix1D m, DoubleMatrix1D[] us, DoubleMatrix2D R) {
        DoubleMatrix2D XtX = this.factory2D().make(this.F(), this.F());
        DoubleMatrix1D Xty = this.factory1D().make(this.F());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.U()).foreach$mVc$sp((Function1)new Serializable(i, us, R, XtX, Xty){
            public static final long serialVersionUID = 0L;
            private final int i$1;
            private final DoubleMatrix1D[] us$2;
            private final DoubleMatrix2D R$1;
            private final DoubleMatrix2D XtX$1;
            private final DoubleMatrix1D Xty$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                DoubleMatrix1D u = this.us$2[j];
                LocalALS$.MODULE$.blas().dger(1.0, u, u, this.XtX$1);
                LocalALS$.MODULE$.blas().daxpy(this.R$1.get(this.i$1, j), u, this.Xty$1);
            }
            {
                this.i$1 = i$1;
                this.us$2 = us$2;
                this.R$1 = R$1;
                this.XtX$1 = XtX$1;
                this.Xty$1 = Xty$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.F()).foreach$mVc$sp((Function1)new Serializable(XtX){
            public static final long serialVersionUID = 0L;
            private final DoubleMatrix2D XtX$1;

            public final void apply(int d) {
                this.apply$mcVI$sp(d);
            }

            public void apply$mcVI$sp(int d) {
                this.XtX$1.set(d, d, this.XtX$1.get(d, d) + LocalALS$.MODULE$.LAMBDA() * (double)LocalALS$.MODULE$.U());
            }
            {
                this.XtX$1 = XtX$1;
            }
        });
        CholeskyDecomposition ch = new CholeskyDecomposition(XtX);
        DoubleMatrix2D Xty2D = this.factory2D().make(Xty.toArray(), this.F());
        DoubleMatrix2D solved2D = ch.solve(Xty2D);
        return solved2D.viewColumn(0);
    }

    public DoubleMatrix1D updateUser(int j, DoubleMatrix1D u, DoubleMatrix1D[] ms, DoubleMatrix2D R) {
        DoubleMatrix2D XtX = this.factory2D().make(this.F(), this.F());
        DoubleMatrix1D Xty = this.factory1D().make(this.F());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)new Serializable(j, ms, R, XtX, Xty){
            public static final long serialVersionUID = 0L;
            private final int j$1;
            private final DoubleMatrix1D[] ms$2;
            private final DoubleMatrix2D R$2;
            private final DoubleMatrix2D XtX$2;
            private final DoubleMatrix1D Xty$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                DoubleMatrix1D m = this.ms$2[i];
                LocalALS$.MODULE$.blas().dger(1.0, m, m, this.XtX$2);
                LocalALS$.MODULE$.blas().daxpy(this.R$2.get(i, this.j$1), m, this.Xty$2);
            }
            {
                this.j$1 = j$1;
                this.ms$2 = ms$2;
                this.R$2 = R$2;
                this.XtX$2 = XtX$2;
                this.Xty$2 = Xty$2;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.F()).foreach$mVc$sp((Function1)new Serializable(XtX){
            public static final long serialVersionUID = 0L;
            private final DoubleMatrix2D XtX$2;

            public final void apply(int d) {
                this.apply$mcVI$sp(d);
            }

            public void apply$mcVI$sp(int d) {
                this.XtX$2.set(d, d, this.XtX$2.get(d, d) + LocalALS$.MODULE$.LAMBDA() * (double)LocalALS$.MODULE$.M());
            }
            {
                this.XtX$2 = XtX$2;
            }
        });
        CholeskyDecomposition ch = new CholeskyDecomposition(XtX);
        DoubleMatrix2D Xty2D = this.factory2D().make(Xty.toArray(), this.F());
        DoubleMatrix2D solved2D = ch.solve(Xty2D);
        return solved2D.viewColumn(0);
    }

    public void main(String[] args) {
        String[] stringArray = args;
        Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(4) == 0) {
            String m = (String)((SeqLike)option.get()).apply(0);
            String u = (String)((SeqLike)option.get()).apply(1);
            String f = (String)((SeqLike)option.get()).apply(2);
            String iters = (String)((SeqLike)option.get()).apply(3);
            this.M_$eq(new StringOps(Predef$.MODULE$.augmentString(m)).toInt());
            this.U_$eq(new StringOps(Predef$.MODULE$.augmentString(u)).toInt());
            this.F_$eq(new StringOps(Predef$.MODULE$.augmentString(f)).toInt());
            this.ITERATIONS_$eq(new StringOps(Predef$.MODULE$.augmentString(iters)).toInt());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            System.err.println("Usage: LocalALS <M> <U> <F> <iters>");
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.printf("Running with M=%d, U=%d, F=%d, iters=%d\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.M()), BoxesRunTime.boxToInteger((int)this.U()), BoxesRunTime.boxToInteger((int)this.F()), BoxesRunTime.boxToInteger((int)this.ITERATIONS())}));
        DoubleMatrix2D R = this.generateR();
        ObjectRef ms = new ObjectRef((Object)((DoubleMatrix1D[])Array$.MODULE$.fill(this.M(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DoubleMatrix1D apply() {
                return LocalALS$.MODULE$.factory1D().random(LocalALS$.MODULE$.F());
            }
        }, ClassTag$.MODULE$.apply(DoubleMatrix1D.class))));
        ObjectRef us = new ObjectRef((Object)((DoubleMatrix1D[])Array$.MODULE$.fill(this.U(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DoubleMatrix1D apply() {
                return LocalALS$.MODULE$.factory1D().random(LocalALS$.MODULE$.F());
            }
        }, ClassTag$.MODULE$.apply(DoubleMatrix1D.class))));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach$mVc$sp((Function1)new Serializable(R, ms, us){
            public static final long serialVersionUID = 0L;
            public final DoubleMatrix2D R$3;
            public final ObjectRef ms$3;
            public final ObjectRef us$3;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Iteration ").append((Object)BoxesRunTime.boxToInteger((int)iter)).append((Object)":").toString());
                this.ms$3.elem = (DoubleMatrix1D[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), LocalALS$.MODULE$.M()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final DoubleMatrix1D apply(int i) {
                        return LocalALS$.MODULE$.updateMovie(i, ((DoubleMatrix1D[])this.$outer.ms$3.elem)[i], (DoubleMatrix1D[])this.$outer.us$3.elem, this.$outer.R$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DoubleMatrix1D.class));
                this.us$3.elem = (DoubleMatrix1D[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), LocalALS$.MODULE$.U()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final DoubleMatrix1D apply(int j) {
                        return LocalALS$.MODULE$.updateUser(j, ((DoubleMatrix1D[])this.$outer.us$3.elem)[j], (DoubleMatrix1D[])this.$outer.ms$3.elem, this.$outer.R$3);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(DoubleMatrix1D.class));
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"RMSE = ").append((Object)BoxesRunTime.boxToDouble((double)LocalALS$.MODULE$.rmse(this.R$3, (DoubleMatrix1D[])this.ms$3.elem, (DoubleMatrix1D[])this.us$3.elem))).toString());
                Predef$.MODULE$.println();
            }
            {
                this.R$3 = R$3;
                this.ms$3 = ms$3;
                this.us$3 = us$3;
            }
        });
    }

    private LocalALS$() {
        MODULE$ = this;
        this.M = 0;
        this.U = 0;
        this.F = 0;
        this.ITERATIONS = 0;
        this.LAMBDA = 0.01;
        this.factory2D = DoubleFactory2D.dense;
        this.factory1D = DoubleFactory1D.dense;
        this.algebra = Algebra.DEFAULT;
        this.blas = SeqBlas.seqBlas;
    }
}

