/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.Blas;
import cern.colt.matrix.linalg.CholeskyDecomposition;
import cern.colt.matrix.linalg.SeqBlas;
import cern.jet.math.Functions;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.examples.SparkALS$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SparkALS$ {
    public static final SparkALS$ MODULE$;
    private int M;
    private int U;
    private int F;
    private int ITERATIONS;
    private final double LAMBDA;
    private final DoubleFactory2D factory2D;
    private final DoubleFactory1D factory1D;
    private final Algebra algebra;
    private final Blas blas;

    static {
        new SparkALS$();
    }

    public int M() {
        return this.M;
    }

    public void M_$eq(int x$1) {
        this.M = x$1;
    }

    public int U() {
        return this.U;
    }

    public void U_$eq(int x$1) {
        this.U = x$1;
    }

    public int F() {
        return this.F;
    }

    public void F_$eq(int x$1) {
        this.F = x$1;
    }

    public int ITERATIONS() {
        return this.ITERATIONS;
    }

    public void ITERATIONS_$eq(int x$1) {
        this.ITERATIONS = x$1;
    }

    public double LAMBDA() {
        return this.LAMBDA;
    }

    public DoubleFactory2D factory2D() {
        return this.factory2D;
    }

    public DoubleFactory1D factory1D() {
        return this.factory1D;
    }

    public Algebra algebra() {
        return this.algebra;
    }

    public Blas blas() {
        return this.blas;
    }

    public DoubleMatrix2D generateR() {
        DoubleMatrix2D mh = this.factory2D().random(this.M(), this.F());
        DoubleMatrix2D uh = this.factory2D().random(this.U(), this.F());
        return this.algebra().mult(mh, this.algebra().transpose(uh));
    }

    public double rmse(DoubleMatrix2D targetR, DoubleMatrix1D[] ms, DoubleMatrix1D[] us) {
        DoubleMatrix2D r = this.factory2D().make(this.M(), this.U());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.M()).foreach$mVc$sp((Function1)new Serializable(ms, us, r){
            public static final long serialVersionUID = 0L;
            public final DoubleMatrix1D[] ms$1;
            public final DoubleMatrix1D[] us$1;
            public final DoubleMatrix2D r$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparkALS$.MODULE$.U()).foreach$mVc$sp((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.rmse.1 $outer;
                    private final int i$2;

                    public final void apply(int j) {
                        this.apply$mcVI$sp(j);
                    }

                    public void apply$mcVI$sp(int j) {
                        this.$outer.r$1.set(this.i$2, j, SparkALS$.MODULE$.blas().ddot(this.$outer.ms$1[this.i$2], this.$outer.us$1[j]));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.i$2 = i$2;
                    }
                });
            }
            {
                this.ms$1 = ms$1;
                this.us$1 = us$1;
                this.r$1 = r$1;
            }
        });
        this.blas().daxpy(-1.0, targetR, r);
        double sumSqs = r.aggregate(Functions.plus, Functions.square);
        return package$.MODULE$.sqrt(sumSqs / (double)(this.M() * this.U()));
    }

    public DoubleMatrix1D update(int i, DoubleMatrix1D m, DoubleMatrix1D[] us, DoubleMatrix2D R) {
        int U = Predef$.MODULE$.refArrayOps((Object[])us).size();
        int F = us[0].size();
        DoubleMatrix2D XtX = this.factory2D().make(F, F);
        DoubleMatrix1D Xty = this.factory1D().make(F);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), U).foreach$mVc$sp((Function1)new Serializable(i, us, R, XtX, Xty){
            public static final long serialVersionUID = 0L;
            private final int i$1;
            private final DoubleMatrix1D[] us$2;
            private final DoubleMatrix2D R$1;
            private final DoubleMatrix2D XtX$1;
            private final DoubleMatrix1D Xty$1;

            public final void apply(int j) {
                this.apply$mcVI$sp(j);
            }

            public void apply$mcVI$sp(int j) {
                DoubleMatrix1D u = this.us$2[j];
                SparkALS$.MODULE$.blas().dger(1.0, u, u, this.XtX$1);
                SparkALS$.MODULE$.blas().daxpy(this.R$1.get(this.i$1, j), u, this.Xty$1);
            }
            {
                this.i$1 = i$1;
                this.us$2 = us$2;
                this.R$1 = R$1;
                this.XtX$1 = XtX$1;
                this.Xty$1 = Xty$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), F).foreach$mVc$sp((Function1)new Serializable(U, XtX){
            public static final long serialVersionUID = 0L;
            private final int U$1;
            private final DoubleMatrix2D XtX$1;

            public final void apply(int d) {
                this.apply$mcVI$sp(d);
            }

            public void apply$mcVI$sp(int d) {
                this.XtX$1.set(d, d, this.XtX$1.get(d, d) + SparkALS$.MODULE$.LAMBDA() * (double)this.U$1);
            }
            {
                this.U$1 = U$1;
                this.XtX$1 = XtX$1;
            }
        });
        CholeskyDecomposition ch = new CholeskyDecomposition(XtX);
        DoubleMatrix2D Xty2D = this.factory2D().make(Xty.toArray(), F);
        DoubleMatrix2D solved2D = ch.solve(Xty2D);
        return solved2D.viewColumn(0);
    }

    public void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: SparkALS <master> [<M> <U> <F> <iters> <slices>]");
            System.exit(1);
        }
        String host = "";
        IntRef slices = new IntRef(0);
        IndexedSeq options = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 5).map((Function1)new Serializable(args){
            public static final long serialVersionUID = 0L;
            private final String[] args$1;

            public final Option<String> apply(int i) {
                return i < this.args$1.length ? new Some((Object)this.args$1[i]) : None$.MODULE$;
            }
            {
                this.args$1 = args$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Option[] optionArray = (Option[])options.toArray(ClassTag$.MODULE$.apply(Option.class));
        Option option = Array$.MODULE$.unapplySeq((Object)optionArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(6) == 0) {
            Option host_ = (Option)((SeqLike)option.get()).apply(0);
            Option m = (Option)((SeqLike)option.get()).apply(1);
            Option u = (Option)((SeqLike)option.get()).apply(2);
            Option f = (Option)((SeqLike)option.get()).apply(3);
            Option iters = (Option)((SeqLike)option.get()).apply(4);
            Option slices_ = (Option)((SeqLike)option.get()).apply(5);
            host = (String)host_.get();
            this.M_$eq(new StringOps(Predef$.MODULE$.augmentString((String)m.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "100";
                }
            }))).toInt());
            this.U_$eq(new StringOps(Predef$.MODULE$.augmentString((String)u.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "500";
                }
            }))).toInt());
            this.F_$eq(new StringOps(Predef$.MODULE$.augmentString((String)f.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "10";
                }
            }))).toInt());
            this.ITERATIONS_$eq(new StringOps(Predef$.MODULE$.augmentString((String)iters.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "5";
                }
            }))).toInt());
            slices.elem = new StringOps(Predef$.MODULE$.augmentString((String)slices_.getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "2";
                }
            }))).toInt();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            System.err.println("Usage: SparkALS <master> [<M> <U> <F> <iters> <slices>]");
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.printf("Running with M=%d, U=%d, F=%d, iters=%d\n", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.M()), BoxesRunTime.boxToInteger((int)this.U()), BoxesRunTime.boxToInteger((int)this.F()), BoxesRunTime.boxToInteger((int)this.ITERATIONS())}));
        SparkContext sc = new SparkContext(host, "SparkALS", System.getenv("SPARK_HOME"), SparkContext$.MODULE$.jarOfClass(this.getClass()), SparkContext$.MODULE$.$lessinit$greater$default$5(), SparkContext$.MODULE$.$lessinit$greater$default$6());
        DoubleMatrix2D R = this.generateR();
        ObjectRef ms = new ObjectRef((Object)((DoubleMatrix1D[])Array$.MODULE$.fill(this.M(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DoubleMatrix1D apply() {
                return SparkALS$.MODULE$.factory1D().random(SparkALS$.MODULE$.F());
            }
        }, ClassTag$.MODULE$.apply(DoubleMatrix1D.class))));
        ObjectRef us = new ObjectRef((Object)((DoubleMatrix1D[])Array$.MODULE$.fill(this.U(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DoubleMatrix1D apply() {
                return SparkALS$.MODULE$.factory1D().random(SparkALS$.MODULE$.F());
            }
        }, ClassTag$.MODULE$.apply(DoubleMatrix1D.class))));
        Broadcast Rc = sc.broadcast((Object)R);
        ObjectRef msb = new ObjectRef((Object)sc.broadcast((Object)((DoubleMatrix1D[])ms.elem)));
        ObjectRef usb = new ObjectRef((Object)sc.broadcast((Object)((DoubleMatrix1D[])us.elem)));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach$mVc$sp((Function1)new Serializable(slices, sc, R, ms, us, Rc, msb, usb){
            public static final long serialVersionUID = 0L;
            private final IntRef slices$1;
            private final SparkContext sc$1;
            private final DoubleMatrix2D R$2;
            private final ObjectRef ms$2;
            private final ObjectRef us$3;
            public final Broadcast Rc$1;
            public final ObjectRef msb$1;
            public final ObjectRef usb$1;

            public final void apply(int iter) {
                this.apply$mcVI$sp(iter);
            }

            public void apply$mcVI$sp(int iter) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Iteration ").append((Object)BoxesRunTime.boxToInteger((int)iter)).append((Object)":").toString());
                this.ms$2.elem = (DoubleMatrix1D[])this.sc$1.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparkALS$.MODULE$.M()), this.slices$1.elem, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final DoubleMatrix1D apply(int i) {
                        return SparkALS$.MODULE$.update(i, ((DoubleMatrix1D[])((Broadcast)this.$outer.msb$1.elem).value())[i], (DoubleMatrix1D[])((Broadcast)this.$outer.usb$1.elem).value(), (DoubleMatrix2D)this.$outer.Rc$1.value());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(DoubleMatrix1D.class)).toArray();
                this.msb$1.elem = this.sc$1.broadcast((Object)((DoubleMatrix1D[])this.ms$2.elem));
                this.us$3.elem = (DoubleMatrix1D[])this.sc$1.parallelize((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), SparkALS$.MODULE$.U()), this.slices$1.elem, ClassTag$.MODULE$.Int()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final DoubleMatrix1D apply(int i) {
                        return SparkALS$.MODULE$.update(i, ((DoubleMatrix1D[])((Broadcast)this.$outer.usb$1.elem).value())[i], (DoubleMatrix1D[])((Broadcast)this.$outer.msb$1.elem).value(), SparkALS$.MODULE$.algebra().transpose((DoubleMatrix2D)this.$outer.Rc$1.value()));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(DoubleMatrix1D.class)).toArray();
                this.usb$1.elem = this.sc$1.broadcast((Object)((DoubleMatrix1D[])this.us$3.elem));
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"RMSE = ").append((Object)BoxesRunTime.boxToDouble((double)SparkALS$.MODULE$.rmse(this.R$2, (DoubleMatrix1D[])this.ms$2.elem, (DoubleMatrix1D[])this.us$3.elem))).toString());
                Predef$.MODULE$.println();
            }
            {
                this.slices$1 = slices$1;
                this.sc$1 = sc$1;
                this.R$2 = R$2;
                this.ms$2 = ms$2;
                this.us$3 = us$3;
                this.Rc$1 = Rc$1;
                this.msb$1 = msb$1;
                this.usb$1 = usb$1;
            }
        });
        System.exit(0);
    }

    private SparkALS$() {
        MODULE$ = this;
        this.M = 0;
        this.U = 0;
        this.F = 0;
        this.ITERATIONS = 0;
        this.LAMBDA = 0.01;
        this.factory2D = DoubleFactory2D.dense;
        this.factory1D = DoubleFactory1D.dense;
        this.algebra = Algebra.DEFAULT;
        this.blas = SeqBlas.seqBlas;
    }
}

