/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.util.Random;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.examples.SparkLR;
import org.apache.spark.examples.SparkLR$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Vector;
import org.apache.spark.util.Vector$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SparkLR$ {
    public static final SparkLR$ MODULE$;
    private final int N;
    private final int D;
    private final double R;
    private final int ITERATIONS;
    private final Random rand;

    static {
        new SparkLR$();
    }

    public int N() {
        return this.N;
    }

    public int D() {
        return this.D;
    }

    public double R() {
        return this.R;
    }

    public int ITERATIONS() {
        return this.ITERATIONS;
    }

    public Random rand() {
        return this.rand;
    }

    public SparkLR.DataPoint[] generateData() {
        return (SparkLR.DataPoint[])Array$.MODULE$.tabulate(this.N(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparkLR.DataPoint apply(int i) {
                return SparkLR$.MODULE$.org$apache$spark$examples$SparkLR$$generatePoint$1(i);
            }
        }, ClassTag$.MODULE$.apply(SparkLR.DataPoint.class));
    }

    public void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: SparkLR <master> [<slices>]");
            System.exit(1);
        }
        SparkContext sc = new SparkContext(args[0], "SparkLR", System.getenv("SPARK_HOME"), SparkContext$.MODULE$.jarOfClass(this.getClass()), SparkContext$.MODULE$.$lessinit$greater$default$5(), SparkContext$.MODULE$.$lessinit$greater$default$6());
        int numSlices = args.length > 1 ? new StringOps(Predef$.MODULE$.augmentString(args[1])).toInt() : 2;
        RDD points = sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])this.generateData()), numSlices, ClassTag$.MODULE$.apply(SparkLR.DataPoint.class)).cache();
        ObjectRef w = new ObjectRef((Object)Vector$.MODULE$.apply(this.D(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int x$2) {
                return this.apply$mcDI$sp(x$2);
            }

            public double apply$mcDI$sp(int x$2) {
                return (double)2 * SparkLR$.MODULE$.rand().nextDouble() - 1.0;
            }
        }));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Initial w: ").append((Object)((Vector)w.elem)).toString());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.ITERATIONS()).foreach$mVc$sp((Function1)new Serializable(points, w){
            public static final long serialVersionUID = 0L;
            private final RDD points$1;
            public final ObjectRef w$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"On iteration ").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                Vector gradient = (Vector)this.points$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final Vector apply(SparkLR.DataPoint p) {
                        return Vector$.MODULE$.doubleToMultiplier((1.0 / (1.0 + package$.MODULE$.exp(-p.y() * ((Vector)this.$outer.w$1.elem).dot(p.x()))) - 1.0) * p.y()).$times(p.x());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Vector x$3, Vector x$4) {
                        return x$3.$plus(x$4);
                    }
                });
                this.w$1.elem = ((Vector)this.w$1.elem).$minus(gradient);
            }
            {
                this.points$1 = points$1;
                this.w$1 = w$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Final w: ").append((Object)((Vector)w.elem)).toString());
        System.exit(0);
    }

    public final SparkLR.DataPoint org$apache$spark$examples$SparkLR$$generatePoint$1(int i) {
        int y = i % 2 == 0 ? -1 : 1;
        Vector x = Vector$.MODULE$.apply(this.D(), (Function1)new Serializable(y){
            public static final long serialVersionUID = 0L;
            private final int y$1;

            public final double apply(int x$1) {
                return this.apply$mcDI$sp(x$1);
            }

            public double apply$mcDI$sp(int x$1) {
                return SparkLR$.MODULE$.rand().nextGaussian() + (double)this.y$1 * SparkLR$.MODULE$.R();
            }
            {
                this.y$1 = y$1;
            }
        });
        return new SparkLR.DataPoint(x, y);
    }

    private SparkLR$() {
        MODULE$ = this;
        this.N = 10000;
        this.D = 10;
        this.R = 0.7;
        this.ITERATIONS = 5;
        this.rand = new Random(42L);
    }
}

