/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.bagel;

import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.bagel.Bagel$;
import org.apache.spark.bagel.Combiner;
import org.apache.spark.examples.bagel.PRCombiner;
import org.apache.spark.examples.bagel.PRKryoRegistrator;
import org.apache.spark.examples.bagel.PRMessage;
import org.apache.spark.examples.bagel.PRVertex;
import org.apache.spark.examples.bagel.PRVertex$;
import org.apache.spark.examples.bagel.PageRankUtils;
import org.apache.spark.rdd.RDD;
import org.xml.sax.SAXParseException;
import scala.Array$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.XML$;

public final class WikipediaPageRank$ {
    public static final WikipediaPageRank$ MODULE$;

    static {
        new WikipediaPageRank$();
    }

    public void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Usage: WikipediaPageRank <inputFile> <threshold> <numPartitions> <host> <usePartitioner>");
            System.exit(-1);
        }
        SparkConf sparkConf = new SparkConf();
        sparkConf.set("spark.serializer", "org.apache.spark.serializer.KryoSerializer");
        sparkConf.set("spark.kryo.registrator", PRKryoRegistrator.class.getName());
        String inputFile = args[0];
        double threshold = new StringOps(Predef$.MODULE$.augmentString(args[1])).toDouble();
        int numPartitions = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        String host = args[3];
        boolean usePartitioner = new StringOps(Predef$.MODULE$.augmentString(args[4])).toBoolean();
        sparkConf.setMaster(host).setAppName("WikipediaPageRank");
        SparkContext sc = new SparkContext(sparkConf, SparkContext$.MODULE$.$lessinit$greater$default$2());
        RDD input = sc.textFile(inputFile, sc.textFile$default$2());
        Predef$.MODULE$.println((Object)"Counting vertices...");
        long numVertices = input.count();
        Predef$.MODULE$.println((Object)"Done counting vertices.");
        Predef$.MODULE$.println((Object)"Parsing input file...");
        RDD vertices = input.map((Function1)new Serializable(numVertices){
            public static final long serialVersionUID = 0L;
            private final long numVertices$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Tuple2<String, PRVertex> apply(String line) {
                NodeSeq nodeSeq;
                String body;
                Tuple2 tuple2;
                String[] fields = line.split("\t");
                Tuple2 tuple22 = new Tuple2((Object)fields[1], (Object)fields[3].replace("\\n", "\n"));
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                String title = (String)tuple22._1();
                String body2 = (String)tuple22._2();
                Tuple2 tuple23 = tuple2 = new Tuple2((Object)title, (Object)body2);
                String title2 = (String)tuple23._1();
                String string = body = (String)tuple23._2();
                String string2 = "\\N";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    nodeSeq = NodeSeq$.MODULE$.Empty();
                } else {
                    try {
                        nodeSeq = XML$.MODULE$.loadString(body).$bslash$bslash("link").$bslash("target");
                    }
                    catch (SAXParseException sAXParseException) {
                        System.err.println(new StringBuilder().append((Object)"Article \"").append((Object)title2).append((Object)"\" has malformed XML in body:\n").append((Object)body).toString());
                        nodeSeq = NodeSeq$.MODULE$.Empty();
                    }
                }
                NodeSeq links = nodeSeq;
                String[] outEdges = (String[])((TraversableOnce)links.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Node link) {
                        return new String(link.text());
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
                String id = new String(title2);
                return new Tuple2((Object)id, (Object)new PRVertex(1.0 / (double)this.numVertices$1, outEdges, PRVertex$.MODULE$.$lessinit$greater$default$3()));
            }
            {
                this.numVertices$1 = numVertices$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        vertices = usePartitioner ? SparkContext$.MODULE$.rddToPairRDDFunctions(vertices, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(PRVertex.class)).partitionBy((Partitioner)new HashPartitioner(sc.defaultParallelism())).cache() : vertices.cache();
        Predef$.MODULE$.println((Object)"Done parsing input file.");
        double epsilon = 0.01 / (double)numVertices;
        RDD messages = sc.parallelize((Seq)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Tuple2.class))), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        PageRankUtils utils = new PageRankUtils();
        RDD result = Bagel$.MODULE$.run(sc, vertices, messages, (Combiner)new PRCombiner(), numPartitions, (Function3)new Serializable(numVertices, epsilon, utils){
            public static final long serialVersionUID = 0L;
            private final long numVertices$1;
            private final double epsilon$1;
            private final PageRankUtils utils$1;

            public final Tuple2<PRVertex, PRMessage[]> apply(PRVertex self, Option<Object> messageSum, int superstep) {
                return this.utils$1.computeWithCombiner(this.numVertices$1, this.epsilon$1, self, messageSum, superstep);
            }
            {
                this.numVertices$1 = numVertices$1;
                this.epsilon$1 = epsilon$1;
                this.utils$1 = utils$1;
            }
        }, ManifestFactory$.MODULE$.classType(String.class), ManifestFactory$.MODULE$.classType(PRVertex.class), ManifestFactory$.MODULE$.classType(PRMessage.class), (Manifest)ManifestFactory$.MODULE$.Double());
        System.err.println(new StringBuilder().append((Object)"Articles with PageRank >= ").append((Object)BoxesRunTime.boxToDouble((double)threshold)).append((Object)":").toString());
        String top = Predef$.MODULE$.refArrayOps((Object[])result.filter((Function1)new Serializable(threshold){
            public static final long serialVersionUID = 0L;
            private final double threshold$1;

            public final boolean apply(Tuple2<String, PRVertex> x0$1) {
                Tuple2<String, PRVertex> tuple2 = x0$1;
                if (tuple2 != null) {
                    PRVertex vertex = (PRVertex)tuple2._2();
                    boolean bl = vertex.value() >= this.threshold$1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.threshold$1 = threshold$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, PRVertex> x0$2) {
                Tuple2<String, PRVertex> tuple2 = x0$2;
                if (tuple2 != null) {
                    String id = (String)tuple2._1();
                    PRVertex vertex = (PRVertex)tuple2._2();
                    String string = new StringOps(Predef$.MODULE$.augmentString("%s\t%s\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, BoxesRunTime.boxToDouble((double)vertex.value())}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect()).mkString();
        Predef$.MODULE$.println((Object)top);
    }

    private WikipediaPageRank$() {
        MODULE$ = this;
    }
}

