/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.examples;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.recommendation.ALS;
import org.apache.spark.mllib.recommendation.MatrixFactorizationModel;
import org.apache.spark.mllib.recommendation.Rating;
import org.apache.spark.rdd.RDD;
import scala.Tuple2;

public final class JavaALS {
    public static void main(String[] args) {
        if (args.length != 5 && args.length != 6) {
            System.err.println("Usage: JavaALS <master> <ratings_file> <rank> <iterations> <output_dir> [<blocks>]");
            System.exit(1);
        }
        int rank = Integer.parseInt(args[2]);
        int iterations = Integer.parseInt(args[3]);
        String outputDir = args[4];
        int blocks = -1;
        if (args.length == 6) {
            blocks = Integer.parseInt(args[5]);
        }
        JavaSparkContext sc = new JavaSparkContext(args[0], "JavaALS", System.getenv("SPARK_HOME"), JavaSparkContext.jarOfClass(JavaALS.class));
        JavaRDD lines = sc.textFile(args[1]);
        JavaRDD ratings = lines.map((Function)new ParseRating());
        MatrixFactorizationModel model = ALS.train((RDD)ratings.rdd(), (int)rank, (int)iterations, (double)0.01, (int)blocks);
        model.userFeatures().toJavaRDD().map((Function)new FeaturesToString()).saveAsTextFile(outputDir + "/userFeatures");
        model.productFeatures().toJavaRDD().map((Function)new FeaturesToString()).saveAsTextFile(outputDir + "/productFeatures");
        System.out.println("Final user/product features written to " + outputDir);
        System.exit(0);
    }

    static class FeaturesToString
    extends Function<Tuple2<Object, double[]>, String> {
        FeaturesToString() {
        }

        public String call(Tuple2<Object, double[]> element) {
            return element._1() + "," + Arrays.toString((double[])element._2());
        }
    }

    static class ParseRating
    extends Function<String, Rating> {
        private static final Pattern COMMA = Pattern.compile(",");

        ParseRating() {
        }

        public Rating call(String line) {
            String[] tok = COMMA.split(line);
            int x = Integer.parseInt(tok[0]);
            int y = Integer.parseInt(tok[1]);
            double rating = Double.parseDouble(tok[2]);
            return new Rating(x, y, rating);
        }
    }
}

