/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.examples;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.examples.StreamingExamples;
import org.apache.spark.streaming.kafka.KafkaUtils;
import scala.Tuple2;

public final class JavaKafkaWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    private JavaKafkaWordCount() {
    }

    public static void main(String[] args) {
        String[] topics;
        if (args.length < 5) {
            System.err.println("Usage: KafkaWordCount <master> <zkQuorum> <group> <topics> <numThreads>");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        JavaStreamingContext jssc = new JavaStreamingContext(args[0], "KafkaWordCount", new Duration(2000L), System.getenv("SPARK_HOME"), JavaStreamingContext.jarOfClass(JavaKafkaWordCount.class));
        int numThreads = Integer.parseInt(args[4]);
        HashMap<String, Integer> topicMap = new HashMap<String, Integer>();
        for (String topic : topics = args[3].split(",")) {
            topicMap.put(topic, numThreads);
        }
        JavaPairDStream messages = KafkaUtils.createStream((JavaStreamingContext)jssc, (String)args[1], (String)args[2], topicMap);
        JavaDStream lines = messages.map((Function)new Function<Tuple2<String, String>, String>(){

            public String call(Tuple2<String, String> tuple2) {
                return (String)tuple2._2();
            }
        });
        JavaDStream words = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterable<String> call(String x) {
                return Lists.newArrayList((Object[])SPACE.split(x));
            }
        });
        JavaPairDStream wordCounts = words.map((PairFunction)new PairFunction<String, String, Integer>(){

            public Tuple2<String, Integer> call(String s) {
                return new Tuple2((Object)s, (Object)1);
            }
        }).reduceByKey((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        });
        wordCounts.print();
        jssc.start();
        jssc.awaitTermination();
    }
}

