/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.examples;

import com.google.common.collect.Lists;
import java.util.regex.Pattern;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.examples.StreamingExamples;
import scala.Tuple2;

public final class JavaNetworkWordCount {
    private static final Pattern SPACE = Pattern.compile(" ");

    private JavaNetworkWordCount() {
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: JavaNetworkWordCount <master> <hostname> <port>\nIn local mode, <master> should be 'local[n]' with n > 1");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        JavaStreamingContext ssc = new JavaStreamingContext(args[0], "JavaNetworkWordCount", new Duration(1000L), System.getenv("SPARK_HOME"), JavaStreamingContext.jarOfClass(JavaNetworkWordCount.class));
        JavaDStream lines = ssc.socketTextStream(args[1], Integer.parseInt(args[2]));
        JavaDStream words = lines.flatMap((FlatMapFunction)new FlatMapFunction<String, String>(){

            public Iterable<String> call(String x) {
                return Lists.newArrayList((Object[])SPACE.split(x));
            }
        });
        JavaPairDStream wordCounts = words.map((PairFunction)new PairFunction<String, String, Integer>(){

            public Tuple2<String, Integer> call(String s) {
                return new Tuple2((Object)s, (Object)1);
            }
        }).reduceByKey((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer i1, Integer i2) {
                return i1 + i2;
            }
        });
        wordCounts.print();
        ssc.start();
        ssc.awaitTermination();
    }
}

