/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.spark.launcher.CommandBuilderUtils;

abstract class AbstractCommandBuilder {
    boolean verbose;
    String appName;
    String appResource;
    String deployMode;
    String javaHome;
    String mainClass;
    String master;
    String propertiesFile;
    final List<String> appArgs = new ArrayList<String>();
    final List<String> jars;
    final List<String> files;
    final List<String> pyFiles;
    final Map<String, String> childEnv = new HashMap<String, String>();
    final Map<String, String> conf = new HashMap<String, String>();

    public AbstractCommandBuilder() {
        this.files = new ArrayList<String>();
        this.jars = new ArrayList<String>();
        this.pyFiles = new ArrayList<String>();
    }

    abstract List<String> buildCommand(Map<String, String> var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> buildJavaCommand(String extraClassPath) throws IOException {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.javaHome != null) {
            cmd.add(CommandBuilderUtils.join(File.separator, this.javaHome, "bin", "java"));
        } else {
            String envJavaHome = System.getenv("JAVA_HOME");
            if (envJavaHome != null) {
                cmd.add(CommandBuilderUtils.join(File.separator, envJavaHome, "bin", "java"));
            } else {
                cmd.add(CommandBuilderUtils.join(File.separator, System.getProperty("java.home"), "bin", "java"));
            }
        }
        File javaOpts = new File(CommandBuilderUtils.join(File.separator, this.getConfDir(), "java-opts"));
        if (javaOpts.isFile()) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(javaOpts), "UTF-8"));){
                String line;
                while ((line = br.readLine()) != null) {
                    this.addOptionString(cmd, line);
                }
            }
        }
        cmd.add("-cp");
        cmd.add(CommandBuilderUtils.join(File.pathSeparator, this.buildClassPath(extraClassPath)));
        return cmd;
    }

    void addPermGenSizeOpt(List<String> cmd) {
        if (CommandBuilderUtils.getJavaVendor() == CommandBuilderUtils.JavaVendor.IBM) {
            return;
        }
        String[] version = System.getProperty("java.version").split("\\.");
        if (Integer.parseInt(version[0]) > 1 || Integer.parseInt(version[1]) > 7) {
            return;
        }
        for (String arg : cmd) {
            if (!arg.startsWith("-XX:MaxPermSize=")) continue;
            return;
        }
        cmd.add("-XX:MaxPermSize=256m");
    }

    void addOptionString(List<String> cmd, String options) {
        if (!CommandBuilderUtils.isEmpty(options)) {
            for (String opt : CommandBuilderUtils.parseOptionString(options)) {
                cmd.add(opt);
            }
        }
    }

    List<String> buildClassPath(String appClassPath) throws IOException {
        String assembly;
        String sparkHome = this.getSparkHome();
        ArrayList<String> cp = new ArrayList<String>();
        this.addToClassPath(cp, this.getenv("SPARK_CLASSPATH"));
        this.addToClassPath(cp, appClassPath);
        this.addToClassPath(cp, this.getConfDir());
        boolean prependClasses = !CommandBuilderUtils.isEmpty(this.getenv("SPARK_PREPEND_CLASSES"));
        boolean isTesting = "1".equals(this.getenv("SPARK_TESTING"));
        if (prependClasses || isTesting) {
            String scala = this.getScalaVersion();
            List<String> projects = Arrays.asList("core", "repl", "mllib", "bagel", "graphx", "streaming", "tools", "sql/catalyst", "sql/core", "sql/hive", "sql/hive-thriftserver", "yarn", "launcher");
            if (prependClasses) {
                System.err.println("NOTE: SPARK_PREPEND_CLASSES is set, placing locally compiled Spark classes ahead of assembly.");
                for (String project : projects) {
                    this.addToClassPath(cp, String.format("%s/%s/target/scala-%s/classes", sparkHome, project, scala));
                }
            }
            if (isTesting) {
                for (String project : projects) {
                    this.addToClassPath(cp, String.format("%s/%s/target/scala-%s/test-classes", sparkHome, project, scala));
                }
            }
            this.addToClassPath(cp, String.format("%s/core/target/jars/*", sparkHome));
        }
        if ((assembly = this.getenv("_SPARK_ASSEMBLY")) == null && CommandBuilderUtils.isEmpty(this.getenv("SPARK_TESTING"))) {
            assembly = this.findAssembly();
        }
        this.addToClassPath(cp, assembly);
        File libdir = new File(sparkHome, "RELEASE").isFile() ? new File(sparkHome, "lib") : new File(sparkHome, "lib_managed/jars");
        CommandBuilderUtils.checkState(libdir.isDirectory(), "Library directory '%s' does not exist.", libdir.getAbsolutePath());
        for (File jar : libdir.listFiles()) {
            if (!jar.getName().startsWith("datanucleus-")) continue;
            this.addToClassPath(cp, jar.getAbsolutePath());
        }
        this.addToClassPath(cp, this.getenv("HADOOP_CONF_DIR"));
        this.addToClassPath(cp, this.getenv("YARN_CONF_DIR"));
        this.addToClassPath(cp, this.getenv("SPARK_DIST_CLASSPATH"));
        return cp;
    }

    private void addToClassPath(List<String> cp, String entries) {
        String[] split;
        if (CommandBuilderUtils.isEmpty(entries)) {
            return;
        }
        for (String entry : split = entries.split(Pattern.quote(File.pathSeparator))) {
            if (CommandBuilderUtils.isEmpty(entry)) continue;
            if (new File(entry).isDirectory() && !entry.endsWith(File.separator)) {
                entry = entry + File.separator;
            }
            cp.add(entry);
        }
    }

    String getScalaVersion() {
        String scala = this.getenv("SPARK_SCALA_VERSION");
        if (scala != null) {
            return scala;
        }
        String sparkHome = this.getSparkHome();
        File scala210 = new File(sparkHome, "assembly/target/scala-2.10");
        File scala211 = new File(sparkHome, "assembly/target/scala-2.11");
        CommandBuilderUtils.checkState(!scala210.isDirectory() || !scala211.isDirectory(), "Presence of build for both scala versions (2.10 and 2.11) detected.\nEither clean one of them or set SPARK_SCALA_VERSION in your environment.", new Object[0]);
        if (scala210.isDirectory()) {
            return "2.10";
        }
        CommandBuilderUtils.checkState(scala211.isDirectory(), "Cannot find any assembly build directories.", new Object[0]);
        return "2.11";
    }

    String getSparkHome() {
        String path = this.getenv("SPARK_HOME");
        CommandBuilderUtils.checkState(path != null, "Spark home not found; set it explicitly or use the SPARK_HOME environment variable.", new Object[0]);
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties loadPropertiesFile() throws IOException {
        File propsFile;
        Properties props = new Properties();
        if (this.propertiesFile != null) {
            propsFile = new File(this.propertiesFile);
            CommandBuilderUtils.checkArgument(propsFile.isFile(), "Invalid properties file '%s'.", this.propertiesFile);
        } else {
            propsFile = new File(this.getConfDir(), "spark-defaults.conf");
        }
        if (propsFile.isFile()) {
            FileInputStream fd = null;
            try {
                fd = new FileInputStream(propsFile);
                props.load(new InputStreamReader((InputStream)fd, "UTF-8"));
                for (Map.Entry<Object, Object> e : props.entrySet()) {
                    e.setValue(e.getValue().toString().trim());
                }
            }
            finally {
                if (fd != null) {
                    try {
                        fd.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return props;
    }

    String getenv(String key) {
        return CommandBuilderUtils.firstNonEmpty(this.childEnv.get(key), System.getenv(key));
    }

    private String findAssembly() {
        File libdir;
        String sparkHome = this.getSparkHome();
        if (new File(sparkHome, "RELEASE").isFile()) {
            libdir = new File(sparkHome, "lib");
            CommandBuilderUtils.checkState(libdir.isDirectory(), "Library directory '%s' does not exist.", libdir.getAbsolutePath());
        } else {
            libdir = new File(sparkHome, String.format("assembly/target/scala-%s", this.getScalaVersion()));
        }
        final Pattern re = Pattern.compile("spark-assembly.*hadoop.*\\.jar");
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && re.matcher(file.getName()).matches();
            }
        };
        File[] assemblies = libdir.listFiles(filter);
        CommandBuilderUtils.checkState(assemblies != null && assemblies.length > 0, "No assemblies found in '%s'.", libdir);
        CommandBuilderUtils.checkState(assemblies.length == 1, "Multiple assemblies found in '%s'.", libdir);
        return assemblies[0].getAbsolutePath();
    }

    private String getConfDir() {
        String confDir = this.getenv("SPARK_CONF_DIR");
        return confDir != null ? confDir : CommandBuilderUtils.join(File.separator, this.getSparkHome(), "conf");
    }
}

