/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.ann.FeedForwardTopology;
import org.apache.spark.ml.ann.FeedForwardTopology$;
import org.apache.spark.ml.ann.FeedForwardTrainer;
import org.apache.spark.ml.ann.TopologyModel;
import org.apache.spark.ml.classification.LabelConverter$;
import org.apache.spark.ml.classification.MultilayerPerceptronClassificationModel;
import org.apache.spark.ml.classification.MultilayerPerceptronParams;
import org.apache.spark.ml.classification.MultilayerPerceptronParams$class;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntArrayParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u001b\tqR*\u001e7uS2\f\u00170\u001a:QKJ\u001cW\r\u001d;s_:\u001cE.Y:tS\u001aLWM\u001d\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f?A)q\u0002\u0005\n\u001b95\tA!\u0003\u0002\u0012\t\tI\u0001K]3eS\u000e$xN\u001d\t\u0003'ai\u0011\u0001\u0006\u0006\u0003+Y\ta\u0001\\5oC2<'BA\f\u0007\u0003\u0015iG\u000e\\5c\u0013\tIBC\u0001\u0004WK\u000e$xN\u001d\t\u00037\u0001i\u0011A\u0001\t\u00037uI!A\b\u0002\u0003O5+H\u000e^5mCf,'\u000fU3sG\u0016\u0004HO]8o\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u00037\u0001J!!\t\u0002\u000355+H\u000e^5mCf,'\u000fU3sG\u0016\u0004HO]8o!\u0006\u0014\u0018-\\:\t\u0011\r\u0002!Q1A\u0005B\u0011\n1!^5e+\u0005)\u0003C\u0001\u0014-\u001d\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-B\u0003\u0002\u0003\u0019\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\tULG\r\t\u0005\u0006e\u0001!\taM\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005i!\u0004\"B\u00122\u0001\u0004)\u0003\"\u0002\u001a\u0001\t\u00031D#\u0001\u000e\t\u000ba\u0002A\u0011A\u001d\u0002\u0013M,G\u000fT1zKJ\u001cHC\u0001\u001e<\u001b\u0005\u0001\u0001\"\u0002\u001f8\u0001\u0004i\u0014!\u0002<bYV,\u0007cA\u0014?\u0001&\u0011q\b\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003O\u0005K!A\u0011\u0015\u0003\u0007%sG\u000fC\u0003E\u0001\u0011\u0005Q)\u0001\u0007tKR\u0014En\\2l'&TX\r\u0006\u0002;\r\")Ah\u0011a\u0001\u0001\")\u0001\n\u0001C\u0001\u0013\u0006Q1/\u001a;NCbLE/\u001a:\u0015\u0005iR\u0005\"\u0002\u001fH\u0001\u0004\u0001\u0005\"\u0002'\u0001\t\u0003i\u0015AB:fiR{G\u000e\u0006\u0002;\u001d\")Ah\u0013a\u0001\u001fB\u0011q\u0005U\u0005\u0003#\"\u0012a\u0001R8vE2,\u0007\"B*\u0001\t\u0003!\u0016aB:fiN+W\r\u001a\u000b\u0003uUCQ\u0001\u0010*A\u0002Y\u0003\"aJ,\n\u0005aC#\u0001\u0002'p]\u001eDQA\u0017\u0001\u0005Bm\u000bAaY8qsR\u0011!\u0004\u0018\u0005\u0006;f\u0003\rAX\u0001\u0006Kb$(/\u0019\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\u0012\tQ\u0001]1sC6L!a\u00191\u0003\u0011A\u000b'/Y7NCBDQ!\u001a\u0001\u0005R\u0019\fQ\u0001\u001e:bS:$\"\u0001H4\t\u000b!$\u0007\u0019A5\u0002\u000f\u0011\fG/Y:fiB\u0011!.\\\u0007\u0002W*\u0011ANB\u0001\u0004gFd\u0017B\u00018l\u0005%!\u0015\r^1Ge\u0006lW\r\u000b\u0002\u0001aB\u0011\u0011\u000f^\u0007\u0002e*\u00111OB\u0001\u000bC:tw\u000e^1uS>t\u0017BA;s\u00051)\u0005\u0010]3sS6,g\u000e^1m\u0001")
public class MultilayerPerceptronClassifier
extends Predictor<Vector, MultilayerPerceptronClassifier, MultilayerPerceptronClassificationModel>
implements MultilayerPerceptronParams {
    private final String uid;
    private final IntArrayParam layers;
    private final IntParam blockSize;
    private final DoubleParam tol;
    private final IntParam maxIter;
    private final LongParam seed;

    @Override
    public final IntArrayParam layers() {
        return this.layers;
    }

    @Override
    public final IntParam blockSize() {
        return this.blockSize;
    }

    @Override
    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$layers_$eq(IntArrayParam x$1) {
        this.layers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$MultilayerPerceptronParams$_setter_$blockSize_$eq(IntParam x$1) {
        this.blockSize = x$1;
    }

    @Override
    public final int[] getLayers() {
        return MultilayerPerceptronParams$class.getLayers(this);
    }

    @Override
    public final int getBlockSize() {
        return MultilayerPerceptronParams$class.getBlockSize(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public MultilayerPerceptronClassifier setLayers(int[] value) {
        return (MultilayerPerceptronClassifier)this.set(this.layers(), value);
    }

    public MultilayerPerceptronClassifier setBlockSize(int value) {
        return (MultilayerPerceptronClassifier)this.set(this.blockSize(), BoxesRunTime.boxToInteger((int)value));
    }

    public MultilayerPerceptronClassifier setMaxIter(int value) {
        return (MultilayerPerceptronClassifier)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public MultilayerPerceptronClassifier setTol(double value) {
        return (MultilayerPerceptronClassifier)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public MultilayerPerceptronClassifier setSeed(long value) {
        return (MultilayerPerceptronClassifier)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public MultilayerPerceptronClassifier copy(ParamMap extra) {
        return (MultilayerPerceptronClassifier)this.defaultCopy(extra);
    }

    @Override
    public MultilayerPerceptronClassificationModel train(DataFrame dataset) {
        int[] myLayers = this.$(this.layers());
        int labels = BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(myLayers).last());
        RDD<LabeledPoint> lpData = this.extractLabeledPoints(dataset);
        RDD data = lpData.map((Function1)new Serializable(this, labels){
            public static final long serialVersionUID = 0L;
            private final int labels$1;

            public final Tuple2<Vector, Vector> apply(LabeledPoint lp) {
                return LabelConverter$.MODULE$.encodeLabeledPoint(lp, this.labels$1);
            }
            {
                this.labels$1 = labels$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        FeedForwardTopology topology = FeedForwardTopology$.MODULE$.multiLayerPerceptron(myLayers, true);
        FeedForwardTrainer FeedForwardTrainer2 = new FeedForwardTrainer(topology, myLayers[0], BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(myLayers).last()));
        FeedForwardTrainer2.LBFGSOptimizer().setConvergenceTol(BoxesRunTime.unboxToDouble((Object)this.$(this.tol()))).setNumIterations(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())));
        FeedForwardTrainer2.setStackSize(BoxesRunTime.unboxToInt((Object)this.$(this.blockSize())));
        TopologyModel mlpModel = FeedForwardTrainer2.train((RDD<Tuple2<Vector, Vector>>)data);
        return new MultilayerPerceptronClassificationModel(this.uid(), myLayers, mlpModel.weights());
    }

    public MultilayerPerceptronClassifier(String uid) {
        this.uid = uid;
        HasSeed$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasTol$class.$init$(this);
        MultilayerPerceptronParams$class.$init$(this);
    }

    public MultilayerPerceptronClassifier() {
        this(Identifiable$.MODULE$.randomUID("mlpc"));
    }
}

