/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import scala.Serializable;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class PolynomialExpansion$
implements Serializable {
    public static final PolynomialExpansion$ MODULE$;

    static {
        new PolynomialExpansion$();
    }

    private int choose(int n, int k) {
        return BoxesRunTime.unboxToInt((Object)package$.MODULE$.Range().apply(n, n - k, -1).product((Numeric)Numeric.IntIsIntegral$.MODULE$)) / BoxesRunTime.unboxToInt((Object)package$.MODULE$.Range().apply(k, 1, -1).product((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private int getPolySize(int numFeatures, int degree) {
        return this.choose(numFeatures + degree, degree);
    }

    private int expandDense(double[] values, int lastIdx, int degree, double multiplier, double[] polyValues, int curPolyIdx) {
        if (multiplier != 0.0) {
            if (degree == 0 || lastIdx < 0) {
                if (curPolyIdx >= 0) {
                    polyValues[curPolyIdx] = multiplier;
                }
            } else {
                double v = values[lastIdx];
                int lastIdx1 = lastIdx - 1;
                double alpha = multiplier;
                int curStart = curPolyIdx;
                for (int i = 0; i <= degree && alpha != 0.0; ++i, alpha *= v) {
                    curStart = this.expandDense(values, lastIdx1, degree - i, alpha, polyValues, curStart);
                }
            }
        }
        return curPolyIdx + this.getPolySize(lastIdx + 1, degree);
    }

    private int expandSparse(int[] indices, double[] values, int lastIdx, int lastFeatureIdx, int degree, double multiplier, ArrayBuilder<Object> polyIndices, ArrayBuilder<Object> polyValues, int curPolyIdx) {
        BoxedUnit boxedUnit;
        if (multiplier == 0.0) {
            boxedUnit = BoxedUnit.UNIT;
        } else if (degree == 0 || lastIdx < 0) {
            if (curPolyIdx >= 0) {
                polyIndices.$plus$eq((Object)BoxesRunTime.boxToInteger((int)curPolyIdx));
                boxedUnit = polyValues.$plus$eq((Object)BoxesRunTime.boxToDouble((double)multiplier));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            double v = values[lastIdx];
            int lastIdx1 = lastIdx - 1;
            int lastFeatureIdx1 = indices[lastIdx] - 1;
            double alpha = multiplier;
            int curStart = curPolyIdx;
            for (int i = 0; i <= degree && alpha != 0.0; ++i, alpha *= v) {
                curStart = this.expandSparse(indices, values, lastIdx1, lastFeatureIdx1, degree - i, alpha, polyIndices, polyValues, curStart);
            }
            boxedUnit = BoxedUnit.UNIT;
        }
        return curPolyIdx + this.getPolySize(lastFeatureIdx + 1, degree);
    }

    private DenseVector expand(DenseVector dv, int degree) {
        int n = dv.size();
        int polySize = this.getPolySize(n, degree);
        double[] polyValues = new double[polySize - 1];
        this.expandDense(dv.values(), n - 1, degree, 1.0, polyValues, -1);
        return new DenseVector(polyValues);
    }

    private SparseVector expand(SparseVector sv, int degree) {
        int polySize = this.getPolySize(sv.size(), degree);
        int nnz = sv.values().length;
        int nnzPolySize = this.getPolySize(nnz, degree);
        ArrayBuilder polyIndices = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
        polyIndices.sizeHint(nnzPolySize - 1);
        ArrayBuilder polyValues = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        polyValues.sizeHint(nnzPolySize - 1);
        this.expandSparse(sv.indices(), sv.values(), nnz - 1, sv.size() - 1, degree, 1.0, (ArrayBuilder<Object>)polyIndices, (ArrayBuilder<Object>)polyValues, -1);
        return new SparseVector(polySize - 1, (int[])polyIndices.result(), (double[])polyValues.result());
    }

    public Vector expand(Vector v, int degree) {
        block4: {
            Vector vector;
            block3: {
                Vector vector2;
                block2: {
                    vector2 = v;
                    if (!(vector2 instanceof DenseVector)) break block2;
                    DenseVector denseVector = (DenseVector)vector2;
                    vector = this.expand(denseVector, degree);
                    break block3;
                }
                if (!(vector2 instanceof SparseVector)) break block4;
                SparseVector sparseVector = (SparseVector)vector2;
                vector = this.expand(sparseVector, degree);
            }
            return vector;
        }
        throw new IllegalArgumentException();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private PolynomialExpansion$() {
        MODULE$ = this;
    }
}

