/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.util.Arrays;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.impl.TreePoint;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class TreePoint$
implements Serializable {
    public static final TreePoint$ MODULE$;

    static {
        new TreePoint$();
    }

    public RDD<TreePoint> convertToTreeRDD(RDD<LabeledPoint> input, Split[][] splits, DecisionTreeMetadata metadata) {
        int[] featureArity = new int[metadata.numFeatures()];
        for (int featureIndex = 0; featureIndex < metadata.numFeatures(); ++featureIndex) {
            featureArity[featureIndex] = BoxesRunTime.unboxToInt((Object)metadata.featureArity().getOrElse((Object)BoxesRunTime.boxToInteger((int)featureIndex), (Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return 0;
                }
            }));
        }
        double[][] thresholds2 = (double[][])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(featureArity).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(splits){
            public static final long serialVersionUID = 0L;
            private final Split[][] splits$1;

            public final double[] apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int arity = tuple2._1$mcI$sp();
                    int idx = tuple2._2$mcI$sp();
                    double[] dArray = arity == 0 ? (double[])Predef$.MODULE$.refArrayOps((Object[])this.splits$1[idx]).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(Split x$1) {
                            return ((ContinuousSplit)x$1).threshold();
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())) : (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
                    return dArray;
                }
                throw new MatchError(tuple2);
            }
            {
                this.splits$1 = splits$1;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))));
        return input.map((Function1)new Serializable(featureArity, thresholds2){
            public static final long serialVersionUID = 0L;
            private final int[] featureArity$1;
            private final double[][] thresholds$1;

            public final TreePoint apply(LabeledPoint x) {
                return TreePoint$.MODULE$.org$apache$spark$ml$tree$impl$TreePoint$$labeledPointToTreePoint(x, this.thresholds$1, this.featureArity$1);
            }
            {
                this.featureArity$1 = featureArity$1;
                this.thresholds$1 = thresholds$1;
            }
        }, ClassTag$.MODULE$.apply(TreePoint.class));
    }

    public TreePoint org$apache$spark$ml$tree$impl$TreePoint$$labeledPointToTreePoint(LabeledPoint labeledPoint, double[][] thresholds2, int[] featureArity) {
        int numFeatures = labeledPoint.features().size();
        int[] arr = new int[numFeatures];
        for (int featureIndex = 0; featureIndex < numFeatures; ++featureIndex) {
            arr[featureIndex] = this.findBin(featureIndex, labeledPoint, featureArity[featureIndex], thresholds2[featureIndex]);
        }
        return new TreePoint(labeledPoint.label(), arr);
    }

    private int findBin(int featureIndex, LabeledPoint labeledPoint, int featureArity, double[] thresholds2) {
        int n;
        double featureValue = labeledPoint.features().apply(featureIndex);
        if (featureArity == 0) {
            int idx = Arrays.binarySearch(thresholds2, featureValue);
            n = idx >= 0 ? idx : -idx - 1;
        } else {
            if (featureValue < 0.0 || featureValue >= (double)featureArity) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree given invalid data:"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Feature ", " is categorical with values in {0,...,", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureIndex), BoxesRunTime.boxToInteger((int)(featureArity - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but a data point gives it value ", ".\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)featureValue)}))).append((Object)"  Bad data point: ").append((Object)labeledPoint.toString()).toString());
            }
            n = (int)featureValue;
        }
        return n;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TreePoint$() {
        MODULE$ = this;
    }
}

