/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.Logging;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\tEh\u0001B\u0001\u0003\u00015\u00111\u0001\u0014#B\u0015\t\u0019A!\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u00051\u0011BA\f\u0007\u0005\u001daunZ4j]\u001eD\u0001\"\u0007\u0001\u0003\u0002\u0004%IAG\u0001\u0002WV\t1\u0004\u0005\u0002\u00109%\u0011Q\u0004\u0005\u0002\u0004\u0013:$\b\u0002C\u0010\u0001\u0005\u0003\u0007I\u0011\u0002\u0011\u0002\u000b-|F%Z9\u0015\u0005\u0005\"\u0003CA\b#\u0013\t\u0019\u0003C\u0001\u0003V]&$\bbB\u0013\u001f\u0003\u0003\u0005\raG\u0001\u0004q\u0012\n\u0004\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0015B\u000e\u0002\u0005-\u0004\u0003\u0002C\u0015\u0001\u0005\u0003\u0007I\u0011\u0002\u000e\u0002\u001b5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t\u0011!Y\u0003A!a\u0001\n\u0013a\u0013!E7bq&#XM]1uS>t7o\u0018\u0013fcR\u0011\u0011%\f\u0005\bK)\n\t\u00111\u0001\u001c\u0011!y\u0003A!A!B\u0013Y\u0012AD7bq&#XM]1uS>t7\u000f\t\u0005\tc\u0001\u0011\t\u0019!C\u0005e\u0005\u0001Bm\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0002gA\u0011AgN\u0007\u0002k)\u0011a\u0007B\u0001\u0007Y&t\u0017\r\\4\n\u0005a*$A\u0002,fGR|'\u000f\u0003\u0005;\u0001\t\u0005\r\u0011\"\u0003<\u0003Q!wnY\"p]\u000e,g\u000e\u001e:bi&|gn\u0018\u0013fcR\u0011\u0011\u0005\u0010\u0005\bKe\n\t\u00111\u00014\u0011!q\u0004A!A!B\u0013\u0019\u0014!\u00053pG\u000e{gnY3oiJ\fG/[8oA!A\u0001\t\u0001BA\u0002\u0013%\u0011)\u0001\nu_BL7mQ8oG\u0016tGO]1uS>tW#\u0001\"\u0011\u0005=\u0019\u0015B\u0001#\u0011\u0005\u0019!u.\u001e2mK\"Aa\t\u0001BA\u0002\u0013%q)\u0001\fu_BL7mQ8oG\u0016tGO]1uS>tw\fJ3r)\t\t\u0003\nC\u0004&\u000b\u0006\u0005\t\u0019\u0001\"\t\u0011)\u0003!\u0011!Q!\n\t\u000b1\u0003^8qS\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\u0002B\u0001\u0002\u0014\u0001\u0003\u0002\u0004%I!T\u0001\u0005g\u0016,G-F\u0001O!\tyq*\u0003\u0002Q!\t!Aj\u001c8h\u0011!\u0011\u0006A!a\u0001\n\u0013\u0019\u0016\u0001C:fK\u0012|F%Z9\u0015\u0005\u0005\"\u0006bB\u0013R\u0003\u0003\u0005\rA\u0014\u0005\t-\u0002\u0011\t\u0011)Q\u0005\u001d\u0006)1/Z3eA!A\u0001\f\u0001BA\u0002\u0013%!$\u0001\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006d\u0007\u0002\u0003.\u0001\u0005\u0003\u0007I\u0011B.\u0002-\rDWmY6q_&tG/\u00138uKJ4\u0018\r\\0%KF$\"!\t/\t\u000f\u0015J\u0016\u0011!a\u00017!Aa\f\u0001B\u0001B\u0003&1$A\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006d\u0007\u0005\u0003\u0005a\u0001\t\u0005\r\u0011\"\u0003b\u00031aG-Y(qi&l\u0017N_3s+\u0005\u0011\u0007CA2e\u001b\u0005\u0011\u0011BA3\u0003\u00051aE)Q(qi&l\u0017N_3s\u0011!9\u0007A!a\u0001\n\u0013A\u0017\u0001\u00057eC>\u0003H/[7ju\u0016\u0014x\fJ3r)\t\t\u0013\u000eC\u0004&M\u0006\u0005\t\u0019\u00012\t\u0011-\u0004!\u0011!Q!\n\t\fQ\u0002\u001c3b\u001fB$\u0018.\\5{KJ\u0004\u0003\"B7\u0001\t\u0013q\u0017A\u0002\u001fj]&$h\b\u0006\u0005paF\u00148\u000f^;w!\t\u0019\u0007\u0001C\u0003\u001aY\u0002\u00071\u0004C\u0003*Y\u0002\u00071\u0004C\u00032Y\u0002\u00071\u0007C\u0003AY\u0002\u0007!\tC\u0003MY\u0002\u0007a\nC\u0003YY\u0002\u00071\u0004C\u0003aY\u0002\u0007!\rC\u0003n\u0001\u0011\u0005\u0001\u0010F\u0001pQ\u00119(0!\u0001\u0011\u0005mtX\"\u0001?\u000b\u0005u4\u0011AC1o]>$\u0018\r^5p]&\u0011q\u0010 \u0002\u0006'&t7-Z\u0011\u0003\u0003\u0007\tQ!\r\u00184]ABa!a\u0002\u0001\t\u0003Q\u0012\u0001B4fi.CS!!\u0002{\u0003\u0003Aq!!\u0004\u0001\t\u0003\ty!\u0001\u0003tKR\\E\u0003BA\t\u0003'i\u0011\u0001\u0001\u0005\u00073\u0005-\u0001\u0019A\u000e)\u000b\u0005-!0!\u0001\t\r\u0005e\u0001\u0001\"\u00013\u0003u9W\r^!ts6lW\r\u001e:jG\u0012{7mQ8oG\u0016tGO]1uS>t\u0007&BA\fu\u0006u\u0011EAA\u0010\u0003\u0015\td&\u000e\u00181\u0011\u0019\t\u0019\u0003\u0001C\u0001\u0003\u0006\u0019r-\u001a;E_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\"*\u0011\u0011\u0005>\u0002\u0002!9\u0011\u0011\u0006\u0001\u0005\u0002\u0005-\u0012aE:fi\u0012{7mQ8oG\u0016tGO]1uS>tG\u0003BA\t\u0003[Aa!MA\u0014\u0001\u0004\u0019\u0004&BA\u0014u\u0006u\u0001bBA\u0015\u0001\u0011\u0005\u00111\u0007\u000b\u0005\u0003#\t)\u0004\u0003\u00042\u0003c\u0001\rA\u0011\u0015\u0006\u0003cQ\u0018\u0011\u0001\u0005\u0007\u0003w\u0001A\u0011\u0001\u001a\u0002%\u001d,G/Q:z[6,GO]5d\u00032\u0004\b.\u0019\u0015\u0006\u0003sQ\u0018Q\u0004\u0005\u0007\u0003\u0003\u0002A\u0011A!\u0002\u0011\u001d,G/\u00117qQ\u0006DS!a\u0010{\u0003\u0003Aq!a\u0012\u0001\t\u0003\tI%\u0001\u0005tKR\fE\u000e\u001d5b)\u0011\t\t\"a\u0013\t\u000f\u00055\u0013Q\ta\u0001g\u0005)\u0011\r\u001c9iC\"*\u0011Q\t>\u0002\u001e!9\u0011q\t\u0001\u0005\u0002\u0005MC\u0003BA\t\u0003+Bq!!\u0014\u0002R\u0001\u0007!\tK\u0003\u0002Ri\f\t\u0001\u0003\u0004\u0002\\\u0001!\t!Q\u0001\u0016O\u0016$Hk\u001c9jG\u000e{gnY3oiJ\fG/[8oQ\u0015\tIF_A\u0001\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\nQc]3u)>\u0004\u0018nY\"p]\u000e,g\u000e\u001e:bi&|g\u000e\u0006\u0003\u0002\u0012\u0005\u0015\u0004B\u0002!\u0002`\u0001\u0007!\tK\u0003\u0002`i\f\t\u0001\u0003\u0004\u0002l\u0001!\t!Q\u0001\bO\u0016$()\u001a;bQ\u0015\tIG_A\u0001\u0011\u001d\t\t\b\u0001C\u0001\u0003g\nqa]3u\u0005\u0016$\u0018\r\u0006\u0003\u0002\u0012\u0005U\u0004bBA<\u0003_\u0002\rAQ\u0001\u0005E\u0016$\u0018\rK\u0003\u0002pi\f\t\u0001\u0003\u0004\u0002~\u0001!\tAG\u0001\u0011O\u0016$X*\u0019=Ji\u0016\u0014\u0018\r^5p]NDS!a\u001f{\u0003\u0003Aq!a!\u0001\t\u0003\t))\u0001\ttKRl\u0015\r_%uKJ\fG/[8ogR!\u0011\u0011CAD\u0011\u0019I\u0013\u0011\u0011a\u00017!*\u0011\u0011\u0011>\u0002\u0002!1\u0011Q\u0012\u0001\u0005\u00025\u000bqaZ3u'\u0016,G\rK\u0003\u0002\fj\f\t\u0001C\u0004\u0002\u0014\u0002!\t!!&\u0002\u000fM,GoU3fIR!\u0011\u0011CAL\u0011\u0019a\u0015\u0011\u0013a\u0001\u001d\"*\u0011\u0011\u0013>\u0002\u0002!1\u0011Q\u0014\u0001\u0005\u0002i\tQcZ3u\u0007\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000eK\u0003\u0002\u001cj\f\t\u0001C\u0004\u0002$\u0002!\t!!*\u0002+M,Go\u00115fG.\u0004x.\u001b8u\u0013:$XM\u001d<bYR!\u0011\u0011CAT\u0011\u0019A\u0016\u0011\u0015a\u00017!*\u0011\u0011\u0015>\u0002\u0002!1\u0011Q\u0016\u0001\u0005\u0002\u0005\fAbZ3u\u001fB$\u0018.\\5{KJDC!a+\u00022B\u001910a-\n\u0007\u0005UFP\u0001\u0007EKZ,Gn\u001c9fe\u0006\u0003\u0018\u000eK\u0003\u0002,j\fI,\t\u0002\u0002<\u0006)\u0011G\f\u001b/a!9\u0011q\u0018\u0001\u0005\u0002\u0005\u0005\u0017\u0001D:fi>\u0003H/[7ju\u0016\u0014H\u0003BA\t\u0003\u0007Dq!!2\u0002>\u0002\u0007!-A\u0005paRLW.\u001b>fe\"\"\u0011QXAYQ\u0015\tiL_A]\u0011\u001d\ty\f\u0001C\u0001\u0003\u001b$B!!\u0005\u0002P\"A\u0011\u0011[Af\u0001\u0004\t\u0019.A\u0007paRLW.\u001b>fe:\u000bW.\u001a\t\u0005\u0003+\fYND\u0002\u0010\u0003/L1!!7\u0011\u0003\u0019\u0001&/\u001a3fM&!\u0011Q\\Ap\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011\u001c\t)\u000b\u0005-'0!/\t\u000f\u0005\u0015\b\u0001\"\u0001\u0002h\u0006\u0019!/\u001e8\u0015\t\u0005%\u0018q\u001e\t\u0004G\u0006-\u0018bAAw\u0005\tAA\nR!N_\u0012,G\u000e\u0003\u0005\u0002r\u0006\r\b\u0019AAz\u0003%!wnY;nK:$8\u000f\u0005\u0004\u0002v\u0006m\u0018q`\u0007\u0003\u0003oT1!!?\u0007\u0003\r\u0011H\rZ\u0005\u0005\u0003{\f9PA\u0002S\t\u0012\u0003Ra\u0004B\u0001\u001dNJ1Aa\u0001\u0011\u0005\u0019!V\u000f\u001d7fe!*\u00111\u001d>\u0002\u0002!9\u0011Q\u001d\u0001\u0005\u0002\t%A\u0003BAu\u0005\u0017A\u0001\"!=\u0003\b\u0001\u0007!Q\u0002\t\b\u0005\u001f\u0011IB!\b4\u001b\t\u0011\tB\u0003\u0003\u0003\u0014\tU\u0011\u0001\u00026bm\u0006T1Aa\u0006\u0007\u0003\r\t\u0007/[\u0005\u0005\u00057\u0011\tBA\u0006KCZ\f\u0007+Y5s%\u0012#\u0005\u0003\u0002B\u0010\u0005Oi!A!\t\u000b\t\t\r\"QE\u0001\u0005Y\u0006twM\u0003\u0002\u0003\u0014%\u0019\u0001K!\t)\u000b\t\u001d!0!\u0001)\u0007\u0001\u0011i\u0003E\u0002|\u0005_I1A!\r}\u00051)\u0005\u0010]3sS6,g\u000e^1mQ\u0011\u0001!0!\u0001\b\u0011\t]\"\u0001#\u0001\u0003\u0005s\t1\u0001\u0014#B!\r\u0019'1\b\u0004\b\u0003\tA\tA\u0001B\u001f'\r\u0011YD\u0004\u0005\b[\nmB\u0011\u0001B!)\t\u0011I$\u0002\u0005\u0003F\tm\u0002A\u0001B$\u0005-!v\u000e]5d\u0007>,h\u000e^:\u0011\u000b\t%#\u0011\u000b\"\u000e\u0005\t-#b\u0001\u001c\u0003N)\u0011!qJ\u0001\u0007EJ,WM_3\n\t\tM#1\n\u0002\f\t\u0016t7/\u001a,fGR|'/B\u0004\u0003X\tm\u0002A\u0001\"\u0003\u0015Q{7.\u001a8D_VtG\u000fC\u0005\u0003\\\tmB\u0011\u0001\u0002\u0003^\u0005QA/\u001a:ne%tG-\u001a=\u0015\u00079\u0013y\u0006C\u0004\u0003b\te\u0003\u0019A\u000e\u0002\tQ,'/\u001c\u0005\n\u0005K\u0012Y\u0004\"\u0001\u0003\u0005O\n!\"\u001b8eKb\u0014D/\u001a:n)\rY\"\u0011\u000e\u0005\b\u0005W\u0012\u0019\u00071\u0001O\u0003%!XM]7J]\u0012,\u0007\u0010C\u0005\u0003p\tmB\u0011\u0001\u0002\u0003r\u0005\u0001\u0012n\u001d#pGVlWM\u001c;WKJ$X\r\u001f\u000b\u0005\u0005g\u0012I\bE\u0002\u0010\u0005kJ1Aa\u001e\u0011\u0005\u001d\u0011un\u001c7fC:D\u0001Ba\u001f\u0003n\u0001\u0007!QP\u0001\u0002mB\"!q\u0010BW!\u001dy!\u0011\u0001BA\u0005S\u0003BAa!\u0003$:!!Q\u0011BO\u001d\u0011\u00119I!'\u000f\t\t%%q\u0013\b\u0005\u0005\u0017\u0013)J\u0004\u0003\u0003\u000e\nMUB\u0001BH\u0015\r\u0011\t\nD\u0001\u0007yI|w\u000e\u001e \n\u0003-I!!\u0003\u0006\n\u0005\u001dA\u0011b\u0001BN\r\u00051qM]1qQbLAAa(\u0003\"\u00069\u0001/Y2lC\u001e,'b\u0001BN\r%!!Q\u0015BT\u0005!1VM\u001d;fq&#'\u0002\u0002BP\u0005C\u0003BAa+\u0003.2\u0001A\u0001\u0004BX\u0005s\n\t\u0011!A\u0003\u0002\tE&aA0%cE!!1\u0017B]!\ry!QW\u0005\u0004\u0005o\u0003\"a\u0002(pi\"Lgn\u001a\t\u0004\u001f\tm\u0016b\u0001B_!\t\u0019\u0011I\\=\t\u0013\t\u0005'1\bC\u0001\u0005\t\r\u0017\u0001D5t)\u0016\u0014XNV3si\u0016DH\u0003\u0002B:\u0005\u000bD\u0001Ba\u001f\u0003@\u0002\u0007!q\u0019\u0019\u0005\u0005\u0013\u0014i\rE\u0004\u0010\u0005\u0003\u0011\tIa3\u0011\t\t-&Q\u001a\u0003\r\u0005\u001f\u0014)-!A\u0001\u0002\u000b\u0005!\u0011\u0017\u0002\u0004?\u0012\u0012\u0004\"\u0003Bj\u0005w!\tA\u0001Bk\u00035\u0019w.\u001c9vi\u0016\u0004Fk\u001c9jGRq!q\u001bBn\u0005?\u0014\u0019Oa:\u0003l\n=\b\u0003\u0002Bm\u0005\u0007j!Aa\u000f\t\u0011\tu'\u0011\u001ba\u0001\u0005/\fa\u0002Z8d)>\u0004\u0018nY\"pk:$8\u000f\u0003\u0005\u0003b\nE\u0007\u0019\u0001Bl\u0003=!XM]7U_BL7mQ8v]R\u001c\b\u0002\u0003Bs\u0005#\u0004\rAa6\u0002!Q|G/\u00197U_BL7mQ8v]R\u001c\bb\u0002Bu\u0005#\u0004\raG\u0001\nm>\u001c\u0017MY*ju\u0016DqA!<\u0003R\u0002\u0007!)A\u0002fi\u0006Dq!!\u0014\u0003R\u0002\u0007!\t")
public class LDA
implements Logging {
    private int k;
    private int maxIterations;
    private Vector docConcentration;
    private double topicConcentration;
    private long seed;
    private int checkpointInterval;
    private LDAOptimizer ldaOptimizer;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private Vector docConcentration() {
        return this.docConcentration;
    }

    private void docConcentration_$eq(Vector x$1) {
        this.docConcentration = x$1;
    }

    private double topicConcentration() {
        return this.topicConcentration;
    }

    private void topicConcentration_$eq(double x$1) {
        this.topicConcentration = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int checkpointInterval() {
        return this.checkpointInterval;
    }

    private void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    private LDAOptimizer ldaOptimizer() {
        return this.ldaOptimizer;
    }

    private void ldaOptimizer_$eq(LDAOptimizer x$1) {
        this.ldaOptimizer = x$1;
    }

    public int getK() {
        return this.k();
    }

    public LDA setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0)new Serializable(this, k){
            public static final long serialVersionUID = 0L;
            private final int k$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"LDA k (number of clusters) must be > 0, but was set to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.k$1)}));
            }
            {
                this.k$1 = k$1;
            }
        });
        this.k_$eq(k);
        return this;
    }

    public Vector getAsymmetricDocConcentration() {
        return this.docConcentration();
    }

    public double getDocConcentration() {
        double d;
        double parameter = this.docConcentration().apply(0);
        if (this.docConcentration().size() == 1) {
            d = parameter;
        } else {
            Predef$.MODULE$.require(Predef$.MODULE$.doubleArrayOps(this.docConcentration().toArray()).forall((Function1)new Serializable(this, parameter){
                public static final long serialVersionUID = 0L;
                private final double parameter$1;

                public final boolean apply(double x$1) {
                    return this.apply$mcZD$sp(x$1);
                }

                public boolean apply$mcZD$sp(double x$1) {
                    return x$1 == this.parameter$1;
                }
                {
                    this.parameter$1 = parameter$1;
                }
            }));
            d = parameter;
        }
        return d;
    }

    public LDA setDocConcentration(Vector docConcentration) {
        Predef$.MODULE$.require(docConcentration.size() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "docConcentration must have > 0 elements";
            }
        });
        this.docConcentration_$eq(docConcentration);
        return this;
    }

    public LDA setDocConcentration(double docConcentration) {
        this.docConcentration_$eq(Vectors$.MODULE$.dense(docConcentration, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])));
        return this;
    }

    public Vector getAsymmetricAlpha() {
        return this.getAsymmetricDocConcentration();
    }

    public double getAlpha() {
        return this.getDocConcentration();
    }

    public LDA setAlpha(Vector alpha) {
        return this.setDocConcentration(alpha);
    }

    public LDA setAlpha(double alpha) {
        return this.setDocConcentration(alpha);
    }

    public double getTopicConcentration() {
        return this.topicConcentration();
    }

    public LDA setTopicConcentration(double topicConcentration) {
        this.topicConcentration_$eq(topicConcentration);
        return this;
    }

    public double getBeta() {
        return this.getTopicConcentration();
    }

    public LDA setBeta(double beta) {
        return this.setTopicConcentration(beta);
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public LDA setMaxIterations(int maxIterations) {
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public LDA setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public int getCheckpointInterval() {
        return this.checkpointInterval();
    }

    public LDA setCheckpointInterval(int checkpointInterval) {
        this.checkpointInterval_$eq(checkpointInterval);
        return this;
    }

    @DeveloperApi
    public LDAOptimizer getOptimizer() {
        return this.ldaOptimizer();
    }

    @DeveloperApi
    public LDA setOptimizer(LDAOptimizer optimizer) {
        this.ldaOptimizer_$eq(optimizer);
        return this;
    }

    public LDA setOptimizer(String optimizerName) {
        String string;
        block4: {
            LDAOptimizer lDAOptimizer;
            block3: {
                block2: {
                    String string2 = string = optimizerName.toLowerCase();
                    if ("em" != null ? !"em".equals(string2) : string2 != null) break block2;
                    lDAOptimizer = new EMLDAOptimizer();
                    break block3;
                }
                String string3 = string;
                if ("online" != null ? !"online".equals(string3) : string3 != null) break block4;
                lDAOptimizer = new OnlineLDAOptimizer();
            }
            this.ldaOptimizer_$eq(lDAOptimizer);
            return this;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only em, online are supported but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
    }

    public LDAModel run(RDD<Tuple2<Object, Vector>> documents) {
        LDAOptimizer state = this.ldaOptimizer().initialize(documents, this);
        double[] iterationTimes = (double[])Array$.MODULE$.fill(this.maxIterations(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        for (int iter = 0; iter < this.maxIterations(); ++iter) {
            double elapsedSeconds;
            long start2 = System.nanoTime();
            state.next();
            iterationTimes[iter] = elapsedSeconds = (double)(System.nanoTime() - start2) / 1.0E9;
        }
        return state.getLDAModel(iterationTimes);
    }

    public LDAModel run(JavaPairRDD<Long, Vector> documents) {
        return this.run((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private LDA(int k, int maxIterations, Vector docConcentration, double topicConcentration, long seed, int checkpointInterval, LDAOptimizer ldaOptimizer) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.seed = seed;
        this.checkpointInterval = checkpointInterval;
        this.ldaOptimizer = ldaOptimizer;
        Logging.class.$init$((Logging)this);
    }

    public LDA() {
        this(10, 20, Vectors$.MODULE$.dense(-1.0, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])), -1.0, Utils$.MODULE$.random().nextLong(), 10, new EMLDAOptimizer());
    }
}

