/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.mllib.feature.StandardScaler;
import org.apache.spark.mllib.feature.StandardScalerModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.optimization.Optimizer;
import org.apache.spark.mllib.regression.GeneralizedLinearModel;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0001\u0003\u0003\u0003i!AG$f]\u0016\u0014\u0018\r\\5{K\u0012d\u0015N\\3be\u0006cwm\u001c:ji\"l'BA\u0002\u0005\u0003)\u0011Xm\u001a:fgNLwN\u001c\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\tq1e\u0005\u0003\u0001\u001fUI\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\ta!\u0003\u0002\u0019\r\t9Aj\\4hS:<\u0007C\u0001\t\u001b\u0013\tY\u0012C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u001e\u0001\u0011\u0005a$\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0019\u0001\u0005A\u0011\u000e\u0003\t\u0001\"AI\u0012\r\u0001\u0011)A\u0005\u0001b\u0001K\t\tQ*\u0005\u0002'SA\u0011\u0001cJ\u0005\u0003QE\u0011qAT8uQ&tw\r\u0005\u0002!U%\u00111F\u0001\u0002\u0017\u000f\u0016tWM]1mSj,G\rT5oK\u0006\u0014Xj\u001c3fY\"9Q\u0006\u0001b\u0001\n#q\u0013A\u0003<bY&$\u0017\r^8sgV\tq\u0006E\u00021qmr!!\r\u001c\u000f\u0005I*T\"A\u001a\u000b\u0005Qb\u0011A\u0002\u001fs_>$h(C\u0001\u0013\u0013\t9\u0014#A\u0004qC\u000e\\\u0017mZ3\n\u0005eR$aA*fc*\u0011q'\u0005\t\u0005!qrt)\u0003\u0002>#\tIa)\u001e8di&|g.\r\t\u0004\u007f\t#U\"\u0001!\u000b\u0005\u00053\u0011a\u0001:eI&\u00111\t\u0011\u0002\u0004%\u0012#\u0005C\u0001\u0011F\u0013\t1%A\u0001\u0007MC\n,G.\u001a3Q_&tG\u000f\u0005\u0002\u0011\u0011&\u0011\u0011*\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019Y\u0005\u0001)A\u0005_\u0005Ya/\u00197jI\u0006$xN]:!\u0011\u0015i\u0005A\"\u0001O\u0003%y\u0007\u000f^5nSj,'/F\u0001P!\t\u00016+D\u0001R\u0015\t\u0011F!\u0001\u0007paRLW.\u001b>bi&|g.\u0003\u0002U#\nIq\n\u001d;j[&TXM\u001d\u0015\u0004\u0019Zc\u0006CA,[\u001b\u0005A&BA-\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u00037b\u0013QaU5oG\u0016\f\u0013!X\u0001\u0006a9Bd\u0006\r\u0005\b?\u0002\u0001\r\u0011\"\u0005a\u00031\tG\rZ%oi\u0016\u00148-\u001a9u+\u00059\u0005b\u00022\u0001\u0001\u0004%\tbY\u0001\u0011C\u0012$\u0017J\u001c;fe\u000e,\u0007\u000f^0%KF$\"\u0001Z4\u0011\u0005A)\u0017B\u00014\u0012\u0005\u0011)f.\u001b;\t\u000f!\f\u0017\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\t\r)\u0004\u0001\u0015)\u0003H\u00035\tG\rZ%oi\u0016\u00148-\u001a9uA!9A\u000e\u0001a\u0001\n#\u0001\u0017\u0001\u0004<bY&$\u0017\r^3ECR\f\u0007b\u00028\u0001\u0001\u0004%\tb\\\u0001\u0011m\u0006d\u0017\u000eZ1uK\u0012\u000bG/Y0%KF$\"\u0001\u001a9\t\u000f!l\u0017\u0011!a\u0001\u000f\"1!\u000f\u0001Q!\n\u001d\u000bQB^1mS\u0012\fG/\u001a#bi\u0006\u0004\u0003b\u0002;\u0001\u0001\u0004%\t\"^\u0001\u0015]VlwJ\u001a'j]\u0016\f'\u000f\u0015:fI&\u001cGo\u001c:\u0016\u0003Y\u0004\"\u0001E<\n\u0005a\f\"aA%oi\"9!\u0010\u0001a\u0001\n#Y\u0018\u0001\u00078v[>3G*\u001b8fCJ\u0004&/\u001a3jGR|'o\u0018\u0013fcR\u0011A\r \u0005\bQf\f\t\u00111\u0001w\u0011\u0019q\b\u0001)Q\u0005m\u0006)b.^7PM2Kg.Z1s!J,G-[2u_J\u0004\u0003\u0002CA\u0001\u0001\u0001\u0007I\u0011\u00021\u0002#U\u001cXMR3biV\u0014XmU2bY&tw\rC\u0005\u0002\u0006\u0001\u0001\r\u0011\"\u0003\u0002\b\u0005)Ro]3GK\u0006$XO]3TG\u0006d\u0017N\\4`I\u0015\fHc\u00013\u0002\n!A\u0001.a\u0001\u0002\u0002\u0003\u0007q\tC\u0004\u0002\u000e\u0001\u0001\u000b\u0015B$\u0002%U\u001cXMR3biV\u0014XmU2bY&tw\r\t\u0005\u0007\u0003#\u0001A\u0011A;\u0002\u001d\u001d,GOT;n\r\u0016\fG/\u001e:fg\"*\u0011q\u0002,\u0002\u0016\u0005\u0012\u0011qC\u0001\u0006c9\"d\u0006\r\u0005\t\u00037\u0001\u0001\u0019!C\tk\u0006Ya.^7GK\u0006$XO]3t\u0011%\ty\u0002\u0001a\u0001\n#\t\t#A\bok64U-\u0019;ve\u0016\u001cx\fJ3r)\r!\u00171\u0005\u0005\tQ\u0006u\u0011\u0011!a\u0001m\"9\u0011q\u0005\u0001!B\u00131\u0018\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003\u0002CA\u0016\u0001\u0011\u0005A!!\f\u0002#M,GOR3biV\u0014XmU2bY&tw\r\u0006\u0003\u00020\u0005ER\"\u0001\u0001\t\u000f\u0005\u0005\u0011\u0011\u0006a\u0001\u000f\"9\u0011Q\u0007\u0001\u0007\u0012\u0005]\u0012aC2sK\u0006$X-T8eK2$R!IA\u001d\u0003\u0013B\u0001\"a\u000f\u00024\u0001\u0007\u0011QH\u0001\bo\u0016Lw\r\u001b;t!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#bAA\"\t\u00051A.\u001b8bY\u001eLA!a\u0012\u0002B\t1a+Z2u_JD\u0001\"a\u0013\u00024\u0001\u0007\u0011QJ\u0001\nS:$XM]2faR\u00042\u0001EA(\u0013\r\t\t&\u0005\u0002\u0007\t>,(\r\\3\t\r\u0005U\u0003\u0001\"\u0001a\u00039I7/\u00113e\u0013:$XM]2faRDS!a\u0015W\u0003+Aq!a\u0017\u0001\t\u0003\ti&\u0001\u0007tKRLe\u000e^3sG\u0016\u0004H\u000f\u0006\u0003\u00020\u0005}\u0003BB0\u0002Z\u0001\u0007q\t\u000b\u0003\u0002ZYc\u0006bBA3\u0001\u0011\u0005\u0011qM\u0001\u0010g\u0016$h+\u00197jI\u0006$X\rR1uCR!\u0011qFA5\u0011\u0019a\u00171\ra\u0001\u000f\"\"\u00111\r,]\u0011\u001d\ty\u0007\u0001C\u0001\u0003c\n1A];o)\r\t\u00131\u000f\u0005\b\u0003k\ni\u00071\u0001?\u0003\u0015Ig\u000e];uQ\u0011\tiG\u0016/\t\u000f\u0005=\u0004\u0001\"\u0001\u0002|Q)\u0011%! \u0002\u0000!9\u0011QOA=\u0001\u0004q\u0004\u0002CAA\u0003s\u0002\r!!\u0010\u0002\u001d%t\u0017\u000e^5bY^+\u0017n\u001a5ug\"*\u0011\u0011\u0010,\u0002\u0006\u0006\u0012\u0011qQ\u0001\u0006c9\u0002d\u0006\r\u0015\u0004\u0001\u0005-\u0005cA,\u0002\u000e&\u0019\u0011q\u0012-\u0003\u0019\u0011+g/\u001a7pa\u0016\u0014\u0018\t]5)\u0007\u00011F\f")
public abstract class GeneralizedLinearAlgorithm<M extends GeneralizedLinearModel>
implements Logging,
Serializable {
    private final Seq<Function1<RDD<LabeledPoint>, Object>> validators;
    private boolean addIntercept;
    private boolean validateData;
    private int numOfLinearPredictor;
    private boolean useFeatureScaling;
    private int numFeatures;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Seq<Function1<RDD<LabeledPoint>, Object>> validators() {
        return this.validators;
    }

    public abstract Optimizer optimizer();

    public boolean addIntercept() {
        return this.addIntercept;
    }

    public void addIntercept_$eq(boolean x$1) {
        this.addIntercept = x$1;
    }

    public boolean validateData() {
        return this.validateData;
    }

    public void validateData_$eq(boolean x$1) {
        this.validateData = x$1;
    }

    public int numOfLinearPredictor() {
        return this.numOfLinearPredictor;
    }

    public void numOfLinearPredictor_$eq(int x$1) {
        this.numOfLinearPredictor = x$1;
    }

    private boolean useFeatureScaling() {
        return this.useFeatureScaling;
    }

    private void useFeatureScaling_$eq(boolean x$1) {
        this.useFeatureScaling = x$1;
    }

    public int getNumFeatures() {
        return this.numFeatures();
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public void numFeatures_$eq(int x$1) {
        this.numFeatures = x$1;
    }

    public GeneralizedLinearAlgorithm<M> setFeatureScaling(boolean useFeatureScaling) {
        this.useFeatureScaling_$eq(useFeatureScaling);
        return this;
    }

    public abstract M createModel(Vector var1, double var2);

    public boolean isAddIntercept() {
        return this.addIntercept();
    }

    public GeneralizedLinearAlgorithm<M> setIntercept(boolean addIntercept) {
        this.addIntercept_$eq(addIntercept);
        return this;
    }

    public GeneralizedLinearAlgorithm<M> setValidateData(boolean validateData) {
        this.validateData_$eq(validateData);
        return this;
    }

    public M run(RDD<LabeledPoint> input) {
        if (this.numFeatures() < 0) {
            this.numFeatures_$eq(BoxesRunTime.unboxToInt((Object)input.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LabeledPoint x$1) {
                    return x$1.features().size();
                }
            }, ClassTag$.MODULE$.Int()).first()));
        }
        Vector initialWeights = this.numOfLinearPredictor() == 1 ? Vectors$.MODULE$.zeros(this.numFeatures()) : (this.addIntercept() ? Vectors$.MODULE$.zeros((this.numFeatures() + 1) * this.numOfLinearPredictor()) : Vectors$.MODULE$.zeros(this.numFeatures() * this.numOfLinearPredictor()));
        return this.run(input, initialWeights);
    }

    public M run(RDD<LabeledPoint> input, Vector initialWeights) {
        Vector weights2;
        StandardScalerModel scaler;
        StandardScalerModel standardScalerModel;
        if (this.numFeatures() < 0) {
            this.numFeatures_$eq(BoxesRunTime.unboxToInt((Object)input.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(LabeledPoint x$2) {
                    return x$2.features().size();
                }
            }, ClassTag$.MODULE$.Int()).first()));
        }
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        if (this.validateData() && !this.validators().forall((Function1)new Serializable(this, input){
            public static final long serialVersionUID = 0L;
            private final RDD input$1;

            public final boolean apply(Function1<RDD<LabeledPoint>, Object> func) {
                return BoxesRunTime.unboxToBoolean((Object)func.apply((Object)this.input$1));
            }
            {
                this.input$1 = input$1;
            }
        })) {
            throw new SparkException("Input validation failed.");
        }
        if (this.useFeatureScaling()) {
            boolean x$4 = true;
            boolean x$5 = false;
            standardScalerModel = new StandardScaler(x$5, x$4).fit((RDD<Vector>)input.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final Vector apply(LabeledPoint x$3) {
                    return x$3.features();
                }
            }, ClassTag$.MODULE$.apply(Vector.class)));
        } else {
            standardScalerModel = scaler = null;
        }
        RDD data = this.addIntercept() ? (this.useFeatureScaling() ? input.map((Function1)new Serializable(this, scaler){
            public static final long serialVersionUID = 0L;
            private final StandardScalerModel scaler$1;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)MLUtils$.MODULE$.appendBias(this.scaler$1.transform(lp.features())));
            }
            {
                this.scaler$1 = scaler$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache() : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)MLUtils$.MODULE$.appendBias(lp.features()));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache()) : (this.useFeatureScaling() ? input.map((Function1)new Serializable(this, scaler){
            public static final long serialVersionUID = 0L;
            private final StandardScalerModel scaler$1;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)this.scaler$1.transform(lp.features()));
            }
            {
                this.scaler$1 = scaler$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache() : input.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint lp) {
                return new Tuple2((Object)BoxesRunTime.boxToDouble((double)lp.label()), (Object)lp.features());
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
        Vector initialWeightsWithIntercept = this.addIntercept() && this.numOfLinearPredictor() == 1 ? MLUtils$.MODULE$.appendBias(initialWeights) : initialWeights;
        Vector weightsWithIntercept = this.optimizer().optimize((RDD<Tuple2<Object, Vector>>)data, initialWeightsWithIntercept);
        double intercept2 = this.addIntercept() && this.numOfLinearPredictor() == 1 ? weightsWithIntercept.apply(weightsWithIntercept.size() - 1) : 0.0;
        Vector vector = weights2 = this.addIntercept() && this.numOfLinearPredictor() == 1 ? Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(weightsWithIntercept.toArray()).slice(0, weightsWithIntercept.size() - 1)) : weightsWithIntercept;
        if (this.useFeatureScaling()) {
            if (this.numOfLinearPredictor() == 1) {
                weights2 = scaler.transform(weights2);
            } else {
                int n = weights2.size() / this.numOfLinearPredictor();
                double[] weightsArray = weights2.toArray();
                for (int i = 0; i < this.numOfLinearPredictor(); ++i) {
                    int start2 = i * n;
                    int end = (i + 1) * n - (this.addIntercept() ? 1 : 0);
                    double[] partialWeightsArray = scaler.transform(Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(weightsArray).slice(start2, end))).toArray();
                    System.arraycopy(partialWeightsArray, 0, weightsArray, start2, Predef$.MODULE$.doubleArrayOps(partialWeightsArray).size());
                }
                weights2 = Vectors$.MODULE$.dense(weightsArray);
            }
        }
        StorageLevel storageLevel3 = input.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        return this.createModel(weights2, intercept2);
    }

    public GeneralizedLinearAlgorithm() {
        Logging.class.$init$((Logging)this);
        this.validators = Nil$.MODULE$;
        this.addIntercept = false;
        this.validateData = true;
        this.numOfLinearPredictor = 1;
        this.useFeatureScaling = false;
        this.numFeatures = -1;
    }
}

