/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import org.apache.spark.Logging;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.GradientBoostedTrees$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u00015\u0011Ac\u0012:bI&,g\u000e\u001e\"p_N$X\r\u001a+sK\u0016\u001c(BA\u0002\u0005\u0003\u0011!(/Z3\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0004\u000b\u0018!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011q\"F\u0005\u0003-A\u0011AbU3sS\u0006d\u0017N_1cY\u0016\u0004\"\u0001G\r\u000e\u0003\u0019I!A\u0007\u0004\u0003\u000f1{wmZ5oO\"AA\u0004\u0001BC\u0002\u0013%Q$\u0001\tc_>\u001cH/\u001b8h'R\u0014\u0018\r^3hsV\ta\u0004\u0005\u0002 E5\t\u0001E\u0003\u0002\"\u0005\u0005i1m\u001c8gS\u001e,(/\u0019;j_:L!a\t\u0011\u0003!\t{wn\u001d;j]\u001e\u001cFO]1uK\u001eL\b\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0010\u0002#\t|wn\u001d;j]\u001e\u001cFO]1uK\u001eL\b\u0005C\u0003(\u0001\u0011\u0005\u0001&\u0001\u0004=S:LGO\u0010\u000b\u0003S-\u0002\"A\u000b\u0001\u000e\u0003\tAQ\u0001\b\u0014A\u0002yA3AJ\u00174!\tq\u0013'D\u00010\u0015\t\u0001d!\u0001\u0006b]:|G/\u0019;j_:L!AM\u0018\u0003\u000bMKgnY3\"\u0003Q\nQ!\r\u00183]ABQA\u000e\u0001\u0005\u0002]\n1A];o)\tAd\b\u0005\u0002:y5\t!H\u0003\u0002<\u0005\u0005)Qn\u001c3fY&\u0011QH\u000f\u0002\u001a\u000fJ\fG-[3oi\n{wn\u001d;fIR\u0013X-Z:N_\u0012,G\u000eC\u0003@k\u0001\u0007\u0001)A\u0003j]B,H\u000fE\u0002B\t\u001ak\u0011A\u0011\u0006\u0003\u0007\u001a\t1A\u001d3e\u0013\t)%IA\u0002S\t\u0012\u0003\"a\u0012&\u000e\u0003!S!!\u0013\u0003\u0002\u0015I,wM]3tg&|g.\u0003\u0002L\u0011\naA*\u00192fY\u0016$\u0007k\\5oi\"\u001aQ'L\u001a\t\u000bY\u0002A\u0011\u0001(\u0015\u0005az\u0005\"B N\u0001\u0004\u0001\u0006cA)W\r6\t!K\u0003\u0002T)\u0006!!.\u0019<b\u0015\t)f!A\u0002ba&L!a\u0016*\u0003\u000f)\u000bg/\u0019*E\t\"\u001aQ*L\u001a\t\u000bi\u0003A\u0011A.\u0002#I,hnV5uQZ\u000bG.\u001b3bi&|g\u000eF\u000299vCQaP-A\u0002\u0001CQAX-A\u0002\u0001\u000bqB^1mS\u0012\fG/[8o\u0013:\u0004X\u000f\u001e\u0015\u000436\u0002\u0017%A1\u0002\u000bErCG\f\u0019\t\u000bi\u0003A\u0011A2\u0015\u0007a\"W\rC\u0003@E\u0002\u0007\u0001\u000bC\u0003_E\u0002\u0007\u0001\u000bK\u0002c[\u0001D#\u0001\u00015\u0011\u00059J\u0017B\u000160\u00051)\u0005\u0010]3sS6,g\u000e^1mQ\r\u0001QfM\u0004\u0006[\nA\tA\\\u0001\u0015\u000fJ\fG-[3oi\n{wn\u001d;fIR\u0013X-Z:\u0011\u0005)zg!B\u0001\u0003\u0011\u0003\u00018\u0003B8\u000f/QAQaJ8\u0005\u0002I$\u0012A\u001c\u0005\u0006i>$\t!^\u0001\u0006iJ\f\u0017N\u001c\u000b\u0004qY<\b\"B t\u0001\u0004\u0001\u0005\"\u0002\u000ft\u0001\u0004q\u0002fA:.g!)Ao\u001cC\u0001uR\u0019\u0001h\u001f?\t\u000b}J\b\u0019\u0001)\t\u000bqI\b\u0019\u0001\u0010)\u0007el3\u0007\u0003\u0004\u0000_\u0012%\u0011\u0011A\u0001\u0006E>|7\u000f\u001e\u000b\nq\u0005\r\u0011QAA\u0004\u0003\u0013AQa\u0010@A\u0002\u0001CQA\u0018@A\u0002\u0001CQ\u0001\b@A\u0002yAq!a\u0003\u007f\u0001\u0004\ti!\u0001\u0005wC2LG-\u0019;f!\ry\u0011qB\u0005\u0004\u0003#\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003+y\u0017\u0011!C\u0005\u0003/\t1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0004\t\u0005\u00037\t\u0019#\u0004\u0002\u0002\u001e)!\u0011qDA\u0011\u0003\u0011a\u0017M\\4\u000b\u0003MKA!!\n\u0002\u001e\t1qJ\u00196fGRD3a\\\u00174Q\raWf\r")
public class GradientBoostedTrees
implements Serializable,
Logging {
    private final BoostingStrategy boostingStrategy;
    private transient Logger org$apache$spark$Logging$$log_;

    public static GradientBoostedTreesModel train(JavaRDD<LabeledPoint> javaRDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(javaRDD, boostingStrategy);
    }

    public static GradientBoostedTreesModel train(RDD<LabeledPoint> rDD, BoostingStrategy boostingStrategy) {
        return GradientBoostedTrees$.MODULE$.train(rDD, boostingStrategy);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    private BoostingStrategy boostingStrategy() {
        return this.boostingStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public GradientBoostedTreesModel run(RDD<LabeledPoint> input) {
        void var2_2;
        block4: {
            GradientBoostedTreesModel gradientBoostedTreesModel;
            block3: {
                Enumeration.Value value;
                block2: {
                    Enumeration.Value algo;
                    value = algo = this.boostingStrategy().treeStrategy().algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Regression();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost(input, input, this.boostingStrategy(), false);
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Classification();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                RDD remappedInput = input.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost((RDD<LabeledPoint>)remappedInput, (RDD<LabeledPoint>)remappedInput, this.boostingStrategy(), false);
            }
            return gradientBoostedTreesModel;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported by the gradient boosting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var2_2})));
    }

    public GradientBoostedTreesModel run(JavaRDD<LabeledPoint> input) {
        return this.run((RDD<LabeledPoint>)input.rdd());
    }

    /*
     * WARNING - void declaration
     */
    public GradientBoostedTreesModel runWithValidation(RDD<LabeledPoint> input, RDD<LabeledPoint> validationInput) {
        void var3_3;
        block4: {
            GradientBoostedTreesModel gradientBoostedTreesModel;
            block3: {
                Enumeration.Value value;
                block2: {
                    Enumeration.Value algo;
                    value = algo = this.boostingStrategy().treeStrategy().algo();
                    Enumeration.Value value2 = Algo$.MODULE$.Regression();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block2;
                    gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost(input, validationInput, this.boostingStrategy(), true);
                    break block3;
                }
                Enumeration.Value value4 = Algo$.MODULE$.Classification();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block4;
                RDD remappedInput = input.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                RDD remappedValidationInput = validationInput.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final LabeledPoint apply(LabeledPoint x) {
                        return new LabeledPoint(x.label() * (double)2 - 1.0, x.features());
                    }
                }, ClassTag$.MODULE$.apply(LabeledPoint.class));
                gradientBoostedTreesModel = GradientBoostedTrees$.MODULE$.org$apache$spark$mllib$tree$GradientBoostedTrees$$boost((RDD<LabeledPoint>)remappedInput, (RDD<LabeledPoint>)remappedValidationInput, this.boostingStrategy(), true);
            }
            return gradientBoostedTreesModel;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not supported by the gradient boosting."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{var3_3})));
    }

    public GradientBoostedTreesModel runWithValidation(JavaRDD<LabeledPoint> input, JavaRDD<LabeledPoint> validationInput) {
        return this.runWithValidation((RDD<LabeledPoint>)input.rdd(), (RDD<LabeledPoint>)validationInput.rdd());
    }

    public GradientBoostedTrees(BoostingStrategy boostingStrategy) {
        this.boostingStrategy = boostingStrategy;
        Logging.class.$init$((Logging)this);
    }
}

