/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.ml.classification.LogisticRegression$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasElasticNetParam;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}d\u0001\u0003\u000b\u0016!\u0003\r\t!F\u0010\t\u000b)\u0003A\u0011\u0001'\t\u000bA\u0003A\u0011A)\t\u000fa\u0003!\u0019!C\u00033\")!\u000f\u0001C\u0001g\")Q\u000f\u0001C!m\")q\u000f\u0001C\u0001q\")Q\u0010\u0001C!}\")q\u0010\u0001C\t\u0019\"I\u0011\u0011\u0001\u0001C\u0002\u0013\u0005\u00111\u0001\u0005\b\u00033\u0001A\u0011AA\u000e\u0011%\ty\u0002\u0001b\u0001\n\u0003\t\u0019\u0001C\u0004\u0002$\u0001!\t!a\u0007\t\u0013\u0005\u001d\u0002A1A\u0005\u0002\u0005%\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\n\u0003w\u0001!\u0019!C\u0001\u0003SAq!a\u0010\u0001\t\u0003\t9\u0004C\u0004\u0002D\u0001!\t\"!\u0012\t\u000f\u00055\u0003\u0001\"\u0015\u0002P!q\u00111\u000f\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003\u0002v\u0005u$\u0001\u0007'pO&\u001cH/[2SK\u001e\u0014Xm]:j_:\u0004\u0016M]1ng*\u0011acF\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\tA\u0012$\u0001\u0002nY*\u0011!dG\u0001\u0006gB\f'o\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0005\u0007\u0001A\u0019R#'\u000e\u001d<}\u0005#u\t\u0005\u0002\"I5\t!EC\u0001$\u0003\u0015\u00198-\u00197b\u0013\t)#E\u0001\u0004B]f\u0014VM\u001a\t\u0003O!j\u0011!F\u0005\u0003SU\u0011Q\u0004\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017.\u001a:QCJ\fWn\u001d\t\u0003WAj\u0011\u0001\f\u0006\u0003[9\naa\u001d5be\u0016$'BA\u0018\u0018\u0003\u0015\u0001\u0018M]1n\u0013\t\tDFA\u0006ICN\u0014Vm\u001a)be\u0006l\u0007CA\u00164\u0013\t!DF\u0001\nICN,E.Y:uS\u000etU\r\u001e)be\u0006l\u0007CA\u00167\u0013\t9DF\u0001\u0006ICNl\u0015\r_%uKJ\u0004\"aK\u001d\n\u0005ib#a\u0004%bg\u001aKG/\u00138uKJ\u001cW\r\u001d;\u0011\u0005-b\u0014BA\u001f-\u0005\u0019A\u0015m\u001d+pYB\u00111fP\u0005\u0003\u00012\u0012!\u0003S1t'R\fg\u000eZ1sI&T\u0018\r^5p]B\u00111FQ\u0005\u0003\u00072\u0012A\u0002S1t/\u0016Lw\r\u001b;D_2\u0004\"aK#\n\u0005\u0019c#\u0001\u0004%bgRC'/Z:i_2$\u0007CA\u0016I\u0013\tIEFA\nICN\fum\u001a:fO\u0006$\u0018n\u001c8EKB$\b.\u0001\u0004%S:LG\u000fJ\u0002\u0001)\u0005i\u0005CA\u0011O\u0013\ty%E\u0001\u0003V]&$\u0018\u0001D:fiRC'/Z:i_2$GC\u0001*T\u001b\u0005\u0001\u0001\"\u0002+\u0003\u0001\u0004)\u0016!\u0002<bYV,\u0007CA\u0011W\u0013\t9&E\u0001\u0004E_V\u0014G.Z\u0001\u0007M\u0006l\u0017\u000e\\=\u0016\u0003i\u00032a\u0017/_\u001b\u0005q\u0013BA//\u0005\u0015\u0001\u0016M]1n!\tyfM\u0004\u0002aIB\u0011\u0011MI\u0007\u0002E*\u00111mS\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015\u0014\u0013A\u0002)sK\u0012,g-\u0003\u0002hQ\n11\u000b\u001e:j]\u001eT!!\u001a\u0012)\u0007\rQ\u0007\u000f\u0005\u0002l]6\tAN\u0003\u0002n3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005=d'!B*j]\u000e,\u0017%A9\u0002\u000bIr\u0013G\f\u0019\u0002\u0013\u001d,GOR1nS2LX#\u00010)\u0007\u0011Q\u0007/\u0001\u0007hKR$\u0006N]3tQ>dG-F\u0001V\u00035\u0019X\r\u001e+ie\u0016\u001c\bn\u001c7egR\u0011!+\u001f\u0005\u0006)\u001a\u0001\rA\u001f\t\u0004Cm,\u0016B\u0001?#\u0005\u0015\t%O]1z\u000359W\r\u001e+ie\u0016\u001c\bn\u001c7egV\t!0A\rdQ\u0016\u001c7\u000e\u00165sKNDw\u000e\u001c3D_:\u001c\u0018n\u001d;f]\u000eL\u0018!\u00077po\u0016\u0014(i\\;oIN|enQ8fM\u001aL7-[3oiN,\"!!\u0002\u0011\tmc\u0016q\u0001\t\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\f\u0002\r1Lg.\u00197h\u0013\u0011\t\t\"a\u0003\u0003\r5\u000bGO]5yQ\u0011I!.!\u0006\"\u0005\u0005]\u0011!\u0002\u001a/e9\u0002\u0014\u0001H4fi2{w/\u001a:C_VtGm](o\u0007>,gMZ5dS\u0016tGo]\u000b\u0003\u0003\u000fACA\u00036\u0002\u0016\u0005IR\u000f\u001d9fe\n{WO\u001c3t\u001f:\u001cu.\u001a4gS\u000eLWM\u001c;tQ\u0011Y!.!\u0006\u00029\u001d,G/\u00169qKJ\u0014u.\u001e8eg>s7i\\3gM&\u001c\u0017.\u001a8ug\"\"AB[A\u000b\u0003]awn^3s\u0005>,h\u000eZ:P]&sG/\u001a:dKB$8/\u0006\u0002\u0002,A!1\fXA\u0017!\u0011\tI!a\f\n\t\u0005E\u00121\u0002\u0002\u0007-\u0016\u001cGo\u001c:)\t5Q\u0017QC\u0001\u001bO\u0016$Hj\\<fe\n{WO\u001c3t\u001f:Le\u000e^3sG\u0016\u0004Ho]\u000b\u0003\u0003[ACA\u00046\u0002\u0016\u00059R\u000f\u001d9fe\n{WO\u001c3t\u001f:Le\u000e^3sG\u0016\u0004Ho\u001d\u0015\u0005\u001f)\f)\"\u0001\u000ehKR,\u0006\u000f]3s\u0005>,h\u000eZ:P]&sG/\u001a:dKB$8\u000f\u000b\u0003\u0011U\u0006U\u0011!I;tS:<'i\\;oI\u000e{gn\u001d;sC&tW\rZ(qi&l\u0017N_1uS>tWCAA$!\r\t\u0013\u0011J\u0005\u0004\u0003\u0017\u0012#a\u0002\"p_2,\u0017M\\\u0001\u001bm\u0006d\u0017\u000eZ1uK\u0006sG\r\u0016:b]N4wN]7TG\",W.\u0019\u000b\t\u0003#\n\t'!\u001a\u0002jA!\u00111KA/\u001b\t\t)F\u0003\u0003\u0002X\u0005e\u0013!\u0002;za\u0016\u001c(bAA.3\u0005\u00191/\u001d7\n\t\u0005}\u0013Q\u000b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007bBA2%\u0001\u0007\u0011\u0011K\u0001\u0007g\u000eDW-\\1\t\u000f\u0005\u001d$\u00031\u0001\u0002H\u00059a-\u001b;uS:<\u0007bBA6%\u0001\u0007\u0011QN\u0001\u0011M\u0016\fG/\u001e:fg\u0012\u000bG/\u0019+za\u0016\u0004B!a\u0015\u0002p%!\u0011\u0011OA+\u0005!!\u0015\r^1UsB,\u0017\u0001I:va\u0016\u0014HE^1mS\u0012\fG/Z!oIR\u0013\u0018M\\:g_Jl7k\u00195f[\u0006$\u0002\"!\u0015\u0002x\u0005e\u00141\u0010\u0005\b\u0003G\u001a\u0002\u0019AA)\u0011\u001d\t9g\u0005a\u0001\u0003\u000fBq!a\u001b\u0014\u0001\u0004\ti'C\u0002\u0002N!\u0002")
public interface LogisticRegressionParams
extends ProbabilisticClassifierParams,
HasRegParam,
HasElasticNetParam,
HasMaxIter,
HasFitIntercept,
HasTol,
HasStandardization,
HasWeightCol,
HasThreshold,
HasAggregationDepth {
    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(Param<String> var1);

    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(Param<Matrix> var1);

    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(Param<Matrix> var1);

    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(Param<Vector> var1);

    public void org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(Param<Vector> var1);

    public /* synthetic */ StructType org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(StructType var1, boolean var2, DataType var3);

    public static /* synthetic */ LogisticRegressionParams setThreshold$(LogisticRegressionParams $this, double value) {
        return $this.setThreshold(value);
    }

    default public LogisticRegressionParams setThreshold(double value) {
        Object object = this.isSet(this.thresholds()) ? this.clear(this.thresholds()) : BoxedUnit.UNIT;
        return (LogisticRegressionParams)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public Param<String> family();

    public static /* synthetic */ String getFamily$(LogisticRegressionParams $this) {
        return $this.getFamily();
    }

    default public String getFamily() {
        return this.$(this.family());
    }

    public static /* synthetic */ double getThreshold$(LogisticRegressionParams $this) {
        return $this.getThreshold();
    }

    @Override
    default public double getThreshold() {
        double d;
        this.checkThresholdConsistency();
        if (this.isSet(this.thresholds())) {
            double[] ts = this.$(this.thresholds());
            Predef$.MODULE$.require(ts.length == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append("Logistic Regression getThreshold only applies to binary classification, but thresholds has length != 2.  thresholds: ").append(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(ts)).mkString(",")).toString());
            d = 1.0 / (1.0 + ts[0] / ts[1]);
        } else {
            d = BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()));
        }
        return d;
    }

    public static /* synthetic */ LogisticRegressionParams setThresholds$(LogisticRegressionParams $this, double[] value) {
        return $this.setThresholds(value);
    }

    default public LogisticRegressionParams setThresholds(double[] value) {
        Object object = this.isSet(this.threshold()) ? this.clear(this.threshold()) : BoxedUnit.UNIT;
        return (LogisticRegressionParams)this.set(this.thresholds(), value);
    }

    public static /* synthetic */ double[] getThresholds$(LogisticRegressionParams $this) {
        return $this.getThresholds();
    }

    @Override
    default public double[] getThresholds() {
        double[] dArray;
        this.checkThresholdConsistency();
        if (!this.isSet(this.thresholds()) && this.isSet(this.threshold())) {
            double t = BoxesRunTime.unboxToDouble((Object)this.$(this.threshold()));
            double[] dArray2 = new double[2];
            dArray2[0] = 1.0 - t;
            dArray = dArray2;
            dArray2[1] = t;
        } else {
            dArray = this.$(this.thresholds());
        }
        return dArray;
    }

    public static /* synthetic */ void checkThresholdConsistency$(LogisticRegressionParams $this) {
        $this.checkThresholdConsistency();
    }

    default public void checkThresholdConsistency() {
        block0: {
            if (!this.isSet(this.threshold()) || !this.isSet(this.thresholds())) break block0;
            double[] ts = this.$(this.thresholds());
            Predef$.MODULE$.require(ts.length == 2, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(106).append("Logistic Regression found inconsistent values for threshold and").append(new StringBuilder(58).append(" thresholds.  Param threshold is set (").append(this.$(this.threshold())).append("), indicating binary").toString()).append(new StringBuilder(58).append(" classification, but Param thresholds is set with length ").append(ts.length).append(".").toString()).append(" Clear one Param value to fix this problem.").toString());
            double t = 1.0 / (1.0 + ts[0] / ts[1]);
            Predef$.MODULE$.require(package$.MODULE$.abs(BoxesRunTime.unboxToDouble((Object)this.$(this.threshold())) - t) < 1.0E-5, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Logistic Regression getThreshold found").append(new StringBuilder(69).append(" inconsistent values for threshold (").append(this.$(this.threshold())).append(") and thresholds (equivalent to ").append(t).append(")").toString()).toString());
        }
    }

    public Param<Matrix> lowerBoundsOnCoefficients();

    public static /* synthetic */ Matrix getLowerBoundsOnCoefficients$(LogisticRegressionParams $this) {
        return $this.getLowerBoundsOnCoefficients();
    }

    default public Matrix getLowerBoundsOnCoefficients() {
        return this.$(this.lowerBoundsOnCoefficients());
    }

    public Param<Matrix> upperBoundsOnCoefficients();

    public static /* synthetic */ Matrix getUpperBoundsOnCoefficients$(LogisticRegressionParams $this) {
        return $this.getUpperBoundsOnCoefficients();
    }

    default public Matrix getUpperBoundsOnCoefficients() {
        return this.$(this.upperBoundsOnCoefficients());
    }

    public Param<Vector> lowerBoundsOnIntercepts();

    public static /* synthetic */ Vector getLowerBoundsOnIntercepts$(LogisticRegressionParams $this) {
        return $this.getLowerBoundsOnIntercepts();
    }

    default public Vector getLowerBoundsOnIntercepts() {
        return this.$(this.lowerBoundsOnIntercepts());
    }

    public Param<Vector> upperBoundsOnIntercepts();

    public static /* synthetic */ Vector getUpperBoundsOnIntercepts$(LogisticRegressionParams $this) {
        return $this.getUpperBoundsOnIntercepts();
    }

    default public Vector getUpperBoundsOnIntercepts() {
        return this.$(this.upperBoundsOnIntercepts());
    }

    public static /* synthetic */ boolean usingBoundConstrainedOptimization$(LogisticRegressionParams $this) {
        return $this.usingBoundConstrainedOptimization();
    }

    default public boolean usingBoundConstrainedOptimization() {
        return this.isSet(this.lowerBoundsOnCoefficients()) || this.isSet(this.upperBoundsOnCoefficients()) || this.isSet(this.lowerBoundsOnIntercepts()) || this.isSet(this.upperBoundsOnIntercepts());
    }

    public static /* synthetic */ StructType validateAndTransformSchema$(LogisticRegressionParams $this, StructType schema, boolean fitting, DataType featuresDataType) {
        return $this.validateAndTransformSchema(schema, fitting, featuresDataType);
    }

    @Override
    default public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        block1: {
            this.checkThresholdConsistency();
            if (this.usingBoundConstrainedOptimization()) {
                Predef$.MODULE$.require(BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Fitting under bound constrained optimization only ").append(new StringBuilder(55).append("supports L2 regularization, but got elasticNetParam = ").append(this.getElasticNetParam()).append(".").toString()).toString());
            }
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) break block1;
            Predef$.MODULE$.require(!this.isSet(this.lowerBoundsOnIntercepts()) && !this.isSet(this.upperBoundsOnIntercepts()), (Function0 & Serializable & scala.Serializable)() -> "Please don't set bounds on intercepts if fitting without intercept.");
        }
        return this.org$apache$spark$ml$classification$LogisticRegressionParams$$super$validateAndTransformSchema(schema, fitting, featuresDataType);
    }

    public static /* synthetic */ boolean $anonfun$family$1(String value) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])LogisticRegression$.MODULE$.supportedFamilyNames())).contains((Object)value.toLowerCase(Locale.ROOT));
    }

    public static void $init$(LogisticRegressionParams $this) {
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$family_$eq(new Param<String>($this, "family", new StringBuilder(86).append("The name of family which is a description of the label distribution to be used in the ").append(new StringBuilder(27).append("model. Supported options: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])LogisticRegression$.MODULE$.supportedFamilyNames())).mkString(", ")).append(".").toString()).toString(), (Function1 & Serializable & scala.Serializable)value -> BoxesRunTime.boxToBoolean((boolean)LogisticRegressionParams.$anonfun$family$1(value))));
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnCoefficients_$eq(new Param<Matrix>($this, "lowerBoundsOnCoefficients", "The lower bounds on coefficients if fitting under bound constrained optimization."));
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnCoefficients_$eq(new Param<Matrix>($this, "upperBoundsOnCoefficients", "The upper bounds on coefficients if fitting under bound constrained optimization."));
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$lowerBoundsOnIntercepts_$eq(new Param<Vector>($this, "lowerBoundsOnIntercepts", "The lower bounds on intercepts if fitting under bound constrained optimization."));
        $this.org$apache$spark$ml$classification$LogisticRegressionParams$_setter_$upperBoundsOnIntercepts_$eq(new Param<Vector>($this, "upperBoundsOnIntercepts", "The upper bounds on intercepts if fitting under bound constrained optimization."));
    }
}

