/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.SparseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.runtime.java8.JFunction1;

public final class NaiveBayes$
implements DefaultParamsReadable<NaiveBayes>,
Serializable {
    public static NaiveBayes$ MODULE$;
    private final String Multinomial;
    private final String Bernoulli;
    private final Set<String> supportedModelTypes;

    static {
        new NaiveBayes$();
    }

    @Override
    public MLReader<NaiveBayes> read() {
        return DefaultParamsReadable.read$(this);
    }

    public String Multinomial() {
        return this.Multinomial;
    }

    public String Bernoulli() {
        return this.Bernoulli;
    }

    public Set<String> supportedModelTypes() {
        return this.supportedModelTypes;
    }

    public void requireNonnegativeValues(Vector v) {
        double[] dArray;
        Vector vector = v;
        if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            dArray = sparseVector.values();
        } else if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            dArray = denseVector.values();
        } else {
            throw new MatchError((Object)vector);
        }
        double[] values = dArray;
        Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).forall((Function1)(JFunction1.mcZD.sp & java.io.Serializable & Serializable)x$4 -> x$4 >= 0.0), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(59).append("Naive Bayes requires nonnegative feature values but found ").append(v).append(".").toString());
    }

    public void requireZeroOneBernoulliValues(Vector v2) {
        double[] dArray;
        Vector vector = v2;
        if (vector instanceof SparseVector) {
            SparseVector sparseVector = (SparseVector)vector;
            dArray = sparseVector.values();
        } else if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            dArray = denseVector.values();
        } else {
            throw new MatchError((Object)vector);
        }
        double[] values = dArray;
        Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(values)).forall((Function1)(JFunction1.mcZD.sp & java.io.Serializable & Serializable)v -> v == 0.0 || v == 1.0), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(64).append("Bernoulli naive Bayes requires 0 or 1 feature values but found ").append(v2).append(".").toString());
    }

    @Override
    public NaiveBayes load(String path) {
        return (NaiveBayes)MLReadable.load$(this, path);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private NaiveBayes$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        DefaultParamsReadable.$init$(this);
        this.Multinomial = "multinomial";
        this.Bernoulli = "bernoulli";
        this.supportedModelTypes = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.Multinomial(), this.Bernoulli()}));
    }
}

