/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.evaluation.BinaryClassificationEvaluator$;
import org.apache.spark.ml.evaluation.Evaluator;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.ParamValidators$;
import org.apache.spark.ml.param.shared.HasLabelCol;
import org.apache.spark.ml.param.shared.HasRawPredictionCol;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.evaluation.BinaryClassificationMetrics;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\n\u0015\u0001}A\u0001\"\u000e\u0001\u0003\u0006\u0004%\tE\u000e\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005o!)q\n\u0001C\u0001!\")q\n\u0001C\u0001+\"9\u0011\f\u0001b\u0001\n\u0003Q\u0006B\u00021\u0001A\u0003%1\fC\u0003c\u0001\u0011\u0005a\u0007C\u0003e\u0001\u0011\u0005Q\rC\u0003k\u0001\u0011\u00051\u000eC\u0003q\u0001\u0011\u0005\u0011\u000fC\u0003u\u0001\u0011\u0005S\u000fC\u0004\u0002$\u0001!\t%!\n\t\u000f\u0005=\u0002\u0001\"\u0011\u00022\u001d9\u0011Q\n\u000b\t\u0002\u0005=cAB\n\u0015\u0011\u0003\t\t\u0006\u0003\u0004P\u001f\u0011\u0005\u0011Q\r\u0005\b\u0003OzA\u0011IA5\u0011%\t)hDA\u0001\n\u0013\t9HA\u000fCS:\f'/_\"mCN\u001c\u0018NZ5dCRLwN\\#wC2,\u0018\r^8s\u0015\t)b#\u0001\u0006fm\u0006dW/\u0019;j_:T!a\u0006\r\u0002\u00055d'BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M)\u0001\u0001\t\u0013-_A\u0011\u0011EI\u0007\u0002)%\u00111\u0005\u0006\u0002\n\u000bZ\fG.^1u_J\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\rMD\u0017M]3e\u0015\tIc#A\u0003qCJ\fW.\u0003\u0002,M\t\u0019\u0002*Y:SC^\u0004&/\u001a3jGRLwN\\\"pYB\u0011Q%L\u0005\u0003]\u0019\u00121\u0002S1t\u0019\u0006\u0014W\r\\\"pYB\u0011\u0001gM\u0007\u0002c)\u0011!GF\u0001\u0005kRLG.\u0003\u00025c\t)B)\u001a4bk2$\b+\u0019:b[N<&/\u001b;bE2,\u0017aA;jIV\tq\u0007\u0005\u00029\u0003:\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0003yy\ta\u0001\u0010:p_Rt$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k\u0014A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u001f)\u0007\u0005)5\n\u0005\u0002G\u00136\tqI\u0003\u0002I1\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005);%!B*j]\u000e,\u0017%\u0001'\u0002\u000bErCG\f\u0019\u0002\tULG\r\t\u0015\u0004\u0005\u0015[\u0015A\u0002\u001fj]&$h\b\u0006\u0002R%B\u0011\u0011\u0005\u0001\u0005\u0006k\r\u0001\ra\u000e\u0015\u0004%\u0016[\u0005fA\u0002F\u0017R\t\u0011\u000bK\u0002\u0005\u000b^\u000b\u0013\u0001W\u0001\u0006c9\u0012d\u0006M\u0001\u000b[\u0016$(/[2OC6,W#A.\u0011\u0007qkv'D\u0001)\u0013\tq\u0006FA\u0003QCJ\fW\u000eK\u0002\u0006\u000b^\u000b1\"\\3ue&\u001cg*Y7fA!\u001aa!R,\u0002\u001b\u001d,G/T3ue&\u001cg*Y7fQ\r9QiV\u0001\u000eg\u0016$X*\u001a;sS\u000et\u0015-\\3\u0015\u0005\u0019<W\"\u0001\u0001\t\u000b!D\u0001\u0019A\u001c\u0002\u000bY\fG.^3)\u0007!)u+A\ntKR\u0014\u0016m\u001e)sK\u0012L7\r^5p]\u000e{G\u000e\u0006\u0002gY\")\u0001.\u0003a\u0001o!\u001a\u0011\"\u00128\"\u0003=\fQ!\r\u00186]A\n1b]3u\u0019\u0006\u0014W\r\\\"pYR\u0011aM\u001d\u0005\u0006Q*\u0001\ra\u000e\u0015\u0004\u0015\u0015;\u0016\u0001C3wC2,\u0018\r^3\u0015\u0005YT\bCA<y\u001b\u0005i\u0014BA=>\u0005\u0019!u.\u001e2mK\")1p\u0003a\u0001y\u00069A-\u0019;bg\u0016$\bgA?\u0002\fA)a0a\u0001\u0002\b5\tqPC\u0002\u0002\u0002a\t1a]9m\u0013\r\t)a \u0002\b\t\u0006$\u0018m]3u!\u0011\tI!a\u0003\r\u0001\u0011Y\u0011Q\u0002>\u0002\u0002\u0003\u0005)\u0011AA\b\u0005\ryF%M\t\u0005\u0003#\t9\u0002E\u0002x\u0003'I1!!\u0006>\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a^A\r\u0013\r\tY\"\u0010\u0002\u0004\u0003:L\b\u0006B\u0006F\u0003?\t#!!\t\u0002\u000bIr\u0003G\f\u0019\u0002\u001d%\u001cH*\u0019:hKJ\u0014U\r\u001e;feV\u0011\u0011q\u0005\t\u0004o\u0006%\u0012bAA\u0016{\t9!i\\8mK\u0006t\u0007f\u0001\u0007F]\u0006!1m\u001c9z)\r\t\u00161\u0007\u0005\b\u0003ki\u0001\u0019AA\u001c\u0003\u0015)\u0007\u0010\u001e:b!\ra\u0016\u0011H\u0005\u0004\u0003wA#\u0001\u0003)be\u0006lW*\u00199)\t5)\u0015qH\u0011\u0003\u0003\u0003\nQ!\r\u00185]EB3\u0001AA#!\r1\u0015qI\u0005\u0004\u0003\u0013:%\u0001D#ya\u0016\u0014\u0018.\\3oi\u0006d\u0007f\u0001\u0001F/\u0006i\")\u001b8bef\u001cE.Y:tS\u001aL7-\u0019;j_:,e/\u00197vCR|'\u000f\u0005\u0002\"\u001fM9q\"a\u0015\u0002Z\u0005}\u0003cA<\u0002V%\u0019\u0011qK\u001f\u0003\r\u0005s\u0017PU3g!\u0011\u0001\u00141L)\n\u0007\u0005u\u0013GA\u000bEK\u001a\fW\u000f\u001c;QCJ\fWn\u001d*fC\u0012\f'\r\\3\u0011\u0007]\f\t'C\u0002\u0002du\u0012AbU3sS\u0006d\u0017N_1cY\u0016$\"!a\u0014\u0002\t1|\u0017\r\u001a\u000b\u0004#\u0006-\u0004BBA7#\u0001\u0007q'\u0001\u0003qCRD\u0007\u0006B\tF\u0003c\n#!a\u001d\u0002\u000bErcG\f\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003s\u0002B!a\u001f\u0002\u00066\u0011\u0011Q\u0010\u0006\u0005\u0003\u007f\n\t)\u0001\u0003mC:<'BAAB\u0003\u0011Q\u0017M^1\n\t\u0005\u001d\u0015Q\u0010\u0002\u0007\u001f\nTWm\u0019;)\t=)\u0015\u0011\u000f\u0015\u0005\u001d\u0015\u000b\t\b")
public class BinaryClassificationEvaluator
extends Evaluator
implements HasRawPredictionCol,
HasLabelCol,
DefaultParamsWritable {
    private final String uid;
    private final Param<String> metricName;
    private final Param<String> labelCol;
    private final Param<String> rawPredictionCol;

    public static BinaryClassificationEvaluator load(String string) {
        return BinaryClassificationEvaluator$.MODULE$.load(string);
    }

    public static MLReader<BinaryClassificationEvaluator> read() {
        return BinaryClassificationEvaluator$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final String getLabelCol() {
        return HasLabelCol.getLabelCol$(this);
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol.getRawPredictionCol$(this);
    }

    @Override
    public final Param<String> labelCol() {
        return this.labelCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasLabelCol$_setter_$labelCol_$eq(Param<String> x$1) {
        this.labelCol = x$1;
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param<String> x$1) {
        this.rawPredictionCol = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Param<String> metricName() {
        return this.metricName;
    }

    public String getMetricName() {
        return this.$(this.metricName());
    }

    public BinaryClassificationEvaluator setMetricName(String value) {
        return (BinaryClassificationEvaluator)this.set(this.metricName(), value);
    }

    public BinaryClassificationEvaluator setRawPredictionCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.rawPredictionCol(), value);
    }

    public BinaryClassificationEvaluator setLabelCol(String value) {
        return (BinaryClassificationEvaluator)this.set(this.labelCol(), value);
    }

    @Override
    public double evaluate(Dataset<?> dataset) {
        double d;
        StructType schema = dataset.schema();
        SchemaUtils$.MODULE$.checkColumnTypes(schema, this.$(this.rawPredictionCol()), (Seq<DataType>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{DoubleType$.MODULE$, new VectorUDT()}))), SchemaUtils$.MODULE$.checkColumnTypes$default$4());
        SchemaUtils$.MODULE$.checkNumericType(schema, this.$(this.labelCol()), SchemaUtils$.MODULE$.checkNumericType$default$3());
        RDD scoreAndLabels = dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol())), functions$.MODULE$.col(this.$(this.labelCol())).cast((DataType)DoubleType$.MODULE$)})).rdd().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Some some;
            Row row = x0$1;
            Some some2 = Row$.MODULE$.unapplySeq(row);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
                Object rawPrediction = ((SeqLike)some2.get()).apply(0);
                Object label = ((SeqLike)some2.get()).apply(1);
                if (rawPrediction instanceof Vector) {
                    Vector vector = (Vector)rawPrediction;
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        return new Tuple2.mcDD.sp(vector.apply(1), d);
                    }
                }
            }
            if ((some = Row$.MODULE$.unapplySeq(row)).isEmpty()) throw new MatchError((Object)row);
            if (some.get() == null) throw new MatchError((Object)row);
            if (((SeqLike)some.get()).lengthCompare(2) != 0) throw new MatchError((Object)row);
            Object rawPrediction = ((SeqLike)some.get()).apply(0);
            Object label = ((SeqLike)some.get()).apply(1);
            if (!(rawPrediction instanceof Double)) throw new MatchError((Object)row);
            double d = BoxesRunTime.unboxToDouble((Object)rawPrediction);
            if (!(label instanceof Double)) throw new MatchError((Object)row);
            double d2 = BoxesRunTime.unboxToDouble((Object)label);
            return new Tuple2.mcDD.sp(d, d2);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        BinaryClassificationMetrics metrics = new BinaryClassificationMetrics((RDD<Tuple2<Object, Object>>)scoreAndLabels);
        String string = this.$(this.metricName());
        if ("areaUnderROC".equals(string)) {
            d = metrics.areaUnderROC();
        } else if ("areaUnderPR".equals(string)) {
            d = metrics.areaUnderPR();
        } else {
            throw new MatchError((Object)string);
        }
        double metric = d;
        metrics.unpersist();
        return metric;
    }

    @Override
    public boolean isLargerBetter() {
        boolean bl;
        String string = this.$(this.metricName());
        if ("areaUnderROC".equals(string)) {
            bl = true;
        } else if ("areaUnderPR".equals(string)) {
            bl = true;
        } else {
            throw new MatchError((Object)string);
        }
        return bl;
    }

    @Override
    public BinaryClassificationEvaluator copy(ParamMap extra) {
        return (BinaryClassificationEvaluator)this.defaultCopy(extra);
    }

    public BinaryClassificationEvaluator(String uid) {
        this.uid = uid;
        HasRawPredictionCol.$init$(this);
        HasLabelCol.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Function1 allowedParams = ParamValidators$.MODULE$.inArray(new String[]{"areaUnderROC", "areaUnderPR"});
        this.metricName = new Param(this, "metricName", "metric name in evaluation (areaUnderROC|areaUnderPR)", allowedParams);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.metricName().$minus$greater("areaUnderROC")}));
    }

    public BinaryClassificationEvaluator() {
        this(Identifiable$.MODULE$.randomUID("binEval"));
    }
}

