/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.evaluation;

import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00054a!\u0002\u0004\u0002\u0002\u0019\u0001\u0002\"B\f\u0001\t\u0003I\u0002\"\u0002\u000f\u0001\t\u0003i\u0002\"\u0002\u001e\u0001\t\u0003Y\u0004\"B+\u0001\t#1&AC*jY\"|W/\u001a;uK*\u0011q\u0001C\u0001\u000bKZ\fG.^1uS>t'BA\u0005\u000b\u0003\tiGN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h'\t\u0001\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0004\u0005\u0002\u001c\u00015\ta!\u0001\u000eq_&tGoU5mQ>,X\r\u001e;f\u0007>,gMZ5dS\u0016tG\u000fF\u0003\u001fC9\u0002T\u0007\u0005\u0002\u0013?%\u0011\u0001e\u0005\u0002\u0007\t>,(\r\\3\t\u000b\t\u0012\u0001\u0019A\u0012\u0002\u0015\rdWo\u001d;fe&#7\u000fE\u0002%Wyq!!J\u0015\u0011\u0005\u0019\u001aR\"A\u0014\u000b\u0005!B\u0012A\u0002\u001fs_>$h(\u0003\u0002+'\u00051\u0001K]3eK\u001aL!\u0001L\u0017\u0003\u0007M+GO\u0003\u0002+'!)qF\u0001a\u0001=\u0005q\u0001o\\5oi\u000ecWo\u001d;fe&#\u0007\"B\u0019\u0003\u0001\u0004\u0011\u0014a\u00069pS:$8\t\\;ti\u0016\u0014h*^7PMB{\u0017N\u001c;t!\t\u00112'\u0003\u00025'\t!Aj\u001c8h\u0011\u00151$\u00011\u00018\u0003a\tg/\u001a:bO\u0016$\u0015n\u001d;b]\u000e,Gk\\\"mkN$XM\u001d\t\u0005%arb$\u0003\u0002:'\tIa)\u001e8di&|g.M\u0001\r_Z,'/\u00197m'\u000e|'/\u001a\u000b\u0004=qz\u0005\"B\u001f\u0004\u0001\u0004q\u0014A\u00013g!\tyDJ\u0004\u0002A\u0013:\u0011\u0011i\u0012\b\u0003\u0005\u001as!aQ#\u000f\u0005\u0019\"\u0015\"A\b\n\u00055q\u0011BA\u0006\r\u0013\tA%\"A\u0002tc2L!AS&\u0002\u000fA\f7m[1hK*\u0011\u0001JC\u0005\u0003\u001b:\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0005)[\u0005\"\u0002)\u0004\u0001\u0004\t\u0016aC:d_J,7i\u001c7v[:\u0004\"AU*\u000e\u0003-K!\u0001V&\u0003\r\r{G.^7o\u0003M9W\r\u001e(v[\n,'o\u00144GK\u0006$XO]3t)\r9&\f\u0018\t\u0003%aK!!W\n\u0003\u0007%sG\u000fC\u0003\\\t\u0001\u0007a(A\u0005eCR\fgI]1nK\")Q\f\u0002a\u0001=\u0006Q1m\u001c7v[:t\u0015-\\3\u0011\u0005\u0011z\u0016B\u00011.\u0005\u0019\u0019FO]5oO\u0002")
public abstract class Silhouette {
    public double pointSilhouetteCoefficient(Set<Object> clusterIds, double pointClusterId, long pointClusterNumOfPoints, Function1<Object, Object> averageDistanceToCluster) {
        double currentClusterDissimilarity;
        Set otherClusterIds = (Set)clusterIds.filter((Function1)(JFunction1.mcZD.sp & java.io.Serializable & Serializable)x$1 -> x$1 != pointClusterId);
        double neighboringClusterDissimilarity = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)otherClusterIds.map(averageDistanceToCluster, Set$.MODULE$.canBuildFrom())).min((Ordering)Ordering.Double$.MODULE$));
        double d = currentClusterDissimilarity = pointClusterNumOfPoints == 1L ? 0.0 : averageDistanceToCluster.apply$mcDD$sp(pointClusterId) * (double)pointClusterNumOfPoints / (double)(pointClusterNumOfPoints - 1L);
        return currentClusterDissimilarity < neighboringClusterDissimilarity ? 1.0 - currentClusterDissimilarity / neighboringClusterDissimilarity : (currentClusterDissimilarity > neighboringClusterDissimilarity ? neighboringClusterDissimilarity / currentClusterDissimilarity - 1.0 : 0.0);
    }

    public double overallScore(Dataset<Row> df, Column scoreColumn) {
        return ((Row[])df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.avg(scoreColumn)})).collect())[0].getDouble(0);
    }

    public int getNumberOfFeatures(Dataset<Row> dataFrame, String columnName) {
        AttributeGroup group = AttributeGroup$.MODULE$.fromStructField(dataFrame.schema().apply(columnName));
        return group.size() < 0 ? ((Vector)((Row)dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(columnName)})).first()).getAs(0)).size() : group.size();
    }
}

