/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.feature;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.NoSuchElementException;
import org.apache.spark.SparkException;
import org.apache.spark.ml.attribute.AttributeGroup$;
import org.apache.spark.ml.feature.VectorAssembler;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.util.DefaultParamsReadable;
import org.apache.spark.ml.util.MLReadable;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction2;

public final class VectorAssembler$
implements DefaultParamsReadable<VectorAssembler>,
scala.Serializable {
    public static VectorAssembler$ MODULE$;
    private final String SKIP_INVALID;
    private final String ERROR_INVALID;
    private final String KEEP_INVALID;
    private final String[] supportedHandleInvalids;

    static {
        new VectorAssembler$();
    }

    @Override
    public MLReader<VectorAssembler> read() {
        return DefaultParamsReadable.read$(this);
    }

    public String SKIP_INVALID() {
        return this.SKIP_INVALID;
    }

    public String ERROR_INVALID() {
        return this.ERROR_INVALID;
    }

    public String KEEP_INVALID() {
        return this.KEEP_INVALID;
    }

    public String[] supportedHandleInvalids() {
        return this.supportedHandleInvalids;
    }

    public Map<String, Object> getVectorLengthsFromFirstRow(Dataset<?> dataset, Seq<String> columns) {
        Map map;
        try {
            Row first_row = (Row)dataset.toDF().select((Seq)columns.map((Function1 & Serializable & scala.Serializable)colName -> functions$.MODULE$.col(colName), Seq$.MODULE$.canBuildFrom())).first();
            map = ((TraversableOnce)((TraversableLike)columns.zip((GenIterable)first_row.toSeq(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String c = (String)tuple2._1();
                Object x = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c), (Object)BoxesRunTime.boxToInteger((int)((Vector)x).size()));
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        }
        catch (NullPointerException e) {
            throw new NullPointerException(new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(140).append("Encountered null value while inferring lengths from the first row. Consider using\n           |VectorSizeHint to add metadata for columns: ").append(columns.mkString("[", ", ", "]")).append(". ").toString())).stripMargin().replaceAll("\n", " ")).append(e.toString()).toString());
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(new StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(145).append("Encountered empty dataframe while inferring lengths from the first row. Consider using\n           |VectorSizeHint to add metadata for columns: ").append(columns.mkString("[", ", ", "]")).append(". ").toString())).stripMargin().replaceAll("\n", " ")).append(e.toString()).toString());
        }
        return map;
    }

    /*
     * Unable to fully structure code
     */
    public Map<String, Object> getLengths(Dataset<?> dataset, Seq<String> columns, String handleInvalid) {
        block8: {
            block7: {
                groupSizes = ((TraversableOnce)columns.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getLengths$1(org.apache.spark.sql.Dataset java.lang.String ), (Ljava/lang/String;)Lscala/Tuple2;)(dataset), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                missingColumns = ((MapLike)groupSizes.filter((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$getLengths$2$adapted(scala.Tuple2 ), (Lscala/Tuple2;)Ljava/lang/Object;)())).keys().toSeq();
                var8_6 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)missingColumns.nonEmpty()), (Object)handleInvalid);
                if (var8_6 == null) break block7;
                var9_7 = var8_6._1$mcZ$sp();
                var10_8 = (String)var8_6._2();
                if (!var9_7) break block7;
                v0 = this.ERROR_INVALID();
                var11_9 = var10_8;
                if (v0 != null ? v0.equals(var11_9) == false : var11_9 != null) break block7;
                var4_10 = this.getVectorLengthsFromFirstRow(dataset, (Seq<String>)missingColumns);
                break block8;
            }
            if (var8_6 == null) ** GOTO lbl-1000
            var12_11 = var8_6._1$mcZ$sp();
            var13_12 = (String)var8_6._2();
            if (!var12_11) ** GOTO lbl-1000
            v1 = this.SKIP_INVALID();
            var14_13 = var13_12;
            if (!(v1 != null ? v1.equals(var14_13) == false : var14_13 != null)) {
                var4_10 = this.getVectorLengthsFromFirstRow(dataset.na().drop(missingColumns), (Seq<String>)missingColumns);
            } else lbl-1000:
            // 3 sources

            {
                if (var8_6 != null) {
                    var15_14 = var8_6._1$mcZ$sp();
                    var16_15 = (String)var8_6._2();
                    if (var15_14) {
                        v2 = this.KEEP_INVALID();
                        var17_16 = var16_15;
                        if (!(v2 != null ? v2.equals(var17_16) == false : var17_16 != null)) {
                            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(130).append("Can not infer column lengths with handleInvalid = \"keep\". Consider using VectorSizeHint\n           |to add metadata for columns: ").append(columns.mkString("[", ", ", "]")).append(".").toString())).stripMargin().replaceAll("\n", " "));
                        }
                    }
                }
                if (var8_6 != null) {
                    var4_10 = Predef$.MODULE$.Map().empty();
                } else {
                    throw new MatchError((Object)var8_6);
                }
            }
        }
        firstSizes = var4_10;
        return groupSizes.$plus$plus((GenTraversableOnce)firstSizes);
    }

    @Override
    public VectorAssembler load(String path) {
        return (VectorAssembler)MLReadable.load$(this, path);
    }

    public Vector assemble(int[] lengths, boolean keepInvalid, Seq<Object> vv) {
        ArrayBuilder indices = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
        ArrayBuilder values = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
        IntRef featureIndex = IntRef.create((int)0);
        IntRef inputColumnIndex = IntRef.create((int)0);
        vv.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            VectorAssembler$.$anonfun$assemble$1(keepInvalid, indices, featureIndex, values, inputColumnIndex, lengths, x0$1);
            return BoxedUnit.UNIT;
        });
        return Vectors$.MODULE$.sparse(featureIndex.elem, (int[])indices.result(), (double[])values.result()).compressed();
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$getLengths$1(Dataset dataset$2, String c) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)c), (Object)BoxesRunTime.boxToInteger((int)AttributeGroup$.MODULE$.fromStructField(dataset$2.schema().apply(c)).size()));
    }

    public static final /* synthetic */ boolean $anonfun$getLengths$2(Tuple2 x$2) {
        return x$2._2$mcI$sp() == -1;
    }

    public static final /* synthetic */ ArrayBuilder $anonfun$assemble$3(ArrayBuilder indices$1, IntRef featureIndex$1, ArrayBuilder values$1, int i) {
        indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(featureIndex$1.elem + i)));
        return (ArrayBuilder)values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)Double.NaN));
    }

    public static final /* synthetic */ void $anonfun$assemble$1(boolean keepInvalid$2, ArrayBuilder indices$1, IntRef featureIndex$1, ArrayBuilder values$1, IntRef inputColumnIndex$1, int[] lengths$2, Object x0$1) {
        Object object = x0$1;
        if (object instanceof Double) {
            BoxedUnit boxedUnit;
            double d = BoxesRunTime.unboxToDouble((Object)object);
            if (Predef$.MODULE$.double2Double(d).isNaN() && !keepInvalid$2) {
                throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Encountered NaN while assembling a row with handleInvalid = \"error\". Consider\n               |removing NaNs from dataset or using handleInvalid = \"keep\" or \"skip\".")).stripMargin());
            }
            if (d != 0.0) {
                indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)featureIndex$1.elem));
                boxedUnit = values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)d));
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ++inputColumnIndex$1.elem;
            ++featureIndex$1.elem;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            vector.foreachActive((Function2)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$2, x1$1) -> {
                BoxedUnit boxedUnit;
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
                if (sp2 != null) {
                    int i = sp2._1$mcI$sp();
                    double v = sp2._2$mcD$sp();
                    if (v != 0.0) {
                        indices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(featureIndex$1.elem + i)));
                        values$1.$plus$eq((Object)BoxesRunTime.boxToDouble((double)v));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                } else {
                    throw new MatchError((Object)sp2);
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            });
            ++inputColumnIndex$1.elem;
            featureIndex$1.elem += vector.size();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (object == null) {
            if (keepInvalid$2) {
                int length = lengths$2[inputColumnIndex$1.elem];
                new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(Array$.MODULE$.range(0, length))).foreach((Function1 & Serializable & scala.Serializable)i -> VectorAssembler$.$anonfun$assemble$3(indices$1, featureIndex$1, values$1, BoxesRunTime.unboxToInt((Object)i)));
                ++inputColumnIndex$1.elem;
                featureIndex$1.elem += length;
            } else {
                throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Encountered null while assembling a row with handleInvalid = \"keep\". Consider\n               |removing nulls from dataset or using handleInvalid = \"keep\" or \"skip\".")).stripMargin());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new SparkException(new StringBuilder(27).append(object).append(" of type ").append(object.getClass().getName()).append(" is not supported.").toString());
        }
    }

    private VectorAssembler$() {
        MODULE$ = this;
        MLReadable.$init$(this);
        DefaultParamsReadable.$init$(this);
        this.SKIP_INVALID = "skip";
        this.ERROR_INVALID = "error";
        this.KEEP_INVALID = "keep";
        this.supportedHandleInvalids = (String[])((Object[])new String[]{this.SKIP_INVALID(), this.ERROR_INVALID(), this.KEEP_INVALID()});
    }

    public static final /* synthetic */ Object $anonfun$getLengths$2$adapted(Tuple2 x$2) {
        return BoxesRunTime.boxToBoolean((boolean)VectorAssembler$.$anonfun$getLengths$2(x$2));
    }
}

