/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.optim;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.DenseVector;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.optim.CholeskySolver;
import org.apache.spark.ml.optim.QuasiNewtonSolver;
import org.apache.spark.ml.optim.SingularMatrixException;
import org.apache.spark.ml.optim.WeightedLeastSquares$;
import org.apache.spark.ml.optim.WeightedLeastSquares$Auto$;
import org.apache.spark.ml.optim.WeightedLeastSquares$QuasiNewton$;
import org.apache.spark.ml.optim.WeightedLeastSquaresModel;
import org.apache.spark.ml.util.OptionalInstrumentation;
import org.apache.spark.ml.util.OptionalInstrumentation$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r}b!\u0002:t\u0001Ul\bBCA\b\u0001\t\u0015\r\u0011\"\u0001\u0002\u0014!Q\u00111\u0004\u0001\u0003\u0002\u0003\u0006I!!\u0006\t\u0015\u0005u\u0001A!b\u0001\n\u0003\ty\u0002\u0003\u0006\u0002(\u0001\u0011\t\u0011)A\u0005\u0003CA!\"!\u000b\u0001\u0005\u000b\u0007I\u0011AA\u0010\u0011)\tY\u0003\u0001B\u0001B\u0003%\u0011\u0011\u0005\u0005\u000b\u0003[\u0001!Q1A\u0005\u0002\u0005M\u0001BCA\u0018\u0001\t\u0005\t\u0015!\u0003\u0002\u0016!Q\u0011\u0011\u0007\u0001\u0003\u0006\u0004%\t!a\u0005\t\u0015\u0005M\u0002A!A!\u0002\u0013\t)\u0002\u0003\u0006\u00026\u0001\u0011)\u0019!C\u0001\u0003oA!Ba8\u0001\u0005\u0003\u0005\u000b\u0011BA\u001d\u0011)\u0011\t\u000f\u0001BC\u0002\u0013\u0005\u00111\n\u0005\u000b\u0005G\u0004!\u0011!Q\u0001\n\u00055\u0003B\u0003Bs\u0001\t\u0015\r\u0011\"\u0001\u0002 !Q!q\u001d\u0001\u0003\u0002\u0003\u0006I!!\t\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0003j\"9!Q \u0001\u0005\u0002\t}\b\"CB\u0014\u0001E\u0005I\u0011AB\u0015\u0011\u001d\u0019i\u0003\u0001C\u0005\u0007_Aqaa\u000e\u0001\t\u0013\u0019Id\u0002\u0005\u0002@MD\t!^A!\r\u001d\u00118\u000f#\u0001v\u0003\u0007Bq!!\u0012\u0018\t\u0003\t9\u0005C\u0005\u0002J]\u0011\r\u0011\"\u0001\u0002L!A\u00111K\f!\u0002\u0013\tiEB\u0005\u0002V]\u0001\n1%\t\u0002X\u001d9\u0011\u0011\\\f\t\u0002\u0006-daBA./!\u0005\u0015Q\f\u0005\b\u0003\u000bjB\u0011AA5\u0011%\ti'HA\u0001\n\u0003\ny\u0007C\u0005\u0002\u0002v\t\t\u0011\"\u0001\u0002L!I\u00111Q\u000f\u0002\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003#k\u0012\u0011!C!\u0003'C\u0011\"!)\u001e\u0003\u0003%\t!a)\t\u0013\u0005\u001dV$!A\u0005B\u0005%\u0006\"CAV;\u0005\u0005I\u0011IAW\u0011%\ty+HA\u0001\n\u0013\t\tlB\u0004\u0002\\^A\t)a0\u0007\u000f\u0005ev\u0003#!\u0002<\"9\u0011Q\t\u0015\u0005\u0002\u0005u\u0006\"CA7Q\u0005\u0005I\u0011IA8\u0011%\t\t\tKA\u0001\n\u0003\tY\u0005C\u0005\u0002\u0004\"\n\t\u0011\"\u0001\u0002B\"I\u0011\u0011\u0013\u0015\u0002\u0002\u0013\u0005\u00131\u0013\u0005\n\u0003CC\u0013\u0011!C\u0001\u0003\u000bD\u0011\"a*)\u0003\u0003%\t%!+\t\u0013\u0005-\u0006&!A\u0005B\u00055\u0006\"CAXQ\u0005\u0005I\u0011BAY\u000f\u001d\tin\u0006EA\u0003\u001f4q!!3\u0018\u0011\u0003\u000bY\rC\u0004\u0002FM\"\t!!4\t\u0013\u000554'!A\u0005B\u0005=\u0004\"CAAg\u0005\u0005I\u0011AA&\u0011%\t\u0019iMA\u0001\n\u0003\t\t\u000eC\u0005\u0002\u0012N\n\t\u0011\"\u0011\u0002\u0014\"I\u0011\u0011U\u001a\u0002\u0002\u0013\u0005\u0011Q\u001b\u0005\n\u0003O\u001b\u0014\u0011!C!\u0003SC\u0011\"a+4\u0003\u0003%\t%!,\t\u0013\u0005=6'!A\u0005\n\u0005E\u0006\"CAp/\t\u0007I\u0011AAq\u0011!\tyo\u0006Q\u0001\n\u0005\rhABAy/\u0011\t\u0019\u0010C\u0004\u0002F}\"\t!!>\t\u0013\u0005ex\b1A\u0005\u0002\u0005M\u0001\"CA~\u007f\u0001\u0007I\u0011AA\u007f\u0011!\u00119a\u0010Q!\n\u0005U\u0001b\u0003B\u0005\u007f\u0001\u0007\t\u0019!C\u0001\u0003\u0017B1Ba\u0003@\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u000e!Y!\u0011C A\u0002\u0003\u0005\u000b\u0015BA'\u0011-\u0011\u0019b\u0010a\u0001\u0002\u0004%\tA!\u0006\t\u0017\tuq\b1AA\u0002\u0013\u0005!q\u0004\u0005\f\u0005Gy\u0004\u0019!A!B\u0013\u00119\u0002C\u0006\u0003&}\u0002\r\u00111A\u0005\u0002\u0005-\u0003b\u0003B\u0014\u007f\u0001\u0007\t\u0019!C\u0001\u0005SA1B!\f@\u0001\u0004\u0005\t\u0015)\u0003\u0002N!Y!qF A\u0002\u0003\u0007I\u0011AA\u0010\u0011-\u0011\td\u0010a\u0001\u0002\u0004%\tAa\r\t\u0017\t]r\b1A\u0001B\u0003&\u0011\u0011\u0005\u0005\f\u0005sy\u0004\u0019!a\u0001\n\u0013\ty\u0002C\u0006\u0003<}\u0002\r\u00111A\u0005\n\tu\u0002b\u0003B!\u007f\u0001\u0007\t\u0011)Q\u0005\u0003CA1Ba\u0011@\u0001\u0004\u0005\r\u0011\"\u0003\u0002 !Y!QI A\u0002\u0003\u0007I\u0011\u0002B$\u0011-\u0011Ye\u0010a\u0001\u0002\u0003\u0006K!!\t\t\u0017\t5s\b1AA\u0002\u0013%\u0011q\u0004\u0005\f\u0005\u001fz\u0004\u0019!a\u0001\n\u0013\u0011\t\u0006C\u0006\u0003V}\u0002\r\u0011!Q!\n\u0005\u0005\u0002b\u0003B,\u007f\u0001\u0007\t\u0019!C\u0005\u00053B1Ba\u001a@\u0001\u0004\u0005\r\u0011\"\u0003\u0003j!Y!QN A\u0002\u0003\u0005\u000b\u0015\u0002B.\u0011-\u0011yg\u0010a\u0001\u0002\u0004%IA!\u0017\t\u0017\tEt\b1AA\u0002\u0013%!1\u000f\u0005\f\u0005oz\u0004\u0019!A!B\u0013\u0011Y\u0006C\u0006\u0003z}\u0002\r\u00111A\u0005\n\te\u0003b\u0003B>\u007f\u0001\u0007\t\u0019!C\u0005\u0005{B1B!!@\u0001\u0004\u0005\t\u0015)\u0003\u0003\\!9!1Q \u0005\n\t\u0015\u0005b\u0002BE\u007f\u0011\u0005!1\u0012\u0005\b\u0005?{D\u0011\u0001BQ\u0011\u001d\u00119k\u0010C\u0001\u0005SCqAa+@\t\u0003\u0011I\u0006C\u0004\u0003.~\"\t!a\b\t\u000f\t=v\b\"\u0001\u0002 !9!\u0011W \u0005\u0002\u0005}\u0001b\u0002BZ\u007f\u0011\u0005!\u0011\f\u0005\b\u0005k{D\u0011\u0001B-\u0011\u001d\u00119l\u0010C\u0001\u00053BqA!/@\t\u0003\u0011I\u0006C\u0005\u0003<^\t\n\u0011\"\u0001\u0003>\"I!1[\f\u0012\u0002\u0013\u0005!Q\u001b\u0005\n\u00053<\u0012\u0013!C\u0001\u00057D\u0011\"a,\u0018\u0003\u0003%I!!-\u0003)]+\u0017n\u001a5uK\u0012dU-Y:u'F,\u0018M]3t\u0015\t!X/A\u0003paRLWN\u0003\u0002wo\u0006\u0011Q\u000e\u001c\u0006\u0003qf\fQa\u001d9be.T!A_>\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0018aA8sON!\u0001A`A\u0005!\ry\u0018QA\u0007\u0003\u0003\u0003Q!!a\u0001\u0002\u000bM\u001c\u0017\r\\1\n\t\u0005\u001d\u0011\u0011\u0001\u0002\u0007\u0003:L(+\u001a4\u0011\u0007}\fY!\u0003\u0003\u0002\u000e\u0005\u0005!\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u00044ji&sG/\u001a:dKB$8\u0001A\u000b\u0003\u0003+\u00012a`A\f\u0013\u0011\tI\"!\u0001\u0003\u000f\t{w\u000e\\3b]\u0006ia-\u001b;J]R,'oY3qi\u0002\n\u0001B]3h!\u0006\u0014\u0018-\\\u000b\u0003\u0003C\u00012a`A\u0012\u0013\u0011\t)#!\u0001\u0003\r\u0011{WO\u00197f\u0003%\u0011Xm\u001a)be\u0006l\u0007%A\bfY\u0006\u001cH/[2OKR\u0004\u0016M]1n\u0003A)G.Y:uS\u000etU\r\u001e)be\u0006l\u0007%A\nti\u0006tG-\u0019:eSj,g)Z1ukJ,7/\u0001\u000bti\u0006tG-\u0019:eSj,g)Z1ukJ,7\u000fI\u0001\u0011gR\fg\u000eZ1sI&TX\rT1cK2\f\u0011c\u001d;b]\u0012\f'\u000fZ5{K2\u000b'-\u001a7!\u0003)\u0019x\u000e\u001c<feRK\b/Z\u000b\u0003\u0003s\u00012!a\u000f\u001c\u001d\r\tiDF\u0007\u0002g\u0006!r+Z5hQR,G\rT3bgR\u001c\u0016/^1sKN\u00042!!\u0010\u0018'\u00119b0!\u0003\u0002\rqJg.\u001b;?)\t\t\t%\u0001\tN\u0003b{f*V'`\r\u0016\u000bE+\u0016*F'V\u0011\u0011Q\n\t\u0004\u007f\u0006=\u0013\u0002BA)\u0003\u0003\u00111!\u00138u\u0003Ei\u0015\tW0O+6{f)R!U+J+5\u000b\t\u0002\u0007'>dg/\u001a:\u0014\u0005mq\u0018\u0006B\u000e\u001eQM\u0012A!Q;u_NAQD`A0\u0003G\nI\u0001E\u0002\u0002bmi\u0011a\u0006\t\u0004\u007f\u0006\u0015\u0014\u0002BA4\u0003\u0003\u0011q\u0001\u0015:pIV\u001cG\u000f\u0006\u0002\u0002lA\u0019\u0011\u0011M\u000f\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\t\b\u0005\u0003\u0002t\u0005uTBAA;\u0015\u0011\t9(!\u001f\u0002\t1\fgn\u001a\u0006\u0003\u0003w\nAA[1wC&!\u0011qPA;\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5us\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BAD\u0003\u001b\u00032a`AE\u0013\u0011\tY)!\u0001\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0010\u0006\n\t\u00111\u0001\u0002N\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!&\u0011\r\u0005]\u0015QTAD\u001b\t\tIJ\u0003\u0003\u0002\u001c\u0006\u0005\u0011AC2pY2,7\r^5p]&!\u0011qTAM\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005U\u0011Q\u0015\u0005\n\u0003\u001f\u001b\u0013\u0011!a\u0001\u0003\u000f\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003\u001b\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003c\n1B]3bIJ+7o\u001c7wKR\u0011\u00111\u0017\t\u0005\u0003g\n),\u0003\u0003\u00028\u0006U$AB(cU\u0016\u001cGO\u0001\u0005DQ>dWm]6z'!Ac0a\u0018\u0002d\u0005%ACAA`!\r\t\t\u0007\u000b\u000b\u0005\u0003\u000f\u000b\u0019\rC\u0005\u0002\u00102\n\t\u00111\u0001\u0002NQ!\u0011QCAd\u0011%\tyILA\u0001\u0002\u0004\t9IA\u0006Rk\u0006\u001c\u0018NT3xi>t7\u0003C\u001a\u007f\u0003?\n\u0019'!\u0003\u0015\u0005\u0005=\u0007cAA1gQ!\u0011qQAj\u0011%\tyiNA\u0001\u0002\u0004\ti\u0005\u0006\u0003\u0002\u0016\u0005]\u0007\"CAHs\u0005\u0005\t\u0019AAD\u0003\u0011\tU\u000f^8\u0002\u0011\rCw\u000e\\3tWf\f1\"U;bg&tUm\u001e;p]\u0006\u00012/\u001e9q_J$X\rZ*pYZ,'o]\u000b\u0003\u0003G\u0004Ra`As\u0003SLA!a:\u0002\u0002\t)\u0011I\u001d:bsJA\u00111^A2\u0003\u0013\tyF\u0002\u0004\u0002n^\u0001\u0011\u0011\u001e\u0002\ryI,g-\u001b8f[\u0016tGOP\u0001\u0012gV\u0004\bo\u001c:uK\u0012\u001cv\u000e\u001c<feN\u0004#AC!hOJ,w-\u0019;peN!qH`A\u0005)\t\t9\u0010E\u0002\u0002b}\n1\"\u001b8ji&\fG.\u001b>fI\u0006y\u0011N\\5uS\u0006d\u0017N_3e?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\n\u0015\u0001cA@\u0003\u0002%!!1AA\u0001\u0005\u0011)f.\u001b;\t\u0013\u0005=%)!AA\u0002\u0005U\u0011\u0001D5oSRL\u0017\r\\5{K\u0012\u0004\u0013!A6\u0002\u000b-|F%Z9\u0015\t\u0005}(q\u0002\u0005\n\u0003\u001f+\u0015\u0011!a\u0001\u0003\u001b\n!a\u001b\u0011\u0002\u000b\r|WO\u001c;\u0016\u0005\t]\u0001cA@\u0003\u001a%!!1DA\u0001\u0005\u0011auN\\4\u0002\u0013\r|WO\u001c;`I\u0015\fH\u0003BA\u0000\u0005CA\u0011\"a$I\u0003\u0003\u0005\rAa\u0006\u0002\r\r|WO\u001c;!\u0003\u0011!(/[&\u0002\u0011Q\u0014\u0018nS0%KF$B!a@\u0003,!I\u0011qR&\u0002\u0002\u0003\u0007\u0011QJ\u0001\u0006iJL7\nI\u0001\u0005oN+X.\u0001\u0005x'Vlw\fJ3r)\u0011\tyP!\u000e\t\u0013\u0005=e*!AA\u0002\u0005\u0005\u0012!B<Tk6\u0004\u0013!B<x'Vl\u0017!C<x'Vlw\fJ3r)\u0011\tyPa\u0010\t\u0013\u0005=\u0015+!AA\u0002\u0005\u0005\u0012AB<x'Vl\u0007%\u0001\u0003c'Vl\u0017\u0001\u00032Tk6|F%Z9\u0015\t\u0005}(\u0011\n\u0005\n\u0003\u001f#\u0016\u0011!a\u0001\u0003C\tQAY*v[\u0002\nQA\u00192Tk6\f\u0011B\u00192Tk6|F%Z9\u0015\t\u0005}(1\u000b\u0005\n\u0003\u001f;\u0016\u0011!a\u0001\u0003C\taA\u00192Tk6\u0004\u0013\u0001B1Tk6,\"Aa\u0017\u0011\t\tu#1M\u0007\u0003\u0005?R1A!\u0019v\u0003\u0019a\u0017N\\1mO&!!Q\rB0\u0005-!UM\\:f-\u0016\u001cGo\u001c:\u0002\u0011\u0005\u001cV/\\0%KF$B!a@\u0003l!I\u0011q\u0012.\u0002\u0002\u0003\u0007!1L\u0001\u0006CN+X\u000eI\u0001\u0006C\n\u001cV/\\\u0001\nC\n\u001cV/\\0%KF$B!a@\u0003v!I\u0011qR/\u0002\u0002\u0003\u0007!1L\u0001\u0007C\n\u001cV/\u001c\u0011\u0002\u000b\u0005\f7+^7\u0002\u0013\u0005\f7+^7`I\u0015\fH\u0003BA\u0000\u0005\u007fB\u0011\"a$a\u0003\u0003\u0005\rAa\u0017\u0002\r\u0005\f7+^7!\u0003\u0011Ig.\u001b;\u0015\t\u0005}(q\u0011\u0005\b\u0005\u0013\u0011\u0007\u0019AA'\u0003\r\tG\r\u001a\u000b\u0005\u0005\u001b\u0013y)D\u0001@\u0011\u001d\u0011\tj\u0019a\u0001\u0005'\u000b\u0001\"\u001b8ti\u0006t7-\u001a\t\u0005\u0005+\u0013Y*\u0004\u0002\u0003\u0018*\u0019!\u0011T;\u0002\u000f\u0019,\u0017\r^;sK&!!Q\u0014BL\u0005!Ien\u001d;b]\u000e,\u0017!B7fe\u001e,G\u0003\u0002BG\u0005GCqA!*e\u0001\u0004\t90A\u0003pi\",'/\u0001\u0005wC2LG-\u0019;f)\t\ty0\u0001\u0003b\u0005\u0006\u0014\u0018\u0001\u00022CCJ\fQA\u00192CCJ\fAAY*uI\u0006)\u0011M\u0019\"be\u0006)\u0011-\u0019\"be\u0006!\u0011m\u0015;e\u0003\u0011\tg+\u0019:\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011yL\u000b\u0003\u0002:\t\u00057F\u0001Bb!\u0011\u0011)Ma4\u000e\u0005\t\u001d'\u0002\u0002Be\u0005\u0017\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\t5\u0017\u0011A\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bi\u0005\u000f\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\u001b\u0016\u0005\u0003\u001b\u0012\t-A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005O\u000b\u0003\u0005;TC!!\t\u0003B\u0006Y1o\u001c7wKJ$\u0016\u0010]3!\u0003\u001di\u0017\r_%uKJ\f\u0001\"\\1y\u0013R,'\u000fI\u0001\u0004i>d\u0017\u0001\u0002;pY\u0002\"\"Ca;\u0003n\n=(\u0011\u001fBz\u0005k\u00149P!?\u0003|B\u0019\u0011Q\b\u0001\t\u000f\u0005=\u0011\u00031\u0001\u0002\u0016!9\u0011QD\tA\u0002\u0005\u0005\u0002bBA\u0015#\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003[\t\u0002\u0019AA\u000b\u0011\u001d\t\t$\u0005a\u0001\u0003+A\u0011\"!\u000e\u0012!\u0003\u0005\r!!\u000f\t\u0013\t\u0005\u0018\u0003%AA\u0002\u00055\u0003\"\u0003Bs#A\u0005\t\u0019AA\u0011\u0003\r1\u0017\u000e\u001e\u000b\u0007\u0007\u0003\u00199aa\u0006\u0011\t\u0005u21A\u0005\u0004\u0007\u000b\u0019(!G,fS\u001eDG/\u001a3MK\u0006\u001cHoU9vCJ,7/T8eK2Dqa!\u0003\u0013\u0001\u0004\u0019Y!A\u0005j]N$\u0018M\\2fgB11QBB\n\u0005'k!aa\u0004\u000b\u0007\rEq/A\u0002sI\u0012LAa!\u0006\u0004\u0010\t\u0019!\u000b\u0012#\t\u0013\re!\u0003%AA\u0002\rm\u0011!B5ogR\u0014\b\u0003BB\u000f\u0007Gi!aa\b\u000b\u0007\r\u0005R/\u0001\u0003vi&d\u0017\u0002BB\u0013\u0007?\u0011qc\u00149uS>t\u0017\r\\%ogR\u0014X/\\3oi\u0006$\u0018n\u001c8\u0002\u001b\u0019LG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0019YC\u000b\u0003\u0004\u001c\t\u0005\u0017AB4fi\u0006#\u0018\t\u0006\u0004\u0003\\\rE2Q\u0007\u0005\b\u0005k#\u0002\u0019AB\u001a!\u0015y\u0018Q]A\u0011\u0011\u001d\u0011Y\u000b\u0006a\u0001\u0007g\taaZ3u\u0003R\u0014EC\u0002B.\u0007w\u0019i\u0004C\u0004\u00034V\u0001\raa\r\t\u000f\t5V\u00031\u0001\u0002\"\u0001")
public class WeightedLeastSquares
implements scala.Serializable {
    private final boolean fitIntercept;
    private final double regParam;
    private final double elasticNetParam;
    private final boolean standardizeFeatures;
    private final boolean standardizeLabel;
    private final Solver solverType;
    private final int maxIter;
    private final double tol;

    public static double $lessinit$greater$default$8() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$8();
    }

    public static int $lessinit$greater$default$7() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$7();
    }

    public static Solver $lessinit$greater$default$6() {
        return WeightedLeastSquares$.MODULE$.$lessinit$greater$default$6();
    }

    public static Product[] supportedSolvers() {
        return WeightedLeastSquares$.MODULE$.supportedSolvers();
    }

    public static int MAX_NUM_FEATURES() {
        return WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES();
    }

    public boolean fitIntercept() {
        return this.fitIntercept;
    }

    public double regParam() {
        return this.regParam;
    }

    public double elasticNetParam() {
        return this.elasticNetParam;
    }

    public boolean standardizeFeatures() {
        return this.standardizeFeatures;
    }

    public boolean standardizeLabel() {
        return this.standardizeLabel;
    }

    public Solver solverType() {
        return this.solverType;
    }

    public int maxIter() {
        return this.maxIter;
    }

    public double tol() {
        return this.tol;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public WeightedLeastSquaresModel fit(RDD<Instance> instances, OptionalInstrumentation instr) {
        block31: {
            block28: {
                block27: {
                    if (this.regParam() == 0.0) {
                        instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$1(), ()Ljava/lang/String;)());
                    }
                    x$1 = new Aggregator();
                    x$2 = (Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$2(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator org.apache.spark.ml.feature.Instance ), (Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;Lorg/apache/spark/ml/feature/Instance;)Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)();
                    x$3 = (Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$3(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator ), (Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)Lorg/apache/spark/ml/optim/WeightedLeastSquares$Aggregator;)();
                    x$4 = instances.treeAggregate$default$4((Object)x$1);
                    summary = (Aggregator)instances.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(Aggregator.class));
                    summary.validate();
                    instr.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$4(org.apache.spark.ml.optim.WeightedLeastSquares$Aggregator ), ()Ljava/lang/String;)((Aggregator)summary));
                    k = this.fitIntercept() != false ? summary.k() + 1 : summary.k();
                    numFeatures = summary.k();
                    triK = summary.triK();
                    wSum = summary.wSum();
                    rawBStd = summary.bStd();
                    rawBBar = summary.bBar();
                    v0 = bStd = rawBStd == 0.0 ? package$.MODULE$.abs(rawBBar) : rawBStd;
                    if (rawBStd == (double)false) {
                        if (this.fitIntercept() || rawBBar == 0.0) {
                            if (rawBBar == 0.0) {
                                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$5(), ()Ljava/lang/String;)());
                            } else {
                                instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$6(), ()Ljava/lang/String;)());
                            }
                            coefficients = new DenseVector((double[])Array$.MODULE$.ofDim(numFeatures, ClassTag$.MODULE$.Double()));
                            intercept = rawBBar;
                            diagInvAtWA = new DenseVector(new double[]{0.0});
                            return new WeightedLeastSquaresModel(coefficients, intercept, diagInvAtWA, new double[]{0.0});
                        }
                        Predef$.MODULE$.require(!(this.regParam() > 0.0) || this.standardizeLabel() == false, (Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$7(), ()Ljava/lang/String;)());
                        instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$8(), ()Ljava/lang/String;)());
                    }
                    bBar = summary.bBar() / bStd;
                    bbBar = summary.bbBar() / (bStd * bStd);
                    aStd = summary.aStd();
                    aStdValues = aStd.values();
                    _aBar = summary.aBar();
                    _aBarValues = _aBar.values();
                    for (i = 0; i < numFeatures; ++i) {
                        if (aStdValues[i] == 0.0) {
                            _aBarValues[i] = 0.0;
                            continue;
                        }
                        var36_25 = i;
                        _aBarValues[var36_25] = _aBarValues[var36_25] / aStdValues[i];
                    }
                    aBar = _aBar;
                    aBarValues = aBar.values();
                    _abBar = summary.abBar();
                    _abBarValues = _abBar.values();
                    for (i = 0; i < numFeatures; ++i) {
                        if (aStdValues[i] == 0.0) {
                            _abBarValues[i] = 0.0;
                            continue;
                        }
                        var42_31 = i;
                        _abBarValues[var42_31] = _abBarValues[var42_31] / (aStdValues[i] * bStd);
                    }
                    abBar = _abBar;
                    abBarValues = abBar.values();
                    _aaBar = summary.aaBar();
                    _aaBarValues = _aaBar.values();
                    p = 0;
                    for (j = 0; j < numFeatures; ++j) {
                        aStdJ = aStdValues[j];
                        for (i = 0; i <= j; ++i) {
                            aStdI = aStdValues[i];
                            if (aStdJ == 0.0 || aStdI == 0.0) {
                                _aaBarValues[p] = 0.0;
                            } else {
                                var54_41 = p;
                                _aaBarValues[var54_41] = _aaBarValues[var54_41] / (aStdI * aStdJ);
                            }
                            ++p;
                        }
                    }
                    aaBar = _aaBar;
                    aaBarValues = aaBar.values();
                    effectiveRegParam = this.regParam() / bStd;
                    effectiveL1RegParam = this.elasticNetParam() * effectiveRegParam;
                    effectiveL2RegParam = (1.0 - this.elasticNetParam()) * effectiveRegParam;
                    i = 0;
                    j = 2;
                    while (i < triK) {
                        lambda = effectiveL2RegParam;
                        if (!this.standardizeFeatures()) {
                            std = aStdValues[j - 2];
                            lambda = std != 0.0 ? (lambda /= std * std) : 0.0;
                        }
                        if (!this.standardizeLabel()) {
                            lambda *= bStd;
                        }
                        var68_51 = i;
                        aaBarValues[var68_51] = aaBarValues[var68_51] + lambda;
                        i += j;
                        ++j;
                    }
                    aa = this.getAtA(aaBarValues, aBarValues);
                    ab = this.getAtB(abBarValues, bBar);
                    v1 = this.solverType();
                    var72_54 = WeightedLeastSquares$Auto$.MODULE$;
                    if (v1 != null ? v1.equals(var72_54) == false : var72_54 != null) break block27;
                    if (this.elasticNetParam() != 0.0 && this.regParam() != 0.0) ** GOTO lbl-1000
                }
                v2 = this.solverType();
                var73_55 = WeightedLeastSquares$QuasiNewton$.MODULE$;
                if (!(v2 != null ? v2.equals(var73_55) == false : var73_55 != null)) lbl-1000:
                // 2 sources

                {
                    effectiveL1RegFun = effectiveL1RegParam != 0.0 ? new Some((Object)(JFunction1.mcDI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (I)D, $anonfun$fit$9(org.apache.spark.ml.optim.WeightedLeastSquares int double double[] int ), (I)D)((WeightedLeastSquares)this, (int)numFeatures, (double)effectiveL1RegParam, (double[])aStdValues)) : None$.MODULE$;
                    v3 /* !! */  = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)effectiveL1RegFun);
                } else {
                    v3 /* !! */  = new CholeskySolver();
                }
                var76_58 = solver = v3 /* !! */ ;
                if (!(var76_58 instanceof CholeskySolver)) break block28;
                var77_59 = var76_58;
                try {
                    v4 = var77_59.solve(bBar, bbBar, ab, aa, aBar);
                }
                catch (Throwable var78_60) {
                    block30: {
                        block29: {
                            var79_61 = var78_60;
                            if (!(var79_61 instanceof SingularMatrixException)) break block29;
                            v5 = this.solverType();
                            var80_62 = WeightedLeastSquares$Auto$.MODULE$;
                            if (!(v5 != null ? v5.equals(var80_62) == false : var80_62 != null)) break block30;
                        }
                        throw var78_60;
                    }
                    instr.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$10(), ()Ljava/lang/String;)());
                    _aa = this.getAtA(aaBarValues, aBarValues);
                    _ab = this.getAtB(abBarValues, bBar);
                    newSolver = new QuasiNewtonSolver(this.fitIntercept(), this.maxIter(), this.tol(), (Option<Function1<Object, Object>>)None$.MODULE$);
                    var5_66 = newSolver.solve(bBar, bbBar, _ab, _aa, aBar);
                    v4 = var5_66;
                }
                var4_67 = v4;
                break block31;
            }
            if (var76_58 instanceof QuasiNewtonSolver) {
                var84_68 = (QuasiNewtonSolver)var76_58;
                var4_67 = var84_68.solve(bBar, bbBar, ab, aa, aBar);
            } else {
                throw new MatchError((Object)var76_58);
            }
        }
        solution = var4_67;
        v6 = var86_70 = this.fitIntercept() != false ? new Tuple2(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(solution.coefficients())).slice(0, solution.coefficients().length - 1), (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(solution.coefficients())).last()) * bStd))) : new Tuple2((Object)solution.coefficients(), (Object)BoxesRunTime.boxToDouble((double)0.0));
        if (var86_70 == null) {
            throw new MatchError((Object)var86_70);
        }
        coefficientArray = (double[])var86_70._1();
        intercept = var86_70._2$mcD$sp();
        var3_73 = new Tuple2((Object)coefficientArray, (Object)BoxesRunTime.boxToDouble((double)intercept));
        var85_74 = var3_73;
        coefficientArray = (double[])var85_74._1();
        intercept = var85_74._2$mcD$sp();
        len = coefficientArray.length;
        for (q = 0; q < len; ++q) {
            var95_79 = q;
            coefficientArray[var95_79] = coefficientArray[var95_79] * (aStdValues[q] != 0.0 ? bStd / aStdValues[q] : 0.0);
        }
        diagInvAtWA = (DenseVector)solution.aaInv().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$fit$11(org.apache.spark.ml.optim.WeightedLeastSquares int double[] double double[] ), ([D)Lorg/apache/spark/ml/linalg/DenseVector;)((WeightedLeastSquares)this, (int)k, (double[])aStdValues, (double)wSum)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$13(), ()Lorg/apache/spark/ml/linalg/DenseVector;)());
        return new WeightedLeastSquaresModel(new DenseVector(coefficientArray), intercept, diagInvAtWA, (double[])solution.objectiveHistory().getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$fit$14(), ()[D)()));
    }

    public OptionalInstrumentation fit$default$2() {
        return OptionalInstrumentation$.MODULE$.create(WeightedLeastSquares.class);
    }

    private DenseVector getAtA(double[] aaBar, double[] aBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{aaBar, aBar, {1.0}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])aaBar.clone());
    }

    private DenseVector getAtB(double[] abBar, double bBar) {
        return this.fitIntercept() ? new DenseVector((double[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new double[][]{abBar, {bBar}}), ClassTag$.MODULE$.Double())) : new DenseVector((double[])abBar.clone());
    }

    public static final /* synthetic */ String $anonfun$fit$1() {
        return "regParam is zero, which might cause numerical instability and overfitting.";
    }

    public static final /* synthetic */ Aggregator $anonfun$fit$2(Aggregator x$1, Instance x$2) {
        return x$1.add(x$2);
    }

    public static final /* synthetic */ Aggregator $anonfun$fit$3(Aggregator x$3, Aggregator x$4) {
        return x$3.merge(x$4);
    }

    public static final /* synthetic */ String $anonfun$fit$4(Aggregator summary$1) {
        return new StringBuilder(22).append("Number of instances: ").append(summary$1.count()).append(".").toString();
    }

    public static final /* synthetic */ String $anonfun$fit$5() {
        return new StringBuilder(143).append("Mean and standard deviation of the label are zero, so the ").append("coefficients and the intercept will all be zero; as a result, training is not ").append("needed.").toString();
    }

    public static final /* synthetic */ String $anonfun$fit$6() {
        return new StringBuilder(164).append("The standard deviation of the label is zero, so the coefficients ").append("will be zeros and the intercept will be the mean of the label; as a result, ").append("training is not needed.").toString();
    }

    public static final /* synthetic */ String $anonfun$fit$7() {
        return "The standard deviation of the label is zero. Model cannot be regularized with standardization=true";
    }

    public static final /* synthetic */ String $anonfun$fit$8() {
        return new StringBuilder(80).append("The standard deviation of the label is zero. Consider setting ").append("fitIntercept=true.").toString();
    }

    public static final /* synthetic */ double $anonfun$fit$9(WeightedLeastSquares $this, int numFeatures$1, double effectiveL1RegParam$1, double[] aStdValues$1, int index) {
        return $this.fitIntercept() && index == numFeatures$1 ? 0.0 : ($this.standardizeFeatures() ? effectiveL1RegParam$1 : (aStdValues$1[index] != 0.0 ? effectiveL1RegParam$1 / aStdValues$1[index] : 0.0));
    }

    public static final /* synthetic */ String $anonfun$fit$10() {
        return "Cholesky solver failed due to singular covariance matrix. Retrying with Quasi-Newton solver.";
    }

    public static final /* synthetic */ DenseVector $anonfun$fit$11(WeightedLeastSquares $this, int k$1, double[] aStdValues$1, double wSum$1, double[] inv) {
        return new DenseVector((double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), k$1).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> {
            double multiplier = i == k$1 && $this.fitIntercept() ? 1.0 : aStdValues$1[i - 1] * aStdValues$1[i - 1];
            return inv[i + (i - 1) * i / 2 - 1] / (wSum$1 * multiplier);
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ DenseVector $anonfun$fit$13() {
        return new DenseVector(new double[]{0.0});
    }

    public static final /* synthetic */ double[] $anonfun$fit$14() {
        return new double[]{0.0};
    }

    public WeightedLeastSquares(boolean fitIntercept, double regParam, double elasticNetParam, boolean standardizeFeatures, boolean standardizeLabel, Solver solverType, int maxIter, double tol) {
        this.fitIntercept = fitIntercept;
        this.regParam = regParam;
        this.elasticNetParam = elasticNetParam;
        this.standardizeFeatures = standardizeFeatures;
        this.standardizeLabel = standardizeLabel;
        this.solverType = solverType;
        this.maxIter = maxIter;
        this.tol = tol;
        Predef$.MODULE$.require(regParam >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("regParam cannot be negative: ").append(this.regParam()).toString());
        Predef$.MODULE$.require(elasticNetParam >= 0.0 && elasticNetParam <= 1.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("elasticNetParam must be in [0, 1]: ").append(this.elasticNetParam()).toString());
        Predef$.MODULE$.require(maxIter >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("maxIter must be a positive integer: ").append(this.maxIter()).toString());
        Predef$.MODULE$.require(tol >= 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("tol must be >= 0, but was set to ").append(this.tol()).toString());
    }

    public static class Aggregator
    implements scala.Serializable {
        private boolean initialized = false;
        private int k;
        private long count;
        private int triK;
        private double wSum;
        private double wwSum;
        private double bSum;
        private double bbSum;
        private DenseVector aSum;
        private DenseVector abSum;
        private DenseVector aaSum;

        public boolean initialized() {
            return this.initialized;
        }

        public void initialized_$eq(boolean x$1) {
            this.initialized = x$1;
        }

        public int k() {
            return this.k;
        }

        public void k_$eq(int x$1) {
            this.k = x$1;
        }

        public long count() {
            return this.count;
        }

        public void count_$eq(long x$1) {
            this.count = x$1;
        }

        public int triK() {
            return this.triK;
        }

        public void triK_$eq(int x$1) {
            this.triK = x$1;
        }

        public double wSum() {
            return this.wSum;
        }

        public void wSum_$eq(double x$1) {
            this.wSum = x$1;
        }

        private double wwSum() {
            return this.wwSum;
        }

        private void wwSum_$eq(double x$1) {
            this.wwSum = x$1;
        }

        private double bSum() {
            return this.bSum;
        }

        private void bSum_$eq(double x$1) {
            this.bSum = x$1;
        }

        private double bbSum() {
            return this.bbSum;
        }

        private void bbSum_$eq(double x$1) {
            this.bbSum = x$1;
        }

        private DenseVector aSum() {
            return this.aSum;
        }

        private void aSum_$eq(DenseVector x$1) {
            this.aSum = x$1;
        }

        private DenseVector abSum() {
            return this.abSum;
        }

        private void abSum_$eq(DenseVector x$1) {
            this.abSum = x$1;
        }

        private DenseVector aaSum() {
            return this.aaSum;
        }

        private void aaSum_$eq(DenseVector x$1) {
            this.aaSum = x$1;
        }

        private void init(int k) {
            Predef$.MODULE$.require(k <= WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("In order to take the normal equation approach efficiently, ").append(new StringBuilder(47).append("we set the max number of features to ").append(WeightedLeastSquares$.MODULE$.MAX_NUM_FEATURES()).append(" but got ").append(k).append(".").toString()).toString());
            this.k_$eq(k);
            this.triK_$eq(k * (k + 1) / 2);
            this.count_$eq(0L);
            this.wSum_$eq(0.0);
            this.wwSum_$eq(0.0);
            this.bSum_$eq(0.0);
            this.bbSum_$eq(0.0);
            this.aSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.abSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(k, ClassTag$.MODULE$.Double())));
            this.aaSum_$eq(new DenseVector((double[])Array$.MODULE$.ofDim(this.triK(), ClassTag$.MODULE$.Double())));
            this.initialized_$eq(true);
        }

        public Aggregator add(Instance instance) {
            Instance instance2 = instance;
            if (instance2 == null) {
                throw new MatchError((Object)instance2);
            }
            double l = instance2.label();
            double w = instance2.weight();
            Vector f = instance2.features();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)l), (Object)BoxesRunTime.boxToDouble((double)w), (Object)f);
            Tuple3 tuple32 = tuple3;
            double l2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            double w2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            Vector f2 = (Vector)tuple32._3();
            int ak = f2.size();
            if (!this.initialized()) {
                this.init(ak);
            }
            Predef$.MODULE$.assert(ak == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Dimension mismatch. Expect vectors of size ").append(this.k()).append(" but got ").append(ak).append(".").toString());
            this.count_$eq(this.count() + 1L);
            this.wSum_$eq(this.wSum() + w2);
            this.wwSum_$eq(this.wwSum() + w2 * w2);
            this.bSum_$eq(this.bSum() + w2 * l2);
            this.bbSum_$eq(this.bbSum() + w2 * l2 * l2);
            BLAS$.MODULE$.axpy(w2, f2, (Vector)this.aSum());
            BLAS$.MODULE$.axpy(w2 * l2, f2, (Vector)this.abSum());
            BLAS$.MODULE$.spr(w2, f2, this.aaSum());
            return this;
        }

        public Aggregator merge(Aggregator other) {
            Aggregator aggregator;
            if (!other.initialized()) {
                aggregator = this;
            } else {
                if (!this.initialized()) {
                    this.init(other.k());
                }
                Predef$.MODULE$.assert(this.k() == other.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("dimension mismatch: this.k = ").append(this.k()).append(" but other.k = ").append(other.k()).toString());
                this.count_$eq(this.count() + other.count());
                this.wSum_$eq(this.wSum() + other.wSum());
                this.wwSum_$eq(this.wwSum() + other.wwSum());
                this.bSum_$eq(this.bSum() + other.bSum());
                this.bbSum_$eq(this.bbSum() + other.bbSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aSum(), (Vector)this.aSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.abSum(), (Vector)this.abSum());
                BLAS$.MODULE$.axpy(1.0, (Vector)other.aaSum(), (Vector)this.aaSum());
                aggregator = this;
            }
            return aggregator;
        }

        public void validate() {
            Predef$.MODULE$.assert(this.initialized(), (Function0 & Serializable & scala.Serializable)() -> "Training dataset is empty.");
            Predef$.MODULE$.assert(this.wSum() > 0.0, (Function0 & Serializable & scala.Serializable)() -> "Sum of weights cannot be zero.");
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aBar() {
            void var1_1;
            DenseVector output = this.aSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public double bBar() {
            return this.bSum() / this.wSum();
        }

        public double bbBar() {
            return this.bbSum() / this.wSum();
        }

        public double bStd() {
            double variance = package$.MODULE$.max(this.bbSum() / this.wSum() - this.bBar() * this.bBar(), 0.0);
            return package$.MODULE$.sqrt(variance);
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector abBar() {
            void var1_1;
            DenseVector output = this.abSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public DenseVector aaBar() {
            void var1_1;
            DenseVector output = this.aaSum().copy();
            BLAS$.MODULE$.scal(1.0 / this.wSum(), (Vector)output);
            return var1_1;
        }

        public DenseVector aStd() {
            double[] std = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                std[l] = package$.MODULE$.sqrt(package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0));
                i += j;
                ++j;
            }
            return new DenseVector(std);
        }

        public DenseVector aVar() {
            double[] variance = (double[])Array$.MODULE$.ofDim(this.k(), ClassTag$.MODULE$.Double());
            int i = 0;
            int j = 2;
            double[] aaValues = this.aaSum().values();
            while (i < this.triK()) {
                int l = j - 2;
                double aw = this.aSum().apply(l) / this.wSum();
                variance[l] = package$.MODULE$.max(aaValues[i] / this.wSum() - aw * aw, 0.0);
                i += j;
                ++j;
            }
            return new DenseVector(variance);
        }
    }

    public static interface Solver {
    }
}

