/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.tree.CategoricalSplit;
import org.apache.spark.ml.tree.ContinuousSplit;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.LearningNode;
import org.apache.spark.ml.tree.LearningNode$;
import org.apache.spark.ml.tree.Split;
import org.apache.spark.ml.tree.impl.BaggedPoint;
import org.apache.spark.ml.tree.impl.BaggedPoint$;
import org.apache.spark.ml.tree.impl.DTStatsAggregator;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata;
import org.apache.spark.ml.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.ml.tree.impl.NodeIdCache;
import org.apache.spark.ml.tree.impl.NodeIdCache$;
import org.apache.spark.ml.tree.impl.NodeIndexUpdater;
import org.apache.spark.ml.tree.impl.RandomForest;
import org.apache.spark.ml.tree.impl.TimeTracker;
import org.apache.spark.ml.tree.impl.TreePoint;
import org.apache.spark.ml.tree.impl.TreePoint$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.ImpurityCalculator;
import org.apache.spark.mllib.tree.model.ImpurityStats;
import org.apache.spark.mllib.tree.model.ImpurityStats$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.random.SamplingUtils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ArrayStack;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.IndexedSeqView$;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

public final class RandomForest$
implements Logging,
scala.Serializable {
    public static RandomForest$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new RandomForest$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public DecisionTreeModel[] run(RDD<LabeledPoint> input, Strategy strategy, int numTrees, String featureSubsetStrategy, long seed, Option<Instrumentation> instr, boolean prune, Option<String> parentUID) {
        DecisionTreeModel[] decisionTreeModelArray;
        BoxedUnit boxedUnit;
        TimeTracker timer = new TimeTracker();
        timer.start("total");
        timer.start("init");
        RDD retaggedInput = input.retag(LabeledPoint.class);
        DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata((RDD<LabeledPoint>)retaggedInput, strategy, numTrees, featureSubsetStrategy);
        Option<Instrumentation> option = instr;
        if (option instanceof Some) {
            Some some = (Some)option;
            Instrumentation instrumentation = (Instrumentation)some.value();
            instrumentation.logNumFeatures(metadata.numFeatures());
            instrumentation.logNumClasses(metadata.numClasses());
            instrumentation.logNumExamples(metadata.numExamples());
            boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("numFeatures: ").append(metadata.numFeatures()).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("numClasses: ").append(metadata.numClasses()).toString());
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("numExamples: ").append(metadata.numExamples()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        timer.start("findSplits");
        Split[][] splits = this.findSplits((RDD<LabeledPoint>)retaggedInput, metadata, seed);
        timer.stop("findSplits");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "numBins: feature: number of bins");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> ((TraversableOnce)scala.package$.MODULE$.Range().apply(0, metadata.numFeatures()).map((Function1 & Serializable & scala.Serializable)featureIndex -> RandomForest$.$anonfun$run$6(metadata, BoxesRunTime.unboxToInt((Object)featureIndex)), IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n"));
        RDD<TreePoint> treeInput = TreePoint$.MODULE$.convertToTreeRDD((RDD<LabeledPoint>)retaggedInput, splits, metadata);
        boolean withReplacement = numTrees > 1;
        RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, strategy.subsamplingRate(), numTrees, withReplacement, seed).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        int maxDepth = strategy.maxDepth();
        Predef$.MODULE$.require(maxDepth <= 30, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(79).append("DecisionTree currently only supports maxDepth <= 30, but was given maxDepth = ").append(maxDepth).append(".").toString());
        long maxMemoryUsage = (long)strategy.maxMemoryInMB() * 1024L * 1024L;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("max memory usage for aggregates = ").append(maxMemoryUsage).append(" bytes.").toString());
        None$ nodeIdCache = strategy.useNodeIdCache() ? new Some((Object)NodeIdCache$.MODULE$.init((RDD<BaggedPoint<TreePoint>>)baggedInput, numTrees, strategy.checkpointInterval(), 1)) : None$.MODULE$;
        ArrayStack nodeStack = new ArrayStack();
        Random rng = new Random();
        rng.setSeed(seed);
        LearningNode[] topNodes = (LearningNode[])Array$.MODULE$.fill(numTrees, (Function0 & Serializable & scala.Serializable)() -> LearningNode$.MODULE$.emptyNode(1), ClassTag$.MODULE$.apply(LearningNode.class));
        scala.package$.MODULE$.Range().apply(0, numTrees).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)treeIndex -> nodeStack.push((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)topNodes[treeIndex])));
        timer.stop("init");
        while (nodeStack.nonEmpty()) {
            Tuple2<scala.collection.immutable.Map<Object, LearningNode[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>> tuple2 = this.selectNodesToSplit((ArrayStack<Tuple2<Object, LearningNode>>)nodeStack, maxMemoryUsage, metadata, rng);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            scala.collection.immutable.Map nodesForGroup = (scala.collection.immutable.Map)tuple2._1();
            scala.collection.immutable.Map treeToNodeToIndexInfo = (scala.collection.immutable.Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
            Tuple2 tuple23 = tuple22;
            scala.collection.immutable.Map nodesForGroup2 = (scala.collection.immutable.Map)tuple23._1();
            scala.collection.immutable.Map treeToNodeToIndexInfo2 = (scala.collection.immutable.Map)tuple23._2();
            Predef$.MODULE$.assert(nodesForGroup2.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "RandomForest selected empty nodesForGroup.  Error for unknown reason.");
            scala.collection.immutable.Map topNodesForGroup = ((TraversableOnce)nodesForGroup2.keys().map((Function1 & Serializable & scala.Serializable)treeIdx -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)treeIdx))), (Object)topNodes[BoxesRunTime.unboxToInt((Object)treeIdx)]), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            timer.start("findBestSplits");
            this.findBestSplits((RDD<BaggedPoint<TreePoint>>)baggedInput, metadata, (scala.collection.immutable.Map<Object, LearningNode>)topNodesForGroup, (scala.collection.immutable.Map<Object, LearningNode[]>)nodesForGroup2, (scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>)treeToNodeToIndexInfo2, splits, (ArrayStack<Tuple2<Object, LearningNode>>)nodeStack, timer, (Option<NodeIdCache>)nodeIdCache);
            timer.stop("findBestSplits");
        }
        baggedInput.unpersist(baggedInput.unpersist$default$1());
        timer.stop("total");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Internal timing for DecisionTree:");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> String.valueOf(timer));
        if (nodeIdCache.nonEmpty()) {
            try {
                ((NodeIdCache)nodeIdCache.get()).deleteAllCheckpoints();
            }
            catch (IOException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("delete all checkpoints failed. Error reason: ").append(e.getMessage()).toString());
            }
        }
        int numFeatures = metadata.numFeatures();
        Option<String> option2 = parentUID;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String uid = (String)some.value();
            Enumeration.Value value = strategy.algo();
            Enumeration.Value value2 = Algo$.MODULE$.Classification();
            decisionTreeModelArray = !(value != null ? !value.equals(value2) : value2 != null) ? (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topNodes)).map((Function1 & Serializable & scala.Serializable)rootNode -> new DecisionTreeClassificationModel(uid, rootNode.toNode(prune), numFeatures, strategy.getNumClasses()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))) : (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topNodes)).map((Function1 & Serializable & scala.Serializable)rootNode -> new DecisionTreeRegressionModel(uid, rootNode.toNode(prune), numFeatures), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
        } else if (None$.MODULE$.equals(option2)) {
            Enumeration.Value value = strategy.algo();
            Enumeration.Value value3 = Algo$.MODULE$.Classification();
            decisionTreeModelArray = !(value != null ? !value.equals(value3) : value3 != null) ? (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topNodes)).map((Function1 & Serializable & scala.Serializable)rootNode -> new DecisionTreeClassificationModel(rootNode.toNode(prune), numFeatures, strategy.getNumClasses()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class))) : (DecisionTreeModel[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])topNodes)).map((Function1 & Serializable & scala.Serializable)rootNode -> new DecisionTreeRegressionModel(rootNode.toNode(prune), numFeatures), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
        } else {
            throw new MatchError(option2);
        }
        return decisionTreeModelArray;
    }

    public boolean run$default$7() {
        return true;
    }

    public Option<String> run$default$8() {
        return None$.MODULE$;
    }

    private void mixedBinSeqOp(DTStatsAggregator agg, TreePoint treePoint, Split[][] splits, Set<Object> unorderedFeatures, double instanceWeight, Option<int[]> featuresForNode) {
        int numFeaturesPerNode = featuresForNode.nonEmpty() ? ((int[])featuresForNode.get()).length : agg.metadata().numFeatures();
        for (int featureIndexIdx = 0; featureIndexIdx < numFeaturesPerNode; ++featureIndexIdx) {
            int featureIndex;
            int n = featureIndex = featuresForNode.nonEmpty() ? ((int[])featuresForNode.get())[featureIndexIdx] : featureIndexIdx;
            if (unorderedFeatures.contains((Object)BoxesRunTime.boxToInteger((int)featureIndex))) {
                int featureValue = treePoint.binnedFeatures()[featureIndex];
                int leftNodeFeatureOffset = agg.getFeatureOffset(featureIndexIdx);
                int numSplits = agg.metadata().numSplits(featureIndex);
                Split[] featureSplits = splits[featureIndex];
                for (int splitIndex = 0; splitIndex < numSplits; ++splitIndex) {
                    if (!featureSplits[splitIndex].shouldGoLeft(featureValue, featureSplits)) continue;
                    agg.featureUpdate(leftNodeFeatureOffset, splitIndex, treePoint.label(), instanceWeight);
                }
                continue;
            }
            int binIndex = treePoint.binnedFeatures()[featureIndex];
            agg.update(featureIndexIdx, binIndex, treePoint.label(), instanceWeight);
        }
    }

    private void orderedBinSeqOp(DTStatsAggregator agg, TreePoint treePoint, double instanceWeight, Option<int[]> featuresForNode) {
        double label = treePoint.label();
        if (featuresForNode.nonEmpty()) {
            for (int featureIndexIdx = 0; featureIndexIdx < ((int[])featuresForNode.get()).length; ++featureIndexIdx) {
                int binIndex = treePoint.binnedFeatures()[((int[])featuresForNode.get())[featureIndexIdx]];
                agg.update(featureIndexIdx, binIndex, label, instanceWeight);
            }
        } else {
            int numFeatures = agg.metadata().numFeatures();
            for (int featureIndex = 0; featureIndex < numFeatures; ++featureIndex) {
                int binIndex = treePoint.binnedFeatures()[featureIndex];
                agg.update(featureIndex, binIndex, label, instanceWeight);
            }
        }
    }

    public void findBestSplits(RDD<BaggedPoint<TreePoint>> input, DecisionTreeMetadata metadata, scala.collection.immutable.Map<Object, LearningNode> topNodesForGroup, scala.collection.immutable.Map<Object, LearningNode[]> nodesForGroup, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>> treeToNodeToIndexInfo, Split[][] splits, ArrayStack<Tuple2<Object, LearningNode>> nodeStack, TimeTracker timer, Option<NodeIdCache> nodeIdCache) {
        block2: {
            RDD rDD;
            int numNodes = BoxesRunTime.unboxToInt((Object)((TraversableOnce)nodesForGroup.values().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)RandomForest$.$anonfun$findBestSplits$1(x$2)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("numNodes = ").append(numNodes).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("numFeatures = ").append(metadata.numFeatures()).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("numClasses = ").append(metadata.numClasses()).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("isMulticlass = ").append(metadata.isMulticlass()).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("isMulticlassWithCategoricalFeatures = ").append(metadata.isMulticlassWithCategoricalFeatures()).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("using nodeIdCache = ").append(((Object)BoxesRunTime.boxToBoolean((boolean)nodeIdCache.nonEmpty())).toString()).toString());
            LearningNode[] nodes = new LearningNode[numNodes];
            nodesForGroup.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                RandomForest$.$anonfun$findBestSplits$14(nodes, treeToNodeToIndexInfo, x0$1);
                return BoxedUnit.UNIT;
            });
            timer.start("chooseSplits");
            Option nodeToFeatures = RandomForest$.getNodeToFeatures$1(treeToNodeToIndexInfo, metadata);
            Broadcast nodeToFeaturesBc = input.sparkContext().broadcast((Object)nodeToFeatures, ClassTag$.MODULE$.apply(Option.class));
            if (nodeIdCache.nonEmpty()) {
                RDD qual$1 = input.zip(((NodeIdCache)nodeIdCache.get()).nodeIdsForInstances(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Integer.TYPE)));
                Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)points -> {
                    DTStatsAggregator[] nodeStatsAggregators = (DTStatsAggregator[])Array$.MODULE$.tabulate(numNodes, (Function1 & Serializable & scala.Serializable)nodeIndex -> RandomForest$.$anonfun$findBestSplits$17(nodeToFeaturesBc, metadata, BoxesRunTime.unboxToInt((Object)nodeIndex)), ClassTag$.MODULE$.apply(DTStatsAggregator.class));
                    points.foreach((Function1 & Serializable & scala.Serializable)x$3 -> this.binSeqOpWithNodeIdCache$1(nodeStatsAggregators, (Tuple2)x$3, treeToNodeToIndexInfo, metadata, splits));
                    return ((IterableLike)((TraversableViewLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodeStatsAggregators)).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.swap(), Seq$.MODULE$.canBuildFrom())).iterator();
                };
                boolean x$22 = qual$1.mapPartitions$default$2();
                rDD = qual$1.mapPartitions((Function1)x$1, x$22, ClassTag$.MODULE$.apply(Tuple2.class));
            } else {
                rDD = input.mapPartitions((Function1 & Serializable & scala.Serializable)points -> {
                    DTStatsAggregator[] nodeStatsAggregators = (DTStatsAggregator[])Array$.MODULE$.tabulate(numNodes, (Function1 & Serializable & scala.Serializable)nodeIndex -> RandomForest$.$anonfun$findBestSplits$22(nodeToFeaturesBc, metadata, BoxesRunTime.unboxToInt((Object)nodeIndex)), ClassTag$.MODULE$.apply(DTStatsAggregator.class));
                    points.foreach((Function1 & Serializable & scala.Serializable)x$5 -> this.binSeqOp$1(nodeStatsAggregators, (BaggedPoint)x$5, treeToNodeToIndexInfo, topNodesForGroup, splits, metadata));
                    return ((IterableLike)((TraversableViewLike)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodeStatsAggregators)).view().zipWithIndex(IndexedSeqView$.MODULE$.arrCanBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.swap(), Seq$.MODULE$.canBuildFrom())).iterator();
                }, input.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
            }
            RDD partitionAggregates = rDD;
            Map nodeToBestSplits = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(partitionAggregates, ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(DTStatsAggregator.class), (Ordering)Ordering.Int$.MODULE$).reduceByKey((Function2 & Serializable & scala.Serializable)(a, b) -> a.merge((DTStatsAggregator)b)).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2;
                int nodeIndex;
                block5: {
                    Tuple2 tuple22;
                    block2: {
                        Split split;
                        ImpurityStats stats;
                        block4: {
                            Tuple2<Split, ImpurityStats> tuple23;
                            block3: {
                                Option featuresForNode;
                                tuple22 = x0$2;
                                if (tuple22 == null) break block2;
                                nodeIndex = tuple22._1$mcI$sp();
                                DTStatsAggregator aggStats = (DTStatsAggregator)tuple22._2();
                                tuple23 = MODULE$.binsToBestSplit(aggStats, splits, (Option<int[]>)(featuresForNode = ((Option)nodeToFeaturesBc.value()).flatMap((Function1 & Serializable & scala.Serializable)nodeToFeatures -> new Some(nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex))))), nodes[nodeIndex]);
                                if (tuple23 == null) break block3;
                                Split split2 = (Split)tuple23._1();
                                stats = (ImpurityStats)tuple23._2();
                                if (split2 == null) break block3;
                                split = split2;
                                if (stats != null) break block4;
                            }
                            throw new MatchError(tuple23);
                        }
                        ImpurityStats impurityStats = stats;
                        tuple2 = new Tuple2((Object)split, (Object)impurityStats);
                        break block5;
                    }
                    throw new MatchError((Object)tuple22);
                }
                Tuple2 tuple24 = tuple2;
                Split split = (Split)tuple24._1();
                ImpurityStats stats = (ImpurityStats)tuple24._2();
                Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Object)new Tuple2((Object)split, (Object)stats));
                return tuple25;
            }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(Tuple2.class), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
            timer.stop("chooseSplits");
            scala.collection.mutable.Map[] nodeIdUpdaters = nodeIdCache.nonEmpty() ? (scala.collection.mutable.Map[])Array$.MODULE$.fill(metadata.numTrees(), (Function0 & Serializable & scala.Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$), ClassTag$.MODULE$.apply(scala.collection.mutable.Map.class)) : null;
            nodesForGroup.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                RandomForest$.$anonfun$findBestSplits$30(treeToNodeToIndexInfo, nodeToBestSplits, metadata, nodeIdCache, nodeIdUpdaters, nodeStack, x0$3);
                return BoxedUnit.UNIT;
            });
            if (!nodeIdCache.nonEmpty()) break block2;
            ((NodeIdCache)nodeIdCache.get()).updateNodeIndices(input, nodeIdUpdaters, splits);
        }
    }

    public TimeTracker findBestSplits$default$8() {
        return new TimeTracker();
    }

    public Option<NodeIdCache> findBestSplits$default$9() {
        return None$.MODULE$;
    }

    private ImpurityStats calculateImpurityStats(ImpurityStats stats, ImpurityCalculator leftImpurityCalculator, ImpurityCalculator rightImpurityCalculator, DecisionTreeMetadata metadata) {
        double rightImpurity;
        double rightWeight;
        ImpurityCalculator parentImpurityCalculator = stats == null ? leftImpurityCalculator.copy().add(rightImpurityCalculator) : stats.impurityCalculator();
        double impurity = stats == null ? parentImpurityCalculator.calculate() : stats.impurity();
        long leftCount = leftImpurityCalculator.count();
        long rightCount = rightImpurityCalculator.count();
        long totalCount = leftCount + rightCount;
        if (leftCount < (long)metadata.minInstancesPerNode() || rightCount < (long)metadata.minInstancesPerNode()) {
            return ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator);
        }
        double leftWeight = (double)leftCount / (double)totalCount;
        double leftImpurity = leftImpurityCalculator.calculate();
        double gain = impurity - leftWeight * leftImpurity - (rightWeight = (double)rightCount / (double)totalCount) * (rightImpurity = rightImpurityCalculator.calculate());
        if (gain < metadata.minInfoGain()) {
            return ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator);
        }
        return new ImpurityStats(gain, impurity, parentImpurityCalculator, leftImpurityCalculator, rightImpurityCalculator, ImpurityStats$.MODULE$.$lessinit$greater$default$6());
    }

    public Tuple2<Split, ImpurityStats> binsToBestSplit(DTStatsAggregator binAggregates, Split[][] splits, Option<int[]> featuresForNode, LearningNode node) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        int level = LearningNode$.MODULE$.indexToLevel(node.id());
        ObjectRef gainAndImpurityStats = ObjectRef.create((Object)(level == 0 ? null : node.stats()));
        SeqView validFeatureSplits = (SeqView)((TraversableViewLike)scala.package$.MODULE$.Range().apply(0, binAggregates.metadata().numFeaturesPerNode()).view().map((Function1 & Serializable & scala.Serializable)featureIndexIdx -> RandomForest$.$anonfun$binsToBestSplit$1(featuresForNode, BoxesRunTime.unboxToInt((Object)featureIndexIdx)), SeqView$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)RandomForest$.$anonfun$binsToBestSplit$4(binAggregates, x0$1)));
        SeqView splitsAndImpurityInfo = (SeqView)validFeatureSplits.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$2;
            if (tuple22 != null) {
                int featureIndexIdx = tuple22._1$mcI$sp();
                int featureIndex = tuple22._2$mcI$sp();
                int numSplits = binAggregates.metadata().numSplits(featureIndex);
                if (binAggregates.metadata().isContinuous(featureIndex)) {
                    int nodeFeatureOffset = binAggregates.getFeatureOffset(featureIndexIdx);
                    for (int splitIndex2 = 0; splitIndex2 < numSplits; ++splitIndex2) {
                        binAggregates.mergeForFeature(nodeFeatureOffset, splitIndex2 + 1, splitIndex2);
                    }
                    Tuple2 tuple23 = (Tuple2)((TraversableOnce)scala.package$.MODULE$.Range().apply(0, numSplits).map((Function1 & Serializable & scala.Serializable)x0$3 -> RandomForest$.$anonfun$binsToBestSplit$6(binAggregates, nodeFeatureOffset, numSplits, gainAndImpurityStats, BoxesRunTime.unboxToInt((Object)x0$3)), IndexedSeq$.MODULE$.canBuildFrom())).maxBy((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToDouble((double)RandomForest$.$anonfun$binsToBestSplit$7(x$9)), (Ordering)Ordering.Double$.MODULE$);
                    if (tuple23 == null) {
                        throw new MatchError((Object)tuple23);
                    }
                    int bestFeatureSplitIndex = tuple23._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats = (ImpurityStats)tuple23._2();
                    Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bestFeatureSplitIndex), (Object)bestFeatureGainStats);
                    Tuple2 tuple25 = tuple24;
                    int bestFeatureSplitIndex2 = tuple25._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats2 = (ImpurityStats)tuple25._2();
                    tuple2 = new Tuple2((Object)splits[featureIndex][bestFeatureSplitIndex2], (Object)bestFeatureGainStats2);
                } else if (binAggregates.metadata().isUnordered(featureIndex)) {
                    int leftChildOffset = binAggregates.getFeatureOffset(featureIndexIdx);
                    Tuple2 tuple26 = (Tuple2)((TraversableOnce)scala.package$.MODULE$.Range().apply(0, numSplits).map((Function1 & Serializable & scala.Serializable)splitIndex -> RandomForest$.$anonfun$binsToBestSplit$8(binAggregates, leftChildOffset, gainAndImpurityStats, BoxesRunTime.unboxToInt((Object)splitIndex)), IndexedSeq$.MODULE$.canBuildFrom())).maxBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)RandomForest$.$anonfun$binsToBestSplit$9(x$11)), (Ordering)Ordering.Double$.MODULE$);
                    if (tuple26 == null) {
                        throw new MatchError((Object)tuple26);
                    }
                    int bestFeatureSplitIndex = tuple26._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats = (ImpurityStats)tuple26._2();
                    Tuple2 tuple27 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bestFeatureSplitIndex), (Object)bestFeatureGainStats);
                    Tuple2 tuple28 = tuple27;
                    int bestFeatureSplitIndex3 = tuple28._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats3 = (ImpurityStats)tuple28._2();
                    tuple2 = new Tuple2((Object)splits[featureIndex][bestFeatureSplitIndex3], (Object)bestFeatureGainStats3);
                } else {
                    int nodeFeatureOffset = binAggregates.getFeatureOffset(featureIndexIdx);
                    int numCategories = binAggregates.metadata().numBins()[featureIndex];
                    scala.collection.immutable.IndexedSeq centroidForCategories = (scala.collection.immutable.IndexedSeq)scala.package$.MODULE$.Range().apply(0, numCategories).map((Function1 & Serializable & scala.Serializable)x0$4 -> RandomForest$.$anonfun$binsToBestSplit$10(binAggregates, nodeFeatureOffset, BoxesRunTime.unboxToInt((Object)x0$4)), IndexedSeq$.MODULE$.canBuildFrom());
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Centroids for categorical variable: ").append(centroidForCategories.mkString(",")).toString());
                    List categoriesSortedByCentroid = (List)centroidForCategories.toList().sortBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToDouble((double)x$13._2$mcD$sp()), (Ordering)Ordering.Double$.MODULE$);
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Sorted centroids for categorical variable = ").append(categoriesSortedByCentroid.mkString(",")).toString());
                    for (int splitIndex3 = 0; splitIndex3 < numSplits; ++splitIndex3) {
                        int currentCategory = ((Tuple2)categoriesSortedByCentroid.apply(splitIndex3))._1$mcI$sp();
                        int nextCategory = ((Tuple2)categoriesSortedByCentroid.apply(splitIndex3 + 1))._1$mcI$sp();
                        binAggregates.mergeForFeature(nodeFeatureOffset, nextCategory, currentCategory);
                    }
                    int lastCategory = ((Tuple2)categoriesSortedByCentroid.last())._1$mcI$sp();
                    Tuple2 tuple29 = (Tuple2)((TraversableOnce)scala.package$.MODULE$.Range().apply(0, numSplits).map((Function1 & Serializable & scala.Serializable)splitIndex -> RandomForest$.$anonfun$binsToBestSplit$14(categoriesSortedByCentroid, binAggregates, nodeFeatureOffset, lastCategory, gainAndImpurityStats, BoxesRunTime.unboxToInt((Object)splitIndex)), IndexedSeq$.MODULE$.canBuildFrom())).maxBy((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)RandomForest$.$anonfun$binsToBestSplit$15(x$14)), (Ordering)Ordering.Double$.MODULE$);
                    if (tuple29 == null) {
                        throw new MatchError((Object)tuple29);
                    }
                    int bestFeatureSplitIndex = tuple29._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats = (ImpurityStats)tuple29._2();
                    Tuple2 tuple210 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)bestFeatureSplitIndex), (Object)bestFeatureGainStats);
                    Tuple2 tuple211 = tuple210;
                    int bestFeatureSplitIndex4 = tuple211._1$mcI$sp();
                    ImpurityStats bestFeatureGainStats4 = (ImpurityStats)tuple211._2();
                    List categoriesForSplit = ((List)categoriesSortedByCentroid.map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToDouble((double)x$16._1$mcI$sp()), List$.MODULE$.canBuildFrom())).slice(0, bestFeatureSplitIndex4 + 1);
                    CategoricalSplit bestFeatureSplit = new CategoricalSplit(featureIndex, (double[])categoriesForSplit.toArray(ClassTag$.MODULE$.Double()), numCategories);
                    tuple2 = new Tuple2((Object)bestFeatureSplit, (Object)bestFeatureGainStats4);
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple212 = tuple2;
            return tuple212;
        }, SeqView$.MODULE$.canBuildFrom());
        if (splitsAndImpurityInfo.isEmpty()) {
            int dummyFeatureIndex = BoxesRunTime.unboxToInt((Object)featuresForNode.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)RandomForest$.$anonfun$binsToBestSplit$17(x$17))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            ImpurityCalculator parentImpurityCalculator = binAggregates.getParentImpurityCalculator();
            if (binAggregates.metadata().isContinuous(dummyFeatureIndex)) {
                tuple22 = new Tuple2((Object)new ContinuousSplit(dummyFeatureIndex, 0.0), (Object)ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator));
            } else {
                int numCategories = BoxesRunTime.unboxToInt((Object)binAggregates.metadata().featureArity().apply((Object)BoxesRunTime.boxToInteger((int)dummyFeatureIndex)));
                tuple22 = new Tuple2((Object)new CategoricalSplit(dummyFeatureIndex, (double[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Double()), numCategories), (Object)ImpurityStats$.MODULE$.getInvalidImpurityStats(parentImpurityCalculator));
            }
        } else {
            tuple22 = tuple2 = (Tuple2)splitsAndImpurityInfo.maxBy((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToDouble((double)RandomForest$.$anonfun$binsToBestSplit$19(x$18)), (Ordering)Ordering.Double$.MODULE$);
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Split bestSplit = (Split)tuple2._1();
        ImpurityStats bestSplitStats = (ImpurityStats)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)bestSplit, (Object)bestSplitStats);
        Tuple2 tuple24 = tuple23;
        Split bestSplit2 = (Split)tuple24._1();
        ImpurityStats bestSplitStats2 = (ImpurityStats)tuple24._2();
        return new Tuple2((Object)bestSplit2, (Object)bestSplitStats2);
    }

    public Split[][] findSplits(RDD<LabeledPoint> input, DecisionTreeMetadata metadata, long seed) {
        RDD rDD;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("isMulticlass = ").append(metadata.isMulticlass()).toString());
        int numFeatures = metadata.numFeatures();
        scala.collection.immutable.IndexedSeq continuousFeatures = (scala.collection.immutable.IndexedSeq)scala.package$.MODULE$.Range().apply(0, numFeatures).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)featureIndex -> metadata.isContinuous(featureIndex));
        if (continuousFeatures.nonEmpty()) {
            double fraction = this.samplesFractionForFindSplits(metadata);
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("fraction of data used for calculating quantiles = ").append(fraction).toString());
            rDD = input.sample(false, fraction, (long)new XORShiftRandom(seed).nextInt());
        } else {
            rDD = input.sparkContext().emptyRDD(ClassTag$.MODULE$.apply(LabeledPoint.class));
        }
        RDD sampledInput = rDD;
        return this.findSplitsBySorting((RDD<LabeledPoint>)sampledInput, metadata, (IndexedSeq<Object>)continuousFeatures);
    }

    private Split[][] findSplitsBySorting(RDD<LabeledPoint> input, DecisionTreeMetadata metadata, IndexedSeq<Object> continuousFeatures) {
        int numPartitions = package$.MODULE$.min(continuousFeatures.length(), input.partitions().length);
        Map continuousSplits = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(input.flatMap((Function1 & Serializable & scala.Serializable)point -> (IndexedSeq)((TraversableLike)continuousFeatures.map((Function1 & Serializable & scala.Serializable)idx -> RandomForest$.$anonfun$findSplitsBySorting$2(point, BoxesRunTime.unboxToInt((Object)idx)), scala.collection.IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)RandomForest$.$anonfun$findSplitsBySorting$3(x$20))), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.Double(), (Ordering)Ordering.Int$.MODULE$).groupByKey(numPartitions).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int idx = tuple2._1$mcI$sp();
            Iterable samples = (Iterable)tuple2._2();
            double[] thresholds = MODULE$.findSplitsForContinuousFeature((Iterable<Object>)samples, metadata, idx);
            Split[] splits = (Split[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(thresholds)).map((Function1 & Serializable & scala.Serializable)thresh -> RandomForest$.$anonfun$findSplitsBySorting$5(idx, BoxesRunTime.unboxToDouble((Object)thresh)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Split.class)));
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("featureIndex = ").append(idx).append(", numSplits = ").append(splits.length).toString());
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)idx), (Object)splits);
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.Int(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Split.class)), (Ordering)Ordering.Int$.MODULE$).collectAsMap();
        int numFeatures = metadata.numFeatures();
        Split[][] splits = (Split[][])Array$.MODULE$.tabulate(numFeatures, (Function1 & Serializable & scala.Serializable)x0$2 -> RandomForest$.$anonfun$findSplitsBySorting$7(metadata, continuousSplits, BoxesRunTime.unboxToInt((Object)x0$2)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Split.class)));
        return splits;
    }

    /*
     * WARNING - void declaration
     */
    public List<Object> extractMultiClassCategories(int input, int maxFeatureValue) {
        void var3_3;
        Nil$ categories = Nil$.MODULE$;
        int bitShiftedInput = input;
        for (int j = 0; j < maxFeatureValue; ++j) {
            if (bitShiftedInput % 2 != 0) {
                double d = j;
                categories = categories.$colon$colon((Object)BoxesRunTime.boxToDouble((double)d));
            }
            bitShiftedInput >>= 1;
        }
        return var3_3;
    }

    public double[] findSplitsForContinuousFeature(Iterable<Object> featureSamples, DecisionTreeMetadata metadata, int featureIndex) {
        double[] dArray;
        Predef$.MODULE$.require(metadata.isContinuous(featureIndex), (Function0 & Serializable & scala.Serializable)() -> "findSplitsForContinuousFeature can only be used to find splits for a continuous feature.");
        if (featureSamples.isEmpty()) {
            dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
        } else {
            int numSplits = metadata.numSplits(featureIndex);
            int partNumSamples = featureSamples.size();
            scala.collection.mutable.Map partValueCountMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            featureSamples.foreach((Function1)(JFunction1.mcVD.sp & Serializable & scala.Serializable)x -> partValueCountMap.update((Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)partValueCountMap.getOrElse((Object)BoxesRunTime.boxToDouble((double)x), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)) + 1))));
            int numSamples = (int)(this.samplesFractionForFindSplits(metadata) * (double)metadata.numExamples());
            scala.collection.immutable.Map valueCountMap = numSamples - partNumSamples > 0 ? partValueCountMap.toMap(Predef$.MODULE$.$conforms()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToDouble((double)0.0)), (Object)BoxesRunTime.boxToInteger((int)(numSamples - partNumSamples)))) : partValueCountMap.toMap(Predef$.MODULE$.$conforms());
            Tuple2[] valueCounts = (Tuple2[])((TraversableOnce)valueCountMap.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToDouble((double)x$22._1$mcD$sp()), (Ordering)Ordering.Double$.MODULE$)).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
            int possibleSplits = valueCounts.length - 1;
            if (possibleSplits == 0) {
                dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            } else if (possibleSplits <= numSplits) {
                dArray = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), possibleSplits).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)index -> (valueCounts[index - 1]._1$mcD$sp() + valueCounts[index]._1$mcD$sp()) / 2.0, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            } else {
                double stride = (double)numSamples / (double)(numSplits + 1);
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("stride = ").append(stride).toString());
                ArrayBuilder splitsBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
                int currentCount = valueCounts[0]._2$mcI$sp();
                double targetCount = stride;
                for (int index2 = 1; index2 < valueCounts.length; ++index2) {
                    double currentGap;
                    int previousCount = currentCount;
                    currentCount += valueCounts[index2]._2$mcI$sp();
                    double previousGap = package$.MODULE$.abs((double)previousCount - targetCount);
                    if (!(previousGap < (currentGap = package$.MODULE$.abs((double)currentCount - targetCount)))) continue;
                    splitsBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)((valueCounts[index2 - 1]._1$mcD$sp() + valueCounts[index2]._1$mcD$sp()) / 2.0)));
                    targetCount += stride;
                }
                dArray = (double[])splitsBuilder.result();
            }
        }
        double[] splits = dArray;
        return splits;
    }

    public Tuple2<scala.collection.immutable.Map<Object, LearningNode[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, RandomForest.NodeIndexInfo>>> selectNodesToSplit(ArrayStack<Tuple2<Object, LearningNode>> nodeStack, long maxMemoryUsage, DecisionTreeMetadata metadata, Random rng) {
        HashMap mutableNodesForGroup = new HashMap();
        HashMap mutableTreeToNodeToIndexInfo = new HashMap();
        LongRef memUsage = LongRef.create((long)0L);
        IntRef numNodesInGroup = IntRef.create((int)0);
        boolean groupDone = false;
        while (nodeStack.nonEmpty() && !groupDone) {
            Tuple2 tuple2 = (Tuple2)nodeStack.top();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int treeIndex = tuple2._1$mcI$sp();
            LearningNode node = (LearningNode)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)node);
            Tuple2 tuple23 = tuple22;
            int treeIndex2 = tuple23._1$mcI$sp();
            LearningNode node2 = (LearningNode)tuple23._2();
            None$ featureSubset = metadata.subsamplingFeatures() ? new Some(SamplingUtils$.MODULE$.reservoirSampleAndCount(scala.package$.MODULE$.Range().apply(0, metadata.numFeatures()).iterator(), metadata.numFeaturesPerNode(), rng.nextLong(), ClassTag$.MODULE$.Int())._1()) : None$.MODULE$;
            long nodeMemUsage = this.aggregateSizeForNode(metadata, (Option<int[]>)featureSubset) * 8L;
            if (memUsage.elem + nodeMemUsage <= maxMemoryUsage || memUsage.elem == 0L) {
                nodeStack.pop();
                ((ArrayBuffer)mutableNodesForGroup.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)treeIndex2), (Function0 & Serializable & scala.Serializable)() -> new ArrayBuffer())).$plus$eq((Object)node2);
                ((HashMap)mutableTreeToNodeToIndexInfo.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)treeIndex2), (Function0 & Serializable & scala.Serializable)() -> new HashMap())).update((Object)BoxesRunTime.boxToInteger((int)node2.id()), (Object)new RandomForest.NodeIndexInfo(numNodesInGroup.elem, (Option<int[]>)featureSubset));
                ++numNodesInGroup.elem;
                memUsage.elem += nodeMemUsage;
                continue;
            }
            groupDone = true;
        }
        if (memUsage.elem > maxMemoryUsage) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Tree learning is using approximately ").append(memUsage$1.elem).append(" bytes per iteration, which").append(new StringBuilder(63).append(" exceeds requested limit maxMemoryUsage=").append(maxMemoryUsage).append(". This allows splitting").toString()).append(new StringBuilder(26).append(" ").append(numNodesInGroup$1.elem).append(" nodes in this iteration.").toString()).toString());
        }
        scala.collection.immutable.Map nodesForGroup = mutableNodesForGroup.mapValues((Function1 & Serializable & scala.Serializable)x$24 -> (LearningNode[])x$24.toArray(ClassTag$.MODULE$.apply(LearningNode.class))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map treeToNodeToIndexInfo = mutableTreeToNodeToIndexInfo.mapValues((Function1 & Serializable & scala.Serializable)x$25 -> x$25.toMap(Predef$.MODULE$.$conforms())).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
    }

    private long aggregateSizeForNode(DecisionTreeMetadata metadata, Option<int[]> featureSubset) {
        long totalBins = featureSubset.nonEmpty() ? BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])featureSubset.get())).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)featureIndex -> metadata.numBins()[featureIndex], Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) : BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(metadata.numBins())).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$26 -> x$26, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        return metadata.isClassification() ? (long)metadata.numClasses() * totalBins : 3L * totalBins;
    }

    private double samplesFractionForFindSplits(DecisionTreeMetadata metadata) {
        int requiredSamples = package$.MODULE$.max(metadata.maxBins() * metadata.maxBins(), 10000);
        return (long)requiredSamples < metadata.numExamples() ? (double)requiredSamples / (double)metadata.numExamples() : 1.0;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ String $anonfun$run$6(DecisionTreeMetadata metadata$1, int featureIndex) {
        return new StringBuilder(2).append("\t").append(featureIndex).append("\t").append(metadata$1.numBins()[featureIndex]).toString();
    }

    public static final /* synthetic */ int $anonfun$findBestSplits$1(LearningNode[] x$2) {
        return x$2.length;
    }

    private final void nodeBinSeqOp$1(int treeIndex, RandomForest.NodeIndexInfo nodeInfo, DTStatsAggregator[] agg, BaggedPoint baggedPoint, DecisionTreeMetadata metadata$2, Split[][] splits$1) {
        block2: {
            if (nodeInfo == null) break block2;
            int aggNodeIndex = nodeInfo.nodeIndexInGroup();
            Option<int[]> featuresForNode = nodeInfo.featureSubset();
            double instanceWeight = baggedPoint.subsampleWeights()[treeIndex];
            if (metadata$2.unorderedFeatures().isEmpty()) {
                this.orderedBinSeqOp(agg[aggNodeIndex], (TreePoint)baggedPoint.datum(), instanceWeight, featuresForNode);
            } else {
                this.mixedBinSeqOp(agg[aggNodeIndex], (TreePoint)baggedPoint.datum(), splits$1, metadata$2.unorderedFeatures(), instanceWeight, featuresForNode);
            }
            agg[aggNodeIndex].updateParent(((TreePoint)baggedPoint.datum()).label(), instanceWeight);
        }
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$8(RandomForest$ $this, scala.collection.immutable.Map topNodesForGroup$1, BaggedPoint baggedPoint$1, Split[][] splits$1, DTStatsAggregator[] agg$1, DecisionTreeMetadata metadata$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int treeIndex = tuple2._1$mcI$sp();
        scala.collection.immutable.Map nodeIndexToInfo = (scala.collection.immutable.Map)tuple2._2();
        int nodeIndex = ((LearningNode)topNodesForGroup$1.apply((Object)BoxesRunTime.boxToInteger((int)treeIndex))).predictImpl(((TreePoint)baggedPoint$1.datum()).binnedFeatures(), splits$1);
        $this.nodeBinSeqOp$1(treeIndex, (RandomForest.NodeIndexInfo)nodeIndexToInfo.getOrElse((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Function0 & Serializable & scala.Serializable)() -> null), agg$1, baggedPoint$1, metadata$2, splits$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final DTStatsAggregator[] binSeqOp$1(DTStatsAggregator[] agg, BaggedPoint baggedPoint, scala.collection.immutable.Map treeToNodeToIndexInfo$1, scala.collection.immutable.Map topNodesForGroup$1, Split[][] splits$1, DecisionTreeMetadata metadata$2) {
        treeToNodeToIndexInfo$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RandomForest$.$anonfun$findBestSplits$8(this, topNodesForGroup$1, baggedPoint, splits$1, agg, metadata$2, x0$1);
            return BoxedUnit.UNIT;
        });
        return agg;
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$10(RandomForest$ $this, Tuple2 dataPoint$1, DTStatsAggregator[] agg$2, DecisionTreeMetadata metadata$2, Split[][] splits$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int treeIndex = tuple2._1$mcI$sp();
        scala.collection.immutable.Map nodeIndexToInfo = (scala.collection.immutable.Map)tuple2._2();
        BaggedPoint baggedPoint = (BaggedPoint)dataPoint$1._1();
        int[] nodeIdCache = (int[])dataPoint$1._2();
        int nodeIndex = nodeIdCache[treeIndex];
        $this.nodeBinSeqOp$1(treeIndex, (RandomForest.NodeIndexInfo)nodeIndexToInfo.getOrElse((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Function0 & Serializable & scala.Serializable)() -> null), agg$2, baggedPoint, metadata$2, splits$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private final DTStatsAggregator[] binSeqOpWithNodeIdCache$1(DTStatsAggregator[] agg, Tuple2 dataPoint, scala.collection.immutable.Map treeToNodeToIndexInfo$1, DecisionTreeMetadata metadata$2, Split[][] splits$1) {
        treeToNodeToIndexInfo$1.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RandomForest$.$anonfun$findBestSplits$10(this, dataPoint, agg, metadata$2, splits$1, x0$1);
            return BoxedUnit.UNIT;
        });
        return agg;
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$13(HashMap mutableNodeToFeatures$1, RandomForest.NodeIndexInfo nodeIndexInfo) {
        Predef$.MODULE$.assert(nodeIndexInfo.featureSubset().isDefined());
        mutableNodeToFeatures$1.update((Object)BoxesRunTime.boxToInteger((int)nodeIndexInfo.nodeIndexInGroup()), nodeIndexInfo.featureSubset().get());
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$12(HashMap mutableNodeToFeatures$1, scala.collection.immutable.Map nodeIdToNodeInfo) {
        nodeIdToNodeInfo.values().foreach((Function1 & Serializable & scala.Serializable)nodeIndexInfo -> {
            RandomForest$.$anonfun$findBestSplits$13(mutableNodeToFeatures$1, nodeIndexInfo);
            return BoxedUnit.UNIT;
        });
    }

    private static final Option getNodeToFeatures$1(scala.collection.immutable.Map treeToNodeToIndexInfo, DecisionTreeMetadata metadata$2) {
        None$ none$;
        if (!metadata$2.subsamplingFeatures()) {
            none$ = None$.MODULE$;
        } else {
            HashMap mutableNodeToFeatures = new HashMap();
            treeToNodeToIndexInfo.values().foreach((Function1 & Serializable & scala.Serializable)nodeIdToNodeInfo -> {
                RandomForest$.$anonfun$findBestSplits$12(mutableNodeToFeatures, nodeIdToNodeInfo);
                return BoxedUnit.UNIT;
            });
            none$ = new Some((Object)mutableNodeToFeatures.toMap(Predef$.MODULE$.$conforms()));
        }
        return none$;
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$14(LearningNode[] nodes$1, scala.collection.immutable.Map treeToNodeToIndexInfo$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int treeIndex = tuple2._1$mcI$sp();
        LearningNode[] nodesForTree = (LearningNode[])tuple2._2();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodesForTree)).foreach((Function1 & Serializable & scala.Serializable)node -> {
            nodes$1[((RandomForest.NodeIndexInfo)((MapLike)treeToNodeToIndexInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)treeIndex))).apply((Object)BoxesRunTime.boxToInteger((int)node.id()))).nodeIndexInGroup()] = node;
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ DTStatsAggregator $anonfun$findBestSplits$17(Broadcast nodeToFeaturesBc$1, DecisionTreeMetadata metadata$2, int nodeIndex) {
        Option featuresForNode = ((Option)nodeToFeaturesBc$1.value()).map((Function1 & Serializable & scala.Serializable)nodeToFeatures -> (int[])nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex)));
        return new DTStatsAggregator(metadata$2, (Option<int[]>)featuresForNode);
    }

    public static final /* synthetic */ DTStatsAggregator $anonfun$findBestSplits$22(Broadcast nodeToFeaturesBc$1, DecisionTreeMetadata metadata$2, int nodeIndex) {
        Option featuresForNode = ((Option)nodeToFeaturesBc$1.value()).flatMap((Function1 & Serializable & scala.Serializable)nodeToFeatures -> new Some(nodeToFeatures.apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex))));
        return new DTStatsAggregator(metadata$2, (Option<int[]>)featuresForNode);
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$31(scala.collection.immutable.Map treeToNodeToIndexInfo$1, int treeIndex$2, Map nodeToBestSplits$1, DecisionTreeMetadata metadata$2, Option nodeIdCache$1, scala.collection.mutable.Map[] nodeIdUpdaters$1, ArrayStack nodeStack$2, LearningNode node) {
        block9: {
            BoxedUnit boxedUnit;
            Split split;
            ImpurityStats stats;
            int nodeIndex;
            block8: {
                Tuple2 tuple2;
                block7: {
                    nodeIndex = node.id();
                    RandomForest.NodeIndexInfo nodeInfo = (RandomForest.NodeIndexInfo)((MapLike)treeToNodeToIndexInfo$1.apply((Object)BoxesRunTime.boxToInteger((int)treeIndex$2))).apply((Object)BoxesRunTime.boxToInteger((int)nodeIndex));
                    int aggNodeIndex = nodeInfo.nodeIndexInGroup();
                    tuple2 = (Tuple2)nodeToBestSplits$1.apply((Object)BoxesRunTime.boxToInteger((int)aggNodeIndex));
                    if (tuple2 == null) break block7;
                    Split split2 = (Split)tuple2._1();
                    stats = (ImpurityStats)tuple2._2();
                    if (split2 == null) break block7;
                    split = split2;
                    if (stats != null) break block8;
                }
                throw new MatchError((Object)tuple2);
            }
            ImpurityStats impurityStats = stats;
            Tuple2 tuple2 = new Tuple2((Object)split, (Object)impurityStats);
            Tuple2 tuple22 = tuple2;
            Split split3 = (Split)tuple22._1();
            ImpurityStats stats2 = (ImpurityStats)tuple22._2();
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("best split = ").append(split3).toString());
            boolean isLeaf = stats2.gain() <= 0.0 || LearningNode$.MODULE$.indexToLevel(nodeIndex) == metadata$2.maxDepth();
            node.isLeaf_$eq(isLeaf);
            node.stats_$eq(stats2);
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("Node = ").append(node).toString());
            if (isLeaf) break block9;
            node.split_$eq((Option<Split>)new Some((Object)split3));
            boolean childIsLeaf = LearningNode$.MODULE$.indexToLevel(nodeIndex) + 1 == metadata$2.maxDepth();
            boolean leftChildIsLeaf = childIsLeaf || stats2.leftImpurity() == 0.0;
            boolean rightChildIsLeaf = childIsLeaf || stats2.rightImpurity() == 0.0;
            node.leftChild_$eq((Option<LearningNode>)new Some((Object)LearningNode$.MODULE$.apply(LearningNode$.MODULE$.leftChildIndex(nodeIndex), leftChildIsLeaf, ImpurityStats$.MODULE$.getEmptyImpurityStats(stats2.leftImpurityCalculator()))));
            node.rightChild_$eq((Option<LearningNode>)new Some((Object)LearningNode$.MODULE$.apply(LearningNode$.MODULE$.rightChildIndex(nodeIndex), rightChildIsLeaf, ImpurityStats$.MODULE$.getEmptyImpurityStats(stats2.rightImpurityCalculator()))));
            if (nodeIdCache$1.nonEmpty()) {
                NodeIndexUpdater nodeIndexUpdater = new NodeIndexUpdater(split3, nodeIndex);
                boxedUnit = nodeIdUpdaters$1[treeIndex$2].put((Object)BoxesRunTime.boxToInteger((int)nodeIndex), (Object)nodeIndexUpdater);
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!leftChildIsLeaf) {
                nodeStack$2.push((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex$2), node.leftChild().get()));
            }
            if (!rightChildIsLeaf) {
                nodeStack$2.push((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex$2), node.rightChild().get()));
            }
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("leftChildIndex = ").append(((LearningNode)node.leftChild().get()).id()).append(", impurity = ").append(stats2.leftImpurity()).toString());
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("rightChildIndex = ").append(((LearningNode)node.rightChild().get()).id()).append(", impurity = ").append(stats2.rightImpurity()).toString());
        }
    }

    public static final /* synthetic */ void $anonfun$findBestSplits$30(scala.collection.immutable.Map treeToNodeToIndexInfo$1, Map nodeToBestSplits$1, DecisionTreeMetadata metadata$2, Option nodeIdCache$1, scala.collection.mutable.Map[] nodeIdUpdaters$1, ArrayStack nodeStack$2, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int treeIndex = tuple2._1$mcI$sp();
        LearningNode[] nodesForTree = (LearningNode[])tuple2._2();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])nodesForTree)).foreach((Function1 & Serializable & scala.Serializable)node -> {
            RandomForest$.$anonfun$findBestSplits$31(treeToNodeToIndexInfo$1, treeIndex, nodeToBestSplits$1, metadata$2, nodeIdCache$1, nodeIdUpdaters$1, nodeStack$2, node);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$1(Option featuresForNode$1, int featureIndexIdx) {
        return (Tuple2)featuresForNode$1.map((Function1 & Serializable & scala.Serializable)features -> new Tuple2.mcII.sp(featureIndexIdx, features[featureIndexIdx])).getOrElse((Function0 & Serializable & scala.Serializable)() -> new Tuple2.mcII.sp(featureIndexIdx, featureIndexIdx));
    }

    public static final /* synthetic */ boolean $anonfun$binsToBestSplit$4(DTStatsAggregator binAggregates$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int featureIndex = tuple2._2$mcI$sp();
        boolean bl = binAggregates$1.metadata().numSplits(featureIndex) != 0;
        return bl;
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$6(DTStatsAggregator binAggregates$1, int nodeFeatureOffset$1, int numSplits$1, ObjectRef gainAndImpurityStats$1, int x0$3) {
        int n = x0$3;
        ImpurityCalculator leftChildStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$1, n);
        ImpurityCalculator rightChildStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$1, numSplits$1);
        rightChildStats.subtract(leftChildStats);
        gainAndImpurityStats$1.elem = MODULE$.calculateImpurityStats((ImpurityStats)gainAndImpurityStats$1.elem, leftChildStats, rightChildStats, binAggregates$1.metadata());
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)n), (Object)((ImpurityStats)gainAndImpurityStats$1.elem));
        return tuple2;
    }

    public static final /* synthetic */ double $anonfun$binsToBestSplit$7(Tuple2 x$9) {
        return ((ImpurityStats)x$9._2()).gain();
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$8(DTStatsAggregator binAggregates$1, int leftChildOffset$1, ObjectRef gainAndImpurityStats$1, int splitIndex) {
        ImpurityCalculator leftChildStats = binAggregates$1.getImpurityCalculator(leftChildOffset$1, splitIndex);
        ImpurityCalculator rightChildStats = binAggregates$1.getParentImpurityCalculator().subtract(leftChildStats);
        gainAndImpurityStats$1.elem = MODULE$.calculateImpurityStats((ImpurityStats)gainAndImpurityStats$1.elem, leftChildStats, rightChildStats, binAggregates$1.metadata());
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)splitIndex), (Object)((ImpurityStats)gainAndImpurityStats$1.elem));
    }

    public static final /* synthetic */ double $anonfun$binsToBestSplit$9(Tuple2 x$11) {
        return ((ImpurityStats)x$11._2()).gain();
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$10(DTStatsAggregator binAggregates$1, int nodeFeatureOffset$2, int x0$4) {
        int n = x0$4;
        ImpurityCalculator categoryStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$2, n);
        double centroid = categoryStats.count() != 0L ? (binAggregates$1.metadata().isMulticlass() ? categoryStats.calculate() : (binAggregates$1.metadata().isClassification() ? categoryStats.stats()[1] : categoryStats.predict())) : Double.MAX_VALUE;
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(n, centroid);
        return sp2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$binsToBestSplit$14(List categoriesSortedByCentroid$1, DTStatsAggregator binAggregates$1, int nodeFeatureOffset$2, int lastCategory$1, ObjectRef gainAndImpurityStats$1, int splitIndex) {
        int featureValue = ((Tuple2)categoriesSortedByCentroid$1.apply(splitIndex))._1$mcI$sp();
        ImpurityCalculator leftChildStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$2, featureValue);
        ImpurityCalculator rightChildStats = binAggregates$1.getImpurityCalculator(nodeFeatureOffset$2, lastCategory$1);
        rightChildStats.subtract(leftChildStats);
        gainAndImpurityStats$1.elem = MODULE$.calculateImpurityStats((ImpurityStats)gainAndImpurityStats$1.elem, leftChildStats, rightChildStats, binAggregates$1.metadata());
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)splitIndex), (Object)((ImpurityStats)gainAndImpurityStats$1.elem));
    }

    public static final /* synthetic */ double $anonfun$binsToBestSplit$15(Tuple2 x$14) {
        return ((ImpurityStats)x$14._2()).gain();
    }

    public static final /* synthetic */ int $anonfun$binsToBestSplit$17(int[] x$17) {
        return BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(x$17)).head());
    }

    public static final /* synthetic */ double $anonfun$binsToBestSplit$19(Tuple2 x$18) {
        return ((ImpurityStats)x$18._2()).gain();
    }

    public static final /* synthetic */ Tuple2 $anonfun$findSplitsBySorting$2(LabeledPoint point$1, int idx) {
        return new Tuple2.mcID.sp(idx, point$1.features().apply(idx));
    }

    public static final /* synthetic */ boolean $anonfun$findSplitsBySorting$3(Tuple2 x$20) {
        return x$20._2$mcD$sp() != 0.0;
    }

    public static final /* synthetic */ ContinuousSplit $anonfun$findSplitsBySorting$5(int idx$1, double thresh) {
        return new ContinuousSplit(idx$1, thresh);
    }

    public static final /* synthetic */ CategoricalSplit $anonfun$findSplitsBySorting$9(int featureArity$1, int x1$1, int splitIndex) {
        List<Object> categories = MODULE$.extractMultiClassCategories(splitIndex + 1, featureArity$1);
        return new CategoricalSplit(x1$1, (double[])categories.toArray(ClassTag$.MODULE$.Double()), featureArity$1);
    }

    public static final /* synthetic */ Split[] $anonfun$findSplitsBySorting$7(DecisionTreeMetadata metadata$4, Map continuousSplits$1, int x0$2) {
        Split[] splitArray;
        int n = x0$2;
        switch (n) {
            default: 
        }
        if (metadata$4.isContinuous(n)) {
            Split[] split = (Split[])continuousSplits$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)n), (Function0 & Serializable & scala.Serializable)() -> (Split[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Split.class)));
            metadata$4.setNumSplits(n, split.length);
            splitArray = split;
        } else if (metadata$4.isCategorical(n) && metadata$4.isUnordered(n)) {
            int featureArity = BoxesRunTime.unboxToInt((Object)metadata$4.featureArity().apply((Object)BoxesRunTime.boxToInteger((int)n)));
            splitArray = (Split[])Array$.MODULE$.tabulate(metadata$4.numSplits(n), (Function1 & Serializable & scala.Serializable)splitIndex -> RandomForest$.$anonfun$findSplitsBySorting$9(featureArity, n, BoxesRunTime.unboxToInt((Object)splitIndex)), ClassTag$.MODULE$.apply(Split.class));
        } else if (metadata$4.isCategorical(n)) {
            splitArray = (Split[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Split.class));
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return splitArray;
    }

    private RandomForest$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

