/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.tree.impl;

import scala.Function1;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=3Q!\u0003\u0006\u0001!YAQ\u0001\t\u0001\u0005\u0002\tBq!\n\u0001C\u0002\u0013%a\u0005\u0003\u0004>\u0001\u0001\u0006Ia\n\u0005\b}\u0001\u0011\r\u0011\"\u0003'\u0011\u0019y\u0004\u0001)A\u0005O!)\u0001\t\u0001C\u0001\u0003\")q\t\u0001C\u0001\u0011\")Q\n\u0001C!\u001d\nYA+[7f)J\f7m[3s\u0015\tYA\"\u0001\u0003j[Bd'BA\u0007\u000f\u0003\u0011!(/Z3\u000b\u0005=\u0001\u0012AA7m\u0015\t\t\"#A\u0003ta\u0006\u00148N\u0003\u0002\u0014)\u00051\u0011\r]1dQ\u0016T\u0011!F\u0001\u0004_J<7c\u0001\u0001\u0018;A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\u0004\"\u0001\u0007\u0010\n\u0005}I\"\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003)\taa\u001d;beR\u001cX#A\u0014\u0011\t!jsFO\u0007\u0002S)\u0011!fK\u0001\b[V$\u0018M\u00197f\u0015\ta\u0013$\u0001\u0006d_2dWm\u0019;j_:L!AL\u0015\u0003\u000f!\u000b7\u000f['baB\u0011\u0001g\u000e\b\u0003cU\u0002\"AM\r\u000e\u0003MR!\u0001N\u0011\u0002\rq\u0012xn\u001c;?\u0013\t1\u0014$\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c\u001a!\tA2(\u0003\u0002=3\t!Aj\u001c8h\u0003\u001d\u0019H/\u0019:ug\u0002\na\u0001^8uC2\u001c\u0018a\u0002;pi\u0006d7\u000fI\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u0005\u0016\u0003\"\u0001G\"\n\u0005\u0011K\"\u0001B+oSRDQA\u0012\u0004A\u0002=\n!\u0002^5nKJd\u0015MY3m\u0003\u0011\u0019Ho\u001c9\u0015\u0005%c\u0005C\u0001\rK\u0013\tY\u0015D\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\r\u001e\u0001\raL\u0001\ti>\u001cFO]5oOR\tq\u0006")
public class TimeTracker
implements Serializable {
    private final HashMap<String, Object> starts = new HashMap();
    private final HashMap<String, Object> totals = new HashMap();

    private HashMap<String, Object> starts() {
        return this.starts;
    }

    private HashMap<String, Object> totals() {
        return this.totals;
    }

    public void start(String timerLabel) {
        long currentTime = System.nanoTime();
        if (this.starts().contains((Object)timerLabel)) {
            throw new RuntimeException(new StringBuilder(45).append("TimeTracker.start(timerLabel) called again on").append(new StringBuilder(45).append(" timerLabel = ").append(timerLabel).append(" before that timer was stopped.").toString()).toString());
        }
        this.starts().update((Object)timerLabel, (Object)BoxesRunTime.boxToLong((long)currentTime));
    }

    public double stop(String timerLabel) {
        long currentTime = System.nanoTime();
        if (!this.starts().contains((Object)timerLabel)) {
            throw new RuntimeException(new StringBuilder(38).append("TimeTracker.stop(timerLabel) called on").append(new StringBuilder(47).append(" timerLabel = ").append(timerLabel).append(", but that timer was not started.").toString()).toString());
        }
        long elapsed = currentTime - BoxesRunTime.unboxToLong((Object)this.starts().apply((Object)timerLabel));
        this.starts().remove((Object)timerLabel);
        if (this.totals().contains((Object)timerLabel)) {
            this.totals().update((Object)timerLabel, (Object)BoxesRunTime.boxToLong((long)(BoxesRunTime.unboxToLong((Object)this.totals().apply((Object)timerLabel)) + elapsed)));
        } else {
            this.totals().update((Object)timerLabel, (Object)BoxesRunTime.boxToLong((long)elapsed));
        }
        return (double)elapsed / 1.0E9;
    }

    public String toString() {
        return ((TraversableOnce)this.totals().map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String label = (String)tuple2._1();
            long elapsed = tuple2._2$mcJ$sp();
            String string = new StringBuilder(4).append("  ").append(label).append(": ").append((double)elapsed / 1.0E9).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString("\n");
    }
}

