/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Random;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.mllib.clustering.BisectingKMeans$;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.clustering.ClusteringTreeNode;
import org.apache.spark.mllib.clustering.DistanceMeasure;
import org.apache.spark.mllib.clustering.DistanceMeasure$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Seq$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\u0005g\u0001\u0002/^\u0001!D\u0001\"\u001e\u0001\u0003\u0002\u0004%IA\u001e\u0005\tu\u0002\u0011\t\u0019!C\u0005w\"I\u00111\u0001\u0001\u0003\u0002\u0003\u0006Ka\u001e\u0005\n\u0003\u000b\u0001!\u00111A\u0005\nYD!\"a\u0002\u0001\u0005\u0003\u0007I\u0011BA\u0005\u0011%\ti\u0001\u0001B\u0001B\u0003&q\u000f\u0003\u0006\u0002\u0010\u0001\u0011\t\u0019!C\u0005\u0003#A!\"!\u0007\u0001\u0005\u0003\u0007I\u0011BA\u000e\u0011)\ty\u0002\u0001B\u0001B\u0003&\u00111\u0003\u0005\u000b\u0003C\u0001!\u00111A\u0005\n\u0005\r\u0002BCA\u0016\u0001\t\u0005\r\u0011\"\u0003\u0002.!Q\u0011\u0011\u0007\u0001\u0003\u0002\u0003\u0006K!!\n\t\u0015\u0005M\u0002A!a\u0001\n\u0013\t)\u0004\u0003\u0006\u0002N\u0001\u0011\t\u0019!C\u0005\u0003\u001fB!\"a\u0015\u0001\u0005\u0003\u0005\u000b\u0015BA\u001c\u0011\u001d\t)\u0006\u0001C\u0005\u0003/Bq!!\u0016\u0001\t\u0003\t9\u0007C\u0004\u0002|\u0001!\t!! \t\r\u0005\u0015\u0005\u0001\"\u0001w\u0011\u001d\tI\t\u0001C\u0001\u0003\u0017Ca!!%\u0001\t\u00031\bbBAK\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003;\u0003A\u0011AA\t\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GCq!!+\u0001\t\u0003\t\u0019\u0003C\u0004\u0002.\u0002!\t!!\u000e\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"A\u0011Q\u0018\u0001\u0005\u0002\u0005\fy\fC\u0004\u0002>\u0002!\t!!@\t\u000f\u0005u\u0006\u0001\"\u0001\u0003\u0004\u001d9!1D/\t\n\tuaA\u0002/^\u0011\u0013\u0011y\u0002C\u0004\u0002V\u0001\"\tAa\n\t\u0013\t%\u0002E1A\u0005\n\u0005\r\u0002\u0002\u0003B\u0016A\u0001\u0006I!!\n\t\u0013\t5\u0002E1A\u0005\n\u0005\r\u0002\u0002\u0003B\u0018A\u0001\u0006I!!\n\t\u0013\tE\u0002E1A\u0005\n\u0005E\u0001\u0002\u0003B\u001aA\u0001\u0006I!a\u0005\t\u000f\tU\u0002\u0005\"\u0003\u00038!9!Q\b\u0011\u0005\n\t}\u0002b\u0002B\"A\u0011%!Q\t\u0005\b\u0005\u0013\u0002C\u0011\u0002B&\r\u0019\u0019I\u0001\t\u0003\u0004\f!I!1\u001f\u0017\u0003\u0006\u0004%\tA\u001e\u0005\n\u0007\u001ba#\u0011!Q\u0001\n]D!\"a\r-\u0005\u000b\u0007I\u0011AB\b\u0011)\t\u0019\u0006\fB\u0001B\u0003%11\u0001\u0005\b\u0003+bC\u0011AB\t\u0011%\u0019I\u0002\fa\u0001\n\u0013\t\u0019\u0003C\u0005\u0004\u001c1\u0002\r\u0011\"\u0003\u0004\u001e!A1\u0011\u0005\u0017!B\u0013\t)\u0003C\u0005\u0004$1\u0012\r\u0011\"\u0003\u0004&!A1q\u0005\u0017!\u0002\u0013\t9\u000eC\u0005\u0004*1\u0002\r\u0011\"\u0003\u0002\u0012!I11\u0006\u0017A\u0002\u0013%1Q\u0006\u0005\t\u0007ca\u0003\u0015)\u0003\u0002\u0014!911\u0007\u0017\u0005\u0002\rU\u0002bBB\u001fY\u0011\u00051q\b\u0005\b\u0007\u000bbC\u0011AB$\u0011\u001d\u0019I\u0005\tC\u0005\u0007\u0017Bqa!\u0019!\t\u0013\u0019\u0019\u0007C\u0004\u0004z\u0001\"Iaa\u001f\u0007\r\t]\u0003\u0005\u0012B-\u0011)\u0011\t\u0007\u0011BK\u0002\u0013\u0005\u00111\u0005\u0005\u000b\u0005G\u0002%\u0011#Q\u0001\n\u0005\u0015\u0002B\u0003B3\u0001\nU\r\u0011\"\u0001\u0003h!Q!q\u000e!\u0003\u0012\u0003\u0006IA!\u001b\t\u0015\tE\u0004I!f\u0001\n\u0003\t\t\u0002\u0003\u0006\u0003t\u0001\u0013\t\u0012)A\u0005\u0003'Aq!!\u0016A\t\u0003\u0011)\bC\u0005\u0003~\u0001\u000b\t\u0011\"\u0001\u0003\u0000!I!q\u0011!\u0012\u0002\u0013\u0005!\u0011\u0012\u0005\n\u0005;\u0003\u0015\u0013!C\u0001\u0005?C\u0011Ba)A#\u0003%\tA!*\t\u0013\t%\u0006)!A\u0005B\t-\u0006\u0002\u0003B]\u0001\u0006\u0005I\u0011\u0001<\t\u0013\tm\u0006)!A\u0005\u0002\tu\u0006\"\u0003Bd\u0001\u0006\u0005I\u0011\tBe\u0011%\u00119\u000eQA\u0001\n\u0003\u0011I\u000eC\u0005\u0003d\u0002\u000b\t\u0011\"\u0011\u0003f\"I!q\u001d!\u0002\u0002\u0013\u0005#\u0011\u001e\u0005\n\u0005W\u0004\u0015\u0011!C!\u0005[<\u0011b!#!\u0003\u0003EIaa#\u0007\u0013\t]\u0003%!A\t\n\r5\u0005bBA++\u0012\u000511\u0014\u0005\n\u0005O,\u0016\u0011!C#\u0005SD\u0011b!(V\u0003\u0003%\tia(\t\u0013\r\u001dV+!A\u0005\u0002\u000e%\u0006\"CB\\+\u0006\u0005I\u0011BB]\u0011%\u00199\fIA\u0001\n\u0013\u0019ILA\bCSN,7\r^5oO.kU-\u00198t\u0015\tqv,\u0001\u0006dYV\u001cH/\u001a:j]\u001eT!\u0001Y1\u0002\u000b5dG.\u001b2\u000b\u0005\t\u001c\u0017!B:qCJ\\'B\u00013f\u0003\u0019\t\u0007/Y2iK*\ta-A\u0002pe\u001e\u001c\u0001aE\u0002\u0001S>\u0004\"A[7\u000e\u0003-T\u0011\u0001\\\u0001\u0006g\u000e\fG.Y\u0005\u0003].\u0014a!\u00118z%\u00164\u0007C\u00019t\u001b\u0005\t(B\u0001:b\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001;r\u0005\u001daunZ4j]\u001e\f\u0011a[\u000b\u0002oB\u0011!\u000e_\u0005\u0003s.\u00141!\u00138u\u0003\u0015Yw\fJ3r)\tax\u0010\u0005\u0002k{&\u0011ap\u001b\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0002\t\t\t\u00111\u0001x\u0003\rAH%M\u0001\u0003W\u0002\nQ\"\\1y\u0013R,'/\u0019;j_:\u001c\u0018!E7bq&#XM]1uS>t7o\u0018\u0013fcR\u0019A0a\u0003\t\u0011\u0005\u0005Q!!AA\u0002]\fa\"\\1y\u0013R,'/\u0019;j_:\u001c\b%A\fnS:$\u0015N^5tS\ndWm\u00117vgR,'oU5{KV\u0011\u00111\u0003\t\u0004U\u0006U\u0011bAA\fW\n1Ai\\;cY\u0016\f1$\\5o\t&4\u0018n]5cY\u0016\u001cE.^:uKJ\u001c\u0016N_3`I\u0015\fHc\u0001?\u0002\u001e!I\u0011\u0011\u0001\u0005\u0002\u0002\u0003\u0007\u00111C\u0001\u0019[&tG)\u001b<jg&\u0014G.Z\"mkN$XM]*ju\u0016\u0004\u0013\u0001B:fK\u0012,\"!!\n\u0011\u0007)\f9#C\u0002\u0002*-\u0014A\u0001T8oO\u0006A1/Z3e?\u0012*\u0017\u000fF\u0002}\u0003_A\u0011\"!\u0001\f\u0003\u0003\u0005\r!!\n\u0002\u000bM,W\r\u001a\u0011\u0002\u001f\u0011L7\u000f^1oG\u0016lU-Y:ve\u0016,\"!a\u000e\u0011\t\u0005e\u0012q\t\b\u0005\u0003w\t\u0019\u0005E\u0002\u0002>-l!!a\u0010\u000b\u0007\u0005\u0005s-\u0001\u0004=e>|GOP\u0005\u0004\u0003\u000bZ\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0002J\u0005-#AB*ue&twMC\u0002\u0002F-\f1\u0003Z5ti\u0006t7-Z'fCN,(/Z0%KF$2\u0001`A)\u0011%\t\tADA\u0001\u0002\u0004\t9$\u0001\teSN$\u0018M\\2f\u001b\u0016\f7/\u001e:fA\u00051A(\u001b8jiz\"B\"!\u0017\u0002^\u0005}\u0013\u0011MA2\u0003K\u00022!a\u0017\u0001\u001b\u0005i\u0006\"B;\u0011\u0001\u00049\bBBA\u0003!\u0001\u0007q\u000fC\u0004\u0002\u0010A\u0001\r!a\u0005\t\u000f\u0005\u0005\u0002\u00031\u0001\u0002&!9\u00111\u0007\tA\u0002\u0005]BCAA-Q\u0015\t\u00121NA<!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9C\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u0014q\u000e\u0002\u0006'&t7-Z\u0011\u0003\u0003s\nQ!\r\u00187]A\nAa]3u\u0017R!\u0011qPAA\u001b\u0005\u0001\u0001\"B;\u0013\u0001\u00049\b&\u0002\n\u0002l\u0005]\u0014\u0001B4fi.CSaEA6\u0003o\n\u0001c]3u\u001b\u0006D\u0018\n^3sCRLwN\\:\u0015\t\u0005}\u0014Q\u0012\u0005\u0007\u0003\u000b!\u0002\u0019A<)\u000bQ\tY'a\u001e\u0002!\u001d,G/T1y\u0013R,'/\u0019;j_:\u001c\b&B\u000b\u0002l\u0005]\u0014AG:fi6Kg\u000eR5wSNL'\r\\3DYV\u001cH/\u001a:TSj,G\u0003BA@\u00033Cq!a\u0004\u0017\u0001\u0004\t\u0019\u0002K\u0003\u0017\u0003W\n9(\u0001\u000ehKRl\u0015N\u001c#jm&\u001c\u0018N\u00197f\u00072,8\u000f^3s'&TX\rK\u0003\u0018\u0003W\n9(A\u0004tKR\u001cV-\u001a3\u0015\t\u0005}\u0014Q\u0015\u0005\b\u0003CA\u0002\u0019AA\u0013Q\u0015A\u00121NA<\u0003\u001d9W\r^*fK\u0012DS!GA6\u0003o\n!cZ3u\t&\u001cH/\u00198dK6+\u0017m];sK\"*!$a\u001b\u00022\u0006\u0012\u00111W\u0001\u0006e9\"d\u0006M\u0001\u0013g\u0016$H)[:uC:\u001cW-T3bgV\u0014X\r\u0006\u0003\u0002\u0000\u0005e\u0006bBA\u001a7\u0001\u0007\u0011q\u0007\u0015\u00067\u0005-\u0014\u0011W\u0001\u0004eVtGCBAa\u0003\u000f\f\u0019\u000f\u0005\u0003\u0002\\\u0005\r\u0017bAAc;\n!\")[:fGRLgnZ&NK\u0006t7/T8eK2Dq!!3\u001d\u0001\u0004\tY-A\u0003j]B,H\u000f\u0005\u0004\u0002N\u0006M\u0017q[\u0007\u0003\u0003\u001fT1!!5b\u0003\r\u0011H\rZ\u0005\u0005\u0003+\fyMA\u0002S\t\u0012\u0003B!!7\u0002`6\u0011\u00111\u001c\u0006\u0004\u0003;|\u0016A\u00027j]\u0006dw-\u0003\u0003\u0002b\u0006m'A\u0002,fGR|'\u000fC\u0004\u0002fr\u0001\r!a:\u0002\u000b%t7\u000f\u001e:\u0011\u000b)\fI/!<\n\u0007\u0005-8N\u0001\u0004PaRLwN\u001c\t\u0005\u0003_\fI0\u0004\u0002\u0002r*!\u00111_A{\u0003\u0011)H/\u001b7\u000b\u0007\u0005]\u0018-\u0001\u0002nY&!\u00111`Ay\u0005=Ien\u001d;sk6,g\u000e^1uS>tG\u0003BAa\u0003\u007fDq!!3\u001e\u0001\u0004\tY\rK\u0003\u001e\u0003W\n9\b\u0006\u0003\u0002B\n\u0015\u0001b\u0002B\u0004=\u0001\u0007!\u0011B\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0003\f\tU\u0011q[\u0007\u0003\u0005\u001bQAAa\u0004\u0003\u0012\u0005!!.\u0019<b\u0015\r\u0011\u0019\"Y\u0001\u0004CBL\u0017\u0002\u0002B\f\u0005\u001b\u0011qAS1wCJ#E\tK\u0003\u0001\u0003W\n9(A\bCSN,7\r^5oO.kU-\u00198t!\r\tY\u0006I\n\u0005A%\u0014\t\u0003E\u0002k\u0005GI1A!\nl\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0011i\"\u0001\u0006S\u001f>#v,\u0013(E\u000bb\u000b1BU(P)~Ke\nR#YA\u0005YR*\u0011-`\t&3\u0016jU%C\u0019\u0016{6\tT+T)\u0016\u0013v,\u0013(E\u000bb\u000bA$T!Y?\u0012Ke+S*J\u00052+ul\u0011'V'R+%kX%O\t\u0016C\u0006%A\u0006M\u000bZ+Ej\u0018'J\u001b&#\u0016\u0001\u0004'F-\u0016cu\fT%N\u0013R\u0003\u0013A\u00047fMR\u001c\u0005.\u001b7e\u0013:$W\r\u001f\u000b\u0005\u0003K\u0011I\u0004C\u0004\u0003<!\u0002\r!!\n\u0002\u000b%tG-\u001a=\u0002\u001fILw\r\u001b;DQ&dG-\u00138eKb$B!!\n\u0003B!9!1H\u0015A\u0002\u0005\u0015\u0012a\u00039be\u0016tG/\u00138eKb$B!!\n\u0003H!9!1\b\u0016A\u0002\u0005\u0015\u0012!C:v[6\f'/\u001b>f)!\u0011iE!=\u0003v\u000e\u0005\u0001\u0003CA\u001d\u0005\u001f\n)Ca\u0015\n\t\tE\u00131\n\u0002\u0004\u001b\u0006\u0004\bc\u0001B+\u00016\t\u0001E\u0001\bDYV\u001cH/\u001a:Tk6l\u0017M]=\u0014\r\u0001K'1\fB\u0011!\rQ'QL\u0005\u0004\u0005?Z'a\u0002)s_\u0012,8\r^\u0001\u0005g&TX-A\u0003tSj,\u0007%\u0001\u0004dK:$XM]\u000b\u0003\u0005S\u0002B!a\u0017\u0003l%\u0019!QN/\u0003\u001dY+7\r^8s/&$\bNT8s[\u000691-\u001a8uKJ\u0004\u0013\u0001B2pgR\fQaY8ti\u0002\"\u0002Ba\u0015\u0003x\te$1\u0010\u0005\b\u0005C:\u0005\u0019AA\u0013\u0011\u001d\u0011)g\u0012a\u0001\u0005SBqA!\u001dH\u0001\u0004\t\u0019\"\u0001\u0003d_BLH\u0003\u0003B*\u0005\u0003\u0013\u0019I!\"\t\u0013\t\u0005\u0004\n%AA\u0002\u0005\u0015\u0002\"\u0003B3\u0011B\u0005\t\u0019\u0001B5\u0011%\u0011\t\b\u0013I\u0001\u0002\u0004\t\u0019\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t-%\u0006BA\u0013\u0005\u001b[#Aa$\u0011\t\tE%\u0011T\u0007\u0003\u0005'SAA!&\u0003\u0018\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003cZ\u0017\u0002\u0002BN\u0005'\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"A!)+\t\t%$QR\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\u00119K\u000b\u0003\u0002\u0014\t5\u0015!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003.B!!q\u0016B\\\u001b\t\u0011\tL\u0003\u0003\u00034\nU\u0016\u0001\u00027b]\u001eT!Aa\u0004\n\t\u0005%#\u0011W\u0001\raJ|G-^2u\u0003JLG/_\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0011yL!2\u0011\u0007)\u0014\t-C\u0002\u0003D.\u00141!\u00118z\u0011!\t\tATA\u0001\u0002\u00049\u0018a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t-\u0007C\u0002Bg\u0005'\u0014y,\u0004\u0002\u0003P*\u0019!\u0011[6\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003V\n='\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa7\u0003bB\u0019!N!8\n\u0007\t}7NA\u0004C_>dW-\u00198\t\u0013\u0005\u0005\u0001+!AA\u0002\t}\u0016\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003]\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005[\u000ba!Z9vC2\u001cH\u0003\u0002Bn\u0005_D\u0011\"!\u0001T\u0003\u0003\u0005\rAa0\t\r\tM8\u00061\u0001x\u0003\u0005!\u0007b\u0002B|W\u0001\u0007!\u0011`\u0001\fCN\u001c\u0018n\u001a8nK:$8\u000f\u0005\u0004\u0002N\u0006M'1 \t\bU\nu\u0018Q\u0005B5\u0013\r\u0011yp\u001b\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005M2\u00061\u0001\u0004\u0004A!\u00111LB\u0003\u0013\r\u00199!\u0018\u0002\u0010\t&\u001cH/\u00198dK6+\u0017m];sK\nA2\t\\;ti\u0016\u00148+^7nCJL\u0018iZ4sK\u001e\fGo\u001c:\u0014\t1J'\u0011E\u0001\u0003I\u0002*\"aa\u0001\u0015\r\rM1QCB\f!\r\u0011)\u0006\f\u0005\u0007\u0005g\f\u0004\u0019A<\t\u000f\u0005M\u0012\u00071\u0001\u0004\u0004\u0005\ta.A\u0003o?\u0012*\u0017\u000fF\u0002}\u0007?A\u0011\"!\u00014\u0003\u0003\u0005\r!!\n\u0002\u00059\u0004\u0013aA:v[V\u0011\u0011q[\u0001\u0005gVl\u0007%A\u0003tk6\u001c\u0016/A\u0005tk6\u001c\u0016o\u0018\u0013fcR\u0019Apa\f\t\u0013\u0005\u0005\u0001(!AA\u0002\u0005M\u0011AB:v[N\u000b\b%A\u0002bI\u0012$Baa\u000e\u0004:5\tA\u0006C\u0004\u0004<i\u0002\rA!\u001b\u0002\u0003Y\fQ!\\3sO\u0016$Baa\u000e\u0004B!911I\u001eA\u0002\rM\u0011!B8uQ\u0016\u0014\u0018aB:v[6\f'/_\u000b\u0003\u0005'\n1b\u001d9mSR\u001cUM\u001c;feRA1QJB(\u0007#\u001ay\u0006E\u0004k\u0005{\u0014IG!\u001b\t\u000f\t\u0015T\b1\u0001\u0003j!911K\u001fA\u0002\rU\u0013A\u0002:b]\u0012|W\u000e\u0005\u0003\u0004X\rmSBAB-\u0015\u0011\t\u0019P!.\n\t\ru3\u0011\f\u0002\u0007%\u0006tGm\\7\t\u000f\u0005MR\b1\u0001\u0004\u0004\u0005\tR\u000f\u001d3bi\u0016\f5o]5h]6,g\u000e^:\u0015\u0015\te8QMB4\u0007c\u001a9\bC\u0004\u0003xz\u0002\rA!?\t\u000f\r%d\b1\u0001\u0004l\u0005\u0001B-\u001b<jg&\u0014G.Z%oI&\u001cWm\u001d\t\u0007\u0003s\u0019i'!\n\n\t\r=\u00141\n\u0002\u0004'\u0016$\bbBB:}\u0001\u00071QO\u0001\u0012]\u0016<8\t\\;ti\u0016\u00148)\u001a8uKJ\u001c\b\u0003CA\u001d\u0005\u001f\n)C!\u001b\t\u000f\u0005Mb\b1\u0001\u0004\u0004\u0005I!-^5mIR\u0013X-\u001a\u000b\u0007\u0007{\u001a\u0019ia\"\u0011\t\u0005m3qP\u0005\u0004\u0007\u0003k&AE\"mkN$XM]5oOR\u0013X-\u001a(pI\u0016Dqa!\"@\u0001\u0004\u0011i%\u0001\u0005dYV\u001cH/\u001a:t\u0011\u001d\t\u0019d\u0010a\u0001\u0007\u0007\tab\u00117vgR,'oU;n[\u0006\u0014\u0018\u0010E\u0002\u0003VU\u001bR!VBH\u0005C\u0001Bb!%\u0004\u0018\u0006\u0015\"\u0011NA\n\u0005'j!aa%\u000b\u0007\rU5.A\u0004sk:$\u0018.\\3\n\t\re51\u0013\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCABF\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011\u0019f!)\u0004$\u000e\u0015\u0006b\u0002B11\u0002\u0007\u0011Q\u0005\u0005\b\u0005KB\u0006\u0019\u0001B5\u0011\u001d\u0011\t\b\u0017a\u0001\u0003'\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004,\u000eM\u0006#\u00026\u0002j\u000e5\u0006#\u00036\u00040\u0006\u0015\"\u0011NA\n\u0013\r\u0019\tl\u001b\u0002\u0007)V\u0004H.Z\u001a\t\u0013\rU\u0016,!AA\u0002\tM\u0013a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\f\u0005\u0003\u00030\u000eu\u0016\u0002BB`\u0005c\u0013aa\u00142kK\u000e$\b")
public class BisectingKMeans
implements Logging {
    private int k;
    private int maxIterations;
    private double minDivisibleClusterSize;
    private long seed;
    private String distanceMeasure;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private double minDivisibleClusterSize() {
        return this.minDivisibleClusterSize;
    }

    private void minDivisibleClusterSize_$eq(double x$1) {
        this.minDivisibleClusterSize = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private String distanceMeasure() {
        return this.distanceMeasure;
    }

    private void distanceMeasure_$eq(String x$1) {
        this.distanceMeasure = x$1;
    }

    public BisectingKMeans setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("k must be positive but got ").append(k).append(".").toString());
        this.k_$eq(k);
        return this;
    }

    public int getK() {
        return this.k();
    }

    public BisectingKMeans setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("maxIterations must be positive but got ").append(maxIterations).append(".").toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public BisectingKMeans setMinDivisibleClusterSize(double minDivisibleClusterSize) {
        Predef$.MODULE$.require(minDivisibleClusterSize > 0.0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("minDivisibleClusterSize must be positive but got ").append(minDivisibleClusterSize).append(".").toString());
        this.minDivisibleClusterSize_$eq(minDivisibleClusterSize);
        return this;
    }

    public double getMinDivisibleClusterSize() {
        return this.minDivisibleClusterSize();
    }

    public BisectingKMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public String getDistanceMeasure() {
        return this.distanceMeasure();
    }

    public BisectingKMeans setDistanceMeasure(String distanceMeasure) {
        DistanceMeasure$.MODULE$.validateDistanceMeasure(distanceMeasure);
        this.distanceMeasure_$eq(distanceMeasure);
        return this;
    }

    public BisectingKMeansModel run(RDD<Vector> input, Option<Instrumentation> instr) {
        StorageLevel storageLevel = input.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(105).append("The input RDD ").append(input.id()).append(" is not directly cached, which may hurt performance if").append(" its parent RDDs are also not cached.").toString());
        }
        int d = BoxesRunTime.unboxToInt((Object)input.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.size()), ClassTag$.MODULE$.Int()).first());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Feature dimension: ").append(d).append(".").toString());
        DistanceMeasure dMeasure = DistanceMeasure$.MODULE$.decodeFromString(this.distanceMeasure());
        RDD norms = input.map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToDouble((double)Vectors$.MODULE$.norm(v, 2.0)), ClassTag$.MODULE$.Double()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
        RDD vectors = input.zip(norms, ClassTag$.MODULE$.Double()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Vector x = (Vector)tuple2._1();
            double norm = tuple2._2$mcD$sp();
            VectorWithNorm vectorWithNorm = new VectorWithNorm(x, norm);
            return vectorWithNorm;
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        ObjectRef assignments = ObjectRef.create((Object)vectors.map((Function1 & Serializable & scala.Serializable)v -> new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()), v), ClassTag$.MODULE$.apply(Tuple2.class)));
        ObjectRef activeClusters = ObjectRef.create(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), dMeasure));
        instr.foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.logNumExamples(BoxesRunTime.unboxToLong((Object)((TraversableOnce)((Map)activeClusters.elem).values().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.size()), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
            return BoxedUnit.UNIT;
        });
        ClusterSummary rootSummary = (ClusterSummary)((Map)activeClusters.elem).apply((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$ROOT_INDEX()));
        long n = rootSummary.size();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Number of points: ").append(n).append(".").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("Initial cost: ").append(rootSummary.cost()).append(".").toString());
        long minSize = this.minDivisibleClusterSize() >= 1.0 ? (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize()) : (long)scala.math.package$.MODULE$.ceil(this.minDivisibleClusterSize() * (double)n);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("The minimum number of points of a divisible cluster is ").append(minSize).append(".").toString());
        scala.collection.mutable.Seq inactiveClusters = (scala.collection.mutable.Seq)Seq$.MODULE$.empty();
        Random random = new Random(this.seed());
        int numLeafClustersNeeded = this.k() - 1;
        IntRef level = IntRef.create((int)1);
        RDD preIndices = null;
        RDD indices = null;
        while (((Map)activeClusters.elem).nonEmpty() && numLeafClustersNeeded > 0 && (double)level.elem < BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$LEVEL_LIMIT()) {
            Map divisibleClusters = (Map)((Map)activeClusters.elem).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)BisectingKMeans.$anonfun$run$12(minSize, x0$2)));
            if (divisibleClusters.size() > numLeafClustersNeeded) {
                divisibleClusters = ((TraversableOnce)((IterableLike)divisibleClusters.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToLong((long)BisectingKMeans.$anonfun$run$13(x0$3)), (Ordering)Ordering.Long$.MODULE$)).take(numLeafClustersNeeded)).toMap(Predef$.MODULE$.$conforms());
            }
            if (divisibleClusters.nonEmpty()) {
                Set divisibleIndices = divisibleClusters.keys().toSet();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Dividing ").append(divisibleIndices.size()).append(" clusters on level ").append(level$1.elem).append(".").toString());
                ObjectRef newClusterCenters = ObjectRef.create((Object)((Map)((TraversableLike)divisibleClusters.flatMap((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    Tuple2 tuple2;
                    long index;
                    Tuple2 tuple22 = x0$4;
                    if (tuple22 != null) {
                        index = tuple22._1$mcJ$sp();
                        ClusterSummary summary = (ClusterSummary)tuple22._2();
                        Tuple2<VectorWithNorm, VectorWithNorm> tuple23 = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$splitCenter(summary.center(), random, dMeasure);
                        if (tuple23 == null) {
                            throw new MatchError(tuple23);
                        }
                        VectorWithNorm left = (VectorWithNorm)tuple23._1();
                        VectorWithNorm right = (VectorWithNorm)tuple23._2();
                        tuple2 = new Tuple2((Object)left, (Object)right);
                    } else {
                        throw new MatchError((Object)tuple22);
                    }
                    Tuple2 tuple24 = tuple2;
                    VectorWithNorm left = (VectorWithNorm)tuple24._1();
                    VectorWithNorm right = (VectorWithNorm)tuple24._2();
                    Iterator iterator = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$leftChildIndex(index)), (Object)left), new Tuple2((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$rightChildIndex(index)), (Object)right)}));
                    return iterator;
                }, Map$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom())));
                ObjectRef newClusters = ObjectRef.create(null);
                ObjectRef newAssignments = ObjectRef.create(null);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.maxIterations()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)iter -> {
                    newAssignments$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments$1.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters$1.elem), dMeasure).filter((Function1 & Serializable & scala.Serializable)x0$5 -> BoxesRunTime.boxToBoolean((boolean)BisectingKMeans.$anonfun$run$18(divisibleIndices, x0$5)));
                    newClusters$1.elem = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$summarize(d, (RDD<Tuple2<Object, VectorWithNorm>>)((RDD)newAssignments$1.elem), dMeasure);
                    newClusterCenters$1.elem = (Map)((Map)newClusters$1.elem).mapValues((Function1 & Serializable & scala.Serializable)x$5 -> x$5.center()).map((Function1 & Serializable & scala.Serializable)x -> (Tuple2)Predef$.MODULE$.identity(x), Map$.MODULE$.canBuildFrom());
                });
                Object object = preIndices != null ? preIndices.unpersist(false) : BoxedUnit.UNIT;
                preIndices = indices;
                indices = RDD$.MODULE$.rddToPairRDDFunctions(BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$updateAssignments((RDD<Tuple2<Object, VectorWithNorm>>)((RDD)assignments.elem), (Set<Object>)divisibleIndices, (Map<Object, VectorWithNorm>)((Map)newClusterCenters.elem), dMeasure), ClassTag$.MODULE$.Long(), ClassTag$.MODULE$.apply(VectorWithNorm.class), (Ordering)Ordering.Long$.MODULE$).keys().persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                assignments.elem = indices.zip(vectors, ClassTag$.MODULE$.apply(VectorWithNorm.class));
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = (Map)newClusters.elem;
                numLeafClustersNeeded -= divisibleClusters.size();
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("None active and divisible clusters left on level ").append(level$1.elem).append(". Stop iterations.").toString());
                inactiveClusters = (scala.collection.mutable.Seq)inactiveClusters.$plus$plus((GenTraversableOnce)((Map)activeClusters.elem), Seq$.MODULE$.canBuildFrom());
                activeClusters.elem = Predef$.MODULE$.Map().empty();
            }
            ++level.elem;
        }
        Object object = preIndices != null ? preIndices.unpersist(false) : BoxedUnit.UNIT;
        Object object2 = indices != null ? indices.unpersist(false) : BoxedUnit.UNIT;
        norms.unpersist(false);
        Map clusters = ((Map)activeClusters.elem).$plus$plus((GenTraversableOnce)inactiveClusters);
        ClusteringTreeNode root = BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$buildTree((Map<Object, ClusterSummary>)clusters, dMeasure);
        return new BisectingKMeansModel(root, this.distanceMeasure());
    }

    public BisectingKMeansModel run(RDD<Vector> input) {
        return this.run(input, (Option<Instrumentation>)None$.MODULE$);
    }

    public BisectingKMeansModel run(JavaRDD<Vector> data) {
        return this.run((RDD<Vector>)data.rdd());
    }

    public static final /* synthetic */ boolean $anonfun$run$12(long minSize$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ClusterSummary summary = (ClusterSummary)tuple2._2();
        boolean bl = summary.size() >= minSize$1 && summary.cost() > MLUtils$.MODULE$.EPSILON() * (double)summary.size();
        return bl;
    }

    public static final /* synthetic */ long $anonfun$run$13(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ClusterSummary summary = (ClusterSummary)tuple2._2();
        long l = -summary.size();
        return l;
    }

    public static final /* synthetic */ boolean $anonfun$run$18(Set divisibleIndices$1, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long index = tuple2._1$mcJ$sp();
        boolean bl = divisibleIndices$1.contains((Object)BoxesRunTime.boxToLong((long)BisectingKMeans$.MODULE$.org$apache$spark$mllib$clustering$BisectingKMeans$$parentIndex(index)));
        return bl;
    }

    private BisectingKMeans(int k, int maxIterations, double minDivisibleClusterSize, long seed, String distanceMeasure) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.minDivisibleClusterSize = minDivisibleClusterSize;
        this.seed = seed;
        this.distanceMeasure = distanceMeasure;
        Logging.$init$((Logging)this);
    }

    public BisectingKMeans() {
        this(4, 20, 1.0, Statics.anyHash((Object)BisectingKMeans.class.getName()), DistanceMeasure$.MODULE$.EUCLIDEAN());
    }

    public static class ClusterSummary
    implements Product,
    scala.Serializable {
        private final long size;
        private final VectorWithNorm center;
        private final double cost;

        public long size() {
            return this.size;
        }

        public VectorWithNorm center() {
            return this.center;
        }

        public double cost() {
            return this.cost;
        }

        public ClusterSummary copy(long size, VectorWithNorm center, double cost) {
            return new ClusterSummary(size, center, cost);
        }

        public long copy$default$1() {
            return this.size();
        }

        public VectorWithNorm copy$default$2() {
            return this.center();
        }

        public double copy$default$3() {
            return this.cost();
        }

        public String productPrefix() {
            return "ClusterSummary";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this.size());
                    break;
                }
                case 1: {
                    object = this.center();
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToDouble((double)this.cost());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ClusterSummary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.size()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.center()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.cost()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ClusterSummary)) return false;
            boolean bl = true;
            if (!bl) return false;
            ClusterSummary clusterSummary = (ClusterSummary)x$1;
            if (this.size() != clusterSummary.size()) return false;
            VectorWithNorm vectorWithNorm = this.center();
            VectorWithNorm vectorWithNorm2 = clusterSummary.center();
            if (vectorWithNorm == null) {
                if (vectorWithNorm2 != null) {
                    return false;
                }
            } else if (!vectorWithNorm.equals(vectorWithNorm2)) return false;
            if (this.cost() != clusterSummary.cost()) return false;
            if (!clusterSummary.canEqual(this)) return false;
            return true;
        }

        public ClusterSummary(long size, VectorWithNorm center, double cost) {
            this.size = size;
            this.center = center;
            this.cost = cost;
            Product.$init$((Product)this);
        }
    }

    public static class ClusterSummaryAggregator
    implements scala.Serializable {
        private final int d;
        private final DistanceMeasure distanceMeasure;
        private long n;
        private final Vector sum;
        private double sumSq;

        public int d() {
            return this.d;
        }

        public DistanceMeasure distanceMeasure() {
            return this.distanceMeasure;
        }

        private long n() {
            return this.n;
        }

        private void n_$eq(long x$1) {
            this.n = x$1;
        }

        private Vector sum() {
            return this.sum;
        }

        private double sumSq() {
            return this.sumSq;
        }

        private void sumSq_$eq(double x$1) {
            this.sumSq = x$1;
        }

        public ClusterSummaryAggregator add(VectorWithNorm v) {
            this.n_$eq(this.n() + 1L);
            this.sumSq_$eq(this.sumSq() + v.norm() * v.norm());
            this.distanceMeasure().updateClusterSum(v, this.sum());
            return this;
        }

        public ClusterSummaryAggregator merge(ClusterSummaryAggregator other) {
            this.n_$eq(this.n() + other.n());
            this.sumSq_$eq(this.sumSq() + other.sumSq());
            this.distanceMeasure().updateClusterSum(new VectorWithNorm(other.sum()), this.sum());
            return this;
        }

        public ClusterSummary summary() {
            VectorWithNorm center = this.distanceMeasure().centroid(this.sum().copy(), this.n());
            double cost = this.distanceMeasure().clusterCost(center, new VectorWithNorm(this.sum()), this.n(), this.sumSq());
            return new ClusterSummary(this.n(), center, cost);
        }

        public ClusterSummaryAggregator(int d, DistanceMeasure distanceMeasure) {
            this.d = d;
            this.distanceMeasure = distanceMeasure;
            this.n = 0L;
            this.sum = Vectors$.MODULE$.zeros(d);
            this.sumSq = 0.0;
        }
    }
}

