/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.clustering.EMLDAOptimizer;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=h\u0001B\u001e=\u0001\u001dC\u0001\u0002\u0016\u0001\u0003\u0002\u0004%I!\u0016\u0005\t3\u0002\u0011\t\u0019!C\u00055\"A\u0001\r\u0001B\u0001B\u0003&a\u000b\u0003\u0005b\u0001\t\u0005\r\u0011\"\u0003V\u0011!\u0011\u0007A!a\u0001\n\u0013\u0019\u0007\u0002C3\u0001\u0005\u0003\u0005\u000b\u0015\u0002,\t\u0011\u0019\u0004!\u00111A\u0005\n\u001dD\u0001B\u001c\u0001\u0003\u0002\u0004%Ia\u001c\u0005\tc\u0002\u0011\t\u0011)Q\u0005Q\"A!\u000f\u0001BA\u0002\u0013%1\u000f\u0003\u0005x\u0001\t\u0005\r\u0011\"\u0003y\u0011!Q\bA!A!B\u0013!\b\u0002C>\u0001\u0005\u0003\u0007I\u0011\u0002?\t\u0015\u0005\u0005\u0001A!a\u0001\n\u0013\t\u0019\u0001C\u0005\u0002\b\u0001\u0011\t\u0011)Q\u0005{\"I\u0011\u0011\u0002\u0001\u0003\u0002\u0004%I!\u0016\u0005\u000b\u0003\u0017\u0001!\u00111A\u0005\n\u00055\u0001\"CA\t\u0001\t\u0005\t\u0015)\u0003W\u0011)\t\u0019\u0002\u0001BA\u0002\u0013%\u0011Q\u0003\u0005\u000b\u0003?\u0001!\u00111A\u0005\n\u0005\u0005\u0002BCA\u0013\u0001\t\u0005\t\u0015)\u0003\u0002\u0018!9\u0011q\u0005\u0001\u0005\n\u0005%\u0002bBA\u0014\u0001\u0011\u0005\u00111\b\u0005\u0007\u0003\u001f\u0002A\u0011A+\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V!1\u0011Q\f\u0001\u0005\u0002\u001dDa!!\u001a\u0001\t\u0003\u0019\bbBA5\u0001\u0011\u0005\u00111\u000e\u0005\b\u0003S\u0002A\u0011AA9\u0011\u0019\t9\b\u0001C\u0001O\"1\u00111\u0010\u0001\u0005\u0002MDq!a \u0001\t\u0003\t\t\tC\u0004\u0002\u0000\u0001!\t!!#\t\r\u0005=\u0005\u0001\"\u0001t\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Ca!a'\u0001\t\u0003\u0019\bbBAP\u0001\u0011\u0005\u0011\u0011\u0015\u0005\u0007\u0003S\u0003A\u0011A+\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"1\u0011Q\u0017\u0001\u0005\u0002qDq!!/\u0001\t\u0003\tY\f\u0003\u0004\u0002B\u0002!\t!\u0016\u0005\b\u0003\u000b\u0004A\u0011AAd\u0011\u001d\ti\r\u0001C\u0001\u0003+Aq!!8\u0001\t\u0003\ty\u000eC\u0004\u0002^\u0002!\t!!;\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n!9!q\u0001\u0001\u0005\u0002\t%r\u0001\u0003B'y!\u0005AHa\u0014\u0007\u000fmb\u0004\u0012\u0001\u001f\u0003R!9\u0011q\u0005\u001a\u0005\u0002\tMSa\u0002B+e\u0001a$qK\u0003\u0007\u0005K\u0012\u0004\u0001\u0010;\t\u0011\t\u001d$\u0007\"\u0001=\u0005SB\u0001Ba\u001c3\t\u0003a$\u0011\u000f\u0005\t\u0005o\u0012D\u0011\u0001\u001f\u0003z!A!\u0011\u0019\u001a\u0005\u0002q\u0012\u0019\r\u0003\u0005\u0003RJ\"\t\u0001\u0010Bj\u0005\raE)\u0011\u0006\u0003{y\n!b\u00197vgR,'/\u001b8h\u0015\ty\u0004)A\u0003nY2L'M\u0003\u0002B\u0005\u0006)1\u000f]1sW*\u00111\tR\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001%O!\tIE*D\u0001K\u0015\u0005Y\u0015!B:dC2\f\u0017BA'K\u0005\u0019\te.\u001f*fMB\u0011qJU\u0007\u0002!*\u0011\u0011\u000bQ\u0001\tS:$XM\u001d8bY&\u00111\u000b\u0015\u0002\b\u0019><w-\u001b8h\u0003\u0005YW#\u0001,\u0011\u0005%;\u0016B\u0001-K\u0005\rIe\u000e^\u0001\u0006W~#S-\u001d\u000b\u00037z\u0003\"!\u0013/\n\u0005uS%\u0001B+oSRDqa\u0018\u0002\u0002\u0002\u0003\u0007a+A\u0002yIE\n!a\u001b\u0011\u0002\u001b5\f\u00070\u0013;fe\u0006$\u0018n\u001c8t\u0003Ei\u0017\r_%uKJ\fG/[8og~#S-\u001d\u000b\u00037\u0012DqaX\u0003\u0002\u0002\u0003\u0007a+\u0001\bnCbLE/\u001a:bi&|gn\u001d\u0011\u0002!\u0011|7mQ8oG\u0016tGO]1uS>tW#\u00015\u0011\u0005%dW\"\u00016\u000b\u0005-t\u0014A\u00027j]\u0006dw-\u0003\u0002nU\n1a+Z2u_J\fA\u0003Z8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8`I\u0015\fHCA.q\u0011\u001dy\u0006\"!AA\u0002!\f\u0011\u0003Z8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8!\u0003I!x\u000e]5d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\u0016\u0003Q\u0004\"!S;\n\u0005YT%A\u0002#pk\ndW-\u0001\fu_BL7mQ8oG\u0016tGO]1uS>tw\fJ3r)\tY\u0016\u0010C\u0004`\u0017\u0005\u0005\t\u0019\u0001;\u0002'Q|\u0007/[2D_:\u001cWM\u001c;sCRLwN\u001c\u0011\u0002\tM,W\rZ\u000b\u0002{B\u0011\u0011J`\u0005\u0003\u007f*\u0013A\u0001T8oO\u0006A1/Z3e?\u0012*\u0017\u000fF\u0002\\\u0003\u000bAqa\u0018\b\u0002\u0002\u0003\u0007Q0A\u0003tK\u0016$\u0007%\u0001\ndQ\u0016\u001c7\u000e]8j]RLe\u000e^3sm\u0006d\u0017AF2iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2|F%Z9\u0015\u0007m\u000by\u0001C\u0004`#\u0005\u0005\t\u0019\u0001,\u0002'\rDWmY6q_&tG/\u00138uKJ4\u0018\r\u001c\u0011\u0002\u00191$\u0017m\u00149uS6L'0\u001a:\u0016\u0005\u0005]\u0001\u0003BA\r\u00037i\u0011\u0001P\u0005\u0004\u0003;a$\u0001\u0004'E\u0003>\u0003H/[7ju\u0016\u0014\u0018\u0001\u00057eC>\u0003H/[7ju\u0016\u0014x\fJ3r)\rY\u00161\u0005\u0005\t?R\t\t\u00111\u0001\u0002\u0018\u0005iA\u000eZ1PaRLW.\u001b>fe\u0002\na\u0001P5oSRtD\u0003EA\u0016\u0003[\ty#!\r\u00024\u0005U\u0012qGA\u001d!\r\tI\u0002\u0001\u0005\u0006)Z\u0001\rA\u0016\u0005\u0006CZ\u0001\rA\u0016\u0005\u0006MZ\u0001\r\u0001\u001b\u0005\u0006eZ\u0001\r\u0001\u001e\u0005\u0006wZ\u0001\r! \u0005\u0007\u0003\u00131\u0002\u0019\u0001,\t\u000f\u0005Ma\u00031\u0001\u0002\u0018Q\u0011\u00111\u0006\u0015\u0006/\u0005}\u00121\n\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t!\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002J\u0005\r#!B*j]\u000e,\u0017EAA'\u0003\u0015\tdf\r\u00181\u0003\u00119W\r^&)\u000ba\ty$a\u0013\u0002\tM,Go\u0013\u000b\u0005\u0003/\nI&D\u0001\u0001\u0011\u0015!\u0016\u00041\u0001WQ\u0015I\u0012qHA&\u0003u9W\r^!ts6lW\r\u001e:jG\u0012{7mQ8oG\u0016tGO]1uS>t\u0007&\u0002\u000e\u0002@\u0005\u0005\u0014EAA2\u0003\u0015\td&\u000e\u00181\u0003M9W\r\u001e#pG\u000e{gnY3oiJ\fG/[8oQ\u0015Y\u0012qHA&\u0003M\u0019X\r\u001e#pG\u000e{gnY3oiJ\fG/[8o)\u0011\t9&!\u001c\t\u000b\u0019d\u0002\u0019\u00015)\u000bq\ty$!\u0019\u0015\t\u0005]\u00131\u000f\u0005\u0006Mv\u0001\r\u0001\u001e\u0015\u0006;\u0005}\u00121J\u0001\u0013O\u0016$\u0018i]=n[\u0016$(/[2BYBD\u0017\rK\u0003\u001f\u0003\u007f\t\t'\u0001\u0005hKR\fE\u000e\u001d5bQ\u0015y\u0012qHA&\u0003!\u0019X\r^!ma\"\fG\u0003BA,\u0003\u0007Ca!!\"!\u0001\u0004A\u0017!B1ma\"\f\u0007&\u0002\u0011\u0002@\u0005\u0005D\u0003BA,\u0003\u0017Ca!!\"\"\u0001\u0004!\b&B\u0011\u0002@\u0005-\u0013!F4fiR{\u0007/[2D_:\u001cWM\u001c;sCRLwN\u001c\u0015\u0006E\u0005}\u00121J\u0001\u0016g\u0016$Hk\u001c9jG\u000e{gnY3oiJ\fG/[8o)\u0011\t9&a&\t\u000bI\u001c\u0003\u0019\u0001;)\u000b\r\ny$a\u0013\u0002\u000f\u001d,GOQ3uC\"*A%a\u0010\u0002L\u000591/\u001a;CKR\fG\u0003BA,\u0003GCa!!*&\u0001\u0004!\u0018\u0001\u00022fi\u0006DS!JA \u0003\u0017\n\u0001cZ3u\u001b\u0006D\u0018\n^3sCRLwN\\:)\u000b\u0019\ny$a\u0013\u0002!M,G/T1y\u0013R,'/\u0019;j_:\u001cH\u0003BA,\u0003cCQ!Y\u0014A\u0002YCSaJA \u0003\u0017\nqaZ3u'\u0016,G\rK\u0003)\u0003\u007f\tY%A\u0004tKR\u001cV-\u001a3\u0015\t\u0005]\u0013Q\u0018\u0005\u0006w&\u0002\r! \u0015\u0006S\u0005}\u00121J\u0001\u0016O\u0016$8\t[3dWB|\u0017N\u001c;J]R,'O^1mQ\u0015Q\u0013qHA&\u0003U\u0019X\r^\"iK\u000e\\\u0007o\\5oi&sG/\u001a:wC2$B!a\u0016\u0002J\"1\u0011\u0011B\u0016A\u0002YCSaKA \u0003\u0017\nAbZ3u\u001fB$\u0018.\\5{KJD3\u0001LAi!\u0011\t\t%a5\n\t\u0005U\u00171\t\u0002\r\t\u00164X\r\\8qKJ\f\u0005/\u001b\u0015\u0006Y\u0005}\u0012\u0011\\\u0011\u0003\u00037\fQ!\r\u00185]A\nAb]3u\u001fB$\u0018.\\5{KJ$B!a\u0016\u0002b\"9\u00111]\u0017A\u0002\u0005]\u0011!C8qi&l\u0017N_3sQ\ri\u0013\u0011\u001b\u0015\u0006[\u0005}\u0012\u0011\u001c\u000b\u0005\u0003/\nY\u000fC\u0004\u0002n:\u0002\r!a<\u0002\u001b=\u0004H/[7ju\u0016\u0014h*Y7f!\u0011\t\t0a@\u000f\t\u0005M\u00181 \t\u0004\u0003kTUBAA|\u0015\r\tIPR\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005u(*\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u0003\u0011\u0019A\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003{T\u0005&\u0002\u0018\u0002@\u0005e\u0017a\u0001:v]R!!1\u0002B\t!\u0011\tIB!\u0004\n\u0007\t=AH\u0001\u0005M\t\u0006ku\u000eZ3m\u0011\u001d\u0011\u0019b\fa\u0001\u0005+\t\u0011\u0002Z8dk6,g\u000e^:\u0011\r\t]!Q\u0004B\u0011\u001b\t\u0011IBC\u0002\u0003\u001c\u0001\u000b1A\u001d3e\u0013\u0011\u0011yB!\u0007\u0003\u0007I#E\tE\u0003J\u0005Gi\b.C\u0002\u0003&)\u0013a\u0001V;qY\u0016\u0014\u0004&B\u0018\u0002@\u0005-C\u0003\u0002B\u0006\u0005WAqAa\u00051\u0001\u0004\u0011i\u0003E\u0004\u00030\te\"Q\b5\u000e\u0005\tE\"\u0002\u0002B\u001a\u0005k\tAA[1wC*\u0019!q\u0007!\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003<\tE\"a\u0003&bm\u0006\u0004\u0016-\u001b:S\t\u0012\u0003BAa\u0010\u0003H5\u0011!\u0011\t\u0006\u0005\u0005\u0007\u0012)%\u0001\u0003mC:<'B\u0001B\u001a\u0013\ry(\u0011\t\u0015\u0006a\u0005}\u00121\n\u0015\u0006\u0001\u0005}\u00121J\u0001\u0004\u0019\u0012\u000b\u0005cAA\reM\u0011!\u0007\u0013\u000b\u0003\u0005\u001f\u00121\u0002V8qS\u000e\u001cu.\u001e8ugB)!\u0011\fB1i6\u0011!1\f\u0006\u0004W\nu#B\u0001B0\u0003\u0019\u0011'/Z3{K&!!1\rB.\u0005-!UM\\:f-\u0016\u001cGo\u001c:\u0003\u0015Q{7.\u001a8D_VtG/\u0001\u0006uKJl''\u001b8eKb$2! B6\u0011\u0019\u0011iG\u000ea\u0001-\u0006!A/\u001a:n\u0003)Ig\u000eZ3yeQ,'/\u001c\u000b\u0004-\nM\u0004B\u0002B;o\u0001\u0007Q0A\u0005uKJl\u0017J\u001c3fq\u0006\u0001\u0012n\u001d#pGVlWM\u001c;WKJ$X\r\u001f\u000b\u0005\u0005w\u0012\t\tE\u0002J\u0005{J1Aa K\u0005\u001d\u0011un\u001c7fC:DqAa!9\u0001\u0004\u0011))A\u0001wa\u0011\u00119Ia,\u0011\u000f%\u0013\u0019C!#\u0003,B!!1\u0012BS\u001d\u0011\u0011iIa(\u000f\t\t=%1\u0014\b\u0005\u0005#\u0013IJ\u0004\u0003\u0003\u0014\n]e\u0002BA{\u0005+K\u0011!R\u0005\u0003\u0007\u0012K!!\u0011\"\n\u0007\tu\u0005)\u0001\u0004he\u0006\u0004\b\u000e_\u0005\u0005\u0005C\u0013\u0019+A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\tu\u0005)\u0003\u0003\u0003(\n%&\u0001\u0003,feR,\u00070\u00133\u000b\t\t\u0005&1\u0015\t\u0005\u0005[\u0013y\u000b\u0004\u0001\u0005\u0019\tE&\u0011QA\u0001\u0002\u0003\u0015\tAa-\u0003\u0007}#\u0013'\u0005\u0003\u00036\nm\u0006cA%\u00038&\u0019!\u0011\u0018&\u0003\u000f9{G\u000f[5oOB\u0019\u0011J!0\n\u0007\t}&JA\u0002B]f\fA\"[:UKJlg+\u001a:uKb$BAa\u001f\u0003F\"9!1Q\u001dA\u0002\t\u001d\u0007\u0007\u0002Be\u0005\u001b\u0004r!\u0013B\u0012\u0005\u0013\u0013Y\r\u0005\u0003\u0003.\n5G\u0001\u0004Bh\u0005\u000b\f\t\u0011!A\u0003\u0002\tM&aA0%e\u0005i1m\\7qkR,\u0007\u000bV8qS\u000e$bB!6\u0003Z\nu'\u0011\u001dBs\u0005S\u0014i\u000fE\u0002\u0003XRj\u0011A\r\u0005\b\u00057T\u0004\u0019\u0001Bk\u00039!wn\u0019+pa&\u001c7i\\;oiNDqAa8;\u0001\u0004\u0011).A\buKJlGk\u001c9jG\u000e{WO\u001c;t\u0011\u001d\u0011\u0019O\u000fa\u0001\u0005+\f\u0001\u0003^8uC2$v\u000e]5d\u0007>,h\u000e^:\t\r\t\u001d(\b1\u0001W\u0003%1xnY1c'&TX\r\u0003\u0004\u0003lj\u0002\r\u0001^\u0001\u0004KR\f\u0007BBACu\u0001\u0007A\u000f")
public class LDA
implements Logging {
    private int k;
    private int maxIterations;
    private Vector docConcentration;
    private double topicConcentration;
    private long seed;
    private int checkpointInterval;
    private LDAOptimizer ldaOptimizer;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private Vector docConcentration() {
        return this.docConcentration;
    }

    private void docConcentration_$eq(Vector x$1) {
        this.docConcentration = x$1;
    }

    private double topicConcentration() {
        return this.topicConcentration;
    }

    private void topicConcentration_$eq(double x$1) {
        this.topicConcentration = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    private int checkpointInterval() {
        return this.checkpointInterval;
    }

    private void checkpointInterval_$eq(int x$1) {
        this.checkpointInterval = x$1;
    }

    private LDAOptimizer ldaOptimizer() {
        return this.ldaOptimizer;
    }

    private void ldaOptimizer_$eq(LDAOptimizer x$1) {
        this.ldaOptimizer = x$1;
    }

    public int getK() {
        return this.k();
    }

    public LDA setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("LDA k (number of clusters) must be > 0, but was set to ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public Vector getAsymmetricDocConcentration() {
        return this.docConcentration();
    }

    /*
     * WARNING - void declaration
     */
    public double getDocConcentration() {
        double d;
        double parameter = this.docConcentration().apply(0);
        if (this.docConcentration().size() == 1) {
            d = parameter;
        } else {
            void var1_1;
            Predef$.MODULE$.require(new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.docConcentration().toArray())).forall((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 == parameter));
            d = var1_1;
        }
        return d;
    }

    public LDA setDocConcentration(Vector docConcentration) {
        Predef$.MODULE$.require(docConcentration.size() == 1 || docConcentration.size() == this.k(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Size of docConcentration must be 1 or ").append(this.k()).append(" but got ").append(docConcentration.size()).toString());
        this.docConcentration_$eq(docConcentration);
        return this;
    }

    public LDA setDocConcentration(double docConcentration) {
        this.docConcentration_$eq(Vectors$.MODULE$.dense(docConcentration, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])));
        return this;
    }

    public Vector getAsymmetricAlpha() {
        return this.getAsymmetricDocConcentration();
    }

    public double getAlpha() {
        return this.getDocConcentration();
    }

    public LDA setAlpha(Vector alpha) {
        return this.setDocConcentration(alpha);
    }

    public LDA setAlpha(double alpha) {
        return this.setDocConcentration(alpha);
    }

    public double getTopicConcentration() {
        return this.topicConcentration();
    }

    public LDA setTopicConcentration(double topicConcentration) {
        this.topicConcentration_$eq(topicConcentration);
        return this;
    }

    public double getBeta() {
        return this.getTopicConcentration();
    }

    public LDA setBeta(double beta) {
        return this.setTopicConcentration(beta);
    }

    public int getMaxIterations() {
        return this.maxIterations();
    }

    public LDA setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public LDA setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    public int getCheckpointInterval() {
        return this.checkpointInterval();
    }

    public LDA setCheckpointInterval(int checkpointInterval) {
        Predef$.MODULE$.require(checkpointInterval == -1 || checkpointInterval > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Period between checkpoints must be -1 or positive but got ").append(checkpointInterval).toString());
        this.checkpointInterval_$eq(checkpointInterval);
        return this;
    }

    @DeveloperApi
    public LDAOptimizer getOptimizer() {
        return this.ldaOptimizer();
    }

    @DeveloperApi
    public LDA setOptimizer(LDAOptimizer optimizer) {
        this.ldaOptimizer_$eq(optimizer);
        return this;
    }

    public LDA setOptimizer(String optimizerName) {
        LDAOptimizer lDAOptimizer;
        String string = optimizerName.toLowerCase(Locale.ROOT);
        if ("em".equals(string)) {
            lDAOptimizer = new EMLDAOptimizer();
        } else if ("online".equals(string)) {
            lDAOptimizer = new OnlineLDAOptimizer();
        } else {
            throw new IllegalArgumentException(new StringBuilder(39).append("Only em, online are supported but got ").append(string).append(".").toString());
        }
        this.ldaOptimizer_$eq(lDAOptimizer);
        return this;
    }

    public LDAModel run(RDD<Tuple2<Object, Vector>> documents) {
        LDAOptimizer state = this.ldaOptimizer().initialize(documents, this);
        double[] iterationTimes = (double[])Array$.MODULE$.fill(this.maxIterations(), (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        for (int iter = 0; iter < this.maxIterations(); ++iter) {
            double elapsedSeconds;
            long start = System.nanoTime();
            state.next();
            iterationTimes[iter] = elapsedSeconds = (double)(System.nanoTime() - start) / 1.0E9;
        }
        return state.getLDAModel(iterationTimes);
    }

    public LDAModel run(JavaPairRDD<Long, Vector> documents) {
        return this.run((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private LDA(int k, int maxIterations, Vector docConcentration, double topicConcentration, long seed, int checkpointInterval, LDAOptimizer ldaOptimizer) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.seed = seed;
        this.checkpointInterval = checkpointInterval;
        this.ldaOptimizer = ldaOptimizer;
        Logging.$init$((Logging)this);
    }

    public LDA() {
        this(10, 20, Vectors$.MODULE$.dense(-1.0, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[0])), -1.0, Utils$.MODULE$.random().nextLong(), 10, new EMLDAOptimizer());
    }
}

