/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.generic.UFunc;
import breeze.linalg.$times$;
import breeze.linalg.Broadcaster$;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseMatrix$;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor$;
import breeze.linalg.Transpose$;
import breeze.linalg.normalize$;
import breeze.linalg.package;
import breeze.linalg.sum$;
import breeze.numerics.package;
import breeze.storage.Zero;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaPairRDD$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.LDAModel;
import org.apache.spark.mllib.clustering.LDAUtils$;
import org.apache.spark.mllib.clustering.LocalLDAModel$;
import org.apache.spark.mllib.clustering.LocalLDAModel$SaveLoadV1_0$;
import org.apache.spark.mllib.clustering.OnlineLDAOptimizer$;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\r=c\u0001B#G\u0001EC\u0001\u0002\u0018\u0001\u0003\u0006\u0004%\t!\u0018\u0005\t[\u0002\u0011\t\u0011)A\u0005=\"Aq\u000e\u0001BC\u0002\u0013\u0005\u0003\u000f\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003r\u0011!I\bA!b\u0001\n\u0003R\b\u0002C@\u0001\u0005\u0003\u0005\u000b\u0011B>\t\u0015\u0005\r\u0001A!b\u0001\n#R%\u0010C\u0005\u0002\u0006\u0001\u0011\t\u0011)A\u0005w\"A\u0011q\u0001\u0001\u0005\u0002)\u000bI\u0001C\u0005\u0002\u001c\u0001\u0001\r\u0011\"\u0003\u0002\u001e!I\u0011Q\u0005\u0001A\u0002\u0013%\u0011q\u0005\u0005\t\u0003g\u0001\u0001\u0015)\u0003\u0002 !9\u0011Q\u0007\u0001\u0005B\u0005]\u0002bBA!\u0001\u0011\u0005\u0013q\u0007\u0005\u0007\u0003\u000b\u0002A\u0011I/\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L!9\u00111\r\u0001\u0005R\u0005\u0015\u0004bBA<\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003\u007f\u0002A\u0011AAA\u0011\u001d\tI\t\u0001C!\u0003\u0017Cq!a-\u0001\t\u0003\t)\fC\u0004\u00024\u0002!\t!a3\t\u000f\u0005\r\b\u0001\"\u0001\u0002f\"9\u00111\u001d\u0001\u0005\u0002\u0005-\bbBAy\u0001\u0011%\u00111\u001f\u0005\b\u0005/\u0001A\u0011\u0001B\r\u0011!\u0011y\u0002\u0001C\u0001\u0015\n\u0005\u0002b\u0002B\u0015\u0001\u0011\u0005!1\u0006\u0005\b\u0005/\u0001A\u0011\u0001B\u001c\u000f\u001d\u0011\u0019E\u0012E\u0001\u0005\u000b2a!\u0012$\t\u0002\t\u001d\u0003bBA\u0004?\u0011\u0005!1L\u0004\b\u0005;z\u0002\u0012\u0002B0\r\u001d\u0011\u0019g\bE\u0005\u0005KBq!a\u0002#\t\u0003\u00119\u0007C\u0005\u0003j\t\u0012\r\u0011\"\u0001\u0002f!A!1\u000e\u0012!\u0002\u0013\t9\u0007C\u0005\u0003n\t\u0012\r\u0011\"\u0001\u0002f!A!q\u000e\u0012!\u0002\u0013\t9G\u0002\u0004\u0003r\t\u0002%1\u000f\u0005\n\u0005wB#Q3A\u0005\u0002AD\u0011B! )\u0005#\u0005\u000b\u0011B9\t\u0015\t}\u0004F!f\u0001\n\u0003\t9\u0004\u0003\u0006\u0003\u0002\"\u0012\t\u0012)A\u0005\u0003sAq!a\u0002)\t\u0003\u0011\u0019\tC\u0005\u0003\u000e\"\n\t\u0011\"\u0001\u0003\u0010\"I!Q\u0013\u0015\u0012\u0002\u0013\u0005!q\u0013\u0005\n\u0005WC\u0013\u0013!C\u0001\u0005[C\u0011B!-)\u0003\u0003%\t%!\u001a\t\u0013\tM\u0006&!A\u0005\u0002\u0005]\u0002\"\u0003B[Q\u0005\u0005I\u0011\u0001B\\\u0011%\u0011\t\rKA\u0001\n\u0003\u0012\u0019\rC\u0005\u0003R\"\n\t\u0011\"\u0001\u0003T\"I!Q\u001c\u0015\u0002\u0002\u0013\u0005#q\u001c\u0005\n\u0005CD\u0013\u0011!C!\u0005GD\u0011B!:)\u0003\u0003%\tEa:\b\u0013\t-(%!A\t\u0002\t5h!\u0003B9E\u0005\u0005\t\u0012\u0001Bx\u0011\u001d\t9A\u000fC\u0001\u0005{D\u0011B!9;\u0003\u0003%)Ea9\t\u0013\t}((!A\u0005\u0002\u000e\u0005\u0001\"CB\u0004u\u0005\u0005I\u0011QB\u0005\u0011%\u00199BOA\u0001\n\u0013\u0019I\u0002C\u0004\u0002\n\n\"\ta!\t\t\u000f\r=\"\u0005\"\u0001\u00042!91qF\u0010\u0005B\ru\u0002BCB#?E\u0005I\u0011\u0001&\u0004H!I1qC\u0010\u0002\u0002\u0013%1\u0011\u0004\u0002\u000e\u0019>\u001c\u0017\r\u001c'E\u00036{G-\u001a7\u000b\u0005\u001dC\u0015AC2mkN$XM]5oO*\u0011\u0011JS\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u00172\u000bQa\u001d9be.T!!\u0014(\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0015aA8sO\u000e\u00011c\u0001\u0001S-B\u00111\u000bV\u0007\u0002\r&\u0011QK\u0012\u0002\t\u0019\u0012\u000bUj\u001c3fYB\u0011qKW\u0007\u00021*\t\u0011,A\u0003tG\u0006d\u0017-\u0003\u0002\\1\na1+\u001a:jC2L'0\u00192mK\u00061Ao\u001c9jGN,\u0012A\u0018\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C\"\u000ba\u0001\\5oC2<\u0017BA2a\u0005\u0019i\u0015\r\u001e:jq\"\u001a\u0011!Z6\u0011\u0005\u0019LW\"A4\u000b\u0005!T\u0015AC1o]>$\u0018\r^5p]&\u0011!n\u001a\u0002\u0006'&t7-Z\u0011\u0002Y\u0006)\u0011GL\u001a/a\u00059Ao\u001c9jGN\u0004\u0003f\u0001\u0002fW\u0006\u0001Bm\\2D_:\u001cWM\u001c;sCRLwN\\\u000b\u0002cB\u0011qL]\u0005\u0003g\u0002\u0014aAV3di>\u0014\bfA\u0002fk\u0006\na/A\u00032]Ur\u0003'A\te_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\u0002B3\u0001B3v\u0003I!x\u000e]5d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\u0016\u0003m\u0004\"a\u0016?\n\u0005uD&A\u0002#pk\ndW\rK\u0002\u0006KV\f1\u0003^8qS\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]\u0002B3AB3v\u0003)9\u0017-\\7b'\"\f\u0007/Z\u0001\fO\u0006lW.Y*iCB,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u000b\u0003\u0017\ti!!\u0005\u0002\u0016\u0005e\u0001CA*\u0001\u0011\u0015a\u0016\u00021\u0001_Q\u0011\ti!Z6\t\u000b=L\u0001\u0019A9)\t\u0005EQ-\u001e\u0005\u0006s&\u0001\ra\u001f\u0015\u0005\u0003+)W\u000f\u0003\u0005\u0002\u0004%\u0001\n\u00111\u0001|\u0003\u0011\u0019X-\u001a3\u0016\u0005\u0005}\u0001cA,\u0002\"%\u0019\u00111\u0005-\u0003\t1{gnZ\u0001\tg\u0016,Gm\u0018\u0013fcR!\u0011\u0011FA\u0018!\r9\u00161F\u0005\u0004\u0003[A&\u0001B+oSRD\u0011\"!\r\f\u0003\u0003\u0005\r!a\b\u0002\u0007a$\u0013'A\u0003tK\u0016$\u0007%A\u0001l+\t\tI\u0004E\u0002X\u0003wI1!!\u0010Y\u0005\rIe\u000e\u001e\u0015\u0004\u001b\u0015\\\u0017!\u0003<pG\u0006\u00147+\u001b>fQ\rqQm[\u0001\ri>\u0004\u0018nY:NCR\u0014\u0018\u000e\u001f\u0015\u0004\u001f\u0015\\\u0017A\u00043fg\u000e\u0014\u0018NY3U_BL7m\u001d\u000b\u0005\u0003\u001b\ni\u0006E\u0003X\u0003\u001f\n\u0019&C\u0002\u0002Ra\u0013Q!\u0011:sCf\u0004raVA+\u00033\nY&C\u0002\u0002Xa\u0013a\u0001V;qY\u0016\u0014\u0004#B,\u0002P\u0005e\u0002\u0003B,\u0002PmDq!a\u0018\u0011\u0001\u0004\tI$\u0001\tnCb$VM]7t!\u0016\u0014Hk\u001c9jG\"\u001a\u0001#Z6\u0002\u001b\u0019|'/\\1u-\u0016\u00148/[8o+\t\t9\u0007\u0005\u0003\u0002j\u0005MTBAA6\u0015\u0011\ti'a\u001c\u0002\t1\fgn\u001a\u0006\u0003\u0003c\nAA[1wC&!\u0011QOA6\u0005\u0019\u0019FO]5oO\u00069q-\u001a;TK\u0016$\u0007\u0006\u0002\nf\u0003w\n#!! \u0002\u000bIrCG\f\u0019\u0002\u000fM,GoU3fIR!\u00111QAC\u001b\u0005\u0001\u0001bBA\u000e'\u0001\u0007\u0011q\u0004\u0015\u0005'\u0015\fY(\u0001\u0003tCZ,GCBA\u0015\u0003\u001b\u000bI\nC\u0004\u0002\u0010R\u0001\r!!%\u0002\u0005M\u001c\u0007\u0003BAJ\u0003+k\u0011AS\u0005\u0004\u0003/S%\u0001D*qCJ\\7i\u001c8uKb$\bbBAN)\u0001\u0007\u0011QT\u0001\u0005a\u0006$\b\u000e\u0005\u0003\u0002 \u00065f\u0002BAQ\u0003S\u00032!a)Y\u001b\t\t)KC\u0002\u0002(B\u000ba\u0001\u0010:p_Rt\u0014bAAV1\u00061\u0001K]3eK\u001aLA!!\u001e\u00020*\u0019\u00111\u0016-)\u0007Q)W/A\u0007m_\u001ed\u0015n[3mS\"|w\u000e\u001a\u000b\u0004w\u0006]\u0006bBA]+\u0001\u0007\u00111X\u0001\nI>\u001cW/\\3oiN\u0004b!!0\u0002D\u0006\u001dWBAA`\u0015\r\t\tMS\u0001\u0004e\u0012$\u0017\u0002BAc\u0003\u007f\u00131A\u0015#E!\u00199\u0016QKA\u0010c\"\u001aQ#Z;\u0015\u0007m\fi\rC\u0004\u0002:Z\u0001\r!a4\u0011\u000f\u0005E\u0017\u0011\\Aoc6\u0011\u00111\u001b\u0006\u0005\u0003c\n)NC\u0002\u0002X*\u000b1!\u00199j\u0013\u0011\tY.a5\u0003\u0017)\u000bg/\u0019)bSJ\u0014F\t\u0012\t\u0005\u0003S\ny.\u0003\u0003\u0002$\u0005-\u0004f\u0001\ffk\u0006iAn\\4QKJ\u0004H.\u001a=jif$2a_At\u0011\u001d\tIl\u0006a\u0001\u0003wC3aF3v)\rY\u0018Q\u001e\u0005\b\u0003sC\u0002\u0019AAhQ\rAR-^\u0001\u0013Y><G*[6fY&Dwn\u001c3C_VtG\rF\b|\u0003k\f90a?\u0002\u0000\nE!1\u0003B\u000b\u0011\u001d\tI,\u0007a\u0001\u0003wCa!!?\u001a\u0001\u0004\t\u0018!B1ma\"\f\u0007BBA\u007f3\u0001\u000710A\u0002fi\u0006DqA!\u0001\u001a\u0001\u0004\u0011\u0019!\u0001\u0004mC6\u0014G-\u0019\t\u0006\u0005\u000b\u0011ia_\u0007\u0003\u0005\u000fQ1!\u0019B\u0005\u0015\t\u0011Y!\u0001\u0004ce\u0016,'0Z\u0005\u0005\u0005\u001f\u00119AA\u0006EK:\u001cX-T1ue&D\bBBA\u00023\u0001\u00071\u0010C\u0004\u00026e\u0001\r!!\u000f\t\u000f\u0005\u0005\u0013\u00041\u0001\u0002 \u0005\u0011Bo\u001c9jG\u0012K7\u000f\u001e:jEV$\u0018n\u001c8t)\u0011\tYLa\u0007\t\u000f\u0005e&\u00041\u0001\u0002<\"\u001a!$Z6\u00025\u001d,G\u000fV8qS\u000e$\u0015n\u001d;sS\n,H/[8o\u001b\u0016$\bn\u001c3\u0016\u0005\t\r\u0002#B,\u0003&E\f\u0018b\u0001B\u00141\nIa)\u001e8di&|g.M\u0001\u0012i>\u0004\u0018n\u0019#jgR\u0014\u0018NY;uS>tGcA9\u0003.!1!q\u0006\u000fA\u0002E\f\u0001\u0002Z8dk6,g\u000e\u001e\u0015\u00059\u0015\u0014\u0019$\t\u0002\u00036\u0005)!G\f\u0019/aQ!\u0011q\u001aB\u001d\u0011\u001d\tI,\ba\u0001\u0003\u001fDC!H3\u0003>\u0005\u0012!qH\u0001\u0006c9\"d&\r\u0015\u0004\u0001\u0015\\\u0017!\u0004'pG\u0006dG\nR!N_\u0012,G\u000e\u0005\u0002T?M1qD!\u0013\u0003PY\u00032a\u0016B&\u0013\r\u0011i\u0005\u0017\u0002\u0007\u0003:L(+\u001a4\u0011\r\tE#qKA\u0006\u001b\t\u0011\u0019FC\u0002\u0003V!\u000bA!\u001e;jY&!!\u0011\fB*\u0005\u0019au.\u00193feR\u0011!QI\u0001\r'\u00064X\rT8bIZ\u000bt\f\r\t\u0004\u0005C\u0012S\"A\u0010\u0003\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0014\u0007\t\u0012I\u0005\u0006\u0002\u0003`\u0005\tB\u000f[5t\r>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0002%QD\u0017n\u001d$pe6\fGOV3sg&|g\u000eI\u0001\u000ei\"L7o\u00117bgNt\u0015-\\3\u0002\u001dQD\u0017n]\"mCN\u001ch*Y7fA\t!A)\u0019;b'\u0019A#\u0011\nB;-B\u0019qKa\u001e\n\u0007\te\u0004LA\u0004Qe>$Wo\u0019;\u0002\u000bQ|\u0007/[2\u0002\rQ|\u0007/[2!\u0003\u0015Ig\u000eZ3y\u0003\u0019Ig\u000eZ3yAQ1!Q\u0011BE\u0005\u0017\u00032Aa\")\u001b\u0005\u0011\u0003B\u0002B>[\u0001\u0007\u0011\u000fC\u0004\u0003\u00005\u0002\r!!\u000f\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005\u000b\u0013\tJa%\t\u0011\tmd\u0006%AA\u0002ED\u0011Ba /!\u0003\u0005\r!!\u000f\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!\u0011\u0014\u0016\u0004c\nm5F\u0001BO!\u0011\u0011yJa*\u000e\u0005\t\u0005&\u0002\u0002BR\u0005K\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005!D\u0016\u0002\u0002BU\u0005C\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa,+\t\u0005e\"1T\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u0018B`!\r9&1X\u0005\u0004\u0005{C&aA!os\"I\u0011\u0011G\u001a\u0002\u0002\u0003\u0007\u0011\u0011H\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!Q\u0019\t\u0007\u0005\u000f\u0014iM!/\u000e\u0005\t%'b\u0001Bf1\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\t='\u0011\u001a\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003V\nm\u0007cA,\u0003X&\u0019!\u0011\u001c-\u0003\u000f\t{w\u000e\\3b]\"I\u0011\u0011G\u001b\u0002\u0002\u0003\u0007!\u0011X\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011H\u0001\ti>\u001cFO]5oOR\u0011\u0011qM\u0001\u0007KF,\u0018\r\\:\u0015\t\tU'\u0011\u001e\u0005\n\u0003cA\u0014\u0011!a\u0001\u0005s\u000bA\u0001R1uCB\u0019!q\u0011\u001e\u0014\ti\u0012\tP\u0016\t\n\u0005g\u0014I0]A\u001d\u0005\u000bk!A!>\u000b\u0007\t]\b,A\u0004sk:$\u0018.\\3\n\t\tm(Q\u001f\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014DC\u0001Bw\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\u0011)ia\u0001\u0004\u0006!1!1P\u001fA\u0002EDqAa >\u0001\u0004\tI$A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r-11\u0003\t\u0006/\u000e51\u0011C\u0005\u0004\u0007\u001fA&AB(qi&|g\u000e\u0005\u0004X\u0003+\n\u0018\u0011\b\u0005\n\u0007+q\u0014\u0011!a\u0001\u0005\u000b\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\rm\u0001\u0003BA5\u0007;IAaa\b\u0002l\t1qJ\u00196fGR$b\"!\u000b\u0004$\r\u00152qEB\u0015\u0007W\u0019i\u0003C\u0004\u0002\u0010\u0002\u0003\r!!%\t\u000f\u0005m\u0005\t1\u0001\u0002\u001e\"1\u0011Q\t!A\u0002yCQa\u001c!A\u0002EDQ!\u001f!A\u0002mDa!a\u0001A\u0001\u0004Y\u0018\u0001\u00027pC\u0012$B\"a\u0003\u00044\rU2qGB\u001d\u0007wAq!a$B\u0001\u0004\t\t\nC\u0004\u0002\u001c\u0006\u0003\r!!(\t\u000b=\f\u0005\u0019A9\t\u000be\f\u0005\u0019A>\t\r\u0005\r\u0011\t1\u0001|)\u0019\tYaa\u0010\u0004B!9\u0011q\u0012\"A\u0002\u0005E\u0005bBAN\u0005\u0002\u0007\u0011Q\u0014\u0015\u0004\u0005\u0016,\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$C'\u0006\u0002\u0004J)\u001a1Pa')\u0007})W\u000fK\u0002\u001fKV\u0004")
public class LocalLDAModel
extends LDAModel
implements scala.Serializable {
    private final Matrix topics;
    private final Vector docConcentration;
    private final double topicConcentration;
    private final double gammaShape;
    private long seed;

    public static LocalLDAModel load(SparkContext sparkContext, String string) {
        return LocalLDAModel$.MODULE$.load(sparkContext, string);
    }

    public Matrix topics() {
        return this.topics;
    }

    @Override
    public Vector docConcentration() {
        return this.docConcentration;
    }

    @Override
    public double topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public double gammaShape() {
        return this.gammaShape;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    @Override
    public int k() {
        return this.topics().numCols();
    }

    @Override
    public int vocabSize() {
        return this.topics().numRows();
    }

    @Override
    public Matrix topicsMatrix() {
        return this.topics();
    }

    @Override
    public Tuple2<int[], double[]>[] describeTopics(int maxTermsPerTopic) {
        DenseMatrix brzTopics = this.topics().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$);
        return (Tuple2[])((TraversableOnce)package$.MODULE$.Range().apply(0, this.k()).map((Function1 & Serializable & scala.Serializable)topicIndex -> LocalLDAModel.$anonfun$describeTopics$1(brzTopics, maxTermsPerTopic, BoxesRunTime.unboxToInt((Object)topicIndex)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    public long getSeed() {
        return this.seed();
    }

    public LocalLDAModel setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    @Override
    public void save(SparkContext sc, String path) {
        LocalLDAModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.topicsMatrix(), this.docConcentration(), this.topicConcentration(), this.gammaShape());
    }

    public double logLikelihood(RDD<Tuple2<Object, Vector>> documents) {
        return this.logLikelihoodBound(documents, this.docConcentration(), this.topicConcentration(), (DenseMatrix<Object>)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$), this.gammaShape(), this.k(), this.vocabSize());
    }

    public double logLikelihood(JavaPairRDD<Long, Vector> documents) {
        return this.logLikelihood((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    public double logPerplexity(RDD<Tuple2<Object, Vector>> documents) {
        double corpusTokenCount = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$logPerplexity$1(x0$1)), ClassTag$.MODULE$.Double())).sum();
        return -this.logLikelihood(documents) / corpusTokenCount;
    }

    public double logPerplexity(JavaPairRDD<Long, Vector> documents) {
        return this.logPerplexity((RDD<Tuple2<Object, Vector>>)documents.rdd());
    }

    private double logLikelihoodBound(RDD<Tuple2<Object, Vector>> documents, Vector alpha, double eta, DenseMatrix<Object> lambda, double gammaShape, int k, long vocabSize) {
        DenseVector brzAlpha = alpha.asBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double());
        DenseMatrix Elogbeta = (DenseMatrix)LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)lambda.t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose());
        Broadcast ElogbetaBc = documents.sparkContext().broadcast((Object)Elogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        long gammaSeed = this.seed();
        double corpusPart = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(documents.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)LocalLDAModel.$anonfun$logLikelihoodBound$1(x$3))).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$logLikelihoodBound$2(ElogbetaBc, brzAlpha, gammaShape, k, gammaSeed, x0$1)), ClassTag$.MODULE$.Double())).sum();
        ElogbetaBc.destroy(false);
        double sumEta = eta * (double)vocabSize;
        double topicsPart = BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)eta))).$minus(lambda, DenseMatrix$.MODULE$.s_dm_op_Double_OpSub())).$times$colon$times((Object)Elogbeta, DenseMatrix$.MODULE$.op_DM_DM_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply(lambda, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))).$minus((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(eta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)), DenseMatrix$.MODULE$.op_DM_S_Double_OpSub()), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues()))) + BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(new package.InjectNumericOps(breeze.linalg.package$.MODULE$.InjectNumericOps((Object)BoxesRunTime.boxToDouble((double)package.lgamma$.MODULE$.apply$mDDc$sp(sumEta, (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$)))).$minus(package.lgamma$.MODULE$.apply(sum$.MODULE$.apply(lambda.apply((Object)package$.MODULE$.$colon$colon(), (Object)$times$.MODULE$, Broadcaster$.MODULE$.canBroadcastColumns(DenseMatrix$.MODULE$.handholdCanMapRows())), sum$.MODULE$.vectorizeCols_Double(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$, sum$.MODULE$.helper_Double())), Transpose$.MODULE$.liftUFunc(package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())), Tensor$.MODULE$.transposeTensor(Predef$.MODULE$.$conforms()))), DenseVector$.MODULE$.liftDMOpToDVTransposeOp(DenseMatrix$.MODULE$.s_dm_op_Double_OpSub())), sum$.MODULE$.reduce_Double(DenseMatrix$.MODULE$.canTraverseValues())));
        return corpusPart + topicsPart;
    }

    public RDD<Tuple2<Object, Vector>> topicDistributions(RDD<Tuple2<Object, Vector>> documents) {
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        Broadcast expElogbetaBc = documents.sparkContext().broadcast((Object)expElogbeta, ClassTag$.MODULE$.apply(DenseMatrix.class));
        breeze.linalg.Vector<Object> docConcentrationBrz = this.docConcentration().asBreeze();
        double gammaShape = this.gammaShape();
        int k = this.k();
        long gammaSeed = this.seed();
        return documents.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) throw new MatchError((Object)tuple22);
            long id = tuple22._1$mcJ$sp();
            Vector termCounts = (Vector)tuple22._2();
            long l = id;
            if (termCounts == null) throw new MatchError((Object)tuple22);
            Vector vector = termCounts;
            if (vector.numNonzeros() == 0) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.zeros(k));
                return tuple2;
            } else {
                DenseVector gamma;
                Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)expElogbetaBc.value()), docConcentrationBrz, gammaShape, k, gammaSeed + l);
                if (tuple3 == null) throw new MatchError(tuple3);
                DenseVector denseVector = gamma = (DenseVector)tuple3._1();
                DenseVector gamma2 = denseVector;
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToLong((long)l), (Object)Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double())));
            }
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Function1<Vector, Vector> getTopicDistributionMethod() {
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        breeze.linalg.Vector<Object> docConcentrationBrz = this.docConcentration().asBreeze();
        double gammaShape = this.gammaShape();
        int k = this.k();
        long gammaSeed = this.seed();
        return (Function1 & Serializable & scala.Serializable)termCounts -> {
            Vector vector;
            if (termCounts.numNonzeros() == 0) {
                vector = Vectors$.MODULE$.zeros(k);
            } else {
                DenseVector gamma;
                Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference((Vector)termCounts, (DenseMatrix<Object>)expElogbeta, docConcentrationBrz, gammaShape, k, gammaSeed);
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                DenseVector denseVector = gamma = (DenseVector)tuple3._1();
                DenseVector gamma2 = denseVector;
                vector = Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double()));
            }
            return vector;
        };
    }

    public Vector topicDistribution(Vector document) {
        Vector vector;
        long gammaSeed = this.seed();
        DenseMatrix expElogbeta = (DenseMatrix)package.exp$.MODULE$.apply(LDAUtils$.MODULE$.dirichletExpectation((DenseMatrix<Object>)((DenseMatrix)this.topicsMatrix().asBreeze().toDenseMatrix$mcD$sp(ClassTag$.MODULE$.Double(), (Zero)Zero.DoubleZero$.MODULE$).t(DenseMatrix$.MODULE$.canTranspose()))).t(DenseMatrix$.MODULE$.canTranspose()), package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())));
        if (document.numNonzeros() == 0) {
            vector = Vectors$.MODULE$.zeros(this.k());
        } else {
            DenseVector gamma;
            Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(document, (DenseMatrix<Object>)expElogbeta, this.docConcentration().asBreeze(), this.gammaShape(), this.k(), gammaSeed);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            DenseVector denseVector = gamma = (DenseVector)tuple3._1();
            DenseVector gamma2 = denseVector;
            vector = Vectors$.MODULE$.dense(((DenseVector)normalize$.MODULE$.apply((Object)gamma2, (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()))).toArray$mcD$sp(ClassTag$.MODULE$.Double()));
        }
        return vector;
    }

    public JavaPairRDD<Long, Vector> topicDistributions(JavaPairRDD<Long, Vector> documents) {
        RDD<Tuple2<Object, Vector>> distributions = this.topicDistributions((RDD<Tuple2<Object, Vector>>)documents.rdd());
        return JavaPairRDD$.MODULE$.fromRDD(distributions, ClassTag$.MODULE$.apply(Long.class), ClassTag$.MODULE$.apply(Vector.class));
    }

    public static final /* synthetic */ double $anonfun$describeTopics$2(Tuple2 x$1) {
        return -x$1._1$mcD$sp();
    }

    public static final /* synthetic */ Tuple2 $anonfun$describeTopics$1(DenseMatrix brzTopics$1, int maxTermsPerTopic$1, int topicIndex) {
        DenseVector topic = (DenseVector)normalize$.MODULE$.apply(brzTopics$1.apply((Object)package$.MODULE$.$colon$colon(), (Object)BoxesRunTime.boxToInteger((int)topicIndex), DenseMatrix$.MODULE$.canSliceCol()), (Object)BoxesRunTime.boxToDouble((double)1.0), normalize$.MODULE$.normalizeDoubleImpl(DenseVector$.MODULE$.dv_s_Op_Double_OpDiv(), DenseVector$.MODULE$.canNorm_Double()));
        Tuple2 tuple2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(topic.toArray$mcD$sp(ClassTag$.MODULE$.Double()))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)LocalLDAModel.$anonfun$describeTopics$2(x$1)), (Ordering)Ordering.Double$.MODULE$))).take(maxTermsPerTopic$1))).unzip((Function1)Predef$.MODULE$.$conforms(), ClassTag$.MODULE$.Double(), ClassTag$.MODULE$.Int());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double[] termWeights = (double[])tuple2._1();
        int[] terms = (int[])tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)termWeights, (Object)terms);
        Tuple2 tuple23 = tuple22;
        double[] termWeights2 = (double[])tuple23._1();
        int[] terms2 = (int[])tuple23._2();
        return new Tuple2(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(terms2)).toArray(ClassTag$.MODULE$.Int()), new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(termWeights2)).toArray(ClassTag$.MODULE$.Double()));
    }

    public static final /* synthetic */ double $anonfun$logPerplexity$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Vector termCounts = (Vector)tuple2._2();
        double d = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(termCounts.toArray())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$logLikelihoodBound$1(Tuple2 x$3) {
        return ((Vector)x$3._2()).numNonzeros() > 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ double $anonfun$logLikelihoodBound$2(Broadcast ElogbetaBc$1, DenseVector brzAlpha$1, double gammaShape$1, int k$1, long gammaSeed$1, Tuple2 x0$1) {
        DenseVector denseVector;
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        long id = tuple2._1$mcJ$sp();
        Vector termCounts = (Vector)tuple2._2();
        long l = id;
        if (termCounts == null) throw new MatchError((Object)tuple2);
        Vector vector = termCounts;
        DenseMatrix localElogbeta = (DenseMatrix)ElogbetaBc$1.value();
        DoubleRef docBound = DoubleRef.create((double)0.0);
        Tuple3<DenseVector<Object>, DenseMatrix<Object>, List<Object>> tuple3 = OnlineLDAOptimizer$.MODULE$.variationalTopicInference(vector, (DenseMatrix<Object>)((DenseMatrix)package.exp$.MODULE$.apply((Object)localElogbeta, package.exp$.MODULE$.fromLowOrderCanMapValues(DenseMatrix$.MODULE$.scalarOf(), (UFunc.UImpl)package.exp$.expDoubleImpl$.MODULE$, DenseMatrix$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))), (breeze.linalg.Vector<Object>)brzAlpha$1, gammaShape$1, k$1, gammaSeed$1 + l);
        if (tuple3 == null) throw new MatchError(tuple3);
        DenseVector gammad = (DenseVector)tuple3._1();
        if (gammad == null) throw new MatchError(tuple3);
        DenseVector denseVector2 = denseVector = gammad;
        DenseVector gammad2 = denseVector2;
        DenseVector<Object> Elogthetad = LDAUtils$.MODULE$.dirichletExpectation((DenseVector<Object>)gammad2);
        vector.foreachActive((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVID.sp & Serializable & scala.Serializable)(x0$2, x1$1) -> {
            Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(x0$2, x1$1);
            if (sp2 != null) {
                int idx = sp2._1$mcI$sp();
                double count = sp2._2$mcD$sp();
                docBound$1.elem += count * LDAUtils$.MODULE$.logSumExp((DenseVector<Object>)((DenseVector)Elogthetad.$plus(((ImmutableNumericOps)localElogbeta.apply((Object)BoxesRunTime.boxToInteger((int)idx), (Object)package$.MODULE$.$colon$colon(), DenseMatrix$.MODULE$.canSliceRow())).t(Transpose$.MODULE$.canUntranspose()), DenseVector$.MODULE$.canAddD())));
            } else {
                throw new MatchError((Object)sp2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)brzAlpha$1.$minus((Object)gammad2, DenseVector$.MODULE$.canSubD())).$times$colon$times(Elogthetad, DenseVector$.MODULE$.dv_dv_Op_Double_OpMulScalar()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
        docBound.elem += BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply(((ImmutableNumericOps)package.lgamma$.MODULE$.apply((Object)gammad2, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double())))).$minus(package.lgamma$.MODULE$.apply((Object)brzAlpha$1, package.lgamma$.MODULE$.fromLowOrderCanMapValues(DenseVector$.MODULE$.scalarOf(), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$, DenseVector$.MODULE$.canMapValues$mDDc$sp(ClassTag$.MODULE$.Double()))), DenseVector$.MODULE$.canSubD()), sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues())));
        docBound.elem += package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)brzAlpha$1, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$) - package.lgamma$.MODULE$.apply$mDDc$sp(BoxesRunTime.unboxToDouble((Object)sum$.MODULE$.apply((Object)gammad2, sum$.MODULE$.reduce_Double(DenseVector$.MODULE$.canIterateValues()))), (UFunc.UImpl)package.lgamma$.lgammaImplDouble$.MODULE$);
        return docBound.elem;
    }

    public LocalLDAModel(Matrix topics, Vector docConcentration, double topicConcentration, double gammaShape) {
        this.topics = topics;
        this.docConcentration = docConcentration;
        this.topicConcentration = topicConcentration;
        this.gammaShape = gammaShape;
        this.seed = Utils$.MODULE$.random().nextLong();
    }
}

