/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.mllib.clustering.PowerIterationClustering$;
import org.apache.spark.mllib.clustering.PowerIterationClusteringModel;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tme\u0001B\u001b7\u0001\u0005C\u0001b\u0013\u0001\u0003\u0002\u0004%I\u0001\u0014\u0005\t!\u0002\u0011\t\u0019!C\u0005#\"Aq\u000b\u0001B\u0001B\u0003&Q\n\u0003\u0005Y\u0001\t\u0005\r\u0011\"\u0003M\u0011!I\u0006A!a\u0001\n\u0013Q\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0015B'\t\u0011u\u0003!\u00111A\u0005\nyC\u0001B\u001b\u0001\u0003\u0002\u0004%Ia\u001b\u0005\t[\u0002\u0011\t\u0011)Q\u0005?\"1a\u000e\u0001C\u0001m=DQA\u001c\u0001\u0005\u0002UDaa \u0001\u0005\u0002\u0005\u0005\u0001bBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003#\u0001A\u0011AA\n\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\u0007\u0001\t\u0003\t\t\u0005C\u0004\u0002\u001c\u0001!\t!!\u0019\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\u001e9\u00111\u0013\u001c\t\u0002\u0005UeAB\u001b7\u0011\u0003\t9\n\u0003\u0004o)\u0011\u0005\u0011Q\u0015\u0004\u0007\u0003O#\u0002)!+\t\u0015\u0005EfC!f\u0001\n\u0003\t\u0019\f\u0003\u0006\u00026Z\u0011\t\u0012)A\u0005\u00033B\u0011\"a.\u0017\u0005+\u0007I\u0011\u0001'\t\u0013\u0005efC!E!\u0002\u0013i\u0005B\u00028\u0017\t\u0003\tY\fC\u0005\u0002FZ\t\t\u0011\"\u0001\u0002H\"I\u0011Q\u001a\f\u0012\u0002\u0013\u0005\u0011q\u001a\u0005\n\u0003G4\u0012\u0013!C\u0001\u0003KD\u0011\"!;\u0017\u0003\u0003%\t%a;\t\u0011\u0005Eh#!A\u0005\u00021C\u0011\"a=\u0017\u0003\u0003%\t!!>\t\u0013\u0005}h#!A\u0005B\t\u0005\u0001\"\u0003B\b-\u0005\u0005I\u0011\u0001B\t\u0011%\u0011YBFA\u0001\n\u0003\u0012i\u0002C\u0005\u0003 Y\t\t\u0011\"\u0011\u0003\"!I!1\u0005\f\u0002\u0002\u0013\u0005#QE\u0004\n\u0005W!\u0012\u0011!E\u0001\u0005[1\u0011\"a*\u0015\u0003\u0003E\tAa\f\t\r9DC\u0011\u0001B\u001f\u0011%\u0011y\u0002KA\u0001\n\u000b\u0012\t\u0003C\u0005\u0003@!\n\t\u0011\"!\u0003B!I!q\t\u0015\u0002\u0002\u0013\u0005%\u0011\n\u0005\n\u00057B\u0013\u0011!C\u0005\u0005;B\u0001B!\u001a\u0015\t\u00031$q\r\u0005\t\u0005K\"B\u0011\u0001\u001c\u0003l!A!q\u000e\u000b\u0005\u0002Y\u0012\t\b\u0003\u0005\u0003xQ!\tA\u000eB=\u0011!\u0011i\b\u0006C\u0001m\t}\u0004\u0002\u0003BF)\u0011\u0005aG!$\t\u0013\tmC#!A\u0005\n\tu#\u0001\u0007)po\u0016\u0014\u0018\n^3sCRLwN\\\"mkN$XM]5oO*\u0011q\u0007O\u0001\u000bG2,8\u000f^3sS:<'BA\u001d;\u0003\u0015iG\u000e\\5c\u0015\tYD(A\u0003ta\u0006\u00148N\u0003\u0002>}\u00051\u0011\r]1dQ\u0016T\u0011aP\u0001\u0004_J<7\u0001A\n\u0004\u0001\tC\u0005CA\"G\u001b\u0005!%\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#%AB!osJ+g\r\u0005\u0002D\u0013&\u0011!\n\u0012\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0002WV\tQ\n\u0005\u0002D\u001d&\u0011q\n\u0012\u0002\u0004\u0013:$\u0018!B6`I\u0015\fHC\u0001*V!\t\u00195+\u0003\u0002U\t\n!QK\\5u\u0011\u001d1&!!AA\u00025\u000b1\u0001\u001f\u00132\u0003\tY\u0007%A\u0007nCbLE/\u001a:bi&|gn]\u0001\u0012[\u0006D\u0018\n^3sCRLwN\\:`I\u0015\fHC\u0001*\\\u0011\u001d1V!!AA\u00025\u000ba\"\\1y\u0013R,'/\u0019;j_:\u001c\b%\u0001\u0005j]&$Xj\u001c3f+\u0005y\u0006C\u00011h\u001d\t\tW\r\u0005\u0002c\t6\t1M\u0003\u0002e\u0001\u00061AH]8pizJ!A\u001a#\u0002\rA\u0013X\rZ3g\u0013\tA\u0017N\u0001\u0004TiJLgn\u001a\u0006\u0003M\u0012\u000bA\"\u001b8ji6{G-Z0%KF$\"A\u00157\t\u000fYC\u0011\u0011!a\u0001?\u0006I\u0011N\\5u\u001b>$W\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\tA\u00148\u000f\u001e\t\u0003c\u0002i\u0011A\u000e\u0005\u0006\u0017*\u0001\r!\u0014\u0005\u00061*\u0001\r!\u0014\u0005\u0006;*\u0001\ra\u0018\u000b\u0002a\"\u001a1b^?\u0011\u0005a\\X\"A=\u000b\u0005iT\u0014AC1o]>$\u0018\r^5p]&\u0011A0\u001f\u0002\u0006'&t7-Z\u0011\u0002}\u0006)\u0011GL\u001a/a\u0005!1/\u001a;L)\u0011\t\u0019!!\u0002\u000e\u0003\u0001AQa\u0013\u0007A\u00025C3\u0001D<~\u0003A\u0019X\r^'bq&#XM]1uS>t7\u000f\u0006\u0003\u0002\u0004\u00055\u0001\"\u0002-\u000e\u0001\u0004i\u0005fA\u0007x{\u0006)2/\u001a;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8N_\u0012,G\u0003BA\u0002\u0003+Aa!a\u0006\u000f\u0001\u0004y\u0016\u0001B7pI\u0016D3AD<~\u0003\r\u0011XO\u001c\u000b\u0005\u0003?\t)\u0003E\u0002r\u0003CI1!a\t7\u0005u\u0001vn^3s\u0013R,'/\u0019;j_:\u001cE.^:uKJLgnZ'pI\u0016d\u0007bBA\u0014\u001f\u0001\u0007\u0011\u0011F\u0001\u0006OJ\f\u0007\u000f\u001b\t\t\u0003W\t\t$!\u000e\u000265\u0011\u0011Q\u0006\u0006\u0004\u0003_Q\u0014AB4sCBD\u00070\u0003\u0003\u00024\u00055\"!B$sCBD\u0007cA\"\u00028%\u0019\u0011\u0011\b#\u0003\r\u0011{WO\u00197fQ\u0011yq/!\u0010\"\u0005\u0005}\u0012!B\u0019/k9\u0002D\u0003BA\u0010\u0003\u0007Bq!!\u0012\u0011\u0001\u0004\t9%\u0001\u0007tS6LG.\u0019:ji&,7\u000f\u0005\u0004\u0002J\u0005=\u00131K\u0007\u0003\u0003\u0017R1!!\u0014;\u0003\r\u0011H\rZ\u0005\u0005\u0003#\nYEA\u0002S\t\u0012\u0003\u0012bQA+\u00033\nI&!\u000e\n\u0007\u0005]CI\u0001\u0004UkBdWm\r\t\u0004\u0007\u0006m\u0013bAA/\t\n!Aj\u001c8hQ\r\u0001r/ \u000b\u0005\u0003?\t\u0019\u0007C\u0004\u0002FE\u0001\r!!\u001a\u0011\r\u0005\u001d\u0014\u0011OA;\u001b\t\tIG\u0003\u0003\u0002l\u00055\u0014\u0001\u00026bm\u0006T1!a\u001c;\u0003\r\t\u0007/[\u0005\u0005\u0003g\nIGA\u0004KCZ\f'\u000b\u0012#\u0011\u0013\r\u000b)&a\u001e\u0002x\u0005\r\u0005\u0003BA=\u0003\u0003k!!a\u001f\u000b\t\u0005u\u0014qP\u0001\u0005Y\u0006twM\u0003\u0002\u0002l%!\u0011QLA>!\u0011\tI(!\"\n\t\u0005e\u00121\u0010\u0015\u0004#]l\u0018a\u00019jGR!\u0011qDAG\u0011\u001d\tyI\u0005a\u0001\u0003S\t\u0011a\u001e\u0015\u0004\u0001]l\u0018\u0001\u0007)po\u0016\u0014\u0018\n^3sCRLwN\\\"mkN$XM]5oOB\u0011\u0011\u000fF\n\u0006)\t\u000bI\n\u0013\t\u0005\u00037\u000b\t+\u0004\u0002\u0002\u001e*\u0019\u0011q\u0014\u001e\u0002\u0011%tG/\u001a:oC2LA!a)\u0002\u001e\n9Aj\\4hS:<GCAAK\u0005)\t5o]5h]6,g\u000e^\n\u0006-\t\u000bY\u000b\u0013\t\u0004\u0007\u00065\u0016bAAX\t\n9\u0001K]8ek\u000e$\u0018AA5e+\t\tI&A\u0002jI\u0002\nqa\u00197vgR,'/\u0001\u0005dYV\u001cH/\u001a:!)\u0019\ti,!1\u0002DB\u0019\u0011q\u0018\f\u000e\u0003QAq!!-\u001c\u0001\u0004\tI\u0006\u0003\u0004\u00028n\u0001\r!T\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002>\u0006%\u00171\u001a\u0005\n\u0003cc\u0002\u0013!a\u0001\u00033B\u0001\"a.\u001d!\u0003\u0005\r!T\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tN\u000b\u0003\u0002Z\u0005M7FAAk!\u0011\t9.a8\u000e\u0005\u0005e'\u0002BAn\u0003;\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005i$\u0015\u0002BAq\u00033\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a:+\u00075\u000b\u0019.A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003[\u0004B!!\u001f\u0002p&\u0019\u0001.a\u001f\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011q_A\u007f!\r\u0019\u0015\u0011`\u0005\u0004\u0003w$%aA!os\"9a+IA\u0001\u0002\u0004i\u0015a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t\r\u0001C\u0002B\u0003\u0005\u0017\t90\u0004\u0002\u0003\b)\u0019!\u0011\u0002#\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003\u000e\t\u001d!\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u0005\u0003\u001aA\u00191I!\u0006\n\u0007\t]AIA\u0004C_>dW-\u00198\t\u0011Y\u001b\u0013\u0011!a\u0001\u0003o\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u001b\u0006AAo\\*ue&tw\r\u0006\u0002\u0002n\u00061Q-];bYN$BAa\u0005\u0003(!AaKJA\u0001\u0002\u0004\t9\u0010K\u0002\u0017ov\f!\"Q:tS\u001etW.\u001a8u!\r\ty\fK\n\u0005Q\tE\u0002\nE\u0005\u00034\te\u0012\u0011L'\u0002>6\u0011!Q\u0007\u0006\u0004\u0005o!\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005w\u0011)DA\tBEN$(/Y2u\rVt7\r^5p]J\"\"A!\f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u0005u&1\tB#\u0011\u001d\t\tl\u000ba\u0001\u00033Ba!a.,\u0001\u0004i\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0017\u00129\u0006E\u0003D\u0005\u001b\u0012\t&C\u0002\u0003P\u0011\u0013aa\u00149uS>t\u0007CB\"\u0003T\u0005eS*C\u0002\u0003V\u0011\u0013a\u0001V;qY\u0016\u0014\u0004\"\u0003B-Y\u0005\u0005\t\u0019AA_\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003`A!\u0011\u0011\u0010B1\u0013\u0011\u0011\u0019'a\u001f\u0003\r=\u0013'.Z2u\u0003%qwN]7bY&TX\r\u0006\u0003\u0002*\t%\u0004bBA\u0014]\u0001\u0007\u0011\u0011\u0006\u000b\u0005\u0003S\u0011i\u0007C\u0004\u0002F=\u0002\r!a\u0012\u0002\u0015I\fg\u000eZ8n\u0013:LG\u000f\u0006\u0003\u0002*\tM\u0004b\u0002B;a\u0001\u0007\u0011\u0011F\u0001\u0002O\u0006\u0001\u0012N\\5u\t\u0016<'/Z3WK\u000e$xN\u001d\u000b\u0005\u0003S\u0011Y\bC\u0004\u0003vE\u0002\r!!\u000b\u0002\u0013A|w/\u001a:Ji\u0016\u0014HC\u0002BA\u0005\u000f\u0013I\t\u0005\u0004\u0002,\t\r\u0015QG\u0005\u0005\u0005\u000b\u000biCA\u0005WKJ$X\r\u001f*E\t\"9!Q\u000f\u001aA\u0002\u0005%\u0002\"\u0002-3\u0001\u0004i\u0015AB6NK\u0006t7\u000f\u0006\u0004\u0003\u0010\nE%Q\u0013\t\u0006\u0003W\u0011\u0019)\u0014\u0005\b\u0005'\u001b\u0004\u0019\u0001BA\u0003\u00051\b\"B&4\u0001\u0004i\u0005f\u0001\u000bx{\"\u001a1c^?")
public class PowerIterationClustering
implements scala.Serializable {
    private int k;
    private int maxIterations;
    private String initMode;

    private int k() {
        return this.k;
    }

    private void k_$eq(int x$1) {
        this.k = x$1;
    }

    private int maxIterations() {
        return this.maxIterations;
    }

    private void maxIterations_$eq(int x$1) {
        this.maxIterations = x$1;
    }

    private String initMode() {
        return this.initMode;
    }

    private void initMode_$eq(String x$1) {
        this.initMode = x$1;
    }

    public PowerIterationClustering setK(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Number of clusters must be positive but got ").append(k).toString());
        this.k_$eq(k);
        return this;
    }

    public PowerIterationClustering setMaxIterations(int maxIterations) {
        Predef$.MODULE$.require(maxIterations >= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Maximum of iterations must be nonnegative but got ").append(maxIterations).toString());
        this.maxIterations_$eq(maxIterations);
        return this;
    }

    public PowerIterationClustering setInitializationMode(String mode) {
        String string = mode;
        boolean bl = "random".equals(string) ? true : "degree".equals(string);
        if (!bl) {
            throw new IllegalArgumentException(new StringBuilder(29).append("Invalid initialization mode: ").append(mode).toString());
        }
        String string2 = mode;
        this.initMode_$eq(string2);
        return this;
    }

    public PowerIterationClusteringModel run(Graph<Object, Object> graph) {
        Graph<Object, Object> graph2;
        Graph<Object, Object> w = PowerIterationClustering$.MODULE$.normalize(graph);
        String string = this.initMode();
        if ("random".equals(string)) {
            graph2 = PowerIterationClustering$.MODULE$.randomInit(w);
        } else if ("degree".equals(string)) {
            graph2 = PowerIterationClustering$.MODULE$.initDegreeVector(w);
        } else {
            throw new MatchError((Object)string);
        }
        Graph<Object, Object> w0 = graph2;
        return this.pic(w0);
    }

    public PowerIterationClusteringModel run(RDD<Tuple3<Object, Object, Object>> similarities) {
        Graph<Object, Object> graph;
        Graph<Object, Object> w = PowerIterationClustering$.MODULE$.normalize(similarities);
        String string = this.initMode();
        if ("random".equals(string)) {
            graph = PowerIterationClustering$.MODULE$.randomInit(w);
        } else if ("degree".equals(string)) {
            graph = PowerIterationClustering$.MODULE$.initDegreeVector(w);
        } else {
            throw new MatchError((Object)string);
        }
        Graph<Object, Object> w0 = graph;
        return this.pic(w0);
    }

    public PowerIterationClusteringModel run(JavaRDD<Tuple3<Long, Long, Double>> similarities) {
        return this.run((RDD<Tuple3<Object, Object, Object>>)similarities.rdd());
    }

    private PowerIterationClusteringModel pic(Graph<Object, Object> w) {
        VertexRDD<Object> v = PowerIterationClustering$.MODULE$.powerIter(w, this.maxIterations());
        RDD assignments = PowerIterationClustering$.MODULE$.kMeans(v, this.k()).mapPartitions((Function1 & Serializable & scala.Serializable)iter -> iter.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long id = tuple2._1$mcJ$sp();
            int cluster = tuple2._2$mcI$sp();
            Assignment assignment = new Assignment(id, cluster);
            return assignment;
        }), true, ClassTag$.MODULE$.apply(Assignment.class));
        return new PowerIterationClusteringModel(this.k(), (RDD<Assignment>)assignments);
    }

    public PowerIterationClustering(int k, int maxIterations, String initMode) {
        this.k = k;
        this.maxIterations = maxIterations;
        this.initMode = initMode;
    }

    public PowerIterationClustering() {
        this(2, 100, "random");
    }

    public static class Assignment
    implements Product,
    scala.Serializable {
        private final long id;
        private final int cluster;

        public long id() {
            return this.id;
        }

        public int cluster() {
            return this.cluster;
        }

        public Assignment copy(long id, int cluster) {
            return new Assignment(id, cluster);
        }

        public long copy$default$1() {
            return this.id();
        }

        public int copy$default$2() {
            return this.cluster();
        }

        public String productPrefix() {
            return "Assignment";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Number number;
            int n = x$1;
            switch (n) {
                case 0: {
                    number = BoxesRunTime.boxToLong((long)this.id());
                    break;
                }
                case 1: {
                    number = BoxesRunTime.boxToInteger((int)this.cluster());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return number;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Assignment;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.id()));
            n = Statics.mix((int)n, (int)this.cluster());
            return Statics.finalizeHash((int)n, (int)2);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Assignment)) return false;
            boolean bl = true;
            if (!bl) return false;
            Assignment assignment = (Assignment)x$1;
            if (this.id() != assignment.id()) return false;
            if (this.cluster() != assignment.cluster()) return false;
            if (!assignment.canEqual(this)) return false;
            return true;
        }

        public Assignment(long id, int cluster) {
            this.id = id;
            this.cluster = cluster;
            Product.$init$((Product)this);
        }
    }
}

