/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.evaluation.RankingMetrics$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Set;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005b\u0001\u0002\u0007\u000e\u0001aA\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t\u0003\u0002\u0011\u0019\u0011)A\u0006\u0005\")\u0001\n\u0001C\u0001\u0013\")q\n\u0001C\u0001!\"A!\r\u0001EC\u0002\u0013\u00051\rC\u0003e\u0001\u0011\u0005QmB\u0003j\u001b!\u0005!NB\u0003\r\u001b!\u00051\u000eC\u0003I\u0011\u0011\u0005A\u000eC\u0003n\u0011\u0011\u0005a\u000eC\u0005\u0002\u0018!\t\t\u0011\"\u0003\u0002\u001a\tq!+\u00198lS:<W*\u001a;sS\u000e\u001c(B\u0001\b\u0010\u0003))g/\u00197vCRLwN\u001c\u0006\u0003!E\tQ!\u001c7mS\nT!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001+\tI\u0002h\u0005\u0003\u00015\u00012\u0003CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g\r\u0005\u0002\"I5\t!E\u0003\u0002$#\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002&E\t9Aj\\4hS:<\u0007CA\u000e(\u0013\tACD\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\nqe\u0016$\u0017n\u0019;j_:\fe\u000e\u001a'bE\u0016d7\u000fE\u0002,]Aj\u0011\u0001\f\u0006\u0003[E\t1A\u001d3e\u0013\tyCFA\u0002S\t\u0012\u0003BaG\u00194g%\u0011!\u0007\b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007m!d'\u0003\u000269\t)\u0011I\u001d:bsB\u0011q\u0007\u000f\u0007\u0001\t\u0015I\u0004A1\u0001;\u0005\u0005!\u0016CA\u001e?!\tYB(\u0003\u0002>9\t9aj\u001c;iS:<\u0007CA\u000e@\u0013\t\u0001EDA\u0002B]f\f!\"\u001a<jI\u0016t7-\u001a\u00132!\r\u0019eIN\u0007\u0002\t*\u0011Q\tH\u0001\be\u00164G.Z2u\u0013\t9EI\u0001\u0005DY\u0006\u001c8\u000fV1h\u0003\u0019a\u0014N\\5u}Q\u0011!J\u0014\u000b\u0003\u00176\u00032\u0001\u0014\u00017\u001b\u0005i\u0001\"B!\u0004\u0001\b\u0011\u0005\"B\u0015\u0004\u0001\u0004Q\u0013a\u00039sK\u000eL7/[8o\u0003R$\"!\u0015+\u0011\u0005m\u0011\u0016BA*\u001d\u0005\u0019!u.\u001e2mK\")Q\u000b\u0002a\u0001-\u0006\t1\u000e\u0005\u0002\u001c/&\u0011\u0001\f\b\u0002\u0004\u0013:$\bf\u0001\u0003[AB\u00111LX\u0007\u00029*\u0011Q,E\u0001\u000bC:tw\u000e^1uS>t\u0017BA0]\u0005\u0015\u0019\u0016N\\2fC\u0005\t\u0017!B\u0019/e9\u0002\u0014\u0001F7fC:\fe/\u001a:bO\u0016\u0004&/Z2jg&|g.F\u0001R\u0003\u0019qGmY4BiR\u0011\u0011K\u001a\u0005\u0006+\u001a\u0001\rA\u0016\u0015\u0004\ri\u0003\u0007f\u0001\u0001[A\u0006q!+\u00198lS:<W*\u001a;sS\u000e\u001c\bC\u0001'\t'\rA!D\n\u000b\u0002U\u0006\u0011qNZ\u000b\u0004_J|HC\u00019u!\ra\u0005!\u001d\t\u0003oI$Qa\u001d\u0006C\u0002i\u0012\u0011!\u0012\u0005\u0006S)\u0001\r!\u001e\t\u0004mnlX\"A<\u000b\u0005aL\u0018\u0001\u00026bm\u0006T!A_\t\u0002\u0007\u0005\u0004\u0018.\u0003\u0002}o\n9!*\u0019<b%\u0012#\u0005\u0003B\u000e2}z\u0004\"aN@\u0005\reR!\u0019AA\u0001#\rY\u00141\u0001\t\u0006\u0003\u000b\ti!]\u0007\u0003\u0003\u000fQA!!\u0003\u0002\f\u0005!A.\u00198h\u0015\u0005A\u0018\u0002BA\b\u0003\u000f\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\u0015\u0005\u0015i\u000b\u0019\"\t\u0002\u0002\u0016\u0005)\u0011G\f\u001b/a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u0002\u0005\u0003\u0002\u0006\u0005u\u0011\u0002BA\u0010\u0003\u000f\u0011aa\u00142kK\u000e$\b")
public class RankingMetrics<T>
implements Logging,
scala.Serializable {
    private double meanAveragePrecision;
    private final RDD<Tuple2<Object, Object>> predictionAndLabels;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static <E, T extends Iterable<E>> RankingMetrics<E> of(JavaRDD<Tuple2<T, T>> javaRDD) {
        return RankingMetrics$.MODULE$.of(javaRDD);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public double precisionAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$precisionAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    private double meanAveragePrecision$lzycompute() {
        RankingMetrics rankingMetrics = this;
        synchronized (rankingMetrics) {
            if (!this.bitmap$0) {
                this.meanAveragePrecision = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$meanAveragePrecision$1(this, x0$1)), ClassTag$.MODULE$.Double())).mean();
                this.bitmap$0 = true;
            }
        }
        return this.meanAveragePrecision;
    }

    public double meanAveragePrecision() {
        return !this.bitmap$0 ? this.meanAveragePrecision$lzycompute() : this.meanAveragePrecision;
    }

    public double ndcgAt(int k) {
        Predef$.MODULE$.require(k > 0, (Function0 & Serializable & scala.Serializable)() -> "ranking position k should be positive");
        return RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndLabels.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RankingMetrics.$anonfun$ndcgAt$2(this, k, x0$1)), ClassTag$.MODULE$.Double())).mean();
    }

    public static final /* synthetic */ double $anonfun$precisionAt$2(RankingMetrics $this, int k$1, Tuple2 x0$1) {
        double d;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            if (labSet.nonEmpty()) {
                int n = package$.MODULE$.min(ScalaRunTime$.MODULE$.array_length(pred), k$1);
                int cnt = 0;
                for (int i = 0; i < n; ++i) {
                    if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                    ++cnt;
                }
                d = (double)cnt / (double)k$1;
            } else {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
                d = 0.0;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        double d2 = d;
        return d2;
    }

    public static final /* synthetic */ double $anonfun$meanAveragePrecision$1(RankingMetrics $this, Tuple2 x0$1) {
        double d;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            if (labSet.nonEmpty()) {
                int cnt = 0;
                double precSum = 0.0;
                int n = ScalaRunTime$.MODULE$.array_length(pred);
                for (int i = 0; i < n; ++i) {
                    if (!labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) continue;
                    precSum += (double)(++cnt) / (double)(i + 1);
                }
                d = precSum / (double)labSet.size();
            } else {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
                d = 0.0;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        double d2 = d;
        return d2;
    }

    public static final /* synthetic */ double $anonfun$ndcgAt$2(RankingMetrics $this, int k$2, Tuple2 x0$1) {
        double d;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Object pred = tuple2._1();
            Object lab = tuple2._2();
            Set labSet = Predef$.MODULE$.genericArrayOps(lab).toSet();
            if (labSet.nonEmpty()) {
                int labSetSize = labSet.size();
                int n = package$.MODULE$.min(package$.MODULE$.max(ScalaRunTime$.MODULE$.array_length(pred), labSetSize), k$2);
                double maxDcg = 0.0;
                double dcg = 0.0;
                for (int i = 0; i < n; ++i) {
                    double gain = 1.0 / package$.MODULE$.log((double)(i + 2));
                    if (i < ScalaRunTime$.MODULE$.array_length(pred) && labSet.contains(ScalaRunTime$.MODULE$.array_apply(pred, i))) {
                        dcg += gain;
                    }
                    if (i >= labSetSize) continue;
                    maxDcg += gain;
                }
                d = dcg / maxDcg;
            } else {
                $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Empty ground truth set, check input data");
                d = 0.0;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        double d2 = d;
        return d2;
    }

    public RankingMetrics(RDD<Tuple2<Object, Object>> predictionAndLabels, ClassTag<T> evidence$1) {
        this.predictionAndLabels = predictionAndLabels;
        Logging.$init$((Logging)this);
    }
}

