/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.evaluation;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.mllib.stat.MultivariateStatisticalSummary;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q4A\u0001E\t\u00019!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00057\u0001\t\u0005\t\u0015!\u00038\u0011\u0015Q\u0004\u0001\"\u0001<\u0011\u0015Q\u0004\u0001\"\u0001J\u0011\u0019Q\u0004\u0001\"\u0001\u0014\u001d\"AA\r\u0001EC\u0002\u0013%Q\r\u0003\u0005m\u0001!\u0015\r\u0011\"\u0003n\u0011!q\u0007\u0001#b\u0001\n\u0013i\u0007\u0002C8\u0001\u0011\u000b\u0007I\u0011B7\t\u0011A\u0004\u0001R1A\u0005\n5DQ!\u001d\u0001\u0005\u00025DQa\u001d\u0001\u0005\u00025DQ!\u001e\u0001\u0005\u00025DQa\u001e\u0001\u0005\u00025DQ!\u001f\u0001\u0005\u00025\u0014\u0011CU3he\u0016\u001c8/[8o\u001b\u0016$(/[2t\u0015\t\u00112#\u0001\u0006fm\u0006dW/\u0019;j_:T!\u0001F\u000b\u0002\u000b5dG.\u001b2\u000b\u0005Y9\u0012!B:qCJ\\'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001aE\u0002\u0001;\r\u0002\"AH\u0011\u000e\u0003}Q\u0011\u0001I\u0001\u0006g\u000e\fG.Y\u0005\u0003E}\u0011a!\u00118z%\u00164\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\u0016\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001e\f\u0011\u0004\u001d:fI&\u001cG/[8o\u0003:$wJY:feZ\fG/[8ogB\u00191F\f\u0019\u000e\u00031R!!L\u000b\u0002\u0007I$G-\u0003\u00020Y\t\u0019!\u000b\u0012#\u0011\ty\t4gM\u0005\u0003e}\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u00105\u0013\t)tD\u0001\u0004E_V\u0014G.Z\u0001\u000ei\"\u0014x.^4i\u001fJLw-\u001b8\u0011\u0005yA\u0014BA\u001d \u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDc\u0001\u001f?\u007fA\u0011Q\bA\u0007\u0002#!)\u0011f\u0001a\u0001U!)ag\u0001a\u0001o!\u001a1!Q$\u0011\u0005\t+U\"A\"\u000b\u0005\u0011+\u0012AC1o]>$\u0018\r^5p]&\u0011ai\u0011\u0002\u0006'&t7-Z\u0011\u0002\u0011\u0006)!G\f\u0019/aQ\u0011AH\u0013\u0005\u0006S\u0011\u0001\rA\u000b\u0015\u0004\t\u0005c\u0015%A'\u0002\u000bEr#G\f\u0019\u0015\u0005qz\u0005\"B\u0015\u0006\u0001\u0004\u0001\u0006CA)b\u001d\t\u0011fL\u0004\u0002T9:\u0011Ak\u0017\b\u0003+js!AV-\u000e\u0003]S!\u0001W\u000e\u0002\rq\u0012xn\u001c;?\u0013\u0005Q\u0012B\u0001\r\u001a\u0013\t1r#\u0003\u0002^+\u0005\u00191/\u001d7\n\u0005}\u0003\u0017a\u00029bG.\fw-\u001a\u0006\u0003;VI!AY2\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA0a\u0003\u001d\u0019X/\\7bef,\u0012A\u001a\t\u0003O*l\u0011\u0001\u001b\u0006\u0003SN\tAa\u001d;bi&\u00111\u000e\u001b\u0002\u001f\u001bVdG/\u001b<be&\fG/Z*uCRL7\u000f^5dC2\u001cV/\\7bef\f1aU*z+\u0005\u0019\u0014!B*TKJ\u0014\u0018!B*Ti>$\u0018!B*Te\u0016<\u0017!E3ya2\f\u0017N\\3e-\u0006\u0014\u0018.\u00198dK\"\u001a1\"\u0011'\u0002#5,\u0017M\\!cg>dW\u000f^3FeJ|'\u000fK\u0002\r\u00032\u000b\u0001#\\3b]N\u000bX/\u0019:fI\u0016\u0013(o\u001c:)\u00075\tE*\u0001\u000bs_>$X*Z1o'F,\u0018M]3e\u000bJ\u0014xN\u001d\u0015\u0004\u001d\u0005c\u0015A\u0001:3Q\ry\u0011\t\u0014\u0015\u0004\u0001\u0005c\u0005")
public class RegressionMetrics
implements Logging {
    private MultivariateStatisticalSummary summary;
    private double SSy;
    private double SSerr;
    private double SStot;
    private double SSreg;
    private final RDD<Tuple2<Object, Object>> predictionAndObservations;
    private final boolean throughOrigin;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    /*
     * WARNING - void declaration
     */
    private MultivariateStatisticalSummary summary$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_7;
                RDD qual$1 = this.predictionAndObservations.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    double prediction = tuple2._1$mcD$sp();
                    double observation = tuple2._2$mcD$sp();
                    Vector vector = Vectors$.MODULE$.dense(observation, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{observation - prediction}));
                    return vector;
                }, ClassTag$.MODULE$.apply(Vector.class));
                MultivariateOnlineSummarizer x$1 = new MultivariateOnlineSummarizer();
                Function2 & Serializable & scala.Serializable x$2 = (Function2 & Serializable & scala.Serializable)(summary, v) -> summary.add((Vector)v);
                Function2 & Serializable & scala.Serializable x$3 = (Function2 & Serializable & scala.Serializable)(sum1, sum2) -> sum1.merge((MultivariateOnlineSummarizer)sum2);
                int x$4 = qual$1.treeAggregate$default$4((Object)x$1);
                MultivariateStatisticalSummary summary2 = (MultivariateStatisticalSummary)qual$1.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(MultivariateOnlineSummarizer.class));
                this.summary = var2_7;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.summary;
    }

    private MultivariateStatisticalSummary summary() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.summary$lzycompute() : this.summary;
    }

    private double SSy$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.SSy = package$.MODULE$.pow(this.summary().normL2().apply(0), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.SSy;
    }

    private double SSy() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.SSy$lzycompute() : this.SSy;
    }

    private double SSerr$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.SSerr = package$.MODULE$.pow(this.summary().normL2().apply(1), 2.0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.SSerr;
    }

    private double SSerr() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.SSerr$lzycompute() : this.SSerr;
    }

    private double SStot$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.SStot = this.summary().variance().apply(0) * (double)(this.summary().count() - 1L);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.SStot;
    }

    private double SStot() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.SStot$lzycompute() : this.SStot;
    }

    private double SSreg$lzycompute() {
        RegressionMetrics regressionMetrics = this;
        synchronized (regressionMetrics) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                double yMean = this.summary().mean().apply(0);
                this.SSreg = RDD$.MODULE$.doubleRDDToDoubleRDDFunctions(this.predictionAndObservations.map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)RegressionMetrics.$anonfun$SSreg$1(yMean, x0$1)), ClassTag$.MODULE$.Double())).sum();
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.SSreg;
    }

    private double SSreg() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.SSreg$lzycompute() : this.SSreg;
    }

    public double explainedVariance() {
        return this.SSreg() / (double)this.summary().count();
    }

    public double meanAbsoluteError() {
        return this.summary().normL1().apply(1) / (double)this.summary().count();
    }

    public double meanSquaredError() {
        return this.SSerr() / (double)this.summary().count();
    }

    public double rootMeanSquaredError() {
        return package$.MODULE$.sqrt(this.meanSquaredError());
    }

    public double r2() {
        return this.throughOrigin ? 1.0 - this.SSerr() / this.SSy() : 1.0 - this.SSerr() / this.SStot();
    }

    public static final /* synthetic */ double $anonfun$SSreg$1(double yMean$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double prediction = tuple2._1$mcD$sp();
        double d = package$.MODULE$.pow(prediction - yMean$1, 2.0);
        return d;
    }

    public RegressionMetrics(RDD<Tuple2<Object, Object>> predictionAndObservations, boolean throughOrigin) {
        this.predictionAndObservations = predictionAndObservations;
        this.throughOrigin = throughOrigin;
        Logging.$init$((Logging)this);
    }

    public RegressionMetrics(RDD<Tuple2<Object, Object>> predictionAndObservations) {
        this(predictionAndObservations, false);
    }

    public RegressionMetrics(Dataset<Row> predictionAndObservations) {
        this((RDD<Tuple2<Object, Object>>)predictionAndObservations.rdd().map((Function1)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Row r) {
                return new Tuple2.mcDD.sp(r.getDouble(0), r.getDouble(1));
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)));
    }
}

