/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import org.apache.spark.SparkException;
import org.apache.spark.unsafe.hash.Murmur3_x86_32;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Serializable;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public final class HashingTF$
implements Serializable {
    public static HashingTF$ MODULE$;
    private final String Native;
    private final String Murmur3;
    private final int seed;

    static {
        new HashingTF$();
    }

    public String Native() {
        return this.Native;
    }

    public String Murmur3() {
        return this.Murmur3;
    }

    public int seed() {
        return this.seed;
    }

    public int nativeHash(Object term) {
        return Statics.anyHash((Object)term);
    }

    public int murmur3Hash(Object term) {
        int n;
        Object object = term;
        if (object == null) {
            n = this.seed();
        } else if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            n = Murmur3_x86_32.hashInt((int)(bl ? 1 : 0), (int)this.seed());
        } else if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            n = Murmur3_x86_32.hashInt((int)by, (int)this.seed());
        } else if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            n = Murmur3_x86_32.hashInt((int)s, (int)this.seed());
        } else if (object instanceof Integer) {
            int n2 = BoxesRunTime.unboxToInt((Object)object);
            n = Murmur3_x86_32.hashInt((int)n2, (int)this.seed());
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            n = Murmur3_x86_32.hashLong((long)l, (int)this.seed());
        } else if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            n = Murmur3_x86_32.hashInt((int)Float.floatToIntBits(f), (int)this.seed());
        } else if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            n = Murmur3_x86_32.hashLong((long)Double.doubleToLongBits(d), (int)this.seed());
        } else if (object instanceof String) {
            String string = (String)object;
            UTF8String utf8 = UTF8String.fromString((String)string);
            n = Murmur3_x86_32.hashUnsafeBytes((Object)utf8.getBaseObject(), (long)utf8.getBaseOffset(), (int)utf8.numBytes(), (int)this.seed());
        } else {
            throw new SparkException(new StringBuilder(42).append("HashingTF with murmur3 algorithm does not ").append(new StringBuilder(28).append("support type ").append(term.getClass().getCanonicalName()).append(" of input data.").toString()).toString());
        }
        return n;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HashingTF$() {
        MODULE$ = this;
        this.Native = "native";
        this.Murmur3 = "murmur3";
        this.seed = 42;
    }
}

