/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.util.BoundedPriorityQueue;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5f\u0001\u0002 @\u0001)C\u0011B\u0017\u0001\u0003\u0006\u0004%\taQ.\t\u00115\u0004!\u0011!Q\u0001\nqC\u0011B\u001c\u0001\u0003\u0006\u0004%\taQ8\t\u0011Y\u0004!\u0011!Q\u0001\nADaa\u001e\u0001\u0005\u0002\rC\bbB?\u0001\u0005\u0004%IA \u0005\u0007\u007f\u0002\u0001\u000b\u0011\u00026\t\u0011\u0005\u0005\u0001A1A\u0005\nyDq!a\u0001\u0001A\u0003%!\u000eC\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0003\u0002\b!A\u00111\u0002\u0001!\u0002\u0013\tI\u0001\u0003\u0005\u0002\u000e\u0001\u0011\r\u0011\"\u0003p\u0011\u001d\ty\u0001\u0001Q\u0001\nADaa\u001e\u0001\u0005\u0002\u0005E\u0001bBA\u0016\u0001\u0011E\u0013Q\u0006\u0005\b\u0003{\u0001A\u0011AA \u0011\u001d\ti\u0006\u0001C\u0001\u0003?Bq!a\u001e\u0001\t\u0003\tI\bC\u0004\u0002x\u0001!\t!!%\t\u000f\u0005]\u0004\u0001\"\u0003\u0002\u001c\"9\u00111\u0016\u0001\u0005\u0002\u00055vaBA\\\u007f!\u0005\u0011\u0011\u0018\u0004\u0007}}B\t!a/\t\r]<B\u0011AAb\u0011\u001d\t)m\u0006C\u0005\u0003\u000fDq!a3\u0018\t\u0013\timB\u0004\u0002R^AI!a5\u0007\u000f\u0005]w\u0003#\u0003\u0002Z\"1q\u000f\bC\u0001\u00037D\u0011\"!8\u001d\u0005\u0004%\t!!\f\t\u0011\u0005}G\u0004)A\u0005\u0003_A\u0011\"!9\u001d\u0005\u0004%\t!!\f\t\u0011\u0005\rH\u0004)A\u0005\u0003_1a!!:\u001d\u0001\u0006\u001d\bBCA8E\tU\r\u0011\"\u0001\u0002p\"I\u0011\u0011\u001f\u0012\u0003\u0012\u0003\u0006Ia\u001a\u0005\n\u0003+\u0013#Q3A\u0005\u0002=D\u0011\"a=#\u0005#\u0005\u000b\u0011\u00029\t\r]\u0014C\u0011AA{\u0011%\tyPIA\u0001\n\u0003\u0011\t\u0001C\u0005\u0003\b\t\n\n\u0011\"\u0001\u0003\n!I!Q\u0004\u0012\u0012\u0002\u0013\u0005!q\u0004\u0005\n\u0005G\u0011\u0013\u0011!C!\u0003[A\u0001B!\n#\u0003\u0003%\tA \u0005\n\u0005O\u0011\u0013\u0011!C\u0001\u0005SA\u0011B!\u000e#\u0003\u0003%\tEa\u000e\t\u0013\t\u0015#%!A\u0005\u0002\t\u001d\u0003\"\u0003B)E\u0005\u0005I\u0011\tB*\u0011%\u0011)FIA\u0001\n\u0003\u00129\u0006C\u0005\u0003Z\t\n\t\u0011\"\u0011\u0003\\\u001dI!q\f\u000f\u0002\u0002#\u0005!\u0011\r\u0004\n\u0003Kd\u0012\u0011!E\u0001\u0005GBaa\u001e\u001b\u0005\u0002\tE\u0004\"\u0003B+i\u0005\u0005IQ\tB,\u0011%\u0011\u0019\bNA\u0001\n\u0003\u0013)\bC\u0005\u0003|Q\n\t\u0011\"!\u0003~!I!q\u0011\u001b\u0002\u0002\u0013%!\u0011\u0012\u0005\b\u0005#cB\u0011\u0001BJ\u0011\u001d\ti\u0004\bC\u0001\u00053CqA!%\u0018\t\u0003\u0012\t\u000bC\u0005\u0003\b^\t\t\u0011\"\u0003\u0003\n\niqk\u001c:eeY+7-T8eK2T!\u0001Q!\u0002\u000f\u0019,\u0017\r^;sK*\u0011!iQ\u0001\u0006[2d\u0017N\u0019\u0006\u0003\t\u0016\u000bQa\u001d9be.T!AR$\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0015aA8sO\u000e\u00011\u0003\u0002\u0001L#R\u0003\"\u0001T(\u000e\u00035S\u0011AT\u0001\u0006g\u000e\fG.Y\u0005\u0003!6\u0013a!\u00118z%\u00164\u0007C\u0001'S\u0013\t\u0019VJ\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0005\u0002V16\taK\u0003\u0002X\u0003\u0006!Q\u000f^5m\u0013\tIfK\u0001\u0005TCZ,\u0017M\u00197f\u0003%9xN\u001d3J]\u0012,\u00070F\u0001]!\u0011iFm\u001a6\u000f\u0005y\u0013\u0007CA0N\u001b\u0005\u0001'BA1J\u0003\u0019a$o\\8u}%\u00111-T\u0001\u0007!J,G-\u001a4\n\u0005\u00154'aA'ba*\u00111-\u0014\t\u0003;\"L!!\u001b4\u0003\rM#(/\u001b8h!\ta5.\u0003\u0002m\u001b\n\u0019\u0011J\u001c;\u0002\u0015]|'\u000fZ%oI\u0016D\b%A\u0006x_J$g+Z2u_J\u001cX#\u00019\u0011\u00071\u000b8/\u0003\u0002s\u001b\n)\u0011I\u001d:bsB\u0011A\n^\u0005\u0003k6\u0013QA\u00127pCR\fAb^8sIZ+7\r^8sg\u0002\na\u0001P5oSRtDcA=|yB\u0011!\u0010A\u0007\u0002\u007f!)!,\u0002a\u00019\")a.\u0002a\u0001a\u0006Aa.^7X_J$7/F\u0001k\u0003%qW/\\,pe\u0012\u001c\b%\u0001\u0006wK\u000e$xN]*ju\u0016\f1B^3di>\u00148+\u001b>fA\u0005Aqo\u001c:e\u0019&\u001cH/\u0006\u0002\u0002\nA\u0019A*]4\u0002\u0013]|'\u000f\u001a'jgR\u0004\u0013\u0001D<pe\u00124Vm\u0019(pe6\u001c\u0018!D<pe\u00124Vm\u0019(pe6\u001c\b\u0005F\u0002z\u0003'Aq!!\u0006\u000f\u0001\u0004\t9\"A\u0003n_\u0012,G\u000e\u0005\u0003^I\u001e\u0004\b&\u0002\b\u0002\u001c\u0005\u001d\u0002\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u00052)\u0001\u0006b]:|G/\u0019;j_:LA!!\n\u0002 \t)1+\u001b8dK\u0006\u0012\u0011\u0011F\u0001\u0006c9*d\u0006M\u0001\u000eM>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0005\u0005=\u0002\u0003BA\u0019\u0003wi!!a\r\u000b\t\u0005U\u0012qG\u0001\u0005Y\u0006twM\u0003\u0002\u0002:\u0005!!.\u0019<b\u0013\rI\u00171G\u0001\u0005g\u00064X\r\u0006\u0004\u0002B\u0005\u001d\u00131\u000b\t\u0004\u0019\u0006\r\u0013bAA#\u001b\n!QK\\5u\u0011\u001d\tI\u0005\u0005a\u0001\u0003\u0017\n!a]2\u0011\t\u00055\u0013qJ\u0007\u0002\u0007&\u0019\u0011\u0011K\"\u0003\u0019M\u0003\u0018M]6D_:$X\r\u001f;\t\r\u0005U\u0003\u00031\u0001h\u0003\u0011\u0001\u0018\r\u001e5)\u000bA\tY\"!\u0017\"\u0005\u0005m\u0013!B\u0019/i9\u0002\u0014!\u0003;sC:\u001chm\u001c:n)\u0011\t\t'!\u001c\u0011\t\u0005\r\u0014\u0011N\u0007\u0003\u0003KR1!a\u001aB\u0003\u0019a\u0017N\\1mO&!\u00111NA3\u0005\u00191Vm\u0019;pe\"1\u0011qN\tA\u0002\u001d\fAa^8sI\"*\u0011#a\u0007\u0002t\u0005\u0012\u0011QO\u0001\u0006c9\nd\u0006M\u0001\rM&tGmU=o_:LXn\u001d\u000b\u0007\u0003w\nI)a#\u0011\t1\u000b\u0018Q\u0010\t\u0007\u0019\u0006}t-a!\n\u0007\u0005\u0005UJ\u0001\u0004UkBdWM\r\t\u0004\u0019\u0006\u0015\u0015bAAD\u001b\n1Ai\\;cY\u0016Da!a\u001c\u0013\u0001\u00049\u0007BBAG%\u0001\u0007!.A\u0002ok6DSAEA\u000e\u0003g\"b!a\u001f\u0002\u0014\u0006]\u0005bBAK'\u0001\u0007\u0011\u0011M\u0001\u0007m\u0016\u001cGo\u001c:\t\r\u000555\u00031\u0001kQ\u0015\u0019\u00121DA:)!\tY(!(\u0002 \u0006\u0005\u0006bBAK)\u0001\u0007\u0011\u0011\r\u0005\u0007\u0003\u001b#\u0002\u0019\u00016\t\u000f\u0005\rF\u00031\u0001\u0002&\u00069qo\u001c:e\u001fB$\b\u0003\u0002'\u0002(\u001eL1!!+N\u0005\u0019y\u0005\u000f^5p]\u0006Qq-\u001a;WK\u000e$xN]:\u0016\u0005\u0005]\u0001&B\u000b\u0002\u001c\u0005E\u0016EAAZ\u0003\u0015\tdF\r\u00181Q\u0015\u0001\u00111DA:\u000359vN\u001d33-\u0016\u001cWj\u001c3fYB\u0011!pF\n\u0006/-\u000bi,\u0015\t\u0005+\u0006}\u00160C\u0002\u0002BZ\u0013a\u0001T8bI\u0016\u0014HCAA]\u00039\u0011W/\u001b7e/>\u0014H-\u00138eKb$2\u0001XAe\u0011\u001d\t)\"\u0007a\u0001\u0003/\t\u0001CY;jY\u0012<vN\u001d3WK\u000e$xN]:\u0015\u0007A\fy\rC\u0004\u0002\u0016i\u0001\r!a\u0006\u0002\u0019M\u000bg/\u001a'pC\u00124\u0016g\u0018\u0019\u0011\u0007\u0005UG$D\u0001\u0018\u00051\u0019\u0016M^3M_\u0006$g+M01'\ta2\n\u0006\u0002\u0002T\u0006\tbm\u001c:nCR4VM]:j_:4\u0016g\u0018\u0019\u0002%\u0019|'/\\1u-\u0016\u00148/[8o-Fz\u0006\u0007I\u0001\u000eG2\f7o\u001d(b[\u00164\u0016g\u0018\u0019\u0002\u001d\rd\u0017m]:OC6,g+M01A\t!A)\u0019;b'\u0015\u00113*!;R!\ra\u00151^\u0005\u0004\u0003[l%a\u0002)s_\u0012,8\r^\u000b\u0002O\u0006)qo\u001c:eA\u00059a/Z2u_J\u0004CCBA|\u0003w\fi\u0010E\u0002\u0002z\nj\u0011\u0001\b\u0005\u0007\u0003_:\u0003\u0019A4\t\r\u0005Uu\u00051\u0001q\u0003\u0011\u0019w\u000e]=\u0015\r\u0005](1\u0001B\u0003\u0011!\ty\u0007\u000bI\u0001\u0002\u00049\u0007\u0002CAKQA\u0005\t\u0019\u00019\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!1\u0002\u0016\u0004O\n51F\u0001B\b!\u0011\u0011\tB!\u0007\u000e\u0005\tM!\u0002\u0002B\u000b\u0005/\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005R*\u0003\u0003\u0003\u001c\tM!!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0011U\r\u0001(QB\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0006B\u0019!\ra%QF\u0005\u0004\u0005_i%aA!os\"A!1G\u0017\u0002\u0002\u0003\u0007!.A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005s\u0001bAa\u000f\u0003B\t-RB\u0001B\u001f\u0015\r\u0011y$T\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\"\u0005{\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!\u0011\nB(!\ra%1J\u0005\u0004\u0005\u001bj%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005gy\u0013\u0011!a\u0001\u0005W\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002U\u0006AAo\\*ue&tw\r\u0006\u0002\u00020\u00051Q-];bYN$BA!\u0013\u0003^!I!1\u0007\u001a\u0002\u0002\u0003\u0007!1F\u0001\u0005\t\u0006$\u0018\rE\u0002\u0002zR\u001aB\u0001\u000eB3#BA!q\rB7OB\f90\u0004\u0002\u0003j)\u0019!1N'\u0002\u000fI,h\u000e^5nK&!!q\u000eB5\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u000b\u0003\u0005C\nQ!\u00199qYf$b!a>\u0003x\te\u0004BBA8o\u0001\u0007q\r\u0003\u0004\u0002\u0016^\u0002\r\u0001]\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yHa!\u0011\u000b1\u000b9K!!\u0011\u000b1\u000byh\u001a9\t\u0013\t\u0015\u0005(!AA\u0002\u0005]\u0018a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\t\u0005\u0003\u00022\t5\u0015\u0002\u0002BH\u0003g\u0011aa\u00142kK\u000e$\u0018\u0001\u00027pC\u0012$R!\u001fBK\u0005/Cq!!\u0013;\u0001\u0004\tY\u0005\u0003\u0004\u0002Vi\u0002\ra\u001a\u000b\t\u0003\u0003\u0012YJ!(\u0003 \"9\u0011\u0011J\u001eA\u0002\u0005-\u0003BBA+w\u0001\u0007q\rC\u0004\u0002\u0016m\u0002\r!a\u0006\u0015\u000be\u0014\u0019K!*\t\u000f\u0005%C\b1\u0001\u0002L!1\u0011Q\u000b\u001fA\u0002\u001dDS\u0001PA\u000e\u00033BSaFA\u000e\u00033BSAFA\u000e\u00033\u0002")
public class Word2VecModel
implements scala.Serializable,
Saveable {
    private final Map<String, Object> wordIndex;
    private final float[] wordVectors;
    private final int numWords;
    private final int vectorSize;
    private final String[] wordList;
    private final float[] wordVecNorms;

    public static Word2VecModel load(SparkContext sparkContext, String string) {
        return Word2VecModel$.MODULE$.load(sparkContext, string);
    }

    public Map<String, Object> wordIndex() {
        return this.wordIndex;
    }

    public float[] wordVectors() {
        return this.wordVectors;
    }

    private int numWords() {
        return this.numWords;
    }

    private int vectorSize() {
        return this.vectorSize;
    }

    private String[] wordList() {
        return this.wordList;
    }

    private float[] wordVecNorms() {
        return this.wordVecNorms;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        Word2VecModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getVectors());
    }

    public Vector transform(String word) {
        Option option = this.wordIndex().get((Object)word);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new IllegalStateException(new StringBuilder(18).append(word).append(" not in vocabulary").toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        int ind = BoxesRunTime.unboxToInt((Object)some.value());
        float[] vec = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.wordVectors())).slice(ind * this.vectorSize(), ind * this.vectorSize() + this.vectorSize());
        Vector vector = Vectors$.MODULE$.dense((double[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(vec)).map((Function1)(JFunction1.mcDF.sp & Serializable & scala.Serializable)x$8 -> x$8, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
        return vector;
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector, num, (Option<String>)new Some((Object)word));
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        return this.findSynonyms(vector, num, (Option<String>)None$.MODULE$);
    }

    private Tuple2<String, Object>[] findSynonyms(Vector vector, int num, Option<String> wordOpt) {
        Seq seq;
        Predef$.MODULE$.require(num > 0, (Function0 & Serializable & scala.Serializable)() -> "Number of similar words should > 0");
        float[] fVector = (float[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(vector.toArray())).map((Function1)(JFunction1.mcFD.sp & Serializable & scala.Serializable)x$9 -> (float)x$9, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        float[] cosineVec = new float[this.numWords()];
        float alpha = 1.0f;
        float beta = 0.0f;
        float vecNorm = BLAS.getInstance().snrm2(this.vectorSize(), fVector, 1);
        if (vecNorm != 0.0f) {
            BLAS.getInstance().sscal(this.vectorSize(), 1.0f / vecNorm, fVector, 0, 1);
        }
        BLAS.getInstance().sgemv("T", this.vectorSize(), this.numWords(), alpha, this.wordVectors(), this.vectorSize(), fVector, 1, beta, cosineVec, 1);
        for (int i = 0; i < this.numWords(); ++i) {
            float norm = this.wordVecNorms()[i];
            if (norm == 0.0f) {
                cosineVec[i] = 0.0f;
                continue;
            }
            int n = i;
            cosineVec[n] = cosineVec[n] / norm;
        }
        BoundedPriorityQueue pq = new BoundedPriorityQueue(num + 1, package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToFloat((float)Word2VecModel.$anonfun$findSynonyms$3(x$10)), (Ordering)Ordering.Float$.MODULE$));
        for (int j = 0; j < this.numWords(); ++j) {
            pq.$plus$eq((Object)new Tuple2((Object)this.wordList()[j], (Object)BoxesRunTime.boxToFloat((float)cosineVec[j])));
        }
        Seq scored = (Seq)pq.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToFloat((float)Word2VecModel.$anonfun$findSynonyms$4(x$11)), (Ordering)Ordering.Float$.MODULE$);
        Option<String> option = wordOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            String w = (String)some.value();
            seq = (Seq)scored.filter((Function1 & Serializable & scala.Serializable)tup -> BoxesRunTime.boxToBoolean((boolean)Word2VecModel.$anonfun$findSynonyms$5(w, tup)));
        } else if (None$.MODULE$.equals(option)) {
            seq = scored;
        } else {
            throw new MatchError(option);
        }
        Seq filtered = seq;
        return (Tuple2[])((TraversableOnce)((TraversableLike)filtered.take(num)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String word = (String)tuple2._1();
            float score = BoxesRunTime.unboxToFloat((Object)tuple2._2());
            Tuple2 tuple22 = new Tuple2((Object)word, (Object)BoxesRunTime.boxToDouble((double)score));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Map<String, float[]> getVectors() {
        return (Map)this.wordIndex().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String word = (String)tuple2._1();
            int ind = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)word, new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.wordVectors())).slice(this.vectorSize() * ind, this.vectorSize() * ind + this.vectorSize()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ float $anonfun$findSynonyms$3(Tuple2 x$10) {
        return BoxesRunTime.unboxToFloat((Object)x$10._2());
    }

    public static final /* synthetic */ float $anonfun$findSynonyms$4(Tuple2 x$11) {
        return -BoxesRunTime.unboxToFloat((Object)x$11._2());
    }

    public static final /* synthetic */ boolean $anonfun$findSynonyms$5(String w$1, Tuple2 tup) {
        String string = w$1;
        Object object = tup._1();
        return string == null ? object != null : !string.equals(object);
    }

    public Word2VecModel(Map<String, Object> wordIndex, float[] wordVectors) {
        Seq wl;
        this.wordIndex = wordIndex;
        this.wordVectors = wordVectors;
        this.numWords = wordIndex.size();
        this.vectorSize = wordVectors.length / this.numWords();
        Tuple2 tuple2 = ((GenericTraversableTemplate)wordIndex.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.$conforms());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq seq = wl = (Seq)tuple2._1();
        Seq wl2 = seq;
        this.wordList = (String[])wl2.toArray(ClassTag$.MODULE$.apply(String.class));
        float[] wordVecNorms = new float[this.numWords()];
        for (int i = 0; i < this.numWords(); ++i) {
            float[] vec = (float[])new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(wordVectors)).slice(i * this.vectorSize(), i * this.vectorSize() + this.vectorSize());
            wordVecNorms[i] = BLAS.getInstance().snrm2(this.vectorSize(), vec, 1);
        }
        this.wordVecNorms = wordVecNorms;
    }

    public Word2VecModel(Map<String, float[]> model) {
        this(Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordIndex(model), Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordVectors(model));
    }
}

