/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.regression;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaDoubleRDD;
import org.apache.spark.api.java.JavaDoubleRDD$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$;
import org.apache.spark.mllib.regression.IsotonicRegressionModel$SaveLoadV1_0$;
import org.apache.spark.mllib.util.Saveable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5g\u0001B\u001c9\u0001\rC\u0001\u0002\u0017\u0001\u0003\u0006\u0004%\t!\u0017\u0005\tS\u0002\u0011\t\u0011)A\u00055\"A1\u000e\u0001BC\u0002\u0013\u0005\u0011\f\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003[\u0011!y\u0007A!b\u0001\n\u0003\u0001\b\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u000b]\u0004A\u0011\u0001=\t\u0013\u0005\u0015\u0001A1A\u0005\n\u0005\u001d\u0001\u0002CA\u000b\u0001\u0001\u0006I!!\u0003\t\r]\u0004A\u0011AA\f\u0011\u001d\t)\u0004\u0001C\u0005\u0003oAq!a\u0018\u0001\t\u0003\t\t\u0007C\u0004\u0002`\u0001!\t!!\u001e\t\u000f\u0005}\u0003\u0001\"\u0001\u0002\n\"A\u0011q\u0012\u0001\u0005\u0002i\n\t\n\u0003\u0005\u0002 \u0002!\tAOAI\u0011\u001d\t\t\u000b\u0001C!\u0003GCq!a2\u0001\t#\nImB\u0004\u0002NbB\t!a4\u0007\r]B\u0004\u0012AAi\u0011\u00199H\u0003\"\u0001\u0002^\u001e9\u0011q\u001c\u000b\t\n\u0005\u0005haBAs)!%\u0011q\u001d\u0005\u0007o^!\t!!;\t\u000f\u0005-x\u0003\"\u0001\u0002J\"9\u0011Q^\f\u0005\u0002\u0005%gABAx/\u0001\u000b\t\u0010\u0003\u0006\u0002zn\u0011)\u001a!C\u0001\u0003wD\u0011\"!@\u001c\u0005#\u0005\u000b\u0011B/\t\u0015\u0005}8D!f\u0001\n\u0003\tY\u0010C\u0005\u0003\u0002m\u0011\t\u0012)A\u0005;\"1qo\u0007C\u0001\u0005\u0007A\u0011B!\u0004\u001c\u0003\u0003%\tAa\u0004\t\u0013\tU1$%A\u0005\u0002\t]\u0001\"\u0003B\u00167E\u0005I\u0011\u0001B\f\u0011%\u0011icGA\u0001\n\u0003\u0012y\u0003C\u0005\u00036m\t\t\u0011\"\u0001\u00038!I!qH\u000e\u0002\u0002\u0013\u0005!\u0011\t\u0005\n\u0005\u001bZ\u0012\u0011!C!\u0005\u001fB\u0011B!\u0018\u001c\u0003\u0003%\tAa\u0018\t\u0013\t\r4$!A\u0005B\t\u0015\u0004\"\u0003B47\u0005\u0005I\u0011\tB5\u0011%\u0011YgGA\u0001\n\u0003\u0012igB\u0005\u0003r]\t\t\u0011#\u0001\u0003t\u0019I\u0011q^\f\u0002\u0002#\u0005!Q\u000f\u0005\u0007o6\"\tAa!\t\u0013\t\u001dT&!A\u0005F\t%\u0004\"\u0003BC[\u0005\u0005I\u0011\u0011BD\u0011%\u0011i)LA\u0001\n\u0003\u0013y\tC\u0005\u0003\"6\n\t\u0011\"\u0003\u0003$\"9\u0011\u0011U\f\u0005\u0002\t-\u0006b\u0002B\\/\u0011\u0005!\u0011\u0018\u0005\b\u0005o#B\u0011\tBa\u0011%\u0011\t\u000bFA\u0001\n\u0013\u0011\u0019KA\fJg>$xN\\5d%\u0016<'/Z:tS>tWj\u001c3fY*\u0011\u0011HO\u0001\u000be\u0016<'/Z:tS>t'BA\u001e=\u0003\u0015iG\u000e\\5c\u0015\tid(A\u0003ta\u0006\u00148N\u0003\u0002@\u0001\u00061\u0011\r]1dQ\u0016T\u0011!Q\u0001\u0004_J<7\u0001A\n\u0005\u0001\u0011S%\u000b\u0005\u0002F\u00116\taIC\u0001H\u0003\u0015\u00198-\u00197b\u0013\tIeI\u0001\u0004B]f\u0014VM\u001a\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000b!![8\u000b\u0003=\u000bAA[1wC&\u0011\u0011\u000b\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+j\nA!\u001e;jY&\u0011q\u000b\u0016\u0002\t'\u00064X-\u00192mK\u0006Q!m\\;oI\u0006\u0014\u0018.Z:\u0016\u0003i\u00032!R.^\u0013\tafIA\u0003BeJ\f\u0017\u0010\u0005\u0002F=&\u0011qL\u0012\u0002\u0007\t>,(\r\\3)\u0007\u0005\tw\r\u0005\u0002cK6\t1M\u0003\u0002ey\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005\u0019\u001c'!B*j]\u000e,\u0017%\u00015\u0002\u000bEr3G\f\u0019\u0002\u0017\t|WO\u001c3be&,7\u000f\t\u0015\u0004\u0005\u0005<\u0017a\u00039sK\u0012L7\r^5p]ND3aA1h\u00031\u0001(/\u001a3jGRLwN\\:!Q\r!\u0011mZ\u0001\tSN|Go\u001c8jGV\t\u0011\u000f\u0005\u0002Fe&\u00111O\u0012\u0002\b\u0005>|G.Z1oQ\r)\u0011mZ\u0001\nSN|Go\u001c8jG\u0002B3AB1h\u0003\u0019a\u0014N\\5u}Q!\u0011p_?\u0000!\tQ\b!D\u00019\u0011\u0015Av\u00011\u0001[Q\rY\u0018m\u001a\u0005\u0006W\u001e\u0001\rA\u0017\u0015\u0004{\u0006<\u0007\"B8\b\u0001\u0004\t\bfA@bO\"\u001aq!Y4\u0002\u001bA\u0014X\rZ5di&|gn\u0014:e+\t\tI\u0001E\u0003\u0002\f\u0005EQ,\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002$\u0002\t5\fG\u000f[\u0005\u0005\u0003'\tiA\u0001\u0005Pe\u0012,'/\u001b8h\u00039\u0001(/\u001a3jGRLwN\\(sI\u0002\"r!_A\r\u0003O\tI\u0003\u0003\u0004Y\u0015\u0001\u0007\u00111\u0004\t\u0006\u0003;\t\u0019#X\u0007\u0003\u0003?Q1!!\tO\u0003\u0011a\u0017M\\4\n\t\u0005\u0015\u0012q\u0004\u0002\t\u0013R,'/\u00192mK\"11N\u0003a\u0001\u00037Aaa\u001c\u0006A\u0002\u0005-\u0002\u0003BA\u000f\u0003[I1a]A\u0010Q\u0011Q\u0011-!\r\"\u0005\u0005M\u0012!B\u0019/i9\u0002\u0014!D1tg\u0016\u0014Ho\u0014:eKJ,G\r\u0006\u0003\u0002:\u0005mC\u0003BA\u001e\u0003\u0003\u00022!RA\u001f\u0013\r\tyD\u0012\u0002\u0005+:LG\u000fC\u0004\u0002D-\u0001\u001d!!\u0012\u0002\u0007=\u0014H\rE\u0003\u0002H\u0005]SL\u0004\u0003\u0002J\u0005Mc\u0002BA&\u0003#j!!!\u0014\u000b\u0007\u0005=#)\u0001\u0004=e>|GOP\u0005\u0002\u000f&\u0019\u0011Q\u000b$\u0002\u000fA\f7m[1hK&!\u00111CA-\u0015\r\t)F\u0012\u0005\u0007\u0003;Z\u0001\u0019\u0001.\u0002\u0005a\u001c\u0018a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003G\ny\u0007E\u0003\u0002f\u0005-T,\u0004\u0002\u0002h)\u0019\u0011\u0011\u000e\u001f\u0002\u0007I$G-\u0003\u0003\u0002n\u0005\u001d$a\u0001*E\t\"9\u0011\u0011\u000f\u0007A\u0002\u0005\r\u0014\u0001\u0003;fgR$\u0015\r^1)\u00071\tw\r\u0006\u0003\u0002x\u0005\u0015\u0005\u0003BA=\u0003\u0003k!!a\u001f\u000b\u0007=\u000biHC\u0002\u0002\u0000q\n1!\u00199j\u0013\u0011\t\u0019)a\u001f\u0003\u001b)\u000bg/\u0019#pk\ndWM\u0015#E\u0011\u001d\t\t(\u0004a\u0001\u0003oB3!D1h)\ri\u00161\u0012\u0005\u0007\u0003cr\u0001\u0019A/)\u00079\tw-\u0001\bc_VtG-\u0019:z-\u0016\u001cGo\u001c:\u0016\u0005\u0005M\u0005\u0003BAK\u00037k!!a&\u000b\u0007\u0005e%(\u0001\u0004mS:\fGnZ\u0005\u0005\u0003;\u000b9J\u0001\u0004WK\u000e$xN]\u0001\u0011aJ,G-[2uS>tg+Z2u_J\fAa]1wKR1\u00111HAS\u0003cCq!a*\u0012\u0001\u0004\tI+\u0001\u0002tGB!\u00111VAW\u001b\u0005a\u0014bAAXy\ta1\u000b]1sW\u000e{g\u000e^3yi\"9\u00111W\tA\u0002\u0005U\u0016\u0001\u00029bi\"\u0004B!a.\u0002@:!\u0011\u0011XA^!\r\tYER\u0005\u0004\u0003{3\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002B\u0006\r'AB*ue&twMC\u0002\u0002>\u001aCC!E1\u00022\u0005iam\u001c:nCR4VM]:j_:,\"!!.)\u0007\u0001\tw-A\fJg>$xN\\5d%\u0016<'/Z:tS>tWj\u001c3fYB\u0011!\u0010F\n\u0007)\u0011\u000b\u0019.!7\u0011\tM\u000b)._\u0005\u0004\u0003/$&A\u0002'pC\u0012,'\u000fE\u0002F\u00037L!!\u0015$\u0015\u0005\u0005=\u0017\u0001D*bm\u0016du.\u00193Wc}\u0003\u0004cAAr/5\tAC\u0001\u0007TCZ,Gj\\1e-Fz\u0006g\u0005\u0002\u0018\tR\u0011\u0011\u0011]\u0001\u0012i\"L7OR8s[\u0006$h+\u001a:tS>t\u0017!\u0004;iSN\u001cE.Y:t\u001d\u0006lWM\u0001\u0003ECR\f7CB\u000eE\u0003g\fI\u000eE\u0002F\u0003kL1!a>G\u0005\u001d\u0001&o\u001c3vGR\f\u0001BY8v]\u0012\f'/_\u000b\u0002;\u0006I!m\\;oI\u0006\u0014\u0018\u0010I\u0001\u000baJ,G-[2uS>t\u0017a\u00039sK\u0012L7\r^5p]\u0002\"bA!\u0002\u0003\n\t-\u0001c\u0001B\u000475\tq\u0003\u0003\u0004\u0002z\u0002\u0002\r!\u0018\u0005\u0007\u0003\u007f\u0004\u0003\u0019A/\u0002\t\r|\u0007/\u001f\u000b\u0007\u0005\u000b\u0011\tBa\u0005\t\u0011\u0005e\u0018\u0005%AA\u0002uC\u0001\"a@\"!\u0003\u0005\r!X\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011IBK\u0002^\u00057Y#A!\b\u0011\t\t}!qE\u0007\u0003\u0005CQAAa\t\u0003&\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0003I\u001aKAA!\u000b\u0003\"\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!\r\u0011\t\u0005u!1G\u0005\u0005\u0003\u0003\fy\"\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003:A\u0019QIa\u000f\n\u0007\tubIA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003D\t%\u0003cA#\u0003F%\u0019!q\t$\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003L\u0019\n\t\u00111\u0001\u0003:\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u0015\u0011\r\tM#\u0011\fB\"\u001b\t\u0011)FC\u0002\u0003X\u0019\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011YF!\u0016\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0004c\n\u0005\u0004\"\u0003B&Q\u0005\u0005\t\u0019\u0001B\"\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B\u001d\u0003!!xn\u0015;sS:<GC\u0001B\u0019\u0003\u0019)\u0017/^1mgR\u0019\u0011Oa\u001c\t\u0013\t-3&!AA\u0002\t\r\u0013\u0001\u0002#bi\u0006\u00042Aa\u0002.'\u0015i#qOAm!!\u0011IHa ^;\n\u0015QB\u0001B>\u0015\r\u0011iHR\u0001\beVtG/[7f\u0013\u0011\u0011\tIa\u001f\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003t\u0005)\u0011\r\u001d9msR1!Q\u0001BE\u0005\u0017Ca!!?1\u0001\u0004i\u0006BBA\u0000a\u0001\u0007Q,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE%Q\u0014\t\u0006\u000b\nM%qS\u0005\u0004\u0005+3%AB(qi&|g\u000eE\u0003F\u00053kV,C\u0002\u0003\u001c\u001a\u0013a\u0001V;qY\u0016\u0014\u0004\"\u0003BPc\u0005\u0005\t\u0019\u0001B\u0003\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003&B!\u0011Q\u0004BT\u0013\u0011\u0011I+a\b\u0003\r=\u0013'.Z2u)1\tYD!,\u00030\nE&1\u0017B[\u0011\u001d\t9k\ra\u0001\u0003SCq!a-4\u0001\u0004\t)\fC\u0003Yg\u0001\u0007!\fC\u0003lg\u0001\u0007!\fC\u0003pg\u0001\u0007\u0011/\u0001\u0003m_\u0006$GC\u0002B^\u0005{\u0013y\fE\u0003F\u00053S&\fC\u0004\u0002(R\u0002\r!!+\t\u000f\u0005MF\u00071\u0001\u00026R)\u0011Pa1\u0003F\"9\u0011qU\u001bA\u0002\u0005%\u0006bBAZk\u0001\u0007\u0011Q\u0017\u0015\u0005k\u0005\f\t\u0004\u000b\u0003\u0015C\u0006E\u0002\u0006B\nb\u0003c\u0001")
public class IsotonicRegressionModel
implements Serializable,
Saveable {
    private final double[] boundaries;
    private final double[] predictions;
    private final boolean isotonic;
    private final Ordering<Object> predictionOrd;

    public static IsotonicRegressionModel load(SparkContext sparkContext, String string) {
        return IsotonicRegressionModel$.MODULE$.load(sparkContext, string);
    }

    public double[] boundaries() {
        return this.boundaries;
    }

    public double[] predictions() {
        return this.predictions;
    }

    public boolean isotonic() {
        return this.isotonic;
    }

    private Ordering<Object> predictionOrd() {
        return this.predictionOrd;
    }

    private void assertOrdered(double[] xs, Ordering<Object> ord) {
        IntRef i = IntRef.create((int)1);
        int len = xs.length;
        while (i.elem < len) {
            Predef$.MODULE$.require(ord.compare((Object)BoxesRunTime.boxToDouble((double)xs[i.elem - 1]), (Object)BoxesRunTime.boxToDouble((double)xs[i.elem])) <= 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Elements (").append(xs[i$1.elem - 1]).append(", ").append(xs[i$1.elem]).append(") are not ordered.").toString());
            ++i.elem;
        }
    }

    public RDD<Object> predict(RDD<Object> testData2) {
        return testData2.map((Function1)(JFunction1.mcDD.sp & Serializable & scala.Serializable)testData -> this.predict(testData), ClassTag$.MODULE$.Double());
    }

    public JavaDoubleRDD predict(JavaDoubleRDD testData) {
        return JavaDoubleRDD$.MODULE$.fromRDD(this.predict((RDD<Object>)testData.rdd().retag(ClassTag$.MODULE$.apply(Double.class))));
    }

    public double predict(double testData) {
        int foundIndex = Arrays.binarySearch(this.boundaries(), testData);
        int insertIndex = -foundIndex - 1;
        return insertIndex == 0 ? BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.predictions())).head()) : (insertIndex == this.boundaries().length ? BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(this.predictions())).last()) : (foundIndex < 0 ? IsotonicRegressionModel.linearInterpolation$1(this.boundaries()[insertIndex - 1], this.predictions()[insertIndex - 1], this.boundaries()[insertIndex], this.predictions()[insertIndex], testData) : this.predictions()[foundIndex]));
    }

    public Vector boundaryVector() {
        return Vectors$.MODULE$.dense(this.boundaries());
    }

    public Vector predictionVector() {
        return Vectors$.MODULE$.dense(this.predictions());
    }

    @Override
    public void save(SparkContext sc, String path) {
        IsotonicRegressionModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.boundaries(), this.predictions(), this.isotonic());
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    private static final double linearInterpolation$1(double x1, double y1, double x2, double y2, double x) {
        return y1 + (y2 - y1) * (x - x1) / (x2 - x1);
    }

    public IsotonicRegressionModel(double[] boundaries, double[] predictions, boolean isotonic) {
        this.boundaries = boundaries;
        this.predictions = predictions;
        this.isotonic = isotonic;
        this.predictionOrd = isotonic ? package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$) : package$.MODULE$.Ordering().apply((Ordering)Ordering.Double$.MODULE$).reverse();
        Predef$.MODULE$.require(boundaries.length == predictions.length);
        this.assertOrdered(boundaries, (Ordering<Object>)Ordering.Double$.MODULE$);
        this.assertOrdered(predictions, this.predictionOrd());
    }

    public IsotonicRegressionModel(Iterable<Object> boundaries, Iterable<Object> predictions, Boolean isotonic) {
        this((double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(boundaries).asScala()).toArray(ClassTag$.MODULE$.Double()), (double[])((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(predictions).asScala()).toArray(ClassTag$.MODULE$.Double()), Predef$.MODULE$.Boolean2boolean(isotonic));
    }
}

